/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.ibis;

import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import edu.duke.cs.osprey.tupexp.BasicPruningTupleExpander;
import java.util.ArrayList;
import java.util.Iterator;

public class IBISKStarTupleExpander
extends BasicPruningTupleExpander {
    EnergyMatrix baseMatrix;
    PruningMatrix basePruneMat;
    int curIntegPos;
    ArrayList<ArrayList<Integer>> RCsforAA;
    public static final double RT = 0.593050165;

    public IBISKStarTupleExpander(int curIntegPos, PruningMatrix basePruneMat, PruningMatrix integPruneMat, EnergyMatrix baseMatrix, ArrayList<ArrayList<Integer>> RCsforAA) {
        super(integPruneMat, null);
        this.baseMatrix = baseMatrix;
        this.basePruneMat = basePruneMat;
        this.curIntegPos = curIntegPos;
        this.RCsforAA = RCsforAA;
    }

    @Override
    public double scoreAssignmentList(int[] assignmentList) {
        double boltz = 0.0;
        int[] mann = (int[])assignmentList.clone();
        Iterator<Integer> iterator2 = this.RCsforAA.get(assignmentList[this.curIntegPos]).iterator();
        while (iterator2.hasNext()) {
            int rc;
            mann[this.curIntegPos] = rc = iterator2.next().intValue();
            if (this.basePruneMat.isPruned(new RCTuple(mann))) continue;
            boltz += Math.exp(-this.baseMatrix.confE(mann) / 0.593050165);
        }
        return -0.593050165 * Math.log(boltz);
    }
}

