/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.ibis;

import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.confspace.HigherTupleFinder;
import edu.duke.cs.osprey.confspace.RC;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SearchProblem;
import edu.duke.cs.osprey.confspace.TupleEnumerator;
import edu.duke.cs.osprey.control.ConfigFileParser;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.ibis.IBISKStarTupleExpander;
import edu.duke.cs.osprey.plug.PolytopeMatrix;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import edu.duke.cs.osprey.tools.ObjectIO;
import edu.duke.cs.osprey.tupexp.TupExpChooser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;

public class KStarBeak {
    EnergyMatrix luteMatrix;
    PruningMatrix lutePruningMatrix;
    int numPos;
    ArrayList<ArrayList<String>> AATypes;
    ArrayList<ArrayList<ArrayList<Integer>>> RCsForAATypes;
    EnergyMatrix seqEMat = null;
    PruningMatrix seqPruneMat = null;
    SearchProblem sp = null;

    public KStarBeak(EnergyMatrix luteMatrix, PruningMatrix lutePruningMatrix, ConfSpace confSpace) {
        this.luteMatrix = luteMatrix;
        this.lutePruningMatrix = lutePruningMatrix;
        this.numPos = luteMatrix.getNumPos();
        this.AATypes = new ArrayList();
        this.RCsForAATypes = new ArrayList();
        for (int pos = 0; pos < this.numPos; ++pos) {
            HashMap rcLists = new HashMap();
            for (RC rc : confSpace.posFlex.get((int)pos).RCs) {
                if (!rcLists.containsKey(rc.AAType)) {
                    rcLists.put(rc.AAType, new ArrayList());
                }
                ((ArrayList)rcLists.get(rc.AAType)).add(rc.RCIndex);
            }
            ArrayList<String> posAATypes = new ArrayList<String>();
            ArrayList<ArrayList> posRCsForAA = new ArrayList<ArrayList>();
            for (String aa : rcLists.keySet()) {
                posAATypes.add(aa);
                posRCsForAA.add((ArrayList)rcLists.get(aa));
            }
            this.AATypes.add(posAATypes);
            this.RCsForAATypes.add(posRCsForAA);
        }
    }

    public void makeUnprunedClusterExpansion() {
        PruningMatrix curPruneMat = this.lutePruningMatrix;
        EnergyMatrix curEMat = this.luteMatrix;
        double totResidsq = 0.0;
        for (int pos = 0; pos < this.numPos; ++pos) {
            PruningMatrix integPruneMat = this.integratedPruningMatrix(curPruneMat, pos);
            EnergyMatrix estIntegEMat = this.estimateIntegEMat(curEMat, pos);
            IBISKStarTupleExpander expander = new IBISKStarTupleExpander(pos, curPruneMat, integPruneMat, curEMat, this.RCsForAATypes.get(pos));
            TupleEnumerator tupEnum = new TupleEnumerator(integPruneMat, estIntegEMat, this.numPos);
            TupExpChooser chooser = new TupExpChooser(expander, tupEnum);
            double resid = chooser.calcPairwiseExpansion();
            System.out.println("IBIS K* Residual for position " + pos + ": " + resid);
            totResidsq += resid;
            curPruneMat = integPruneMat;
            curEMat = expander.getEnergyMatrix();
        }
        System.out.println("IBIS tot residsq: " + totResidsq);
        this.seqEMat = curEMat;
        this.seqPruneMat = curPruneMat;
    }

    PruningMatrix integratedPruningMatrix(PruningMatrix p, int integPos) {
        int rc2;
        int pos2;
        int integPosNumAA;
        int[] numAllowedAtPos = (int[])p.getNumConfAtPos().clone();
        numAllowedAtPos[integPos] = integPosNumAA = this.RCsForAATypes.get(integPos).size();
        PruningMatrix ans = new PruningMatrix(p.getNumPos(), numAllowedAtPos, p.getPruningInterval());
        for (int aa = 0; aa < integPosNumAA; ++aa) {
            boolean singlePruned = true;
            for (int rc : this.RCsForAATypes.get(integPos).get(aa)) {
                if (p.getOneBody(integPos, rc).booleanValue()) continue;
                singlePruned = false;
            }
            ans.setOneBody(integPos, aa, singlePruned);
            for (pos2 = 0; pos2 < p.getNumPos(); ++pos2) {
                if (pos2 == integPos) continue;
                for (rc2 = 0; rc2 < p.getNumConfAtPos(pos2); ++rc2) {
                    boolean pairPruned = true;
                    Iterator<Serializable> iterator2 = this.RCsForAATypes.get(integPos).get(aa).iterator();
                    while (iterator2.hasNext()) {
                        int rc = iterator2.next();
                        if (p.getPairwise(integPos, rc, pos2, rc2).booleanValue()) continue;
                        pairPruned = false;
                    }
                    ans.setPairwise(integPos, aa, pos2, rc2, pairPruned);
                }
            }
        }
        for (int pos1 = 0; pos1 < p.getNumPos(); ++pos1) {
            if (pos1 == integPos) continue;
            for (int rc = 0; rc < p.getNumConfAtPos(pos1); ++rc) {
                ans.setOneBody(pos1, rc, p.getOneBody(pos1, rc));
                for (pos2 = 0; pos2 < pos1; ++pos2) {
                    if (pos2 == integPos) continue;
                    for (rc2 = 0; rc2 < p.getNumConfAtPos(pos2); ++rc2) {
                        ans.setPairwise(pos1, rc, pos2, rc2, p.getPairwise(pos1, rc, pos2, rc2));
                        HigherTupleFinder<Boolean> htf = p.getHigherOrderTerms(pos1, rc, pos2, rc2);
                        if (htf == null) continue;
                        for (RCTuple prunedTup : htf.listInteractionsWithValue(true)) {
                            if (prunedTup.pos.contains(integPos)) continue;
                            ans.setTupleValue(prunedTup.addRC(pos1, rc).addRC(pos2, rc2), true);
                        }
                    }
                }
            }
        }
        return ans;
    }

    EnergyMatrix estimateIntegEMat(EnergyMatrix emat, int integPos) {
        int integPosNumAA;
        int[] numAllowedAtPos = (int[])emat.getNumConfAtPos().clone();
        numAllowedAtPos[integPos] = integPosNumAA = this.RCsForAATypes.get(integPos).size();
        EnergyMatrix ans = new EnergyMatrix(emat.getNumPos(), numAllowedAtPos, emat.getPruningInterval());
        for (int aa = 0; aa < integPosNumAA; ++aa) {
            double singleE = 0.0;
            for (int rc : this.RCsForAATypes.get(integPos).get(aa)) {
                if (!(Math.abs(emat.getOneBody(integPos, rc)) > Math.abs(singleE))) continue;
                singleE = emat.getOneBody(integPos, rc);
            }
            ans.setOneBody(integPos, aa, singleE);
            for (int pos2 = 0; pos2 < emat.getNumPos(); ++pos2) {
                if (pos2 == integPos) continue;
                for (int rc2 = 0; rc2 < emat.getNumConfAtPos(pos2); ++rc2) {
                    double pairE = 0.0;
                    for (int rc : this.RCsForAATypes.get(integPos).get(aa)) {
                        if (!(Math.abs(emat.getPairwise(integPos, rc, pos2, rc2)) > Math.abs(pairE))) continue;
                        pairE = emat.getPairwise(integPos, rc, pos2, rc2);
                    }
                    ans.setPairwise(integPos, aa, pos2, rc2, pairE);
                }
            }
        }
        for (int pos1 = 0; pos1 < emat.getNumPos(); ++pos1) {
            if (pos1 == integPos) continue;
            for (int rc = 0; rc < emat.getNumConfAtPos(pos1); ++rc) {
                ans.setOneBody(pos1, rc, emat.getOneBody(pos1, rc));
                for (int pos2 = 0; pos2 < pos1; ++pos2) {
                    if (pos2 == integPos) continue;
                    for (int rc2 = 0; rc2 < emat.getNumConfAtPos(pos2); ++rc2) {
                        ans.setPairwise(pos1, rc, pos2, rc2, emat.getPairwise(pos1, rc, pos2, rc2));
                    }
                }
            }
        }
        return ans;
    }

    public void testVsExhaustiveLUTE(boolean testEPICToo) {
        int numTests = 10;
        Random rand = new Random();
        System.out.println("COMPARING IBIS TO EXHAUSTIVE SEARCH");
        for (int t = 0; t < numTests; ++t) {
            int pos;
            int[] seq = new int[this.numPos];
            do {
                for (pos = 0; pos < this.numPos; ++pos) {
                    seq[pos] = rand.nextInt(this.RCsForAATypes.get(pos).size());
                }
            } while (this.seqPruneMat.isPruned(new RCTuple(seq)));
            System.out.print("SEQUENCE: ");
            for (pos = 0; pos < this.numPos; ++pos) {
                System.out.print(this.AATypes.get(pos).get(seq[pos]) + " ");
            }
            System.out.println();
            System.out.println("IBIS FREE ENERGY: " + this.seqEMat.confE(seq));
            int[] conf = new int[this.numPos];
            double luteQ = this.computeExhaustivePartitionFunction(seq, conf, 0, true);
            System.out.println("LUTE FREE ENERGY: " + -0.593050165 * Math.log(luteQ));
            if (!testEPICToo) continue;
            conf = new int[this.numPos];
            double epicQ = this.computeExhaustivePartitionFunction(seq, conf, 0, false);
            System.out.println("EPIC FREE ENERGY: " + -0.593050165 * Math.log(epicQ));
        }
    }

    public double computeExhaustivePartitionFunction(int[] seq, int[] conf, int posOffset, boolean useLUTE) {
        if (posOffset == this.numPos) {
            if (this.lutePruningMatrix.isPruned(new RCTuple(conf))) {
                return 0.0;
            }
            double E = useLUTE ? this.luteMatrix.confE(conf) : this.sp.EPICMinimizedEnergy(conf);
            return Math.exp(-E / 0.593050165);
        }
        double ans = 0.0;
        for (int rc : this.RCsForAATypes.get(posOffset).get(seq[posOffset])) {
            if (this.lutePruningMatrix.getOneBody(posOffset, rc).booleanValue()) continue;
            conf[posOffset] = rc;
            ans += this.computeExhaustivePartitionFunction(seq, conf, posOffset + 1, useLUTE);
        }
        return ans;
    }

    public static void main(String[] args) {
        ConfigFileParser cfp = ConfigFileParser.makeFromFilePaths(args);
        cfp.loadData();
        SearchProblem searchSpace = cfp.getSearchProblem();
        searchSpace.pruneMat = new PruningMatrix(searchSpace.confSpace, Double.POSITIVE_INFINITY);
        searchSpace.plugMat = new PolytopeMatrix(searchSpace, true);
        ObjectIO.writeObject(searchSpace.pruneMat, searchSpace.name + ".PRUNEMAT.dat");
        searchSpace.loadEnergyMatrix();
        searchSpace.loadEPICMatrix();
        searchSpace.loadTupExpEMatrix();
        ConfSpace confSpace = searchSpace.confSpace;
        KStarBeak curvedBeak = new KStarBeak(searchSpace.tupExpEMat, searchSpace.pruneMat, confSpace);
        curvedBeak.makeUnprunedClusterExpansion();
        curvedBeak.sp = searchSpace;
        curvedBeak.testVsExhaustiveLUTE(true);
        System.out.println("The ibis has completed its work.");
    }
}

