/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar;

import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.confspace.ConfDB;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.ConfSpaceIteration;
import edu.duke.cs.osprey.confspace.SeqSpace;
import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.kstar.ConfSpaceType;
import edu.duke.cs.osprey.kstar.InitException;
import edu.duke.cs.osprey.kstar.KStar;
import edu.duke.cs.osprey.kstar.KStarScore;
import edu.duke.cs.osprey.kstar.KStarScoreWriter;
import edu.duke.cs.osprey.kstar.KStarSettings;
import edu.duke.cs.osprey.kstar.ScoredSequence;
import edu.duke.cs.osprey.kstar.pfunc.BoltzmannCalculator;
import edu.duke.cs.osprey.kstar.pfunc.PartitionFunction;
import edu.duke.cs.osprey.kstar.pfunc.UpperBoundCalculator;
import edu.duke.cs.osprey.parallelism.TaskExecutor;
import edu.duke.cs.osprey.tools.AutoCloseableNoEx;
import edu.duke.cs.osprey.tools.BigMath;
import edu.duke.cs.osprey.tools.ExpFunction;
import edu.duke.cs.osprey.tools.MathTools;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class BBKStar {
    public final ConfSpaceInfo protein;
    public final ConfSpaceInfo ligand;
    public final ConfSpaceInfo complex;
    public final KStarSettings kstarSettings;
    public final Settings bbkstarSettings;
    private final Map<Sequence, PartitionFunction> proteinPfuncs;
    private final Map<Sequence, PartitionFunction> ligandPfuncs;
    private final Map<Sequence, PartitionFunction> complexPfuncs;
    private final ExpFunction exp;

    public BBKStar(ConfSpaceIteration protein, ConfSpaceIteration ligand, ConfSpaceIteration complex, KStarSettings kstarSettings, Settings bbkstarSettings) {
        if (kstarSettings.useExternalMemory) {
            throw new IllegalArgumentException("BBK* is not compatible with external memory. Please switch to regular K* with external memory, or keep using BBK* and disable external memory.");
        }
        this.kstarSettings = kstarSettings;
        this.bbkstarSettings = bbkstarSettings;
        this.protein = new ConfSpaceInfo(protein, ConfSpaceType.Protein);
        this.ligand = new ConfSpaceInfo(ligand, ConfSpaceType.Ligand);
        this.complex = new ConfSpaceInfo(complex, ConfSpaceType.Complex);
        this.proteinPfuncs = new HashMap<Sequence, PartitionFunction>();
        this.ligandPfuncs = new HashMap<Sequence, PartitionFunction>();
        this.complexPfuncs = new HashMap<Sequence, PartitionFunction>();
        this.exp = new ExpFunction(ExpFunction.mc);
    }

    public Iterable<ConfSpaceInfo> confSpaceInfos() {
        return Arrays.asList(this.protein, this.ligand, this.complex);
    }

    public ConfSpaceInfo getConfSpaceInfo(SimpleConfSpace confSpace) {
        if (confSpace == this.protein.confSpace) {
            return this.protein;
        }
        if (confSpace == this.ligand.confSpace) {
            return this.ligand;
        }
        if (confSpace == this.complex.confSpace) {
            return this.complex;
        }
        throw new IllegalArgumentException("conf space does not match any known by this K* instance");
    }

    public List<ScoredSequence> run() {
        return this.run(new TaskExecutor());
    }

    /*
     * Exception decompiling
     */
    public List<ScoredSequence> run(TaskExecutor tasks) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void reportSequence(SingleSequenceNode ssnode, List<ScoredSequence> scoredSequences) {
        KStarScore kstarScore = ssnode.makeKStarScore();
        scoredSequences.add(new ScoredSequence(ssnode.sequence, kstarScore));
        this.kstarSettings.scoreWriters.writeScore(new KStarScoreWriter.ScoreInfo(scoredSequences.size() - 1, this.bbkstarSettings.numBestSequences, ssnode.sequence, kstarScore));
    }

    public static class Settings {
        public final int numBestSequences;
        public final int numConfsPerBatch;

        public Settings(int numBestSequences, int numConfsPerBatch) {
            this.numBestSequences = numBestSequences;
            this.numConfsPerBatch = numConfsPerBatch;
        }

        public static class Builder {
            private int numBestSequences = 1;
            private int numConfsPerBatch = 8;

            public Builder setNumBestSequences(int val) {
                this.numBestSequences = val;
                return this;
            }

            public Builder setNumConfsPerBatch(int val) {
                this.numConfsPerBatch = val;
                return this;
            }

            public Settings build() {
                return new Settings(this.numBestSequences, this.numConfsPerBatch);
            }
        }
    }

    public class ConfSpaceInfo {
        public final ConfSpaceIteration confSpace;
        public final ConfSpaceType type;
        public final String id;
        public ConfEnergyCalculator confEcalcMinimized = null;
        public ConfSearchFactory confSearchFactoryMinimized = null;
        public ConfSearchFactory confSearchFactoryRigid = null;
        public KStar.PfuncFactory pfuncFactory = null;
        public File confDBFile = null;
        private ConfDB confDB = null;
        private BigDecimal stabilityThreshold = null;

        public ConfSpaceInfo(ConfSpaceIteration confSpace, ConfSpaceType type) {
            this.confSpace = confSpace;
            this.type = type;
            this.id = type.name().toLowerCase();
            this.confDBFile = new File(String.format(BBKStar.this.kstarSettings.confDBPattern, this.id));
        }

        private void check() {
            if (this.confEcalcMinimized == null) {
                throw new InitException(this.type, "confEcalcMinimized");
            }
            if (this.confSearchFactoryMinimized == null) {
                throw new InitException(this.type, "confSearchFactoryMinimized");
            }
            if (this.confSearchFactoryRigid == null) {
                throw new InitException(this.type, "confSearchFactoryRigid");
            }
            if (this.pfuncFactory == null) {
                throw new InitException(this.type, "pfuncFactory");
            }
        }

        public void setConfDBFile(String path2) {
            this.confDBFile = new File(path2);
        }

        private PartitionFunction makePfunc(Sequence sequence) {
            RCs rcs = sequence.makeRCs(this.confSpace);
            PartitionFunction pfunc = this.pfuncFactory.make(rcs);
            pfunc.setReportProgress(BBKStar.this.kstarSettings.showPfuncProgress);
            pfunc.setStabilityThreshold(this.stabilityThreshold);
            if (BBKStar.this.kstarSettings.useExternalMemory) {
                PartitionFunction.WithExternalMemory.setOrThrow(pfunc, true, rcs);
            }
            if (this.confDB != null) {
                PartitionFunction.WithConfDB.cast(pfunc).setConfDB(this.confDB, sequence);
            }
            pfunc.setInstanceId(this.type.ordinal());
            pfunc.init(BBKStar.this.kstarSettings.epsilon);
            return pfunc;
        }

        private AutoCloseableNoEx openConfDB() {
            if (this.confDBFile != null) {
                if (!BBKStar.this.kstarSettings.resume) {
                    this.confDBFile.delete();
                }
                this.confDB = new ConfDB(this.confSpace, this.confDBFile);
            }
            return () -> {
                if (this.confDB != null) {
                    this.confDB.close();
                    this.confDB = null;
                }
            };
        }
    }

    public class SingleSequenceNode
    extends Node {
        public final PartitionFunction protein;
        public final PartitionFunction ligand;
        public final PartitionFunction complex;

        public SingleSequenceNode(Sequence sequence) {
            super(BBKStar.this, sequence);
            this.protein = this.makePfunc(BBKStar.this.proteinPfuncs, BBKStar.this.protein);
            this.ligand = this.makePfunc(BBKStar.this.ligandPfuncs, BBKStar.this.ligand);
            this.complex = this.makePfunc(BBKStar.this.complexPfuncs, BBKStar.this.complex);
        }

        private PartitionFunction makePfunc(Map<Sequence, PartitionFunction> pfuncCache, ConfSpaceInfo info2) {
            Sequence sequence = this.sequence.filter(info2.confSpace.seqSpace());
            PartitionFunction pfunc = pfuncCache.get(sequence);
            if (pfunc != null) {
                return pfunc;
            }
            pfunc = info2.makePfunc(sequence);
            pfuncCache.put(sequence, pfunc);
            return pfunc;
        }

        @Override
        public void estimateScore() {
            if (this.protein.getStatus() == PartitionFunction.Status.Unstable || this.ligand.getStatus() == PartitionFunction.Status.Unstable) {
                this.score = Double.NEGATIVE_INFINITY;
                this.isUnboundUnstable = true;
                return;
            }
            if (this.protein.getStatus().canContinue()) {
                this.protein.compute(BBKStar.this.bbkstarSettings.numConfsPerBatch);
                if (this.protein.getStatus() == PartitionFunction.Status.Unstable) {
                    this.score = Double.NEGATIVE_INFINITY;
                    this.isUnboundUnstable = true;
                    return;
                }
            }
            if (this.ligand.getStatus().canContinue()) {
                this.ligand.compute(BBKStar.this.bbkstarSettings.numConfsPerBatch);
                if (this.ligand.getStatus() == PartitionFunction.Status.Unstable) {
                    this.score = Double.NEGATIVE_INFINITY;
                    this.isUnboundUnstable = true;
                    return;
                }
            }
            if (this.complex.getStatus().canContinue()) {
                this.complex.compute(BBKStar.this.bbkstarSettings.numConfsPerBatch);
            }
            this.score = BBKStar.this.exp.log10(this.makeKStarScore().upperBound);
            this.isUnboundUnstable = false;
            if (this.getStatus() == PfuncsStatus.Blocked && this.score == Double.POSITIVE_INFINITY) {
                this.score = Double.NEGATIVE_INFINITY;
            }
        }

        public KStarScore computeScore() {
            while (this.protein.getStatus().canContinue()) {
                this.protein.compute(BBKStar.this.bbkstarSettings.numConfsPerBatch);
            }
            while (this.ligand.getStatus().canContinue()) {
                this.ligand.compute(BBKStar.this.bbkstarSettings.numConfsPerBatch);
            }
            while (this.complex.getStatus().canContinue()) {
                this.complex.compute(BBKStar.this.bbkstarSettings.numConfsPerBatch);
            }
            KStarScore kstarScore = this.makeKStarScore();
            this.score = BBKStar.this.exp.log10(kstarScore.upperBound);
            return kstarScore;
        }

        public KStarScore makeKStarScore() {
            return new KStarScore(this.protein.makeResult(), this.ligand.makeResult(), this.complex.makeResult());
        }

        public PfuncsStatus getStatus() {
            if (this.protein.getStatus() == PartitionFunction.Status.Estimated && this.ligand.getStatus() == PartitionFunction.Status.Estimated && this.complex.getStatus() == PartitionFunction.Status.Estimated) {
                return PfuncsStatus.Estimated;
            }
            if (this.protein.getStatus() == PartitionFunction.Status.Estimating || this.ligand.getStatus() == PartitionFunction.Status.Estimating || this.complex.getStatus() == PartitionFunction.Status.Estimating) {
                return PfuncsStatus.Estimating;
            }
            return PfuncsStatus.Blocked;
        }

        public String toString() {
            return String.format("SingleSequenceNode[score=%12.6f, seq=%s, K*=%s]", this.score, this.sequence, this.makeKStarScore());
        }
    }

    public class MultiSequenceNode
    extends Node {
        public MultiSequenceNode(Sequence sequence) {
            super(BBKStar.this, sequence);
        }

        public List<Node> makeChildren() {
            ArrayList<Node> children = new ArrayList<Node>();
            List<SeqSpace.Position> positions = BBKStar.this.complex.confSpace.seqSpace().positions;
            SeqSpace.Position assignPos = positions.stream().filter(pos -> !this.sequence.isAssigned(pos.resNum)).findFirst().orElseThrow(() -> new IllegalStateException("no design positions left to choose"));
            HashSet<SeqSpace.ResType> resTypes = new HashSet<SeqSpace.ResType>(assignPos.resTypes);
            if (BBKStar.this.kstarSettings.maxSimultaneousMutations < positions.size()) {
                resTypes.add(assignPos.wildType);
            }
            for (SeqSpace.ResType resType : resTypes) {
                Sequence s = this.sequence.copy().set(assignPos, resType);
                if (s.isFullyAssigned()) {
                    children.add(new SingleSequenceNode(s));
                    continue;
                }
                if (s.countMutations() == BBKStar.this.kstarSettings.maxSimultaneousMutations) {
                    s.fillWildType();
                    if (!s.isFullyAssigned()) continue;
                    children.add(new SingleSequenceNode(s));
                    continue;
                }
                children.add(new MultiSequenceNode(s));
            }
            return children;
        }

        @Override
        public void estimateScore() {
            BigDecimal ligandUpperBound;
            BigDecimal proteinUpperBound;
            int numConfs = 1000;
            if (BBKStar.this.protein.stabilityThreshold != null && MathTools.isLessThan(proteinUpperBound = this.calcUpperBound(BBKStar.this.protein, this.sequence, 1000), BBKStar.this.protein.stabilityThreshold)) {
                this.score = Double.NEGATIVE_INFINITY;
                this.isUnboundUnstable = true;
                return;
            }
            BigDecimal proteinLowerBound = this.calcLowerBound(BBKStar.this.protein, this.sequence, 1000);
            if (MathTools.isZero(proteinLowerBound)) {
                this.score = Double.POSITIVE_INFINITY;
                this.isUnboundUnstable = false;
                return;
            }
            if (BBKStar.this.ligand.stabilityThreshold != null && MathTools.isLessThan(ligandUpperBound = this.calcUpperBound(BBKStar.this.ligand, this.sequence, 1000), BBKStar.this.ligand.stabilityThreshold)) {
                this.score = Double.NEGATIVE_INFINITY;
                this.isUnboundUnstable = true;
                return;
            }
            BigDecimal ligandLowerBound = this.calcLowerBound(BBKStar.this.ligand, this.sequence, 1000);
            if (MathTools.isZero(ligandLowerBound)) {
                this.score = Double.POSITIVE_INFINITY;
                this.isUnboundUnstable = false;
                return;
            }
            BigDecimal complexUpperBound = this.calcUpperBound(BBKStar.this.complex, this.sequence, 1000);
            this.score = MathTools.bigDivideDivide(complexUpperBound, proteinLowerBound, ligandLowerBound, PartitionFunction.decimalPrecision).doubleValue();
            this.isUnboundUnstable = false;
        }

        private BigDecimal calcLowerBound(ConfSpaceInfo info2, Sequence sequence, int numConfs) {
            ConfSearch.ScoredConf conf;
            RCs rcs = sequence.makeRCs(info2.confSpace);
            ConfSearch astar = info2.confSearchFactoryRigid.make(rcs);
            BoltzmannCalculator bcalc = new BoltzmannCalculator(PartitionFunction.decimalPrecision);
            BigMath m = new BigMath(PartitionFunction.decimalPrecision).set(0.0);
            for (int i = 0; i < numConfs && (conf = astar.nextConf()) != null; ++i) {
                m.add(bcalc.calc(conf.getScore()));
            }
            return m.get();
        }

        private BigDecimal calcUpperBound(ConfSpaceInfo info2, Sequence sequence, int numConfs) {
            RCs rcs = sequence.makeRCs(info2.confSpace);
            UpperBoundCalculator calc2 = new UpperBoundCalculator(info2.confSearchFactoryMinimized.make(rcs), rcs.getNumConformations());
            calc2.run(numConfs);
            return calc2.totalBound;
        }

        public String toString() {
            return String.format("MultiSequenceNode[score=%12.6f, seq=%s]", this.score, this.sequence);
        }
    }

    private abstract class Node
    implements Comparable<Node> {
        public final Sequence sequence;
        public double score;
        public boolean isUnboundUnstable;

        protected Node(BBKStar bBKStar, Sequence sequence) {
            this.sequence = sequence;
            this.score = 0.0;
        }

        @Override
        public int compareTo(Node other) {
            return -Double.compare(this.score, other.score);
        }

        public abstract void estimateScore();
    }

    public static enum PfuncsStatus {
        Estimating,
        Estimated,
        Blocked;

    }

    public static interface ConfSearchFactory {
        public ConfSearch make(RCs var1);
    }
}

