/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar;

import edu.duke.cs.osprey.kstar.KAStarNode;
import edu.duke.cs.osprey.kstar.KSAbstract;
import edu.duke.cs.osprey.kstar.KSAllowedSeqs;
import edu.duke.cs.osprey.kstar.KSCalc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.PriorityQueue;

public class KAStarTree {
    private PriorityQueue<KAStarNode> pq = null;

    public KAStarTree(KSAbstract ksObj, HashMap<Integer, KSAllowedSeqs> strand2AllowedSeqs, KSCalc wt) {
        KAStarNode.init(ksObj, strand2AllowedSeqs, wt);
        this.pq = new PriorityQueue<KAStarNode>(strand2AllowedSeqs.get(2).getNumSeqs() * 2, KAStarNode.KUStarNodeComparator);
    }

    public KAStarNode poll() {
        return this.pq.poll();
    }

    public KAStarNode peek() {
        return this.pq.peek();
    }

    public int size() {
        return this.pq.size();
    }

    public void add(KAStarNode node) {
        this.pq.add(node);
    }

    public void add(ArrayList<KAStarNode> nodes) {
        for (KAStarNode node : nodes) {
            this.add(node);
        }
    }
}

