/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar;

import edu.duke.cs.osprey.dof.deeper.DEEPerSettings;
import edu.duke.cs.osprey.ematrix.epic.EPICSettings;
import edu.duke.cs.osprey.kstar.KSAllowedSeqs;
import edu.duke.cs.osprey.kstar.KSCalc;
import edu.duke.cs.osprey.kstar.KSConfigFileParser;
import edu.duke.cs.osprey.kstar.KSInterface;
import edu.duke.cs.osprey.kstar.KSSearchProblem;
import edu.duke.cs.osprey.kstar.pfunc.PFAbstract;
import edu.duke.cs.osprey.kstar.pfunc.PFFactory;
import edu.duke.cs.osprey.kstar.pruning.APrioriPruningProver;
import edu.duke.cs.osprey.pruning.Pruner;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import edu.duke.cs.osprey.tools.ObjectIO;
import edu.duke.cs.osprey.tupexp.LUTESettings;
import java.io.File;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;

public abstract class KSAbstract
implements KSInterface {
    protected KSConfigFileParser cfp = null;
    protected ArrayList<String> wtSeq = null;
    protected boolean doWTCalc = true;
    protected KSCalc wtKSCalc = null;
    protected String outputDir = null;
    protected String outFilePath = null;
    protected String ematDir = null;
    protected String checkPointDir = null;
    protected String runName = null;
    protected String checkPointFilePath = null;
    protected HashMap<Integer, KSAllowedSeqs> strand2AllowedSeqs = new HashMap(3);
    protected ConcurrentHashMap<String, KSSearchProblem> name2SP = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, PFAbstract> name2PF = new ConcurrentHashMap();
    protected double EW;
    protected double I0;
    private String pdbName;
    private boolean useEPIC;
    private boolean useTupExp;
    private boolean useEllipses;
    private boolean useERef;
    private boolean addResEntropy;
    private boolean addWT;
    private boolean addWTRots;
    private boolean usePoissonBoltzmann;
    double stericThresh;
    protected boolean useVoxelG;
    public static long runTimeout = 0L;
    public static boolean doCheckPoint = false;
    protected static long checkpointInterval = 50000L;
    private long startTime = 0L;
    private int numSeqsCompleted = 0;
    private int numSeqsCreated = 0;

    public KSAbstract(KSConfigFileParser cfp) {
        this.cfp = cfp;
        this.EW = cfp.params.getDouble("Ew", 0.0);
        this.I0 = cfp.params.getDouble("Ival", 5.0);
        this.pdbName = cfp.params.getFile("PDBNAME").getAbsolutePath();
        this.useEPIC = cfp.params.getBool("UseEPIC");
        this.useTupExp = cfp.params.getBool("UseTupExp");
        this.useEllipses = cfp.params.getBool("useEllipses");
        this.useERef = cfp.params.getBool("useERef");
        this.addResEntropy = cfp.params.getBool("AddResEntropy");
        this.addWT = cfp.params.getBool("addWT", true);
        this.addWTRots = cfp.params.getBool("addWTRots", true);
        if (!this.addWT && this.addWTRots) {
            throw new RuntimeException("ERROR: addWTRots is true but addWT is false. addWT must be true if addWTRots is true");
        }
        this.usePoissonBoltzmann = cfp.params.getBool("UsePoissonBoltzmann");
        this.stericThresh = cfp.params.getDouble("StericThresh");
        this.useVoxelG = cfp.params.getBool("useVoxelG", false);
        if (this.useVoxelG && !this.useTupExp) {
            throw new RuntimeException("ERROR: K* with continuous entropy requires LUTE");
        }
    }

    public void checkAPPP() {
        if (this.cfp.params.getBool("APrioriProvablePruning", this.useTupExp && !this.usePoissonBoltzmann)) {
            APrioriPruningProver appp = new APrioriPruningProver(this, this.cfp, this.strand2AllowedSeqs);
            this.EW = appp.calcEw();
            this.I0 = appp.calcI0();
        }
    }

    public int getNumSeqsCompleted(int increment) {
        this.numSeqsCompleted += increment;
        return this.numSeqsCompleted;
    }

    public int getNumSeqsCreated(int increment) {
        this.numSeqsCreated += increment;
        return this.numSeqsCreated;
    }

    public void setStartTime(long time) {
        this.startTime = time;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public static void setCheckPointInterval(long interval) {
        if (interval <= 0L) {
            interval = 1L;
        }
        checkpointInterval = interval;
    }

    @Override
    public void createEmats(ArrayList<Boolean> contSCFlexVals) {
        this.preparePanSeqSPs(contSCFlexVals);
    }

    protected void createOutputDir() {
        if (!new File(this.getOutputDir()).exists()) {
            ObjectIO.makeDir(this.getOutputDir(), false);
        }
    }

    protected void createCheckPointDir() {
        if (!new File(this.getCheckPointDir()).exists()) {
            ObjectIO.makeDir(this.getCheckPointDir(), false);
        }
    }

    protected void createEmatDir() {
        ObjectIO.makeDir(this.getEMATdir(), this.cfp.params.getBool("kStarDeleteEmatDir", false));
    }

    public static String list1D2String(ArrayList<String> seq, String separator) {
        StringBuilder ans = new StringBuilder();
        for (int i = 0; i < seq.size(); ++i) {
            if (i > 0) {
                ans.append(separator);
            }
            ans.append(seq.get(i));
        }
        return ans.toString();
    }

    public static ArrayList<String> file2List(String path2) {
        ArrayList<String> ans = new ArrayList<String>();
        try {
            if (!new File(path2).exists()) {
                return ans;
            }
            Scanner s = new Scanner(new File(path2));
            while (s.hasNextLine()) {
                ans.add(s.nextLine());
            }
            s.close();
        }
        catch (Exception ex) {
            throw new Error("can't scan file", ex);
        }
        return ans;
    }

    public static ArrayList<ArrayList<String>> list1D2ListOfLists(ArrayList<String> list) {
        ArrayList<ArrayList<String>> ans = new ArrayList<ArrayList<String>>();
        for (String s : list) {
            ArrayList<String> newList = new ArrayList<String>();
            newList.add(s);
            ans.add(newList);
        }
        return ans;
    }

    public String getSearchProblemName(boolean contSCFlex, int strand) {
        String flexibility = contSCFlex ? "min" : "rig";
        return this.getEMATdir() + File.separator + this.getRunName() + "." + flexibility + ".Strand" + strand;
    }

    private String getCheckPointName(boolean contSCFlex, int strand) {
        String flexibility = contSCFlex ? "min" : "rig";
        return this.getCheckPointDir() + File.separator + this.getRunName() + "." + flexibility + ".Strand" + strand;
    }

    public String getSearchProblemName(boolean contSCFlex, int strand, String pfImpl, ArrayList<String> seq) {
        return this.getSearchProblemName(contSCFlex, strand) + "." + pfImpl + "." + KSAbstract.list1D2String(seq, ".");
    }

    public String getCheckPointName(boolean contSCFlex, int strand, String pfImpl, ArrayList<String> seq) {
        return this.getCheckPointName(contSCFlex, strand) + "." + pfImpl + "." + KSAbstract.list1D2String(seq, ".") + ".checkpoint";
    }

    protected void printSequences() {
        boolean bl = this.doWTCalc = !this.cfp.params.getBool("kStarSkipWTCalc");
        if (!this.doWTCalc) {
            this.wtKSCalc = null;
            System.out.println("WARNING: skipping K* calculation for wild-type sequence: ");
            ArrayList<Integer> strands = new ArrayList<Integer>(Arrays.asList(1, 0, 2));
            Iterator<Serializable> iterator2 = strands.iterator();
            while (iterator2.hasNext()) {
                int strand = (Integer)iterator2.next();
                this.strand2AllowedSeqs.get(strand).removeStrandSeq(0);
            }
        }
        System.out.println("\nPreparing to compute K* for the following sequences:");
        int i = 0;
        for (ArrayList<String> al : this.strand2AllowedSeqs.get(2).getStrandSeqList()) {
            System.out.println(i++ + "\t" + KSAbstract.list1D2String(al, " "));
        }
        System.out.println();
    }

    public ArrayList<ArrayList<String>> getSequences(int strand) {
        return this.strand2AllowedSeqs.get(strand).getStrandSeqList();
    }

    public ArrayList<ArrayList<String>> getUniqueSequences(int strand) {
        LinkedHashSet<ArrayList<String>> uniques = new LinkedHashSet<ArrayList<String>>();
        uniques.addAll(this.getSequences(strand));
        return new ArrayList<ArrayList<String>>(uniques);
    }

    protected PFAbstract getPartitionFunction(boolean contSCFlex, int strand, String pfImpl, ArrayList<String> seq) {
        return this.name2PF.get(this.getSearchProblemName(contSCFlex, strand, pfImpl, seq));
    }

    protected void loadAndPruneMatrices(HashMap<String, Integer> name2Strand) {
        try {
            System.out.println("\nCreating and pruning pan energy matrices\n");
            long begin = System.currentTimeMillis();
            for (String key : this.name2SP.keySet()) {
                KSSearchProblem sp = this.name2SP.get(key);
                if (sp.getEnergyMatrix() != null) continue;
                sp.loadEnergyMatrix();
                if (!this.usePoissonBoltzmann) {
                    this.cfp.setupPruning(sp, this.EW + this.I0, false, false).prune();
                }
                if (sp.useTupExpForSearch && sp.contSCFlex) {
                    int strand = name2Strand.get(key);
                    this.setupLUTESearchProblem(key, strand);
                    continue;
                }
                sp.inverseMat = sp.getInvertedFromUnreducedPruningMatrix(sp);
            }
            System.out.println("\nFinished creating and pruning energy matrices");
            System.out.println("Running time: " + (System.currentTimeMillis() - begin) / 1000L + " seconds\n");
        }
        catch (Exception ex) {
            throw new Error("can't load prune matrices", ex);
        }
    }

    private void setupLUTESearchProblem(String key, int strand) {
        KSSearchProblem contSP = this.name2SP.get(key);
        if (this.usePoissonBoltzmann) {
            contSP.pruneMat = new PruningMatrix(contSP.confSpace, Double.POSITIVE_INFINITY);
            Pruner pruner = new Pruner(contSP, false, 0.0, 0.0, false, false);
            pruner.pruneSteric(this.stericThresh);
            contSP.loadTupExpEMatrix();
        } else {
            if (contSP.useEPIC) {
                contSP.loadEPICMatrix();
                if (contSP.epicSettings.useEPICPruning) {
                    System.out.println("Beginning post-EPIC pruning.");
                    this.cfp.setupPruning(contSP, this.EW + this.I0, true, false).prune();
                    System.out.println("Finished post-EPIC pruning.");
                }
            }
            contSP.loadTupExpEMatrix();
            System.out.println("Beginning post-tup-exp pruning.");
            this.cfp.setupPruning(contSP, this.EW, false, true).prune();
            System.out.println("Finished post-tup-exp pruning.");
        }
        KSSearchProblem luteSP = this.createPanSeqSP(false, strand);
        luteSP.pruneMat = contSP.pruneMat;
        luteSP.emat = contSP.tupExpEMat;
        luteSP.inverseMat = luteSP.getInvertedFromUnreducedPruningMatrix(luteSP);
        this.name2SP.put(key, luteSP);
    }

    protected PFAbstract createPF4Seq(boolean contSCFlex, int strand, ArrayList<String> seq, String pfImpl) {
        PFAbstract ans = null;
        String panSeqSPName = this.getSearchProblemName(contSCFlex, strand);
        KSSearchProblem panSeqSP = this.name2SP.get(panSeqSPName);
        String seqSPName = this.getSearchProblemName(contSCFlex, strand, pfImpl, seq);
        String cpName = this.getCheckPointName(contSCFlex, strand, pfImpl, seq);
        ans = this.name2PF.get(seqSPName);
        if (ans != null) {
            return ans;
        }
        if (doCheckPoint && (ans = this.deSerializePF(seqSPName, cpName, contSCFlex)) != null) {
            return ans;
        }
        ArrayList<Integer> flexResIndexes = this.strand2AllowedSeqs.get(strand).getFlexResIndexesFromSeq(seq);
        ans = PFFactory.getPartitionFunction(pfImpl, strand, seq, flexResIndexes, cpName, seqSPName, this.cfp, panSeqSP);
        return ans;
    }

    protected ConcurrentHashMap<Integer, PFAbstract> createPFs4Seqs(ArrayList<ArrayList<String>> seqs, ArrayList<Boolean> contSCFlexVals, ArrayList<String> pfImplVals) {
        ConcurrentHashMap<Integer, PFAbstract> ans = new ConcurrentHashMap<Integer, PFAbstract>();
        ArrayList<Integer> strands = new ArrayList<Integer>(Arrays.asList(2, 0, 1));
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < strands.size(); ++i) {
            indexes.add(i);
        }
        for (int index = 0; index < strands.size(); ++index) {
            int strand = strands.get(index);
            boolean contSCFlex = contSCFlexVals.get(strand);
            String pfImpl = pfImplVals.get(strand);
            ArrayList<String> seq = seqs.get(strand);
            PFAbstract pf = this.createPF4Seq(contSCFlex, strand, seq, pfImpl);
            this.name2PF.put(pf.getReducedSearchProblemName(), pf);
            ans.put(strand, pf);
            if (pf.getRunState() != PFAbstract.RunState.NOTSTARTED) continue;
            if (pf.getReducedSearchProblem().getEnergyMatrix() == null) {
                pf.getReducedSearchProblem().loadEnergyMatrix();
            }
            if (pf.getReducedSearchProblem().numConfs(pf.getReducedPruningMatrix()).compareTo(BigInteger.ZERO) == 0) {
                System.out.println("\nRe-pruning to steric threshold...");
                double maxPruningInterval = this.cfp.params.getDouble("StericThresh");
                pf.rePruneReducedSP(maxPruningInterval);
                if (pf.getReducedSearchProblem().numConfs(pf.getReducedPruningMatrix()).compareTo(BigInteger.ZERO) == 0) {
                    System.out.println("\nWARNING: there are no valid conformations for sequence " + KSAbstract.list1D2String(pf.getSequence(), " ") + " " + pf.getFlexibility() + "\n");
                    pf.setEpsilonStatus(PFAbstract.EApproxReached.NOT_POSSIBLE);
                }
            }
            pf.setNumUnPruned();
            pf.setNumPruned();
        }
        if (ans.size() != 3) {
            throw new RuntimeException("ERROR: returned map must contain three different partition functions");
        }
        return ans;
    }

    public void removeFromMap(String spName, boolean sp, boolean pf) {
        if (sp) {
            this.name2SP.remove(spName);
        }
        if (pf) {
            this.name2PF.remove(spName);
        }
    }

    public KSSearchProblem createPanSeqSP(boolean contSCFlex, int strand) {
        ArrayList<ArrayList<String>> allowedAAs = KSAllowedSeqs.removePosFromAllowedAAs(this.strand2AllowedSeqs.get(strand).getAllowedAAs());
        ArrayList<String> flexibleRes = this.strand2AllowedSeqs.get(strand).getFlexRes();
        ArrayList<String[]> moveableStrands = this.strand2AllowedSeqs.get(strand).getMoveableStrandTermini();
        ArrayList<String[]> freeBBZones = this.strand2AllowedSeqs.get(strand).getFreeBBZoneTermini();
        DEEPerSettings dset = this.strand2AllowedSeqs.get(strand).getDEEPerSettings();
        KSSearchProblem panSeqSP = contSCFlex ? new KSSearchProblem(this.cfp.params, this.getSearchProblemName(contSCFlex, strand), this.pdbName, flexibleRes, allowedAAs, this.addWT, contSCFlex, this.useEPIC, new EPICSettings(this.cfp.params), this.useTupExp, new LUTESettings(this.cfp.params), dset, moveableStrands, freeBBZones, this.useEllipses, this.useERef, this.addResEntropy, this.addWTRots, this.cfp.getStrandLimits(strand), this.useVoxelG) : new KSSearchProblem(this.cfp.params, this.getSearchProblemName(contSCFlex, strand), this.pdbName, flexibleRes, allowedAAs, this.addWT, contSCFlex, false, new EPICSettings(), false, new LUTESettings(), dset.makeDiscreteVersion(), new ArrayList<String[]>(), new ArrayList<String[]>(), this.useEllipses, this.useERef, this.addResEntropy, this.addWTRots, this.cfp.getStrandLimits(strand), false);
        panSeqSP.numEmatThreads = this.cfp.params.getInt("EmatThreads");
        return panSeqSP;
    }

    protected void preparePanSeqSPs(ArrayList<Boolean> contSCFlexVals) {
        ArrayList<Integer> strands = new ArrayList<Integer>(Arrays.asList(1, 0, 2));
        HashMap<String, Integer> name2Strand = new HashMap<String, Integer>();
        for (boolean contSCFlex : contSCFlexVals) {
            for (int strand : strands) {
                String spName = this.getSearchProblemName(contSCFlex, strand);
                name2Strand.put(spName, strand);
                if (this.name2SP.containsKey(spName)) continue;
                KSSearchProblem sp = this.createPanSeqSP(contSCFlex, strand);
                this.name2SP.put(sp.name, sp);
            }
        }
        this.loadAndPruneMatrices(name2Strand);
    }

    protected String getOputputFilePath() {
        if (this.outFilePath == null) {
            this.outFilePath = this.getOutputDir() + File.separator + this.getRunName() + "." + this.getSummaryFileExtension();
        }
        return this.outFilePath;
    }

    protected String getCheckPointFilePath() {
        if (this.checkPointFilePath == null) {
            this.checkPointFilePath = this.getCheckPointDir() + File.separator + this.getOputputFilePath();
        }
        return this.checkPointFilePath;
    }

    protected String getSummaryFileExtension() {
        String ans = null;
        try {
            ans = InetAddress.getLocalHost().getHostName() + "." + this.getKSMethod() + "." + PFAbstract.getCFGImpl() + ".txt";
        }
        catch (Exception ex) {
            throw new Error("can't get hostname", ex);
        }
        return ans;
    }

    protected String getOutputDir() {
        if (this.outputDir == null) {
            this.outputDir = this.cfp.params.getValue("kStarOutputDir", "runName");
            if (this.outputDir.equalsIgnoreCase("runName")) {
                this.outputDir = this.getRunName();
            }
        }
        return this.outputDir;
    }

    protected String getRunName() {
        if (this.runName == null) {
            this.runName = this.cfp.params.getValue("runName");
        }
        return this.runName;
    }

    protected String getEMATdir() {
        if (this.ematDir == null) {
            this.ematDir = this.getOutputDir() + File.separator + this.cfp.params.getValue("kStarEmatDir");
        }
        return this.ematDir;
    }

    protected synchronized String getCheckPointDir() {
        if (this.checkPointDir == null) {
            this.checkPointDir = this.getOutputDir() + File.separator + this.cfp.params.getValue("kStarCheckPointDir");
        }
        return this.checkPointDir;
    }

    protected ArrayList<String> getWTSeq() {
        if (this.wtSeq == null) {
            this.wtSeq = this.strand2AllowedSeqs.get(2).getWTSeq();
        }
        return this.wtSeq;
    }

    protected KSCalc getWTKSCalc() {
        return this.wtKSCalc;
    }

    protected boolean isWT(KSCalc mutSeq) {
        return mutSeq.getPF(2).getSequence().equals(this.getWTSeq());
    }

    protected BigInteger countProcessedConfs() {
        BigInteger ans = BigInteger.ZERO;
        for (PFAbstract pf : this.name2PF.values()) {
            ans = ans.add(pf.getNumProcessed());
        }
        return ans;
    }

    protected BigInteger countTotNumConfs() {
        BigInteger ans = BigInteger.ZERO;
        for (PFAbstract pf : this.name2PF.values()) {
            ans = ans.add(pf.getNumUnPruned());
        }
        return ans;
    }

    protected void abortPFs() {
        this.name2PF.keySet().parallelStream().forEach(key -> {
            PFAbstract pf = this.name2PF.get(key);
            pf.abort(true);
        });
    }

    protected ArrayList<ArrayList<String>> getStrandStringsAtPos(int i) {
        ArrayList<ArrayList<String>> ans = new ArrayList<ArrayList<String>>(Arrays.asList(null, null, null));
        ans.set(2, this.strand2AllowedSeqs.get(2).getStrandSeqAtPos(i));
        ans.set(0, this.strand2AllowedSeqs.get(0).getStrandSeqAtPos(i));
        ans.set(1, this.strand2AllowedSeqs.get(1).getStrandSeqAtPos(i));
        ans.trimToSize();
        return ans;
    }

    protected KSCalc computeWTCalc() {
        if (!doCheckPoint || !new File(this.getOputputFilePath()).exists()) {
            KSCalc.printSummaryHeader(this.getOputputFilePath());
        }
        if (doCheckPoint && !new File(this.getCheckPointFilePath()).exists()) {
            KSCalc.printSummaryHeader(this.getCheckPointFilePath());
        }
        ArrayList<ArrayList<String>> strandSeqs = this.getStrandStringsAtPos(0);
        boolean contSCFlex = this.cfp.params.getBool("doMinimize", true);
        String impl = PFAbstract.getCFGImpl();
        ArrayList<Boolean> contSCFlexVals = new ArrayList<Boolean>(Arrays.asList(contSCFlex, contSCFlex, contSCFlex));
        ArrayList<String> pfImplVals = new ArrayList<String>(Arrays.asList(impl, impl, impl));
        ConcurrentHashMap<Integer, PFAbstract> pfs = this.createPFs4Seqs(strandSeqs, contSCFlexVals, pfImplVals);
        KSCalc calc2 = new KSCalc(0, pfs);
        PFAbstract pf = calc2.getPF(2);
        if (doCheckPoint && this.getSeqsFromFile(this.getOputputFilePath()).contains(pf.getSequence())) {
            return calc2;
        }
        calc2.run(calc2, false, true);
        for (int strand : Arrays.asList(1, 0, 2)) {
            pf = calc2.getPF(strand);
            if ((strand == 2 || pf.getEpsilonStatus() == PFAbstract.EApproxReached.TRUE) && (strand != 2 || pf.getEpsilonStatus() != PFAbstract.EApproxReached.NOT_POSSIBLE)) continue;
            throw new RuntimeException("ERROR: could not compute the wild-type sequence " + KSAbstract.list1D2String(pf.getSequence(), " ") + " to an epsilon value of " + PFAbstract.targetEpsilon + ". Resolve any clashes involving the flexible residues, or increase the value of epsilon.");
        }
        if (doCheckPoint) {
            pf = calc2.getPF(2);
            this.name2PF.remove(pf.getReducedSearchProblemName());
            calc2.deleteSeqFromFile(pf.getSequence(), this.getCheckPointFilePath());
            calc2.serializePFs();
        }
        if (calc2.getEpsilonStatus() == PFAbstract.EApproxReached.TRUE) {
            calc2.deleteCheckPointFile(2);
            calc2.printSummary(this.getOputputFilePath(), this.getStartTime(), this.getNumSeqsCreated(1), this.getNumSeqsCompleted(1));
        } else {
            calc2.printSummary(this.getCheckPointFilePath(), this.getStartTime(), this.getNumSeqsCreated(0), this.getNumSeqsCompleted(0));
        }
        return calc2;
    }

    protected PFAbstract deSerializePF(String spName, String path2, boolean contSCFlex) {
        if (!new File(path2).exists()) {
            return null;
        }
        PFAbstract ans = (PFAbstract)ObjectIO.readObject(path2, true);
        if (ans != null) {
            this.name2PF.put(spName, ans);
            KSSearchProblem panSeqSP = this.name2SP.get(this.getSearchProblemName(contSCFlex, ans.getStrand()));
            ans.setPanSeqSP(panSeqSP);
        }
        return ans;
    }

    protected ArrayList<ArrayList<String>> getSeqsFromFile(String path2) {
        ArrayList<ArrayList<String>> ans = new ArrayList<ArrayList<String>>();
        ArrayList<String> lines = KSAbstract.file2List(path2);
        if (lines.size() == 0) {
            return ans;
        }
        block0: for (ArrayList<String> seq : this.strand2AllowedSeqs.get(2).getStrandSeqList()) {
            String strSeq = KSAbstract.list1D2String(seq, " ");
            for (String line : lines) {
                if (!line.contains(strSeq)) continue;
                ans.add(seq);
                continue block0;
            }
        }
        return ans;
    }
}

