/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar;

import edu.duke.cs.osprey.kstar.KSAbstract;
import edu.duke.cs.osprey.kstar.pfunc.PFAbstract;
import edu.duke.cs.osprey.tools.ExpFunction;
import edu.duke.cs.osprey.tools.ObjectIO;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public class KSCalc {
    private ConcurrentHashMap<Integer, PFAbstract> strand2PF = null;
    private int seqID = 0;
    private static int precision = 4;

    public KSCalc(int seqID, ConcurrentHashMap<Integer, PFAbstract> pfs) {
        this.seqID = seqID;
        this.strand2PF = pfs;
    }

    public PFAbstract getPF(int strand) {
        return this.strand2PF.get(strand);
    }

    protected boolean unboundIsStable(PFAbstract wtPF, PFAbstract pf) {
        return pf.getQStarUpperBound().compareTo(wtPF.getQStar().multiply(PFAbstract.getStabilityThresh())) >= 0;
    }

    protected boolean doingKAStar() {
        for (PFAbstract pf : this.strand2PF.values()) {
            if (pf.getImpl().equalsIgnoreCase(PFAbstract.getCFGImpl())) continue;
            return true;
        }
        return false;
    }

    public PFAbstract.EApproxReached getEpsilonStatus() {
        PFAbstract pl = this.strand2PF.get(2);
        PFAbstract p = this.strand2PF.get(0);
        PFAbstract l = this.strand2PF.get(1);
        if (pl.getEpsilonStatus() == PFAbstract.EApproxReached.NOT_POSSIBLE || p.getEpsilonStatus() == PFAbstract.EApproxReached.NOT_POSSIBLE || l.getEpsilonStatus() == PFAbstract.EApproxReached.NOT_POSSIBLE) {
            return PFAbstract.EApproxReached.NOT_POSSIBLE;
        }
        if (p.getEpsilonStatus() == PFAbstract.EApproxReached.NOT_STABLE || l.getEpsilonStatus() == PFAbstract.EApproxReached.NOT_STABLE) {
            return PFAbstract.EApproxReached.NOT_STABLE;
        }
        if (pl.getEpsilonStatus() == PFAbstract.EApproxReached.TRUE && p.getEpsilonStatus() == PFAbstract.EApproxReached.TRUE && l.getEpsilonStatus() == PFAbstract.EApproxReached.TRUE) {
            return PFAbstract.EApproxReached.TRUE;
        }
        return PFAbstract.EApproxReached.FALSE;
    }

    public boolean canContinue() {
        if (!this.doingKAStar()) {
            return this.getEpsilonStatus() != PFAbstract.EApproxReached.NOT_POSSIBLE && this.getEpsilonStatus() != PFAbstract.EApproxReached.NOT_STABLE;
        }
        return this.getPF(2).getEpsilonStatus() != PFAbstract.EApproxReached.NOT_POSSIBLE;
    }

    public void runPF(PFAbstract pf, PFAbstract wtPF, boolean complete, boolean stabilityCheck) {
        if (pf.getEpsilonStatus() != PFAbstract.EApproxReached.FALSE) {
            return;
        }
        if (pf.getRunState() == PFAbstract.RunState.NOTSTARTED) {
            System.out.println("\n" + pf.getImpl() + ": Initializing partition function for " + KSAbstract.list1D2String(pf.getSequence(), " ") + " " + pf.getFlexibility());
            pf.start();
        }
        if (pf.getEpsilonStatus() == PFAbstract.EApproxReached.FALSE) {
            if (complete) {
                System.out.println("\n" + pf.getImpl() + ": Computing partition function for " + KSAbstract.list1D2String(pf.getSequence(), " ") + " " + pf.getFlexibility());
                pf.runToCompletion();
            } else {
                System.out.println("\n" + pf.getImpl() + ": Resuming partition function for " + KSAbstract.list1D2String(pf.getSequence(), " ") + " " + pf.getFlexibility());
                pf.runSlice(KSAbstract.checkpointInterval);
            }
        }
        if (pf.getEpsilonStatus() != PFAbstract.EApproxReached.FALSE) {
            System.out.println("\n" + pf.getImpl() + ": Completed partition function for " + KSAbstract.list1D2String(pf.getSequence(), " ") + " " + pf.getFlexibility() + "\n");
        }
        if (this.getEpsilonStatus() == PFAbstract.EApproxReached.NOT_POSSIBLE) {
            return;
        }
        if (stabilityCheck && !this.unboundIsStable(wtPF, pf)) {
            pf.setEpsilonStatus(PFAbstract.EApproxReached.NOT_STABLE);
            System.out.println("\nSequence " + KSAbstract.list1D2String(pf.getSequence(), " ") + " " + pf.getFlexibility() + " is unstable\n");
            return;
        }
    }

    public void run(KSCalc wtKSCalc, boolean forceRun, boolean stabilityCheck) {
        ArrayList<Integer> strands = new ArrayList<Integer>(Arrays.asList(1, 0, 2));
        for (int strand : strands) {
            PFAbstract wtPF;
            if (!forceRun && this.getEpsilonStatus() != PFAbstract.EApproxReached.FALSE) {
                return;
            }
            boolean complete = !KSAbstract.doCheckPoint || strand != 2;
            PFAbstract pFAbstract = wtPF = wtKSCalc == null ? null : wtKSCalc.getPF(strand);
            if (wtPF == null || strand == 2) {
                stabilityCheck = false;
            }
            this.runPF(this.getPF(strand), wtPF, complete, stabilityCheck);
        }
    }

    public void serializePFs() {
        Iterator iterator2 = ((ConcurrentHashMap.KeySetView)this.strand2PF.keySet()).iterator();
        while (iterator2.hasNext()) {
            int strand = (Integer)iterator2.next();
            this.serializePF(strand);
        }
    }

    public void serializePF(int strand) {
        PFAbstract pf = this.strand2PF.get(strand);
        if (pf.getRunState() == PFAbstract.RunState.NOTSTARTED) {
            return;
        }
        System.out.print("\nSerializing " + pf.getCheckPointPath() + " ... ");
        pf.abort(false);
        if (KSAbstract.doCheckPoint) {
            pf.setPanSeqSP(null);
        }
        ObjectIO.writeObject(pf, pf.getCheckPointPath());
        if (pf.getEpsilonStatus() == PFAbstract.EApproxReached.FALSE) {
            pf.writeTopConfs();
        }
        System.out.println("Done");
    }

    public void deleteCheckPointFiles() {
        ArrayList<Integer> strands = new ArrayList<Integer>(Arrays.asList(1, 0, 2));
        for (int strand : strands) {
            this.deleteCheckPointFile(strand);
        }
    }

    public void deleteCheckPointFile(int strand) {
        PFAbstract pf = this.strand2PF.get(strand);
        ObjectIO.delete(pf.getCheckPointPath());
    }

    public BigDecimal getKStarScore(boolean useUB) {
        BigDecimal pl = useUB ? this.getPF(2).getQStarUpperBound() : this.getPF(2).getQStar();
        BigDecimal p = this.getPF(0).getQStar();
        BigDecimal l = this.getPF(1).getQStar();
        if (this.doingKAStar() && pl.multiply(p).multiply(l).compareTo(BigDecimal.ZERO) == 0) {
            BigDecimal score = new BigDecimal(Double.MAX_VALUE);
            return score;
        }
        BigDecimal dividend = pl;
        BigDecimal divisor = p.multiply(l);
        BigDecimal score = divisor.compareTo(BigDecimal.ZERO) == 0 ? (dividend.compareTo(BigDecimal.ZERO) != 0 ? new BigDecimal(Double.POSITIVE_INFINITY) : BigDecimal.ZERO) : dividend.divide(divisor, precision);
        return score;
    }

    protected double getKStarScoreLog10(boolean useUB) {
        BigDecimal pl = useUB ? this.getPF(2).getQStarUpperBound() : this.getPF(2).getQStar();
        BigDecimal p = this.getPF(0).getQStar();
        BigDecimal l = this.getPF(1).getQStar();
        if (this.doingKAStar() && pl.multiply(p).multiply(l).compareTo(BigDecimal.ZERO) == 0) {
            return Double.POSITIVE_INFINITY;
        }
        return KSCalc.getKStarScoreLog10(l, p, pl);
    }

    public static double getKStarScoreLog10(PFAbstract l, PFAbstract p, PFAbstract pl, boolean useUB) {
        return KSCalc.getKStarScoreLog10(l.getQStar(), p.getQStar(), useUB ? pl.getQStarUpperBound() : pl.getQStar());
    }

    public static double getKStarScoreLog10(BigDecimal l, BigDecimal p, BigDecimal pl) {
        double score = 0.0;
        ExpFunction e = new ExpFunction();
        score = l.compareTo(BigDecimal.ZERO) == 0 && p.compareTo(BigDecimal.ZERO) == 0 && pl.compareTo(BigDecimal.ZERO) == 0 ? 0.0 : (l.compareTo(BigDecimal.ZERO) == 0 || p.compareTo(BigDecimal.ZERO) == 0 ? (pl.compareTo(BigDecimal.ZERO) != 0 ? Double.POSITIVE_INFINITY : 0.0) : (pl.compareTo(BigDecimal.ZERO) == 0 ? Double.NEGATIVE_INFINITY : e.log10(pl) - e.log10(p) - e.log10(l)));
        return score;
    }

    private static void printOutputHeader(PrintStream out) {
        out.print("Seq ID");
        out.print("\t");
        out.print("Sequence");
        out.print("\t");
        out.print("K* Score (Log10)");
        out.print("\t");
        out.print("UB(K*) Score (Log10)");
        out.print("\t");
        out.print("Total # Confs.");
        out.print("\t");
        out.print("Complex Partition Function");
        out.print("\t");
        out.print("Complex Epsilon");
        out.print("\t");
        out.print("Complex # Confs.");
        out.print("\t");
        out.print("Protein Partition Function");
        out.print("\t");
        out.print("Protein Epsilon");
        out.print("\t");
        out.print("Protein # Confs.");
        out.print("\t");
        out.print("Ligand Partition Function");
        out.print("\t");
        out.print("Ligand Epsilon");
        out.print("\t");
        out.print("Ligand # Confs.");
        out.print("\t");
        out.print("# Seqs Created");
        out.print("\t");
        out.print("# Seqs Completed");
        out.print("\t");
        out.print("Time (sec)");
        out.println();
    }

    public static void printSummaryHeader(String outFile) {
        try {
            PrintStream out = new PrintStream(new FileOutputStream(outFile, false));
            KSCalc.printOutputHeader(out);
            out.println();
            out.flush();
            out.close();
        }
        catch (Exception ex) {
            throw new Error("can't write log", ex);
        }
    }

    public void printSummary(String outFile, long startTime, long numCreatedSeqs, long numCompletedSeqs) {
        try {
            PFAbstract pf;
            PrintStream out = new PrintStream(new FileOutputStream(outFile, true));
            out.print(this.seqID);
            out.print("\t");
            out.print(KSAbstract.list1D2String(this.getPF(2).getSequence(), " "));
            out.print("\t");
            out.print(this.getKStarScoreLog10(false));
            out.print("\t");
            out.print(this.getKStarScoreLog10(true));
            ArrayList<Integer> strands = new ArrayList<Integer>(Arrays.asList(2, 0, 1));
            BigInteger numProcessedConfs = BigInteger.ZERO;
            for (int strand : strands) {
                pf = this.getPF(strand);
                numProcessedConfs = numProcessedConfs.add(pf.getNumProcessed());
            }
            out.print("\t");
            out.print(numProcessedConfs);
            for (int strand : strands) {
                pf = this.getPF(strand);
                out.print("\t");
                out.print(ObjectIO.formatBigDecimal(pf.getQStar(), precision));
                out.print("\t");
                out.print(pf.getEffectiveEpsilon());
                out.print("\t");
                out.print(pf.getNumProcessed());
            }
            out.print("\t");
            out.print(numCreatedSeqs);
            out.print("\t");
            out.print(numCompletedSeqs);
            out.print("\t");
            out.print((System.currentTimeMillis() - startTime) / 1000L);
            out.println();
            out.flush();
            out.close();
        }
        catch (Exception ex) {
            throw new Error("can't write log", ex);
        }
    }

    public void deleteSeqFromFile(ArrayList<String> seq, String path2) {
        try {
            String strSeq = KSAbstract.list1D2String(seq, " ");
            ArrayList<String> lines = KSAbstract.file2List(path2);
            for (String line : lines) {
                if (!line.contains(strSeq)) continue;
                lines.remove(line);
                break;
            }
            PrintStream out = new PrintStream(new FileOutputStream(path2, false));
            for (String line : lines) {
                out.println(line);
            }
            out.flush();
            out.close();
        }
        catch (Exception ex) {
            throw new Error("can't write to file: " + path2, ex);
        }
    }
}

