/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar;

import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.kstar.KSAbstract;
import edu.duke.cs.osprey.kstar.KSConf;
import edu.duke.cs.osprey.kstar.pfunc.PFAbstract;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashSet;

public class KSConfQ
extends Thread
implements Serializable {
    private PFAbstract pf;
    private ConfSearch confSearch;
    private int minCapacity;
    public final String lock = new String("LOCK");
    private LinkedHashSet<ArrayList<Integer>> q = null;
    private int qCap = (int)Math.pow(2.0, 20.0);
    private boolean confsExhausted = false;
    private ArrayList<Integer> tail = null;

    public KSConfQ(PFAbstract pf, int minCapacity, BigDecimal partialQLB) {
        this.pf = pf;
        this.confSearch = pf.getConfTree(false);
        this.minCapacity = minCapacity;
        this.qCap = Math.max(minCapacity, PFAbstract.qCapacity);
        this.q = new LinkedHashSet(this.qCap);
    }

    public double getNextConfBound() {
        ConfSearch.ScoredConf c = null;
        c = this.confSearch.nextConf();
        if (c != null) {
            return this.enQueue(c.getAssignments());
        }
        throw new RuntimeException("ERROR: all the conformations of this sequence were pruned");
    }

    public int size() {
        if (this.q == null) {
            return 0;
        }
        return this.q.size();
    }

    public boolean isExhausted() {
        return this.confsExhausted;
    }

    public boolean canSatisfy(int requested) {
        return this.size() >= requested;
    }

    public double getConfBound(int[] conf) {
        return this.pf.getConfBound(this.confSearch, conf);
    }

    public KSConf peekTail() {
        return this.size() > 0 ? new KSConf(this.tail, this.pf.getConfBound(this.confSearch, KSConf.list2Array(this.tail))) : null;
    }

    public KSConf peekHead() {
        if (this.size() == 0) {
            return null;
        }
        ArrayList value2 = (ArrayList)this.q.iterator().next();
        return new KSConf(value2, this.pf.getConfBound(this.confSearch, KSConf.list2Array(value2)));
    }

    protected double enQueue(int[] conf) {
        double energyBound = this.pf.getConfBound(this.confSearch, conf);
        BigDecimal boltzmannWeight = this.pf.getBoltzmannWeight(energyBound);
        if (boltzmannWeight.compareTo(BigDecimal.ZERO) == 0) {
            energyBound = Double.POSITIVE_INFINITY;
        }
        ArrayList<Integer> list = KSConf.array2List(conf);
        if (KSAbstract.doCheckPoint && this.size() > 0 && energyBound < this.peekTail().getEnergyBound()) {
            return energyBound;
        }
        if (this.pf.getProcessedConfsSet().contains(list) || this.q.contains(list)) {
            return energyBound;
        }
        this.q.add(list);
        this.tail = list;
        return energyBound;
    }

    public KSConf deQueue() {
        KSConf conf;
        KSConf kSConf = conf = this.size() > 0 ? this.peekHead() : null;
        if (conf == null) {
            throw new RuntimeException("ERROR: attempting to dequeue from an empty list");
        }
        this.q.remove(conf.getConf());
        if (this.size() == 0) {
            this.tail = null;
        }
        conf.getConf().trimToSize();
        return conf;
    }

    public ConfSearch getConfSearch() {
        return this.confSearch;
    }

    public int getQCapacity() {
        return this.qCap;
    }

    public void setQCapacity(int newCap) {
        this.qCap = Math.max(newCap, this.minCapacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp(boolean nullify) throws InterruptedException {
        String string = this.lock;
        synchronized (string) {
            this.lock.notify();
        }
        this.join();
        if (nullify) {
            this.nullify();
        }
    }

    private void nullify() {
        this.confSearch = null;
        this.q = null;
        this.tail = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            if (this.confsExhausted) {
                return;
            }
            while (true) {
                ConfSearch.ScoredConf conf = this.confSearch.nextConf();
                String string = this.lock;
                synchronized (string) {
                    if (conf == null) {
                        this.confsExhausted = true;
                        this.lock.notify();
                        return;
                    }
                    if (this.enQueue(conf.getAssignments()) == Double.POSITIVE_INFINITY) {
                        this.confsExhausted = true;
                        this.lock.notify();
                        return;
                    }
                    if (this.size() == this.minCapacity) {
                        this.lock.notify();
                    }
                    if (this.size() >= this.qCap) {
                        this.lock.notify();
                        if (this.pf.getEpsilonStatus() != PFAbstract.EApproxReached.FALSE) {
                            return;
                        }
                        this.lock.wait();
                    }
                    if (this.pf.getEpsilonStatus() != PFAbstract.EApproxReached.FALSE) {
                        this.lock.notify();
                        return;
                    }
                }
            }
        }
        catch (InterruptedException ex) {
            throw new Error(ex);
        }
    }
}

