/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar;

import edu.duke.cs.osprey.kstar.pfunc.PartitionFunction;
import edu.duke.cs.osprey.tools.MathTools;
import java.math.BigDecimal;
import java.util.function.Function;

public class KStarScore {
    public final PartitionFunction.Result protein;
    public final PartitionFunction.Result ligand;
    public final PartitionFunction.Result complex;
    public final BigDecimal score;
    public final BigDecimal lowerBound;
    public final BigDecimal upperBound;

    public KStarScore(BigDecimal score, BigDecimal lowerBound, BigDecimal upperBound) {
        this.protein = null;
        this.ligand = null;
        this.complex = null;
        this.score = score;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public KStarScore(PartitionFunction.Result protein, PartitionFunction.Result ligand, PartitionFunction.Result complex) {
        BigDecimal x;
        this.protein = protein;
        this.ligand = ligand;
        this.complex = complex;
        this.score = protein.status == PartitionFunction.Status.Estimated && ligand.status == PartitionFunction.Status.Estimated && complex.status == PartitionFunction.Status.Estimated ? (MathTools.isNaN(x = MathTools.bigDivideDivide(complex.values.qstar, protein.values.qstar, ligand.values.qstar, PartitionFunction.decimalPrecision)) ? null : x) : null;
        this.lowerBound = MathTools.bigDivideDivide(complex.values.calcLowerBound(), protein.values.calcUpperBound(), ligand.values.calcUpperBound(), PartitionFunction.decimalPrecision);
        this.upperBound = MathTools.bigDivideDivide(complex.values.calcUpperBound(), protein.values.calcLowerBound(), ligand.values.calcLowerBound(), PartitionFunction.decimalPrecision);
    }

    public static boolean isLigandComplexUseful(PartitionFunction.Result protein) {
        return protein.status != PartitionFunction.Status.Unstable;
    }

    public static boolean isComplexUseful(PartitionFunction.Result protein, PartitionFunction.Result ligand) {
        return protein.status != PartitionFunction.Status.Unstable && ligand.status != PartitionFunction.Status.Unstable;
    }

    public String toString() {
        Function<String, String> trim = s -> {
            if (s.length() > 9) {
                return s.substring(0, 9);
            }
            return s;
        };
        return String.format("%-9s in [%-9s,%9s] (log10)", trim.apply(this.scoreLog10String()), trim.apply(this.lowerBoundLog10String()), trim.apply(this.upperBoundLog10String()));
    }

    public boolean equals(Object other) {
        return other instanceof KStarScore && this.equals((KStarScore)other);
    }

    public boolean equals(KStarScore other) {
        return MathTools.isSameValue(this.score, other.score) && MathTools.isSameValue(this.lowerBound, other.lowerBound) && MathTools.isSameValue(this.upperBound, other.upperBound);
    }

    public boolean isSimilarTo(KStarScore other, double relativeEpsilon) {
        return MathTools.isRelativelySame(this.score, other.score, PartitionFunction.decimalPrecision, relativeEpsilon) && MathTools.isRelativelySame(this.lowerBound, other.lowerBound, PartitionFunction.decimalPrecision, relativeEpsilon) && MathTools.isRelativelySame(this.upperBound, other.upperBound, PartitionFunction.decimalPrecision, relativeEpsilon);
    }

    public Double scoreLog10() {
        return KStarScore.scoreToLog10(this.score);
    }

    public Double lowerBoundLog10() {
        return KStarScore.scoreToLog10(this.lowerBound);
    }

    public Double upperBoundLog10() {
        return KStarScore.scoreToLog10(this.upperBound);
    }

    public String scoreLog10String() {
        return KStarScore.scoreToLog10String(this.score);
    }

    public String lowerBoundLog10String() {
        return KStarScore.scoreToLog10String(this.lowerBound);
    }

    public String upperBoundLog10String() {
        return KStarScore.scoreToLog10String(this.upperBound);
    }

    public String complexLowerBoundLog10String() {
        return KStarScore.scoreToLog10String(this.complex.values.calcLowerBound());
    }

    public String complexUpperBoundLog10String() {
        return KStarScore.scoreToLog10String(this.complex.values.calcUpperBound());
    }

    public String ligandLowerBoundLog10String() {
        return KStarScore.scoreToLog10String(this.ligand.values.calcLowerBound());
    }

    public String ligandUpperBoundLog10String() {
        return KStarScore.scoreToLog10String(this.ligand.values.calcUpperBound());
    }

    public String proteinLowerBoundLog10String() {
        return KStarScore.scoreToLog10String(this.protein.values.calcLowerBound());
    }

    public String proteinUpperBoundLog10String() {
        return KStarScore.scoreToLog10String(this.protein.values.calcUpperBound());
    }

    public static Double scoreToLog10(BigDecimal score) {
        if (score != null) {
            return MathTools.log10(score);
        }
        return null;
    }

    public static String scoreToLog10String(BigDecimal score) {
        if (score != null) {
            return String.format("%f", KStarScore.scoreToLog10(score));
        }
        return "none";
    }
}

