/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar;

import edu.duke.cs.osprey.confspace.ConfSpaceIteration;
import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.kstar.ConfSpaceInfo;
import edu.duke.cs.osprey.kstar.ConfSpaceType;
import edu.duke.cs.osprey.kstar.KStarScore;
import edu.duke.cs.osprey.kstar.KStarSettings;
import edu.duke.cs.osprey.kstar.ScoredSequence;
import edu.duke.cs.osprey.kstar.pfunc.BoltzmannCalculator;
import edu.duke.cs.osprey.kstar.pfunc.PartitionFunction;
import edu.duke.cs.osprey.parallelism.TaskExecutor;
import edu.duke.cs.osprey.tools.AutoCloseableNoEx;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NewKStar {
    public final ConfSpaceInfo protein;
    public final ConfSpaceInfo ligand;
    public final ConfSpaceInfo complex;
    public final KStarSettings settings;
    private final List<Sequence> sequences;
    private final List<ScoredSequence> scores = new ArrayList<ScoredSequence>();
    private final List<SequenceComputedListener> sequenceListeners = new ArrayList<SequenceComputedListener>();

    public NewKStar(ConfSpaceIteration protein, ConfSpaceIteration ligand, ConfSpaceIteration complex, KStarSettings settings) {
        this.settings = settings;
        this.protein = new ConfSpaceInfo(settings, protein, ConfSpaceType.Protein);
        this.ligand = new ConfSpaceInfo(settings, ligand, ConfSpaceType.Ligand);
        this.complex = new ConfSpaceInfo(settings, complex, ConfSpaceType.Complex);
        this.sequences = new ArrayList<Sequence>();
    }

    public void putSequenceComputedListener(SequenceComputedListener listener) {
        this.sequenceListeners.add(listener);
    }

    public List<ConfSpaceInfo> confSpaceInfos() {
        return Arrays.asList(this.protein, this.ligand, this.complex);
    }

    public List<ScoredSequence> run() {
        return this.run(new TaskExecutor());
    }

    public List<ScoredSequence> run(TaskExecutor tasks) {
        try (TaskExecutor.ContextGroup ctxGroup = tasks.contextGroup();){
            PartitionFunction.Result complexResult;
            PartitionFunction.Result ligandResult;
            PartitionFunction.Result proteinResult;
            this.protein.check();
            this.ligand.check();
            this.complex.check();
            this.sequences.clear();
            this.protein.clear();
            this.ligand.clear();
            this.complex.clear();
            if (this.complex.confSpace.seqSpace().containsWildTypeSequence()) {
                this.sequences.add(this.complex.confSpace.seqSpace().makeWildTypeSequence());
            }
            this.sequences.addAll(this.complex.confSpace.seqSpace().getMutants(this.settings.maxSimultaneousMutations, true));
            int n = this.sequences.size();
            BigDecimal proteinStabilityThreshold = null;
            BigDecimal ligandStabilityThreshold = null;
            try (AutoCloseableNoEx proteinCloser = this.protein.openConfDB();
                 AutoCloseableNoEx ligandCloser = this.ligand.openConfDB();
                 AutoCloseableNoEx complexCloser = this.complex.openConfDB();){
                proteinResult = this.protein.calcPfunc(ctxGroup, this.sequences.get(0), BigDecimal.ZERO);
                ligandResult = this.ligand.calcPfunc(ctxGroup, this.sequences.get(0), BigDecimal.ZERO);
                complexResult = this.complex.calcPfunc(ctxGroup, this.sequences.get(0), BigDecimal.ZERO);
            }
            ScoredSequence wildTypeScore = new ScoredSequence(this.sequences.get(0), new KStarScore(proteinResult, ligandResult, complexResult));
            this.saveScoredSequence(wildTypeScore);
            if (this.settings.stabilityThreshold != null) {
                BigDecimal stabilityThresholdFactor = new BoltzmannCalculator(PartitionFunction.decimalPrecision).calc(this.settings.stabilityThreshold);
                proteinStabilityThreshold = wildTypeScore.score().protein.values.calcLowerBound().multiply(stabilityThresholdFactor);
                ligandStabilityThreshold = wildTypeScore.score().ligand.values.calcLowerBound().multiply(stabilityThresholdFactor);
            }
            for (int i = 1; i < n; ++i) {
                Sequence seq = this.sequences.get(i);
                try (AutoCloseableNoEx proteinCloser = this.protein.openConfDB();
                     AutoCloseableNoEx ligandCloser = this.ligand.openConfDB();
                     AutoCloseableNoEx complexCloser = this.complex.openConfDB();){
                    proteinResult = this.protein.calcPfunc(ctxGroup, seq, proteinStabilityThreshold);
                    if (!KStarScore.isLigandComplexUseful(proteinResult)) {
                        ligandResult = PartitionFunction.Result.makeAborted();
                        complexResult = PartitionFunction.Result.makeAborted();
                    } else {
                        ligandResult = this.ligand.calcPfunc(ctxGroup, seq, ligandStabilityThreshold);
                        complexResult = !KStarScore.isComplexUseful(proteinResult, ligandResult) ? PartitionFunction.Result.makeAborted() : this.complex.calcPfunc(ctxGroup, seq, BigDecimal.ZERO);
                    }
                }
                ScoredSequence scoredSeq = new ScoredSequence(seq, new KStarScore(proteinResult, ligandResult, complexResult));
                this.saveScoredSequence(scoredSeq);
            }
            List<ScoredSequence> list = this.scores;
            return list;
        }
    }

    private void saveScoredSequence(ScoredSequence scoredSeq) {
        this.scores.add(scoredSeq);
        for (SequenceComputedListener listener : this.sequenceListeners) {
            listener.onSequence(this, scoredSeq);
        }
    }

    public static interface SequenceComputedListener {
        public void onSequence(NewKStar var1, ScoredSequence var2);
    }
}

