/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar;

import edu.duke.cs.osprey.confspace.ConfDB;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.ConfSpaceIteration;
import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.gmec.ConfAnalyzer;
import edu.duke.cs.osprey.kstar.BBKStar;
import edu.duke.cs.osprey.kstar.KStar;
import java.io.File;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SequenceAnalyzer {
    private final Function<Sequence, ConfSpaceInfo> finder;

    public SequenceAnalyzer(KStar kstar) {
        this.finder = sequence -> {
            for (KStar.ConfSpaceInfo info2 : kstar.confSpaceInfos()) {
                if (info2.confSpace.seqSpace() != sequence.seqSpace) continue;
                ConfSpaceInfo adapter = new ConfSpaceInfo();
                adapter.confSpace = info2.confSpace;
                adapter.id = info2.id;
                adapter.confEcalc = info2.confEcalc;
                adapter.confDBFile = info2.confDBFile;
                return adapter;
            }
            throw new NoSuchConfSpaceException((Sequence)sequence);
        };
    }

    public SequenceAnalyzer(BBKStar bbkstar) {
        this.finder = sequence -> {
            for (BBKStar.ConfSpaceInfo info2 : bbkstar.confSpaceInfos()) {
                if (info2.confSpace.seqSpace() != sequence.seqSpace) continue;
                ConfSpaceInfo adapter = new ConfSpaceInfo();
                adapter.confSpace = info2.confSpace;
                adapter.id = info2.id;
                adapter.confEcalc = info2.confEcalcMinimized;
                adapter.confDBFile = info2.confDBFile;
                return adapter;
            }
            throw new NoSuchConfSpaceException((Sequence)sequence);
        };
    }

    public Analysis analyze(Sequence sequence, int numConfs) {
        return this.analyze(sequence, numConfs, null);
    }

    public Analysis analyze(Sequence sequence, int numConfs, ConfEnergyCalculator confEcalc) {
        ConfSpaceInfo info2 = this.finder.apply(sequence);
        try (ConfDB confdb = new ConfDB(info2.confSpace, info2.confDBFile);){
            Iterator<ConfSearch.EnergiedConf> econfs = confdb.getSequence(sequence).energiedConfs(ConfDB.SortOrder.Energy).iterator();
            if (confEcalc == null) {
                confEcalc = info2.confEcalc;
            }
            ConfAnalyzer analyzer = new ConfAnalyzer(confEcalc);
            ConfAnalyzer.EnsembleAnalysis ensemble = analyzer.analyzeEnsemble(econfs, numConfs);
            Analysis analysis = new Analysis(this, info2, sequence, ensemble);
            return analysis;
        }
    }

    public class Analysis {
        public final ConfSpaceInfo info;
        public final Sequence sequence;
        public final ConfAnalyzer.EnsembleAnalysis ensemble;

        public Analysis(SequenceAnalyzer this$0, ConfSpaceInfo info2, Sequence sequence, ConfAnalyzer.EnsembleAnalysis ensemble) {
            this.info = info2;
            this.sequence = sequence;
            this.ensemble = ensemble;
        }

        public ConfSpaceIteration getConfSpace() {
            return this.info.confSpace;
        }

        public void writePdbs(String filePattern) {
            this.ensemble.writePdbs(filePattern);
        }

        public void writePdb(String path2, String comment) {
            this.ensemble.writePdb(path2, comment);
        }

        public String toString() {
            ConfSpaceIteration confSpace = this.getConfSpace();
            int indexSize = 1 + (int)Math.log10(this.ensemble.analyses.size());
            StringBuilder buf = new StringBuilder();
            buf.append("Residues           ");
            buf.append(IntStream.range(0, confSpace.numPos()).mapToObj(posi -> String.format("%-5s", confSpace.name(posi))).collect(Collectors.joining(" ")));
            buf.append(String.format("%-16s   %s\n", this.info.id + " Sequence", this.sequence.toString(Sequence.Renderer.ResTypeMutations, 5)));
            buf.append(String.format("Ensemble of %d conformations:\n", this.ensemble.analyses.size()));
            for (int i = 0; i < this.ensemble.analyses.size(); ++i) {
                ConfAnalyzer.ConfAnalysis analysis = this.ensemble.analyses.get(i);
                buf.append("\t");
                buf.append(String.format("%" + indexSize + "d/%" + indexSize + "d", i + 1, this.ensemble.analyses.size()));
                buf.append(String.format("     Energy: %-12.6f     Score: %-12.6f", analysis.epmol.energy, analysis.score));
                buf.append("     Rotamers: ");
                buf.append(IntStream.range(0, confSpace.numPos()).mapToObj(posi -> confSpace.confId(posi, analysis.assignments[posi])).collect(Collectors.joining(" ")));
                buf.append("     Residue Conf IDs: ");
                buf.append(SimpleConfSpace.formatConfRCs(analysis.assignments));
                buf.append("\n");
            }
            return buf.toString();
        }
    }

    public static class ConfSpaceInfo {
        public ConfSpaceIteration confSpace;
        public String id;
        public ConfEnergyCalculator confEcalc;
        public File confDBFile;
    }

    public static class NoSuchConfSpaceException
    extends NoSuchElementException {
        public NoSuchConfSpaceException(Sequence sequence) {
            super("no conformation space matching sequence " + String.valueOf(sequence));
        }
    }
}

