/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar.impl;

import edu.duke.cs.osprey.kstar.KSAbstract;
import edu.duke.cs.osprey.kstar.KSAllowedSeqs;
import edu.duke.cs.osprey.kstar.KSCalc;
import edu.duke.cs.osprey.kstar.KSConfigFileParser;
import edu.duke.cs.osprey.kstar.pfunc.PFAbstract;
import edu.duke.cs.osprey.tools.ObjectIO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;

public class KSImplLinear
extends KSAbstract {
    private boolean contSCFlex;
    private String pfImpl;

    public KSImplLinear(KSConfigFileParser cfp) {
        super(cfp);
    }

    @Override
    public void init(HashMap<Integer, KSAllowedSeqs> strand2AllowedSeqs) {
        this.strand2AllowedSeqs = strand2AllowedSeqs;
        this.checkAPPP();
        this.printSequences();
        this.createOutputDir();
        this.createEmatDir();
        if (doCheckPoint) {
            this.createCheckPointDir();
        }
        this.contSCFlex = this.cfp.params.getBool("doMinimize", true);
        ArrayList<Boolean> contSCFlexVals = new ArrayList<Boolean>(Arrays.asList(this.contSCFlex));
        this.createEmats(contSCFlexVals);
        this.pfImpl = this.cfp.params.getValue("kStarPFuncMethod");
    }

    @Override
    public String getKSMethod() {
        return "linear";
    }

    @Override
    public void run() {
        if (this.strand2AllowedSeqs == null) {
            throw new RuntimeException("ERROR: call init() method on this object before invoking run()");
        }
        this.setStartTime(System.currentTimeMillis());
        if (doCheckPoint) {
            this.runRR();
        } else {
            this.runFCFS();
        }
        System.out.println("\nK* calculations computed: " + this.getNumSeqsCompleted(0));
        System.out.println("Total # sequences: " + ((KSAllowedSeqs)this.strand2AllowedSeqs.get(2)).getNumSeqs());
        System.out.println("K* conformations processed: " + String.valueOf(this.countProcessedConfs()));
        System.out.println("Total # of conformations in search space: " + String.valueOf(this.countTotNumConfs()));
        System.out.println("K* running time: " + (System.currentTimeMillis() - this.getStartTime()) / 1000L + " seconds\n");
    }

    protected void runFCFS() {
        ArrayList<ArrayList<String>> strandSeqs = null;
        ArrayList<Boolean> contSCFlexVals = new ArrayList<Boolean>(Arrays.asList(this.contSCFlex, this.contSCFlex, this.contSCFlex));
        ArrayList<String> pfImplVals = new ArrayList<String>(Arrays.asList(this.pfImpl, this.pfImpl, this.pfImpl));
        int startSeq = 0;
        if (this.doWTCalc) {
            this.computeWTCalc();
            startSeq = 1;
        }
        int numSeqs = ((KSAllowedSeqs)this.strand2AllowedSeqs.get(2)).getNumSeqs();
        for (int i = startSeq; i < numSeqs; ++i) {
            System.out.println("\nComputing K* for sequence " + i + "/" + (numSeqs - 1) + ": " + KSImplLinear.list1D2String(((KSAllowedSeqs)this.strand2AllowedSeqs.get(2)).getStrandSeqAtPos(i), " ") + "\n");
            strandSeqs = this.getStrandStringsAtPos(i);
            ConcurrentHashMap<Integer, PFAbstract> pfs = this.createPFs4Seqs(strandSeqs, contSCFlexVals, pfImplVals);
            KSCalc calc2 = new KSCalc(i, pfs);
            calc2.run(this.wtKSCalc, false, true);
            if (calc2.getEpsilonStatus() != PFAbstract.EApproxReached.TRUE && calc2.getEpsilonStatus() != PFAbstract.EApproxReached.NOT_POSSIBLE) continue;
            calc2.printSummary(this.getOputputFilePath(), this.getStartTime(), this.getNumSeqsCreated(1), this.getNumSeqsCompleted(1));
        }
    }

    protected void runRR() {
        ArrayList<ArrayList<String>> strandSeqs = null;
        ArrayList<Boolean> contSCFlexVals = new ArrayList<Boolean>(Arrays.asList(this.contSCFlex, this.contSCFlex, this.contSCFlex));
        ArrayList<String> pfImplVals = new ArrayList<String>(Arrays.asList(this.pfImpl, this.pfImpl, this.pfImpl));
        HashSet seqSet = new HashSet((ArrayList)ObjectIO.deepCopy(((KSAllowedSeqs)this.strand2AllowedSeqs.get(2)).getStrandSeqList()));
        if (this.doWTCalc) {
            this.computeWTCalc();
        }
        seqSet.removeAll(this.getSeqsFromFile(this.getOputputFilePath()));
        int numSeqs = ((KSAllowedSeqs)this.strand2AllowedSeqs.get(2)).getNumSeqs();
        do {
            for (int i = 0; i < numSeqs; ++i) {
                ArrayList<String> seq = ((KSAllowedSeqs)this.strand2AllowedSeqs.get(2)).getStrandSeqAtPos(i);
                if (!seqSet.contains(seq)) continue;
                System.out.println("\nResuming K* for sequence " + i + "/" + (numSeqs - 1) + ": " + KSImplLinear.list1D2String(seq, " ") + "\n");
                strandSeqs = this.getStrandStringsAtPos(i);
                ConcurrentHashMap<Integer, PFAbstract> pfs = this.createPFs4Seqs(strandSeqs, contSCFlexVals, pfImplVals);
                KSCalc calc2 = new KSCalc(i, pfs);
                calc2.run(this.wtKSCalc, false, true);
                for (int strand : Arrays.asList(1, 0)) {
                    PFAbstract pf = calc2.getPF(strand);
                    if (pf.checkPointExists()) continue;
                    calc2.serializePF(strand);
                }
                PFAbstract pf = calc2.getPF(2);
                calc2.deleteSeqFromFile(pf.getSequence(), this.getCheckPointFilePath());
                if (calc2.getEpsilonStatus() != PFAbstract.EApproxReached.FALSE) {
                    calc2.deleteCheckPointFile(2);
                    seqSet.remove(seq);
                    if (calc2.getEpsilonStatus() != PFAbstract.EApproxReached.TRUE && calc2.getEpsilonStatus() != PFAbstract.EApproxReached.NOT_POSSIBLE) continue;
                    calc2.printSummary(this.getOputputFilePath(), this.getStartTime(), this.getNumSeqsCreated(1), this.getNumSeqsCompleted(1));
                    continue;
                }
                this.name2PF.remove(pf.getReducedSearchProblemName());
                calc2.serializePF(2);
                calc2.printSummary(this.getCheckPointFilePath(), this.getStartTime(), this.getNumSeqsCreated(0), this.getNumSeqsCompleted(0));
            }
        } while (seqSet.size() > 0);
        ObjectIO.delete(this.getCheckPointDir());
    }

    public PFAbstract getPartitionFunction(int strand, ArrayList<String> seq) {
        return (PFAbstract)this.name2PF.get(this.getSearchProblemName(this.contSCFlex, strand, this.pfImpl, seq));
    }

    public double getKStarScoreLog10(int sequenceIndex, boolean useUB) {
        PFAbstract l = this.getPartitionFunction(1, this.getSequences(1).get(sequenceIndex));
        PFAbstract p = this.getPartitionFunction(0, this.getSequences(0).get(sequenceIndex));
        PFAbstract pl = this.getPartitionFunction(2, this.getSequences(2).get(sequenceIndex));
        return KSCalc.getKStarScoreLog10(l, p, pl, useUB);
    }
}

