/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar.pfunc;

import edu.duke.cs.osprey.confspace.ConfDB;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.kstar.pfunc.BoltzmannCalculator;
import edu.duke.cs.osprey.kstar.pfunc.PartitionFunction;
import edu.duke.cs.osprey.parallelism.TaskExecutor;
import edu.duke.cs.osprey.tools.MathTools;
import edu.duke.cs.osprey.tools.TimeTools;
import java.math.BigDecimal;

public class LowerBoundCalculator {
    public final ConfSearch tree;
    public final ConfEnergyCalculator ecalc;
    public BigDecimal weightedScoreSum = BigDecimal.ZERO;
    public BigDecimal weightedEnergySum = BigDecimal.ZERO;
    public int numConfsScored = 0;
    public int numConfsEnergied = 0;
    public ConfDB confDB = null;
    public ConfDB.ConfTable confTable = null;
    private BoltzmannCalculator boltzmann = new BoltzmannCalculator(PartitionFunction.decimalPrecision);

    public LowerBoundCalculator(ConfSearch tree, ConfEnergyCalculator ecalc) {
        this.tree = tree;
        this.ecalc = ecalc;
    }

    public Status run(int numConfs) {
        return this.run(numConfs, null);
    }

    public Status run(int numConfs, TaskExecutor.TaskListener<ConfSearch.EnergiedConf> confListener) {
        Status status = Status.HasLowEnergies;
        for (int i = 0; i < numConfs && status == Status.HasLowEnergies; ++i) {
            status = this.energyNextConfAsync(confListener);
        }
        this.waitForFinish();
        return status;
    }

    public Status energyNextConfAsync() {
        return this.energyNextConfAsync(null);
    }

    public Status energyNextConfAsync(TaskExecutor.TaskListener<ConfSearch.EnergiedConf> confListener) {
        ConfDB.Conf dbconf;
        ConfDB.ConfTable confTable;
        ConfSearch.ScoredConf conf = this.tree.nextConf();
        if (conf == null) {
            return Status.OutOfConfs;
        }
        ++this.numConfsScored;
        if (Double.isInfinite(conf.getScore()) || MathTools.isZero(this.boltzmann.calc(conf.getScore()))) {
            return Status.OutOfLowEnergies;
        }
        TaskExecutor.TaskListener<ConfSearch.EnergiedConf> onEconf = econf -> {
            LowerBoundCalculator lowerBoundCalculator = this;
            synchronized (lowerBoundCalculator) {
                if (!Double.isInfinite(econf.getEnergy())) {
                    this.weightedEnergySum = this.weightedEnergySum.add(this.boltzmann.calc(econf.getEnergy()));
                }
                this.weightedScoreSum = this.weightedScoreSum.add(this.boltzmann.calc(econf.getScore()));
                ++this.numConfsEnergied;
            }
            if (confListener != null) {
                confListener.onFinished((ConfSearch.EnergiedConf)econf);
            }
        };
        if (this.confTable != null) {
            confTable = this.confTable;
        } else if (this.confDB != null) {
            Sequence sequence = this.confDB.confSpace.makeSequenceFromAssignments(conf.getAssignments());
            confTable = this.confDB.getSequence(sequence);
        } else {
            confTable = null;
        }
        if (confTable != null && (dbconf = confTable.get(conf.getAssignments())) != null) {
            this.ecalc.tasks.submit(() -> new ConfSearch.EnergiedConf(conf, dbconf.upper.energy), econf -> onEconf.onFinished((ConfSearch.EnergiedConf)econf));
            return Status.HasLowEnergies;
        }
        this.ecalc.calcEnergyAsync(conf, econf -> {
            if (confTable != null) {
                confTable.setBounds(conf.getAssignments(), conf.getScore(), econf.getEnergy(), TimeTools.getTimestampNs());
                confTable.flush();
            }
            onEconf.onFinished((ConfSearch.EnergiedConf)econf);
        });
        return Status.HasLowEnergies;
    }

    public void waitForFinish() {
        this.ecalc.tasks.waitForFinish();
    }

    public String toString() {
        return String.format("LowerBoundCalculator   scored: %6d   energied: %6d   energies: %e   scores: %e", this.numConfsScored, this.numConfsEnergied, this.weightedEnergySum.doubleValue(), this.weightedScoreSum.doubleValue());
    }

    public static enum Status {
        HasLowEnergies,
        OutOfConfs,
        OutOfLowEnergies;

    }
}

