/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar.pfunc;

import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.confspace.ConfDB;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.kstar.KStarScore;
import edu.duke.cs.osprey.kstar.pfunc.BoltzmannCalculator;
import edu.duke.cs.osprey.parallelism.TaskExecutor;
import edu.duke.cs.osprey.tools.BigMath;
import edu.duke.cs.osprey.tools.MathTools;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.time.Duration;
import java.util.function.Function;

public interface PartitionFunction {
    public static final MathContext decimalPrecision = new MathContext(64, RoundingMode.HALF_UP);

    public void setReportProgress(boolean var1);

    public void setConfListener(ConfListener var1);

    public void init(double var1);

    default public void setStabilityThreshold(BigDecimal stabilityThreshold) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not yet support stability thresholds");
    }

    public Status getStatus();

    public Values getValues();

    public int getParallelism();

    public int getNumConfsEvaluated();

    public void compute(int var1);

    default public void compute() {
        this.compute(Integer.MAX_VALUE);
    }

    default public void compute(Duration timeout) {
        long startNs = System.nanoTime();
        long timeoutNs = timeout.toNanos();
        while (this.getStatus().canContinue) {
            int batchSize = this.getParallelism();
            this.compute(batchSize);
            long elapsedNs = System.nanoTime() - startNs;
            if (elapsedNs < timeoutNs) continue;
            break;
        }
    }

    default public Result makeResult() {
        return new Result(this.getStatus(), this.getValues(), this.getNumConfsEvaluated());
    }

    default public void setInstanceId(int val) {
    }

    default public void putTaskContexts(TaskExecutor.ContextGroup contexts) {
    }

    public static enum Status {
        Estimating(true),
        Estimated(false),
        OutOfConformations(false),
        OutOfLowEnergies(false),
        Unstable(false),
        Aborted(false);

        private boolean canContinue;

        private Status(boolean canContinue) {
            this.canContinue = canContinue;
        }

        public boolean canContinue() {
            return this.canContinue;
        }
    }

    public static class Result {
        public final Status status;
        public final Values values;
        public final int numConfs;

        public Result(Status status, Values values2, int numConfs) {
            this.status = status;
            this.values = values2;
            this.numConfs = numConfs;
        }

        public String toString() {
            Function<String, String> trim = s -> {
                if (s.length() > 9) {
                    return s.substring(0, 9);
                }
                return s;
            };
            StringBuilder buf = new StringBuilder();
            buf.append(String.format("[%-9s,%9s]", trim.apply(KStarScore.scoreToLog10String(this.values.calcLowerBound())), trim.apply(KStarScore.scoreToLog10String(this.values.calcUpperBound()))));
            if (this.status == Status.Estimated) {
                buf.append(String.format(" %-26s", "(log10)"));
            } else {
                buf.append(String.format(" %-26s", "(log10," + this.status.name() + ")"));
            }
            return buf.toString();
        }

        public static Result makeAborted() {
            return new Result(Status.Aborted, Values.makeFullRange(), 0);
        }
    }

    public static class Values {
        public BigDecimal qstar = BigDecimal.ZERO;
        public BigDecimal qprime = BigDecimal.ZERO;
        public BigDecimal pstar = BigDecimal.ZERO;

        public static Values makeFullRange() {
            Values values2 = new Values();
            values2.qprime = MathTools.BigPositiveInfinity;
            return values2;
        }

        public double getEffectiveEpsilon() {
            BigDecimal s = MathTools.bigAdd(this.qprime, this.pstar, decimalPrecision);
            BigDecimal qu = MathTools.bigAdd(s, this.qstar, decimalPrecision);
            double delta = MathTools.bigDivide(s, qu, decimalPrecision).doubleValue();
            delta = Math.abs(delta);
            return delta;
        }

        public BigDecimal calcLowerBound() {
            return this.qstar;
        }

        public BigDecimal calcUpperBound() {
            return new BigMath(decimalPrecision).set(this.qstar).add(this.qprime).add(this.pstar).get();
        }

        public MathTools.BigDecimalBounds calcBounds() {
            return new MathTools.BigDecimalBounds(this.calcLowerBound(), this.calcUpperBound());
        }

        public double calcFreeEnergyLowerBound() {
            return new BoltzmannCalculator(decimalPrecision).freeEnergy(this.calcUpperBound());
        }

        public double calcFreeEnergyUpperBound() {
            return new BoltzmannCalculator(decimalPrecision).freeEnergy(this.calcLowerBound());
        }

        public MathTools.DoubleBounds calcFreeEnergyBounds(MathTools.DoubleBounds dest) {
            dest.lower = this.calcFreeEnergyLowerBound();
            dest.upper = this.calcFreeEnergyUpperBound();
            return dest;
        }

        public MathTools.DoubleBounds calcFreeEnergyBounds() {
            return new MathTools.DoubleBounds(this.calcFreeEnergyLowerBound(), this.calcFreeEnergyUpperBound());
        }

        public double calcFreeEnergyLowerBoundPrecise() {
            return new BoltzmannCalculator(decimalPrecision).freeEnergyPrecise(this.calcUpperBound());
        }

        public double calcFreeEnergyUpperBoundPrecise() {
            return new BoltzmannCalculator(decimalPrecision).freeEnergyPrecise(this.calcLowerBound());
        }

        public MathTools.DoubleBounds calcFreeEnergyBoundsPrecise() {
            return new MathTools.DoubleBounds(this.calcFreeEnergyLowerBoundPrecise(), this.calcFreeEnergyUpperBoundPrecise());
        }

        public String toString() {
            return String.format("Z = %s", this.calcBounds());
        }
    }

    public static interface WithExternalMemory
    extends PartitionFunction {
        public void setUseExternalMemory(boolean var1, RCs var2);

        public static void setOrThrow(PartitionFunction pfunc, boolean val, RCs rcs) {
            if (!(pfunc instanceof WithExternalMemory)) {
                throw new UnsupportedException(pfunc);
            }
            ((WithExternalMemory)pfunc).setUseExternalMemory(val, rcs);
        }

        public static class UnsupportedException
        extends RuntimeException {
            public UnsupportedException(PartitionFunction pfunc) {
                super("This partition function implementation (" + pfunc.getClass().getSimpleName() + ") doesn't support external memory");
            }
        }
    }

    public static interface WithConfDB
    extends PartitionFunction {
        public void setConfDB(ConfDB var1, ConfDB.Key var2);

        default public void setConfDB(ConfDB confDB, String table) {
            this.setConfDB(confDB, new ConfDB.Key(table));
        }

        default public void setConfDB(ConfDB confDB, Sequence seq) {
            this.setConfDB(confDB, new ConfDB.Key(seq));
        }

        public static WithConfDB cast(PartitionFunction pfunc) {
            if (pfunc instanceof WithConfDB) {
                return (WithConfDB)pfunc;
            }
            throw new UnsupportedOperationException("This partition function implementation (" + pfunc.getClass().getSimpleName() + ") doesn't support conformation databases");
        }
    }

    public static interface ConfListener {
        public void onConf(ConfSearch.ScoredConf var1);
    }
}

