/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar.pfunc.impl;

import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.kstar.KSConf;
import edu.duke.cs.osprey.kstar.KSConfigFileParser;
import edu.duke.cs.osprey.kstar.KSSearchProblem;
import edu.duke.cs.osprey.kstar.pfunc.PFAbstract;
import edu.duke.cs.osprey.kstar.pfunc.PartitionFunction;
import java.util.ArrayList;

public class PFAdapter
extends PFAbstract {
    private static final long serialVersionUID = -4339776095146902581L;
    private String pfImpl;
    private PartitionFunction pfunc;

    public PFAdapter(String pfImpl, int strand, ArrayList<String> sequence, ArrayList<Integer> absolutePos, String checkPointPath, String reducedSPName, KSConfigFileParser cfp, KSSearchProblem panSP) {
        super(strand, sequence, absolutePos, checkPointPath, reducedSPName, cfp, panSP);
        this.pfImpl = pfImpl;
    }

    public PartitionFunction getPartitionFunction() {
        return this.pfunc;
    }

    public void setPartitionFunction(PartitionFunction pfunc) {
        this.pfunc = pfunc;
    }

    @Override
    protected void printHeader() {
    }

    @Override
    public void start() {
        this.setRunState(PFAbstract.RunState.STARTED);
        this.pfunc.init(PFAbstract.targetEpsilon);
        if (this.isFullyDefined() && saveTopConfsAsPDB) {
            this.pfunc.setConfListener(sconf -> {
                double energy = sconf instanceof ConfSearch.EnergiedConf ? ((ConfSearch.EnergiedConf)sconf).getEnergy() : sconf.getScore();
                this.saveTopConf(new KSConf(((ConfSearch.EnergiedConf)sconf).getAssignments(), ((ConfSearch.EnergiedConf)sconf).getScore(), energy));
            });
        }
    }

    @Override
    protected void computeSlice() {
        this.iterate();
    }

    @Override
    protected void compute() {
        this.pfunc.compute();
        this.update();
    }

    @Override
    protected void iterate() {
        this.pfunc.compute(this.pfunc.getParallelism());
        this.update();
    }

    @Override
    public String getImpl() {
        return this.pfImpl;
    }

    private void update() {
        this.eAppx = this.mapStatus(this.pfunc.getStatus());
        PartitionFunction.Values values2 = this.pfunc.getValues();
        this.qStar = values2.qstar;
        this.qPrime = values2.qprime;
        this.pStar = values2.pstar;
        this.effectiveEpsilon = values2.getEffectiveEpsilon();
    }

    private PFAbstract.EApproxReached mapStatus(PartitionFunction.Status status) {
        switch (status) {
            case Estimating: {
                return PFAbstract.EApproxReached.FALSE;
            }
            case Estimated: {
                return PFAbstract.EApproxReached.TRUE;
            }
        }
        return PFAbstract.EApproxReached.NOT_POSSIBLE;
    }
}

