/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.lute;

import edu.duke.cs.osprey.Queue;
import edu.duke.cs.osprey.astar.conf.ConfAStarTree;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.gmec.ConfPrinter;
import edu.duke.cs.osprey.gmec.ConsoleConfPrinter;
import edu.duke.cs.osprey.gmec.EnergyRange;
import edu.duke.cs.osprey.lute.LUTEConfEnergyCalculator;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import edu.duke.cs.osprey.tools.Stopwatch;

public class LUTEGMECFinder {
    public final PruningMatrix pmat;
    public final LUTEConfEnergyCalculator confEcalc;
    public final ConfPrinter logPrinter;
    public final ConfPrinter consolePrinter;
    public final boolean printIntermediateConfsToConsole;

    private LUTEGMECFinder(PruningMatrix pmat, LUTEConfEnergyCalculator confEcalc, ConfPrinter logPrinter, ConfPrinter consolePrinter, boolean printIntermediateConfsToConsole) {
        this.pmat = pmat;
        this.confEcalc = confEcalc;
        this.logPrinter = logPrinter;
        this.consolePrinter = consolePrinter;
        this.printIntermediateConfsToConsole = printIntermediateConfsToConsole;
    }

    public ConfSearch.ScoredConf find() {
        return (ConfSearch.ScoredConf)this.find(0.0).poll();
    }

    public Queue.FIFO<ConfSearch.ScoredConf> find(double energyWindowSize) {
        Queue.FIFO<ConfSearch.ScoredConf> confs = Queue.FIFOFactory.of(new ConfSearch.ScoredConf[0]);
        ConfAStarTree search2 = new ConfAStarTree.Builder(null, this.pmat).setLUTE(this.confEcalc).build();
        System.out.println("Searching for GMEC...");
        Stopwatch minScoreStopwatch = new Stopwatch().start();
        System.out.println("\t(among " + search2.getNumConformations().floatValue() + " possibilities)");
        ConfSearch.ScoredConf gmec = search2.nextConf();
        if (gmec == null) {
            System.out.println("No conformations found with finite energies");
            return confs;
        }
        System.out.println("Found GMEC in " + minScoreStopwatch.getTime(1));
        this.consolePrinter.print(gmec, this.confEcalc.confSpace);
        this.logPrinter.print(gmec, this.confEcalc.confSpace);
        confs.push(gmec);
        if (energyWindowSize > 0.0) {
            EnergyRange ewin = new EnergyRange(gmec.getScore(), energyWindowSize);
            while (true) {
                ConfSearch.ScoredConf conf;
                if ((conf = search2.nextConf()) == null) {
                    System.out.println("Conformation space exhausted, can't finished enumerating energy window.");
                    break;
                }
                if (!ewin.contains(conf.getScore())) break;
                confs.push(conf);
                if (this.printIntermediateConfsToConsole) {
                    System.out.println();
                    this.consolePrinter.print(conf, this.confEcalc.confSpace);
                }
                this.logPrinter.print(conf, this.confEcalc.confSpace);
            }
            System.out.println(String.format("Found %d total conformations in energy window", confs.size()));
        }
        return confs;
    }

    public static class Builder {
        private PruningMatrix pmat;
        private LUTEConfEnergyCalculator confEcalc;
        private ConfPrinter logPrinter;
        private ConfPrinter consolePrinter;
        private boolean printIntermediateConfsToConsole = false;

        public Builder(PruningMatrix pmat, LUTEConfEnergyCalculator confEcalc) {
            this.pmat = pmat;
            this.confEcalc = confEcalc;
            this.logPrinter = new ConfPrinter.Nop();
            this.consolePrinter = new ConsoleConfPrinter();
        }

        public Builder setLogPrinter(ConfPrinter val) {
            this.logPrinter = val;
            return this;
        }

        public Builder setConsolePrinter(ConfPrinter val) {
            this.consolePrinter = val;
            return this;
        }

        public Builder setPrintIntermediateConfsToConsole(boolean val) {
            this.printIntermediateConfsToConsole = val;
            return this;
        }

        public LUTEGMECFinder build() {
            return new LUTEGMECFinder(this.pmat, this.confEcalc, this.logPrinter, this.consolePrinter, this.printIntermediateConfsToConsole);
        }
    }
}

