/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.lute;

import edu.duke.cs.osprey.confspace.Conf;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.confspace.TuplesIndex;
import edu.duke.cs.osprey.lute.ConfSampler;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import edu.duke.cs.osprey.tools.MathTools;
import edu.duke.cs.osprey.tools.UnpossibleError;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

@Deprecated
public class UniformConfSampler
extends ConfSampler {
    public UniformConfSampler(SimpleConfSpace confSpace, PruningMatrix pmat, int randomSeed) {
        super(confSpace, pmat, randomSeed);
    }

    public BigInteger getNumConfsUpperBound(RCTuple tuple, TuplesIndex tuples) {
        if (tuple.size() == this.confSpace.positions.size()) {
            return BigInteger.ONE;
        }
        int[] conf = Conf.make(this.confSpace, tuple);
        BigInteger numConfs = BigInteger.ZERO;
        for (SimpleConfSpace.Position pos : this.confSpace.positions) {
            if (conf[pos.index] != -1) continue;
            int numAssignments = 0;
            for (SimpleConfSpace.ResidueConf rc : pos.resConfs) {
                if (!tuples.isAssignmentCoveredByPairs(conf, pos.index, rc.index)) continue;
                ++numAssignments;
            }
            if (MathTools.isZero(numConfs)) {
                numConfs = BigInteger.valueOf(numAssignments);
                continue;
            }
            numConfs = numConfs.multiply(BigInteger.valueOf(numAssignments));
        }
        return numConfs;
    }

    @Override
    public void sampleConfsForTuples(ConfSampler.Samples samples, int minSamplesPerTuple) {
        HashSet<RCTuple> unsampleableTuples = new HashSet<RCTuple>();
        while (true) {
            RCTuple tuple;
            if ((tuple = samples.getLeastSampledTuple(unsampleableTuples)) == null) {
                throw new Error("can't find another tuple to sample. This is probably a bug?");
            }
            int numSamples = samples.getConfs(tuple).size();
            if (numSamples >= minSamplesPerTuple) break;
            BigInteger maxNumConfs = this.getNumConfsUpperBound(tuple, samples.tuples);
            if (BigInteger.valueOf(numSamples).compareTo(maxNumConfs) >= 0) {
                unsampleableTuples.add(tuple);
                continue;
            }
            int[] conf = this.sample(tuple, samples.getConfs(tuple), 100, samples.tuples);
            if (conf == null) {
                unsampleableTuples.add(tuple);
                continue;
            }
            samples.addConf(conf);
        }
    }

    public int[] sample(RCTuple tuple, Set<int[]> except, int numAttempts, TuplesIndex tuples) {
        for (int i = 0; i < numAttempts; ++i) {
            int[] conf = this.sample(tuple, tuples);
            if (conf == null || except != null && except.contains(conf)) continue;
            return conf;
        }
        return null;
    }

    public int[] sample(RCTuple tuple, TuplesIndex tuples) {
        int[] conf = Conf.make(this.confSpace, tuple);
        HashSet<RCTuple> assignments = new HashSet<RCTuple>();
        for (SimpleConfSpace.Position pos : this.confSpace.positions) {
            if (conf[pos.index] != -1) continue;
            for (SimpleConfSpace.ResidueConf rc : pos.resConfs) {
                assignments.add(new RCTuple(pos.index, rc.index));
            }
        }
        while (true) {
            assignments.removeIf(assignment -> !tuples.isAssignmentCoveredByPairs(conf, assignment.pos.get(0), assignment.RCs.get(0)) || this.isPruned(conf, assignment.pos.get(0), assignment.RCs.get(0)));
            if (assignments.isEmpty()) {
                if (Conf.isCompletelyAssigned(conf)) {
                    return conf;
                }
                return null;
            }
            RCTuple assignment2 = (RCTuple)this.removeRandom(assignments);
            assert (conf[assignment2.pos.get(0)] == -1);
            conf[assignment2.pos.get((int)0).intValue()] = assignment2.RCs.get(0);
            if (Conf.isCompletelyAssigned(conf)) {
                return conf;
            }
            assignments.removeIf(a -> a.pos.get(0) == assignment.pos.get(0));
        }
    }

    private <T> T removeRandom(Set<T> set) {
        int removeIndex = this.rand.nextInt(set.size());
        Iterator<T> iter = set.iterator();
        int index = 0;
        while (iter.hasNext()) {
            T item = iter.next();
            if (index == removeIndex) {
                iter.remove();
                return item;
            }
            ++index;
        }
        throw new UnpossibleError();
    }

    private boolean isPruned(int[] conf, int nextPos, int nextRC) {
        for (int pos1 = 1; pos1 < this.pmat.getNumPos(); ++pos1) {
            if (nextPos == pos1 || conf[pos1] == -1) continue;
            for (int pos2 = 0; pos2 < pos1; ++pos2) {
                if (nextPos == pos2 || conf[pos2] == -1 || !this.pmat.isTriplePruned(pos1, conf[pos1], pos2, conf[pos2], nextPos, nextRC)) continue;
                return true;
            }
        }
        return false;
    }
}

