/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.markstar;

import edu.duke.cs.osprey.astar.AStarProgress;
import edu.duke.cs.osprey.tools.JvmMem;
import edu.duke.cs.osprey.tools.Stopwatch;

public class MARKStarProgress
extends AStarProgress {
    private static final long serialVersionUID = 767988861537797830L;
    private static final int ReportIntervalMs = 10000;
    private int numLevels;
    private int level;
    private int deepestLevel;
    private double gscore;
    private double hscore;
    private long numNodesExpanded;
    private long numNodesInQueue;
    private long numNodesQueuedThisReport;
    private Stopwatch stopwatch;
    private int msRunning;
    private int numLeafNodes;
    private double goalScore;
    private double curEpsilon;
    private int numPartialMinimizations;

    public MARKStarProgress(int numLevels) {
        super(numLevels);
        this.numLevels = numLevels;
        this.level = 0;
        this.deepestLevel = 0;
        this.gscore = Double.POSITIVE_INFINITY;
        this.hscore = Double.POSITIVE_INFINITY;
        this.numNodesInQueue = 0L;
        this.numNodesQueuedThisReport = 0L;
        this.numPartialMinimizations = 0;
        this.stopwatch = new Stopwatch();
        this.msRunning = 0;
        this.numLeafNodes = 0;
        this.curEpsilon = 1.0;
    }

    public void reportInternalNode(int level, double gscore, double hscore, long numNodesInQueue, int numAddedToQueue, double curEpsilon) {
        int msRunning;
        ++this.numNodesExpanded;
        this.numNodesInQueue = numNodesInQueue;
        this.numNodesQueuedThisReport += (long)numAddedToQueue;
        this.curEpsilon = curEpsilon;
        if (this.numLeafNodes > 0) {
            return;
        }
        this.level = level;
        this.deepestLevel = Math.max(this.deepestLevel, this.level);
        this.gscore = gscore;
        this.hscore = hscore;
        if (!this.stopwatch.isRunning()) {
            this.stopwatch.start();
            this.msRunning = 0;
        }
        if ((msRunning = (int)this.stopwatch.getTimeMs()) >= this.msRunning + 10000) {
            this.printProgressReport();
            this.msRunning = msRunning;
            this.numNodesQueuedThisReport = 0L;
        }
    }

    @Override
    public String makeProgressReport() {
        double diffMs = this.stopwatch.getTimeMs() - (double)this.msRunning;
        Object oldPool = "(Error)";
        try {
            oldPool = String.valueOf(JvmMem.getOldPool());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.format("MARK* expanded:%10d, queued:%10d, scored/sec:%5d, partial minimizations:%5d, time:%s, delta:%12.11f heapMem:%s", this.numNodesExpanded, this.numNodesInQueue, (int)((double)(this.numNodesQueuedThisReport * 1000L) / diffMs), this.numPartialMinimizations, this.stopwatch.getTime(2), this.curEpsilon, oldPool);
    }

    @Override
    public void setGoalScore(double val) {
        this.goalScore = val;
    }

    public void reportLeafNode(double gscore, long numNodesInQueue, double curEpsilon) {
        this.curEpsilon = curEpsilon;
        super.reportLeafNode(gscore, numNodesInQueue);
    }

    @Override
    protected String makeLeafProgressReport() {
        double diffMs = this.stopwatch.getTimeMs() - (double)this.msRunning;
        return String.format("A* leaf nodes:%10d, score:%14.8f, remaining:%14.8f, expanded:%10d, queued:%10d, scored/sec:%5d, time:%s, delta:%10.4f, heapMem:%s", this.numLeafNodes, this.gscore, this.goalScore - this.gscore, this.numNodesExpanded, this.numNodesInQueue, (int)((double)(this.numNodesQueuedThisReport * 1000L) / diffMs), this.stopwatch.getTime(2), this.curEpsilon, JvmMem.getOldPool());
    }

    public void reportPartialMinimization(int numPartialMinimizations, double curEpsilon) {
        int msRunning;
        this.numPartialMinimizations += numPartialMinimizations;
        this.curEpsilon = curEpsilon;
        if (!this.stopwatch.isRunning()) {
            this.stopwatch.start();
            this.msRunning = 0;
        }
        if ((msRunning = (int)this.stopwatch.getTimeMs()) >= this.msRunning + 10000) {
            this.printProgressReport();
            this.msRunning = msRunning;
            this.numNodesQueuedThisReport = 0L;
            this.numPartialMinimizations = 0;
        }
    }
}

