/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.markstar.framework;

import edu.duke.cs.osprey.astar.conf.ConfIndex;
import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.astar.conf.order.AStarOrder;
import edu.duke.cs.osprey.astar.conf.order.UpperLowerAStarOrder;
import edu.duke.cs.osprey.astar.conf.pruning.AStarPruner;
import edu.duke.cs.osprey.astar.conf.scoring.AStarScorer;
import edu.duke.cs.osprey.astar.conf.scoring.PairwiseGScorer;
import edu.duke.cs.osprey.astar.conf.scoring.TraditionalPairwiseHScorer;
import edu.duke.cs.osprey.confspace.ConfDB;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.ematrix.NegatedEnergyMatrix;
import edu.duke.cs.osprey.ematrix.UpdatingEnergyMatrix;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.kstar.pfunc.BoltzmannCalculator;
import edu.duke.cs.osprey.kstar.pfunc.PartitionFunction;
import edu.duke.cs.osprey.kstar.pfunc.PfuncSurface;
import edu.duke.cs.osprey.markstar.MARKStarProgress;
import edu.duke.cs.osprey.markstar.framework.MARKStarNode;
import edu.duke.cs.osprey.tools.BigMath;
import edu.duke.cs.osprey.tools.JvmMem;
import edu.duke.cs.osprey.tools.MathTools;
import edu.duke.cs.osprey.tools.Stopwatch;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;

public class GradientDescentMARKStarPfunc
implements PartitionFunction.WithConfDB,
PartitionFunction.WithExternalMemory {
    private final AStarScorer gScorer;
    private final AStarScorer rigidgScorer;
    private final AStarScorer hScorer;
    private final AStarScorer negatedHScorer;
    private final EnergyMatrix minimizingEnergyMatrix;
    private final EnergyMatrix rigidEnergyMatrix;
    private AStarOrder order;
    private AStarPruner pruner;
    private MARKStarProgress progress;
    public final ConfEnergyCalculator ecalc;
    private double targetEpsilon = Double.NaN;
    private BigDecimal stabilityThreshold = BigDecimal.ZERO;
    private PartitionFunction.ConfListener confListener = null;
    private boolean isReportingProgress = false;
    private Stopwatch stopwatch = new Stopwatch().start();
    private ConfSearch scoreConfs = null;
    private ConfSearch energyConfs = null;
    private BoltzmannCalculator bcalc = new BoltzmannCalculator(PartitionFunction.decimalPrecision);
    private MARKStarNode root;
    private Queue<MARKStarNode> queue = new PriorityBlockingQueue<MARKStarNode>();
    private UpdatingEnergyMatrix correctionMatrix;
    private PartitionFunction.Status status = null;
    private PartitionFunction.Values values = null;
    private State state = null;
    private boolean hasEnergyConfs = true;
    private boolean hasScoreConfs = true;
    private long numEnergyConfsEnumerated = 0L;
    private long numScoreConfsEnumerated = 0L;
    private ConfDB.ConfTable confTable = null;
    private boolean useExternalMemory = false;
    private RCs rcs = null;
    private PfuncSurface surf = null;
    private PfuncSurface.Trace trace = null;

    public void setCorrections(UpdatingEnergyMatrix corrections) {
        this.correctionMatrix = corrections;
    }

    public GradientDescentMARKStarPfunc(SimpleConfSpace confSpace, EnergyMatrix rigidEnergyMatrix, EnergyMatrix minimizingEnergyMatrix, RCs rcs, ConfEnergyCalculator ecalc) {
        this.ecalc = ecalc;
        this.minimizingEnergyMatrix = minimizingEnergyMatrix;
        this.rigidEnergyMatrix = rigidEnergyMatrix;
        MARKStarNode.ScorerFactory gScorerFactory = emats -> new PairwiseGScorer(emats);
        MARKStarNode.ScorerFactory hScorerFactory = emats -> new TraditionalPairwiseHScorer(minimizingEnergyMatrix, rcs);
        this.gScorer = new PairwiseGScorer(minimizingEnergyMatrix);
        this.rigidgScorer = new PairwiseGScorer(rigidEnergyMatrix);
        this.negatedHScorer = hScorerFactory.make(new NegatedEnergyMatrix(confSpace, rigidEnergyMatrix));
        this.hScorer = hScorerFactory.make(minimizingEnergyMatrix);
        EnergyMatrix minimizingEmat = minimizingEnergyMatrix;
        EnergyMatrix rigidEmat = rigidEnergyMatrix;
        this.root = MARKStarNode.makeRoot(confSpace, rigidEmat, minimizingEmat, rcs, gScorerFactory.make(minimizingEmat), hScorerFactory.make(minimizingEmat), gScorerFactory.make(rigidEmat), new TraditionalPairwiseHScorer(new NegatedEnergyMatrix(confSpace, rigidEmat), rcs), true);
        this.order = new UpperLowerAStarOrder();
        this.rcs = rcs;
        this.correctionMatrix = new UpdatingEnergyMatrix(confSpace, minimizingEnergyMatrix);
        this.progress = new MARKStarProgress(rcs.getNumPos());
    }

    private void boundLowestBoundConfUnderNode(MARKStarNode startNode, List<MARKStarNode> generatedNodes) {
        Comparator<MARKStarNode> confBoundComparator = Comparator.comparingDouble(o -> o.getConfSearchNode().getConfLowerBound());
        PriorityQueue<MARKStarNode> drillQueue = new PriorityQueue<MARKStarNode>(confBoundComparator);
        drillQueue.add(startNode);
        ArrayList<MARKStarNode> newNodes = new ArrayList<MARKStarNode>();
        int numNodes = 0;
        Stopwatch leafLoop = new Stopwatch().start();
        Stopwatch overallLoop = new Stopwatch().start();
        while (!drillQueue.isEmpty()) {
            ++numNodes;
            MARKStarNode curNode = drillQueue.poll();
            MARKStarNode.Node node = curNode.getConfSearchNode();
            ConfIndex index = new ConfIndex(this.rcs.getNumPos());
            node.index(index);
            if (node.getLevel() >= this.rcs.getNumPos()) {
                newNodes.add(curNode);
                break;
            }
            MARKStarNode nextNode = this.drillDown(newNodes, curNode, node);
            newNodes.remove(nextNode);
            drillQueue.add(nextNode);
            if (!(leafLoop.getTimeS() > 10.0)) continue;
            leafLoop.stop();
            leafLoop.reset();
            leafLoop.start();
            System.out.println(String.format("Processed %d, %s so far. Bounds are now [%12.6e,%12.6e]", numNodes, overallLoop.getTime(2), this.root.getLowerBound(), this.root.getUpperBound()));
        }
        generatedNodes.addAll(newNodes);
    }

    private MARKStarNode drillDown(List<MARKStarNode> newNodes, MARKStarNode curNode, MARKStarNode.Node node) {
        ConfIndex confIndex = new ConfIndex(this.rcs.getNumPos());
        node.index(confIndex);
        int nextPos = this.order.getNextPos(confIndex, this.rcs);
        assert (!confIndex.isDefined(nextPos));
        assert (confIndex.isUndefined(nextPos));
        ArrayList<MARKStarNode> children = new ArrayList<MARKStarNode>();
        double bestChildLower = Double.POSITIVE_INFINITY;
        MARKStarNode bestChild = null;
        for (int nextRc : this.rcs.get(nextPos)) {
            if (this.hasPrunedPair(confIndex, nextPos, nextRc) || this.pruner != null && this.pruner.isPruned(node, nextPos, nextRc)) continue;
            Stopwatch partialTime = new Stopwatch().start();
            MARKStarNode.Node child = node.assign(nextPos, nextRc);
            double confLowerBound = Double.POSITIVE_INFINITY;
            if (child.getLevel() < this.rcs.getNumPos()) {
                double diff = this.gScorer.calcDifferential(confIndex, this.rcs, nextPos, nextRc);
                double rigiddiff = this.rigidgScorer.calcDifferential(confIndex, this.rcs, nextPos, nextRc);
                double hdiff = this.hScorer.calcDifferential(confIndex, this.rcs, nextPos, nextRc);
                double maxhdiff = -this.negatedHScorer.calcDifferential(confIndex, this.rcs, nextPos, nextRc);
                child.gscore = diff;
                child.rigidScore = rigiddiff = rigiddiff - node.gscore + node.rigidScore;
                confLowerBound = child.gscore + hdiff;
                double confUpperbound = rigiddiff + maxhdiff;
                child.computeNumConformations(this.rcs);
                child.setBoundsFromConfLowerAndUpper(confLowerBound, confUpperbound);
                this.progress.reportInternalNode(child.level, child.gscore, child.getHScore(), this.queue.size(), children.size(), this.state.prevDelta);
            }
            if (child.getLevel() == this.rcs.getNumPos()) {
                double confRigid = this.rigidgScorer.calcDifferential(confIndex, this.rcs, nextPos, nextRc);
                confRigid = confRigid - node.gscore + node.rigidScore;
                child.computeNumConformations(this.rcs);
                double confCorrection = this.gScorer.calcDifferential(confIndex, this.rcs, nextPos, nextRc);
                child.setBoundsFromConfLowerAndUpper(confCorrection, confRigid);
                child.gscore = child.getConfLowerBound();
                child.rigidScore = confRigid;
                ++this.state.numScoredConfs;
                this.progress.reportLeafNode(child.gscore, this.queue.size(), this.state.prevDelta);
            }
            partialTime.stop();
            if (Double.isNaN(child.rigidScore)) {
                System.out.println("Huh!?");
            }
            MARKStarNode MARKStarNodeChild = curNode.makeChild(child);
            MARKStarNodeChild.markUpdated();
            if (MARKStarNodeChild.getConfSearchNode().getConfLowerBound() < 0.0) {
                children.add(MARKStarNodeChild);
            }
            newNodes.add(MARKStarNodeChild);
        }
        return bestChild;
    }

    @Override
    public void setReportProgress(boolean val) {
        this.isReportingProgress = val;
    }

    @Override
    public void setConfListener(PartitionFunction.ConfListener val) {
        this.confListener = val;
    }

    @Override
    public PartitionFunction.Status getStatus() {
        return this.status;
    }

    @Override
    public PartitionFunction.Values getValues() {
        return this.values;
    }

    @Override
    public int getNumConfsEvaluated() {
        return (int)this.state.numEnergiedConfs;
    }

    public int getNumConfsScored() {
        return (int)this.state.numScoredConfs;
    }

    @Override
    public int getParallelism() {
        return this.ecalc.tasks.getParallelism();
    }

    @Override
    public void setConfDB(ConfDB confDB, ConfDB.Key key) {
        this.confTable = confDB.get(key);
    }

    @Override
    public void setUseExternalMemory(boolean val, RCs rcs) {
        this.useExternalMemory = val;
        this.rcs = rcs;
    }

    public void traceTo(PfuncSurface val) {
        this.surf = val;
    }

    @Override
    public void init(double targetEpsilon) {
        throw new Error("If anyone ever uses this again, update it to the newest PartitionFunction api");
    }

    @Override
    public void setStabilityThreshold(BigDecimal val) {
        this.stabilityThreshold = val;
    }

    public void setRCs(RCs rcs) {
        this.rcs = rcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compute(int maxNumConfs) {
        if (this.status == null) {
            throw new IllegalStateException("pfunc was not initialized. Call init() before compute()");
        }
        if (!this.status.canContinue()) {
            return;
        }
        if (this.surf != null) {
            this.trace = new PfuncSurface.Trace(this.surf);
        }
        boolean keepStepping = true;
        int numConfsEnergied = 0;
        while (numConfsEnergied < maxNumConfs) {
            Step step = Step.None;
            int numScores = 0;
            GradientDescentMARKStarPfunc gradientDescentMARKStarPfunc = this;
            synchronized (gradientDescentMARKStarPfunc) {
                boolean energySteeperThanScore;
                boolean bl = keepStepping = keepStepping && !this.state.epsilonReached(this.targetEpsilon) && this.state.isStable(this.stabilityThreshold) && this.state.hasLowEnergies();
                if (!keepStepping) {
                    break;
                }
                if (Double.isNaN(this.state.dEnergy) || Double.isNaN(this.state.dScore)) {
                    throw new Error("Can't determine gradient of delta surface. This is a bug.");
                }
                boolean scoreAheadOfEnergy = this.numEnergyConfsEnumerated < this.numScoreConfsEnumerated;
                boolean bl2 = energySteeperThanScore = this.state.dEnergy <= this.state.dScore;
                if (this.hasEnergyConfs && (scoreAheadOfEnergy && energySteeperThanScore || !this.hasScoreConfs)) {
                    step = Step.Energy;
                } else if (this.hasScoreConfs) {
                    step = Step.Score;
                    double scoringSeconds = Math.max(0.1 / this.state.energyOps, 0.01);
                    numScores = Math.max((int)(scoringSeconds * this.state.scoreOps), 1);
                }
            }
            switch (step) {
                case Energy: {
                    class EnergyResult {
                        ConfSearch.EnergiedConf econf;
                        BigDecimal scoreWeight;
                        BigDecimal energyWeight;
                        Stopwatch stopwatch = new Stopwatch();

                        EnergyResult(GradientDescentMARKStarPfunc this$0) {
                        }
                    }
                    ConfSearch.ScoredConf conf = this.energyConfs.nextConf();
                    if (conf != null) {
                        ++this.numEnergyConfsEnumerated;
                    }
                    if (conf == null || conf.getScore() == Double.POSITIVE_INFINITY) {
                        this.hasEnergyConfs = false;
                        keepStepping = false;
                        break;
                    }
                    ++numConfsEnergied;
                    this.ecalc.tasks.submit(() -> {
                        EnergyResult result = new EnergyResult(this);
                        result.stopwatch.start();
                        result.econf = this.ecalc.calcEnergy(conf, this.confTable);
                        result.scoreWeight = this.bcalc.calc(result.econf.getScore());
                        result.energyWeight = this.bcalc.calc(result.econf.getEnergy());
                        result.stopwatch.stop();
                        return result;
                    }, result -> this.onEnergy(result.econf, result.scoreWeight, result.energyWeight, result.stopwatch.getTimeS()));
                    break;
                }
                case Score: {
                    class ScoreResult {
                        List<BigDecimal> scoreWeights = new ArrayList<BigDecimal>();
                        Stopwatch stopwatch = new Stopwatch();

                        ScoreResult(GradientDescentMARKStarPfunc this$0) {
                        }
                    }
                    ArrayList<MARKStarNode> nodes = new ArrayList<MARKStarNode>();
                    for (int i = 0; i < numScores; ++i) {
                        MARKStarNode conf = this.queue.poll();
                        if (conf == null) continue;
                        if (this.queue.isEmpty()) {
                            this.processNode(conf);
                        } else {
                            nodes.add(conf);
                        }
                        if (conf != null) {
                            ++this.numScoreConfsEnumerated;
                        }
                        if (conf != null && conf.getConfSearchNode().getConfLowerBound() != Double.POSITIVE_INFINITY) continue;
                        this.hasScoreConfs = false;
                        break;
                    }
                    this.ecalc.tasks.submit(() -> {
                        ScoreResult result = new ScoreResult(this);
                        result.stopwatch.start();
                        for (MARKStarNode node : nodes) {
                            this.processNode(node);
                            node.markUpdated();
                        }
                        result.stopwatch.stop();
                        return result;
                    }, result -> this.onScores(nodes.size(), result.stopwatch.getTimeS()));
                    break;
                }
                case None: {
                    keepStepping = false;
                }
            }
        }
        this.ecalc.tasks.waitForFinish();
        this.values.qstar = this.state.getLowerBound();
        this.values.qprime = new BigMath(PartitionFunction.decimalPrecision).set(this.state.getUpperBound()).sub(this.state.getLowerBound()).get();
        if (!this.state.hasLowEnergies()) {
            this.status = PartitionFunction.Status.OutOfLowEnergies;
        }
        if (!this.hasEnergyConfs) {
            this.status = PartitionFunction.Status.OutOfConformations;
        }
        if (this.state.epsilonReached(this.targetEpsilon)) {
            this.status = PartitionFunction.Status.Estimated;
            System.out.println(String.format("Total Z upper bound reduction through minimizations: %12.6e", this.state.cumulativeZReduction));
            System.out.println(String.format("Average Z upper bound reduction per minimizations: %12.6e", this.state.cumulativeZReduction.divide(new BigDecimal(this.state.numEnergiedConfs), new MathContext(4))));
        }
        if (!this.state.isStable(this.stabilityThreshold)) {
            this.status = PartitionFunction.Status.Unstable;
        }
    }

    private void processNode(MARKStarNode node) {
        if (node.getConfSearchNode().getLevel() == this.rcs.getNumPos()) {
            this.processFullConfNode(node);
        } else {
            ArrayList nodes = new ArrayList();
            this.processPartialConfNode(node);
        }
    }

    private void processFullConfNode(MARKStarNode node) {
    }

    private void processPartialConfNode(MARKStarNode curNode) {
        ConfIndex confIndex = new ConfIndex(this.rcs.getNumPos());
        MARKStarNode.Node node = curNode.getConfSearchNode();
        node.index(confIndex);
        int nextPos = this.order.getNextPos(confIndex, this.rcs);
        assert (!confIndex.isDefined(nextPos));
        assert (confIndex.isUndefined(nextPos));
        ArrayList<MARKStarNode> children = new ArrayList<MARKStarNode>();
        for (int nextRc : this.rcs.get(nextPos)) {
            MARKStarNode MARKStarNodeChild;
            if (this.hasPrunedPair(confIndex, nextPos, nextRc) || this.pruner != null && this.pruner.isPruned(node, nextPos, nextRc)) continue;
            Stopwatch partialTime = new Stopwatch().start();
            node.index(confIndex);
            MARKStarNode.Node child = node.assign(nextPos, nextRc);
            if (child.getLevel() < this.rcs.getNumPos()) {
                double confCorrection;
                double diff = confCorrection = this.correctionMatrix.confE(child.assignments);
                double rigiddiff = this.rigidgScorer.calcDifferential(confIndex, this.rcs, nextPos, nextRc);
                double hdiff = this.hScorer.calcDifferential(confIndex, this.rcs, nextPos, nextRc);
                double maxhdiff = -this.negatedHScorer.calcDifferential(confIndex, this.rcs, nextPos, nextRc);
                child.gscore = diff;
                child.rigidScore = rigiddiff = rigiddiff - node.gscore + node.rigidScore;
                double confLowerBound = child.gscore + hdiff;
                double confUpperbound = rigiddiff + maxhdiff;
                child.computeNumConformations(this.rcs);
                double lowerbound = this.minimizingEnergyMatrix.confE(child.assignments);
                if (diff < confCorrection) {
                    this.recordCorrection(confLowerBound, confCorrection - diff);
                    confLowerBound = confCorrection + hdiff;
                }
                child.setBoundsFromConfLowerAndUpper(confLowerBound, confUpperbound);
                this.progress.reportInternalNode(child.level, child.gscore, child.getHScore(), this.queue.size(), children.size(), this.state.prevDelta);
            }
            if (child.getLevel() == this.rcs.getNumPos()) {
                double confRigid = this.rigidgScorer.calcDifferential(confIndex, this.rcs, nextPos, nextRc);
                confRigid = confRigid - node.gscore + node.rigidScore;
                child.computeNumConformations(this.rcs);
                double confCorrection = this.correctionMatrix.confE(child.assignments);
                double lowerbound = this.minimizingEnergyMatrix.confE(child.assignments);
                if (lowerbound < confCorrection) {
                    this.recordCorrection(lowerbound, confCorrection - lowerbound);
                }
                child.setBoundsFromConfLowerAndUpper(confCorrection, confRigid);
                child.gscore = child.getConfLowerBound();
                child.rigidScore = confRigid;
                ++this.state.numScoredConfs;
                this.progress.reportLeafNode(child.gscore, this.queue.size(), this.state.prevDelta);
            }
            partialTime.stop();
            if (Double.isNaN(child.rigidScore)) {
                System.out.println("Huh!?");
            }
            if ((MARKStarNodeChild = curNode.makeChild(child)).getConfSearchNode().getConfLowerBound() < 0.0) {
                children.add(MARKStarNodeChild);
            }
            if (!child.isMinimized()) {
                this.queue.add(MARKStarNodeChild);
                continue;
            }
            MARKStarNodeChild.computeEpsilonErrorBounds();
        }
        curNode.markUpdated();
    }

    private void recordCorrection(double lowerbound, double v) {
    }

    private boolean hasPrunedPair(ConfIndex confIndex, int nextPos, int nextRc) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEnergy(ConfSearch.EnergiedConf econf, BigDecimal scoreWeight, BigDecimal energyWeight, double seconds) {
        GradientDescentMARKStarPfunc gradientDescentMARKStarPfunc = this;
        synchronized (gradientDescentMARKStarPfunc) {
            if (energyWeight.compareTo(scoreWeight) == 1) {
                System.err.println("Bounds are incorrect:" + String.valueOf(energyWeight) + " > " + String.valueOf(scoreWeight));
            }
            this.state.energyWeightSum = this.state.energyWeightSum.add(energyWeight);
            this.state.lowerScoreWeightSum = this.state.lowerScoreWeightSum.add(scoreWeight);
            ++this.state.numEnergiedConfs;
            this.state.energyOps = 1.0 / seconds;
            if (MathTools.isLessThan(scoreWeight, this.state.minLowerScoreWeight)) {
                this.state.minLowerScoreWeight = scoreWeight;
            }
            double delta = this.state.calcDelta();
            this.state.dEnergy = GradientDescentMARKStarPfunc.calcSlope(delta, this.state.prevDelta, this.state.dScore);
            this.state.prevDelta = delta;
            this.state.cumulativeZReduction = this.state.cumulativeZReduction.add(scoreWeight.subtract(energyWeight));
            int minimizationSize = econf.getAssignments().length;
            if (this.state.minList.size() < minimizationSize) {
                this.state.minList.addAll(new ArrayList<Integer>(Collections.nCopies(minimizationSize - this.state.minList.size(), 0)));
            }
            this.state.minList.set(minimizationSize - 1, this.state.minList.get(minimizationSize - 1) + 1);
            this.state.dScore *= 2.0;
            if (this.isReportingProgress) {
                int[] x = econf.getAssignments();
                System.out.println("[" + SimpleConfSpace.formatConfRCs(econf) + "] " + String.format("conf:%4d, score:%12.6f, energy:%12.6f, bounds:[%12e,%12e], delta:%.6f, time:%10s, heapMem:%s", this.state.numEnergiedConfs, econf.getScore(), econf.getEnergy(), this.state.getLowerBound().doubleValue(), this.state.getUpperBound().doubleValue(), this.state.calcDelta(), this.stopwatch.getTime(2), JvmMem.getOldPool()));
            }
            if (this.trace != null) {
                this.trace.step(this.state.numScoredConfs, this.state.numEnergiedConfs, this.state.calcDelta());
            }
        }
        if (this.confListener != null) {
            this.confListener.onConf(econf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onScores(int numScored, double seconds) {
        GradientDescentMARKStarPfunc gradientDescentMARKStarPfunc = this;
        synchronized (gradientDescentMARKStarPfunc) {
            BigDecimal oldUpper = this.state.getUpperBound();
            this.root.computeEpsilonErrorBounds();
            BigDecimal newUpper = this.state.getUpperBound();
            System.out.println(String.format("Upper bound was %12.6e, now is %12.6e", oldUpper, newUpper));
            double newEpsilon = this.state.calcDelta();
            this.state.numScoredConfs += (long)numScored;
            this.state.scoreOps = (double)numScored / seconds;
            double delta = newEpsilon;
            this.state.dScore = GradientDescentMARKStarPfunc.calcSlope(delta, this.state.prevDelta, this.state.dEnergy);
            this.state.prevDelta = delta;
            this.state.dEnergy *= 2.0;
            if (this.trace != null) {
                this.trace.step(this.state.numScoredConfs, this.state.numEnergiedConfs, this.state.calcDelta());
            }
        }
    }

    private static double calcSlope(double delta, double prevDelta, double otherSlope) {
        double slope = delta - prevDelta;
        if (slope >= 0.0) {
            slope = otherSlope / 10.0;
        }
        return slope;
    }

    @Override
    public PartitionFunction.Result makeResult() {
        return new PartitionFunction.Result(this.getStatus(), this.getValues(), this.getNumConfsEvaluated());
    }

    private static class State {
        BigDecimal numConfs;
        long numScoredConfs = 0L;
        BigDecimal upperScoreWeightSum = BigDecimal.ZERO;
        BigDecimal minUpperScoreWeight = MathTools.BigPositiveInfinity;
        long numEnergiedConfs = 0L;
        BigDecimal lowerScoreWeightSum = BigDecimal.ZERO;
        BigDecimal energyWeightSum = BigDecimal.ZERO;
        BigDecimal minLowerScoreWeight = MathTools.BigPositiveInfinity;
        BigDecimal cumulativeZReduction = BigDecimal.ZERO;
        ArrayList<Integer> minList = new ArrayList();
        double scoreOps = 100.0;
        double energyOps = 1.0;
        double prevDelta = 1.0;
        double dEnergy = -1.0;
        double dScore = -1.0;
        private MARKStarNode root;

        State(BigInteger numConfs) {
            this.numConfs = new BigDecimal(numConfs);
        }

        double calcDelta() {
            BigDecimal upperBound = this.getUpperBound();
            if (MathTools.isZero(upperBound) || MathTools.isInf(upperBound)) {
                return 1.0;
            }
            return new BigMath(PartitionFunction.decimalPrecision).set(upperBound).sub(this.getLowerBound()).div(upperBound).get().doubleValue();
        }

        public BigDecimal getLowerBound() {
            return this.energyWeightSum;
        }

        public void printBoundStats() {
            System.out.println("Num confs: " + String.format("%12e", this.numConfs));
            System.out.println("Num Scored confs: " + String.format("%4d", this.numScoredConfs));
            String upperScoreString = this.minUpperScoreWeight.toString();
            String upperSumString = this.upperScoreWeightSum.toString();
            if (!MathTools.isInf(this.minUpperScoreWeight)) {
                upperScoreString = String.format("%12e", this.minUpperScoreWeight);
            }
            if (!MathTools.isInf(this.upperScoreWeightSum)) {
                upperSumString = String.format("%12e", this.upperScoreWeightSum);
            }
            System.out.println("Conf bound: " + upperScoreString);
            System.out.println("Scored weight bound:" + upperSumString);
        }

        public BigDecimal getUpperBound() {
            return this.root.getUpperBound().subtract(this.lowerScoreWeightSum).add(this.energyWeightSum);
        }

        boolean epsilonReached(double targetEpsilon) {
            return this.calcDelta() <= targetEpsilon;
        }

        boolean isStable(BigDecimal stabilityThreshold) {
            return this.numEnergiedConfs <= 0L || stabilityThreshold == null || MathTools.isGreaterThanOrEqual(this.getUpperBound(), stabilityThreshold);
        }

        boolean hasLowEnergies() {
            return MathTools.isGreaterThan(this.minLowerScoreWeight, BigDecimal.ZERO);
        }

        public String toString() {
            return String.format("upper: count %d  sum %e  min %e     lower: count %d  score sum %e  energy sum %e", this.numScoredConfs, this.upperScoreWeightSum, this.minUpperScoreWeight, this.numEnergiedConfs, this.lowerScoreWeightSum, this.energyWeightSum);
        }
    }

    private static enum Step {
        None,
        Score,
        Energy;

    }
}

