/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.minimization;

import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.confspace.ParameterizedMoleculeCopy;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.energy.EnergyFunction;
import edu.duke.cs.osprey.minimization.Minimizer;
import edu.duke.cs.osprey.minimization.MoleculeModifierAndScorer;
import edu.duke.cs.osprey.parallelism.TaskExecutor;
import edu.duke.cs.osprey.parallelism.ThreadPoolTaskExecutor;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.tools.Factory;
import edu.duke.cs.osprey.tools.ObjectPool;
import edu.duke.cs.osprey.tools.Progress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class ConfMinimizer {
    private ThreadPoolTaskExecutor tasks = null;
    private Async asyncMinimizer = null;
    private boolean reportProgress = false;

    protected ConfMinimizer() {
    }

    protected void init(int numThreads, Factory<? extends EnergyFunction, Molecule> efuncs, Factory<? extends Minimizer, MoleculeModifierAndScorer> minimizers, ConfSpace confSpace) {
        if (numThreads <= 0) {
            throw new IllegalArgumentException("numThreads must be > 0");
        }
        this.tasks = new ThreadPoolTaskExecutor();
        this.tasks.start(numThreads);
        this.asyncMinimizer = new Async(efuncs, confSpace, this.tasks, minimizers);
    }

    public void setReportProgress(boolean val) {
        this.reportProgress = val;
    }

    public Async getAsync() {
        return this.asyncMinimizer;
    }

    public ConfSearch.EnergiedConf minimize(ConfSearch.ScoredConf conf) {
        return this.minimize(Arrays.asList(conf)).get(0);
    }

    public List<ConfSearch.EnergiedConf> minimize(List<ConfSearch.ScoredConf> confs) {
        final ArrayList<ConfSearch.EnergiedConf> econfs = new ArrayList<ConfSearch.EnergiedConf>(confs.size());
        for (int i = 0; i < confs.size(); ++i) {
            econfs.add(null);
        }
        final Progress progress2 = this.reportProgress ? new Progress(confs.size()) : null;
        for (int i = 0; i < confs.size(); ++i) {
            final int fi = i;
            this.asyncMinimizer.minimizeAsync(confs.get(i), new Async.Listener(){

                @Override
                public void onMinimized(ConfSearch.EnergiedConf econf) {
                    econfs.set(fi, econf);
                    if (progress2 != null) {
                        progress2.incrementProgress();
                    }
                }
            });
        }
        this.asyncMinimizer.tasks.waitForFinish();
        return econfs;
    }

    public void cleanup() {
        this.asyncMinimizer.cleanup();
        this.tasks.stop();
    }

    public static class Async {
        private ConfSpace confSpace;
        private TaskExecutor tasks;
        private Factory<? extends Minimizer, MoleculeModifierAndScorer> minimizers;
        private ObjectPool<TaskStuff> taskStuffPool;

        public Async(final Factory<? extends EnergyFunction, Molecule> efuncs, final ConfSpace confSpace, TaskExecutor tasks, Factory<? extends Minimizer, MoleculeModifierAndScorer> minimizers) {
            this.confSpace = confSpace;
            this.tasks = tasks;
            this.minimizers = minimizers;
            this.taskStuffPool = new ObjectPool<TaskStuff>(new Factory<TaskStuff, Void>(){

                @Override
                public TaskStuff make(Void context) {
                    TaskStuff out = new TaskStuff();
                    out.pmol = new ParameterizedMoleculeCopy(confSpace);
                    out.efunc = (EnergyFunction)efuncs.make(out.pmol.getCopiedMolecule());
                    out.minimizer = null;
                    return out;
                }
            });
            this.taskStuffPool.allocate(tasks.getParallelism());
        }

        public ConfSearch.EnergiedConf minimizeSync(ConfSearch.ScoredConf conf) {
            try (ObjectPool.Checkout<TaskStuff> checkout = this.taskStuffPool.autoCheckout();){
                Minimizer minimizer;
                TaskStuff stuff = checkout.get();
                RCTuple tuple = new RCTuple(conf.getAssignments());
                MoleculeModifierAndScorer mof = new MoleculeModifierAndScorer(stuff.efunc, this.confSpace, tuple, stuff.pmol);
                if (stuff.minimizer == null) {
                    minimizer = this.minimizers.make(mof);
                } else {
                    stuff.minimizer.init(mof);
                    minimizer = stuff.minimizer;
                }
                Minimizer.Result result = minimizer.minimize();
                if (minimizer instanceof Minimizer.Reusable) {
                    stuff.minimizer = (Minimizer.Reusable)minimizer;
                } else if (minimizer instanceof Minimizer.NeedsCleanup) {
                    ((Minimizer.NeedsCleanup)minimizer).cleanWithoutCrashing();
                }
                ConfSearch.EnergiedConf energiedConf = new ConfSearch.EnergiedConf(conf, result.energy);
                return energiedConf;
            }
        }

        public void minimizeAsync(ConfSearch.ScoredConf conf, Listener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener can't be null");
            }
            this.tasks.submit(() -> this.minimizeSync(conf), minimizedConf -> listener.onMinimized((ConfSearch.EnergiedConf)minimizedConf));
        }

        public TaskExecutor getTasks() {
            return this.tasks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanup() {
            try {
                this.tasks.waitForFinish();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ObjectPool<TaskStuff> objectPool = this.taskStuffPool;
            synchronized (objectPool) {
                if (this.taskStuffPool.available() < this.taskStuffPool.size()) {
                    System.err.println(String.format("molecule pool in inconsistent state (only %d/%d molecules available).Some items will not be cleaned up. this is a bug", this.taskStuffPool.available(), this.taskStuffPool.size()));
                }
                for (TaskStuff stuff : this.taskStuffPool) {
                    if (stuff.efunc instanceof EnergyFunction.NeedsCleanup) {
                        ((EnergyFunction.NeedsCleanup)stuff.efunc).cleanWithoutCrashing();
                    }
                    if (!(stuff.minimizer instanceof Minimizer.NeedsCleanup)) continue;
                    ((Minimizer.NeedsCleanup)((Object)stuff.minimizer)).cleanWithoutCrashing();
                }
                this.taskStuffPool.clear();
            }
        }

        private static class TaskStuff {
            public ParameterizedMoleculeCopy pmol;
            public EnergyFunction efunc;
            public Minimizer.Reusable minimizer;

            private TaskStuff() {
            }
        }

        public static interface Listener {
            public void onMinimized(ConfSearch.EnergiedConf var1);
        }
    }
}

