/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.minimization;

import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.energy.EnergyFunction;
import edu.duke.cs.osprey.energy.EnergyFunctionGenerator;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldInteractions;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.minimization.ConfMinimizer;
import edu.duke.cs.osprey.minimization.Minimizer;
import edu.duke.cs.osprey.minimization.MoleculeModifierAndScorer;
import edu.duke.cs.osprey.minimization.ObjectiveFunction;
import edu.duke.cs.osprey.minimization.SimpleCCDMinimizer;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.tools.Factory;

public class CpuConfMinimizer
extends ConfMinimizer {
    public CpuConfMinimizer(int numThreads, ForcefieldParams ffparams, final Factory<ForcefieldInteractions, Molecule> interactions, ConfSpace confSpace, Factory<? extends Minimizer, MoleculeModifierAndScorer> minimizers) {
        final EnergyFunctionGenerator egen = new EnergyFunctionGenerator(ffparams);
        Factory<EnergyFunction, Molecule> efuncs = new Factory<EnergyFunction, Molecule>(){

            @Override
            public EnergyFunction make(Molecule mol) {
                return egen.interactionEnergy((ForcefieldInteractions)interactions.make(mol));
            }
        };
        this.init(numThreads, (Factory<? extends EnergyFunction, Molecule>)efuncs, minimizers, confSpace);
    }

    public static class Builder {
        public final ForcefieldParams ffparams;
        public final Factory<ForcefieldInteractions, Molecule> interactions;
        public final ConfSpace confSpace;
        public int numThreads;
        Factory<Minimizer, MoleculeModifierAndScorer> minimizers;

        public Builder(ForcefieldParams ffparams, Factory<ForcefieldInteractions, Molecule> interactions, ConfSpace confSpace) {
            this.ffparams = ffparams;
            this.interactions = interactions;
            this.confSpace = confSpace;
            this.numThreads = 1;
            this.minimizers = mof -> new SimpleCCDMinimizer((ObjectiveFunction)mof);
        }

        public Builder setNumThreads(int val) {
            this.numThreads = val;
            return this;
        }

        public Builder setMinimizers(Factory<Minimizer, MoleculeModifierAndScorer> val) {
            this.minimizers = val;
            return this;
        }

        public CpuConfMinimizer build() {
            return new CpuConfMinimizer(this.numThreads, this.ffparams, this.interactions, this.confSpace, this.minimizers);
        }
    }
}

