/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.minimization;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import edu.duke.cs.osprey.gpu.cuda.GpuStream;
import edu.duke.cs.osprey.gpu.cuda.GpuStreamPool;
import edu.duke.cs.osprey.gpu.cuda.kernels.CCDKernelCuda;
import edu.duke.cs.osprey.minimization.Minimizer;
import edu.duke.cs.osprey.minimization.MoleculeModifierAndScorer;
import edu.duke.cs.osprey.minimization.MoleculeObjectiveFunction;
import edu.duke.cs.osprey.minimization.ObjectiveFunction;
import java.io.IOException;

public class CudaCCDMinimizer
implements Minimizer.NeedsCleanup,
Minimizer.Reusable {
    private GpuStreamPool streams;
    private ObjectiveFunction f;
    private GpuStream stream;
    private CCDKernelCuda kernel;
    private ObjectiveFunction.DofBounds dofBounds;

    public CudaCCDMinimizer(GpuStreamPool streams) {
        this.streams = streams;
    }

    public CudaCCDMinimizer(GpuStreamPool streams, ObjectiveFunction f) {
        this(streams);
        this.init(f);
    }

    @Override
    public void init(ObjectiveFunction f) {
        this.f = f;
        if (this.kernel == null) {
            try {
                this.stream = this.streams.checkout();
                this.kernel = new CCDKernelCuda(this.stream);
            }
            catch (IOException ex) {
                this.streams.release(this.stream);
                this.stream = null;
                throw new Error("can't make CCD kernel", ex);
            }
        }
        if (f instanceof MoleculeModifierAndScorer) {
            this.kernel.init(new MoleculeObjectiveFunction((MoleculeModifierAndScorer)f));
        } else if (f instanceof MoleculeObjectiveFunction) {
            this.kernel.init((MoleculeObjectiveFunction)f);
        } else {
            throw new Error("objective function should be a " + MoleculeModifierAndScorer.class.getSimpleName() + ", not a " + f.getClass().getSimpleName() + ". this is a bug");
        }
        this.dofBounds = new ObjectiveFunction.DofBounds(f.getConstraints());
    }

    @Override
    public Minimizer.Result minimizeFromCenter() {
        DoubleMatrix1D x = DoubleFactory1D.dense.make(this.dofBounds.size());
        this.dofBounds.getCenter(x);
        return this.minimizeFrom(x);
    }

    @Override
    public Minimizer.Result minimizeFrom(DoubleMatrix1D x) {
        this.f.setDOFs(x);
        this.kernel.uploadCoordsAsync();
        Minimizer.Result result = this.kernel.runSync(x, this.dofBounds);
        this.f.setDOFs(result.dofValues);
        return result;
    }

    @Override
    public void clean() {
        if (this.kernel != null) {
            this.kernel.cleanup();
            this.kernel = null;
        }
        this.streams.release(this.stream);
    }
}

