/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.minimization;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import edu.duke.cs.osprey.confspace.ParametricMolecule;
import edu.duke.cs.osprey.energy.EnergyFunction;
import edu.duke.cs.osprey.minimization.MoleculeModifierAndScorer;
import edu.duke.cs.osprey.minimization.ObjectiveFunction;
import java.util.ArrayList;
import java.util.List;

public class MoleculeObjectiveFunction
implements ObjectiveFunction {
    private static final long serialVersionUID = -5301575611582359731L;
    public final ParametricMolecule pmol;
    public final EnergyFunction efunc;
    public final List<EnergyFunction> efuncsByDof;
    public final DoubleMatrix1D curDOFVals;

    public MoleculeObjectiveFunction(ParametricMolecule pmol, EnergyFunction efunc) {
        this.pmol = pmol;
        this.efunc = efunc;
        this.curDOFVals = DoubleFactory1D.dense.make(pmol.dofBounds.size());
        if (efunc instanceof EnergyFunction.NeedsInit) {
            ((EnergyFunction.NeedsInit)efunc).init(pmol.mol, pmol.dofs, this.curDOFVals);
        }
        this.efuncsByDof = efunc instanceof EnergyFunction.DecomposableByDof ? ((EnergyFunction.DecomposableByDof)efunc).decomposeByDof(pmol.mol, pmol.dofs) : null;
    }

    @Deprecated
    public MoleculeObjectiveFunction(MoleculeModifierAndScorer mof) {
        this.pmol = new ParametricMolecule(mof.getMolec(), mof.getDOFs(), new ObjectiveFunction.DofBounds(mof.getConstraints()));
        this.efunc = mof.getEfunc();
        this.efuncsByDof = new ArrayList<EnergyFunction>();
        for (int d = 0; d < this.pmol.dofs.size(); ++d) {
            this.efuncsByDof.add(mof.getEfunc(d));
        }
        this.curDOFVals = mof.curDOFVals;
    }

    public EnergyFunction getEfunc(int d) {
        if (this.efuncsByDof != null) {
            return this.efuncsByDof.get(d);
        }
        return this.efunc;
    }

    @Override
    public int getNumDOFs() {
        return this.pmol.dofs.size();
    }

    @Override
    public DoubleMatrix1D[] getConstraints() {
        return this.pmol.dofBounds.getBounds();
    }

    @Override
    public void setDOF(int d, double val) {
        this.curDOFVals.set(d, val);
        this.pmol.dofs.get(d).apply(val);
    }

    @Override
    public double getValForDOF(int d, double val) {
        this.setDOF(d, val);
        return this.getEfunc(d).getEnergy();
    }

    @Override
    public void setDOFs(DoubleMatrix1D x) {
        this.curDOFVals.assign(x);
        for (int d = 0; d < x.size(); ++d) {
            this.pmol.dofs.get(d).apply(x.get(d));
        }
    }

    @Override
    public double getValue(DoubleMatrix1D x) {
        this.setDOFs(x);
        return this.efunc.getEnergy();
    }

    @Override
    public double getInitStepSize(int d) {
        return MoleculeModifierAndScorer.getInitStepSize(this.pmol.dofs.get(d));
    }

    @Override
    public boolean isDOFAngle(int d) {
        return MoleculeModifierAndScorer.isDOFAngle(this.pmol.dofs.get(d));
    }

    @Override
    public ArrayList<Integer> getInitFixableDOFs() {
        throw new UnsupportedOperationException("implement me!");
    }
}

