/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.minimization;

import edu.duke.cs.osprey.minimization.LineSearcher;
import edu.duke.cs.osprey.minimization.ObjectiveFunction;

public class SurfingLineSearcher
implements LineSearcher {
    private static final double Tolerance = 1.0E-6;
    private ObjectiveFunction.OneDof f;
    private double firstStep = 1.0;
    private double lastStep = 1.0;
    private int iteration = 0;

    @Override
    public void init(ObjectiveFunction.OneDof f) {
        this.f = f;
    }

    @Override
    public double search(double xd) {
        double fxdstar;
        double xdmin = this.f.getXMin();
        double xdmax = this.f.getXMax();
        double fxd = this.f.getValue(xd);
        Double fxdmin = null;
        Double fxdmax = null;
        double step = Math.abs(this.lastStep) > 1.0E-6 && Math.abs(this.firstStep) > 1.0E-6 ? this.f.getInitialStepSize() * Math.abs(this.lastStep / this.firstStep) : this.f.getInitialStepSize() / Math.pow(this.iteration + 1, 3.0);
        while (xd - step < xdmin && xd + step > xdmax) {
            step /= 2.0;
        }
        double xdp = xd + step;
        double xdm = xd - step;
        double fxdp = Double.POSITIVE_INFINITY;
        if (xdp <= xdmax) {
            fxdp = this.f.getValue(xdp);
        }
        double fxdm = Double.POSITIVE_INFINITY;
        if (xdm >= xdmin) {
            fxdm = this.f.getValue(xdm);
        }
        double shape = fxdp + fxdm - 2.0 * fxd;
        double ShapeEpsilon = 1.0E-12;
        double xdstar = 0.0;
        xdstar = shape < -1.0E-12 || Double.isNaN(shape) || Double.isInfinite(shape) ? (fxdm < fxdp ? xdm : xdp) : (shape <= 1.0E-12 ? xd : xd + (fxdm - fxdp) * step / 2.0 / shape);
        if (xdstar < xdmin) {
            xdstar = xdmin;
        }
        if (xdstar > xdmax) {
            xdstar = xdmax;
        }
        if ((fxdstar = this.f.getValue(xdstar)) < fxd) {
            double xdsurfHere = xdstar;
            double fxdsurfHere = fxdstar;
            while (true) {
                double xdsurfNext;
                if ((xdsurfNext = xd + 2.0 * (xdsurfHere - xd)) < xdmin) {
                    if (fxdmin == null) {
                        fxdmin = this.f.getValue(xdmin);
                    }
                    if (!(fxdmin < fxdsurfHere)) break;
                    xdsurfHere = xdmin;
                    fxdsurfHere = fxdmin;
                    break;
                }
                if (xdsurfNext > xdmax) {
                    if (fxdmax == null) {
                        fxdmax = this.f.getValue(xdmax);
                    }
                    if (!(fxdmax < fxdsurfHere)) break;
                    xdsurfHere = xdmax;
                    fxdsurfHere = fxdmax;
                    break;
                }
                double fxdsurfNext = this.f.getValue(xdsurfNext);
                if (!(fxdsurfNext < fxdsurfHere - this.getTolerance(fxdsurfHere))) break;
                xdsurfHere = xdsurfNext;
                fxdsurfHere = fxdsurfNext;
            }
            xdstar = xdsurfHere;
            fxdstar = fxdsurfHere;
        } else if (fxdstar > fxd + 1.0E-6) {
            double xdsurfNext;
            double fxdsurfNext;
            double xdsurfHere = xdstar;
            double fxdsurfHere = fxdstar;
            while ((fxdsurfNext = this.f.getValue(xdsurfNext = xd + (xdsurfHere - xd) / 2.0)) < fxdsurfHere - this.getTolerance(fxdsurfHere)) {
                xdsurfHere = xdsurfNext;
                fxdsurfHere = fxdsurfNext;
            }
            if (!(fxdstar < fxd)) {
                xdstar = xd;
                fxdstar = fxd;
            }
            if (fxdsurfHere < fxdstar) {
                xdstar = xdsurfHere;
                fxdstar = fxdsurfHere;
            }
        }
        this.lastStep = xdstar - xd;
        if (this.iteration == 0) {
            this.firstStep = this.lastStep;
        }
        xdm = xdstar - 1.0;
        xdp = xdstar + 1.0;
        if (xdm >= xdmin && (fxdm = this.f.getValue(xdm)) < fxdstar) {
            xdstar = xdm;
            fxdstar = fxdm;
        }
        if (xdp <= xdmax && (fxdp = this.f.getValue(xdp)) < fxdstar) {
            xdstar = xdp;
            fxdstar = fxdp;
        }
        ++this.iteration;
        this.f.setX(xdstar);
        return xdstar;
    }

    private double getTolerance(double f) {
        return 1.0E-6 * Math.max(1.0, Math.abs(f));
    }
}

