/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.molscope.molecule;

import edu.duke.cs.osprey.molscope.molecule.Atom;
import edu.duke.cs.osprey.molscope.molecule.ChainMap;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import edu.duke.cs.osprey.molscope.molecule.MoleculeMaps;
import edu.duke.cs.osprey.molscope.molecule.Polymer;
import edu.duke.cs.osprey.molscope.molecule.PolymerMaps;
import edu.duke.cs.osprey.molscope.molecule.ResidueMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0002\u001f B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u0000H\u0016J$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00002\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fJ\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u001c\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00122\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0003J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003J(\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\f0\u00122\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006!"}, d2={"Ledu/duke/cs/osprey/molscope/molecule/Polymer;", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "name", "", "(Ljava/lang/String;)V", "chains", "", "Ledu/duke/cs/osprey/molscope/molecule/Polymer$Chain;", "getChains", "()Ljava/util/List;", "copy", "copyTo", "Ledu/duke/cs/osprey/molscope/molecule/PolymerMaps;", "dst", "transform", "Lkotlin/Function1;", "Lorg/joml/Vector3d;", "copyWithMaps", "Lkotlin/Pair;", "Ledu/duke/cs/osprey/molscope/molecule/MoleculeMaps;", "findChainAndResidue", "Ledu/duke/cs/osprey/molscope/molecule/Polymer$Residue;", "atom", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "findChainOrThrow", "id", "findResidue", "findResidueOrThrow", "chainId", "resId", "transformCopy", "Chain", "Residue", "osprey3"})
@SourceDebugExtension(value={"SMAP\nPolymer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Polymer.kt\nedu/duke/cs/osprey/molscope/molecule/Polymer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1549#2:135\n1620#2,3:136\n1360#2:140\n1446#2,5:141\n1#3:139\n*S KotlinDebug\n*F\n+ 1 Polymer.kt\nedu/duke/cs/osprey/molscope/molecule/Polymer\n*L\n88#1:135\n88#1:136,3\n109#1:140\n109#1:141,5\n*E\n"})
public final class Polymer
extends Molecule {
    @NotNull
    private final List<Chain> chains;

    public Polymer(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name, null, null, 6, null);
        this.chains = new ArrayList();
    }

    @NotNull
    public final List<Chain> getChains() {
        return this.chains;
    }

    @Override
    @NotNull
    public Polymer copy() {
        return (Polymer)this.copyWithMaps().getFirst();
    }

    @NotNull
    public Pair<Polymer, MoleculeMaps> copyWithMaps() {
        Polymer src = this;
        Polymer dst = new Polymer(this.getName());
        PolymerMaps maps = Polymer.copyTo$default(src, dst, null, 2, null);
        return TuplesKt.to((Object)dst, (Object)maps);
    }

    @NotNull
    public Pair<Polymer, PolymerMaps> transformCopy(@NotNull Function1<? super Vector3d, ? extends Vector3d> transform) {
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        Polymer src = this;
        Polymer dst = new Polymer(this.getName());
        PolymerMaps maps = src.copyTo(dst, transform);
        return TuplesKt.to((Object)dst, (Object)maps);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PolymerMaps copyTo(@NotNull Polymer dst, @NotNull Function1<? super Vector3d, ? extends Vector3d> transform) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        Polymer src = this;
        MoleculeMaps maps = src.copyTo((Molecule)dst, transform);
        ChainMap chainMap = new ChainMap();
        ResidueMap resMap = new ResidueMap();
        for (Chain srcChain : src.chains) {
            Chain dstChain = new Chain(srcChain.getId());
            chainMap.add(srcChain, dstChain);
            for (Residue srcRes : srcChain.getResidues()) {
                Collection<Atom> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = srcRes.getAtoms();
                String string = srcRes.getType();
                String string2 = srcRes.getId();
                boolean $i$f$map = false;
                void var15_15 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Atom atom = (Atom)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((Atom)maps.getAtoms().getBOrThrow(it));
                }
                collection = (List)destination$iv$iv;
                List list = collection;
                String string3 = string;
                String string4 = string2;
                Residue dstRes = new Residue(string4, string3, list);
                resMap.add(srcRes, dstRes);
                dstChain.getResidues().add(dstRes);
            }
            dst.chains.add(dstChain);
        }
        return new PolymerMaps(maps, chainMap, resMap);
    }

    public static /* synthetic */ PolymerMaps copyTo$default(Polymer polymer, Polymer polymer2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = copyTo.1.INSTANCE;
        }
        return polymer.copyTo(polymer2, (Function1<? super Vector3d, ? extends Vector3d>)function1);
    }

    @NotNull
    public final Chain findChainOrThrow(@NotNull String id) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Iterable iterable = this.chains;
            for (Object t : iterable) {
                Chain it = (Chain)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Chain chain = v0;
        if (chain == null) {
            throw new NoSuchElementException("no chain with id=" + id);
        }
        return chain;
    }

    @NotNull
    public final Residue findResidueOrThrow(@NotNull String chainId, @NotNull String resId) {
        Intrinsics.checkNotNullParameter((Object)chainId, (String)"chainId");
        Intrinsics.checkNotNullParameter((Object)resId, (String)"resId");
        return this.findChainOrThrow(chainId).findResidueOrThrow(resId);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Residue findResidue(@NotNull Atom atom) {
        Object v0;
        block2: {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
            Iterable $this$flatMap$iv = this.chains;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Chain it = (Chain)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getResidues();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            for (Object e : iterable2) {
                Residue it = (Residue)e;
                boolean bl = false;
                if (!it.getAtoms().contains(atom)) continue;
                v0 = e;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final Residue findResidueOrThrow(@NotNull Atom atom) {
        Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
        Residue residue = this.findResidue(atom);
        if (residue == null) {
            throw new NoSuchElementException("atom " + atom.getName() + " was not found in any residue");
        }
        return residue;
    }

    @Nullable
    public final Pair<Chain, Residue> findChainAndResidue(@NotNull Atom atom) {
        Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
        for (Chain chain : this.chains) {
            for (Residue res : chain.getResidues()) {
                if (!res.getAtoms().contains(atom)) continue;
                return TuplesKt.to((Object)chain, (Object)res);
            }
        }
        return null;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010\r\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Ledu/duke/cs/osprey/molscope/molecule/Polymer$Chain;", "", "id", "", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "residues", "", "Ledu/duke/cs/osprey/molscope/molecule/Polymer$Residue;", "getResidues", "()Ljava/util/List;", "findResidueOrThrow", "toString", "osprey3"})
    @SourceDebugExtension(value={"SMAP\nPolymer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Polymer.kt\nedu/duke/cs/osprey/molscope/molecule/Polymer$Chain\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1#2:135\n*E\n"})
    public static final class Chain {
        @NotNull
        private final String id;
        @NotNull
        private final List<Residue> residues;

        public Chain(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = id;
            this.residues = new ArrayList();
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final List<Residue> getResidues() {
            return this.residues;
        }

        @NotNull
        public final Residue findResidueOrThrow(@NotNull String id) {
            Object v0;
            block2: {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Iterable iterable = this.residues;
                for (Object t : iterable) {
                    Residue it = (Residue)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            Residue residue = v0;
            if (residue == null) {
                throw new NoSuchElementException("no residue with id=" + id);
            }
            return residue;
        }

        @NotNull
        public String toString() {
            return this.id;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\r\u0018\u00002\u00020\u0001B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0003J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\b\u0010\u0016\u001a\u00020\u0003H\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000e\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Ledu/duke/cs/osprey/molscope/molecule/Polymer$Residue;", "", "id", "", "type", "atoms", "", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "(Ljava/lang/String;Ljava/lang/String;)V", "", "getAtoms", "()Ljava/util/List;", "getId", "()Ljava/lang/String;", "getType", "setType", "(Ljava/lang/String;)V", "findAtomOrThrow", "name", "mainchain", "sidechain", "toString", "osprey3"})
    @SourceDebugExtension(value={"SMAP\nPolymer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Polymer.kt\nedu/duke/cs/osprey/molscope/molecule/Polymer$Residue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1#2:135\n766#3:136\n857#3,2:137\n*S KotlinDebug\n*F\n+ 1 Polymer.kt\nedu/duke/cs/osprey/molscope/molecule/Polymer$Residue\n*L\n34#1:136\n34#1:137,2\n*E\n"})
    public static final class Residue {
        @NotNull
        private final String id;
        @NotNull
        private String type;
        @NotNull
        private final List<Atom> atoms;

        public Residue(@NotNull String id, @NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.id = id;
            this.type = type;
            this.atoms = new ArrayList();
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        public final void setType(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.type = string;
        }

        @NotNull
        public final List<Atom> getAtoms() {
            return this.atoms;
        }

        public Residue(@NotNull String id, @NotNull String type, @NotNull List<Atom> atoms) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter(atoms, (String)"atoms");
            this(id, type);
            this.atoms.addAll((Collection<Atom>)atoms);
        }

        @NotNull
        public final Atom findAtomOrThrow(@NotNull String name) {
            Object v0;
            block2: {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Iterable iterable = this.atoms;
                for (Object t : iterable) {
                    Atom it = (Atom)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            Atom atom = v0;
            if (atom == null) {
                throw new NoSuchElementException("no atom with name=" + name);
            }
            return atom;
        }

        @NotNull
        public String toString() {
            return this.id + ":" + this.type;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Atom> mainchain() {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.atoms;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Atom it = (Atom)element$iv$iv;
                boolean bl = false;
                Object[] objectArray = new String[]{"O", "C", "OXT", "CA"};
                if (!SetsKt.setOf((Object[])objectArray).contains(it.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }

        @NotNull
        public final List<Atom> sidechain() {
            return CollectionsKt.toList((Iterable)CollectionsKt.subtract((Iterable)this.atoms, (Iterable)CollectionsKt.toSet((Iterable)this.mainchain())));
        }
    }
}

