/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.molscope.render;

import cuchaz.kludge.tools.AutoCloser;
import cuchaz.kludge.tools.IntFlags;
import cuchaz.kludge.tools.LangKt;
import cuchaz.kludge.tools.MathKt;
import cuchaz.kludge.vulkan.Buffer;
import cuchaz.kludge.vulkan.CommandBuffer;
import cuchaz.kludge.vulkan.Device;
import cuchaz.kludge.vulkan.MemoryAllocation;
import cuchaz.kludge.vulkan.MemoryKt;
import cuchaz.kludge.vulkan.MemoryStagerKt;
import cuchaz.kludge.vulkan.MemoryType;
import edu.duke.cs.osprey.molscope.molecule.Atom;
import edu.duke.cs.osprey.molscope.view.MoleculeRenderView;
import edu.duke.cs.osprey.molscope.view.RenderView;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.AABBf;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0001SB\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u00108\u001a\u000209J\b\u0010:\u001a\u000209H\u0016J \u0010\u0019\u001a\u0002092\u0006\u0010;\u001a\u00020<2\u0010\b\u0002\u0010=\u001a\n\u0012\u0004\u0012\u00020?\u0018\u00010>J6\u0010@\u001a\u0002092\u0006\u0010A\u001a\u00020#2\u0006\u0010B\u001a\u00020#2\u0006\u0010C\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010-\u001a\u00020\u00162\u0006\u0010D\u001a\u00020EJ\u0016\u0010F\u001a\u0002092\u0006\u0010A\u001a\u00020#2\u0006\u0010B\u001a\u00020#J\u000e\u0010G\u001a\u0002092\u0006\u0010H\u001a\u00020IJ\u000e\u0010J\u001a\u0002092\u0006\u0010K\u001a\u00020\u0000J\u000e\u0010L\u001a\n M*\u0004\u0018\u00010\u00160\u0016J\u000e\u0010N\u001a\n M*\u0004\u0018\u00010\u00160\u0016J\u0006\u0010O\u001a\u000209J\u001b\u0010P\u001a\u0002HQ\"\b\b\u0000\u0010Q*\u00020\u0001*\u0002HQH\u0002\u00a2\u0006\u0002\u0010RR\u0015\u0010\u0005\u001a\u00060\u0006R\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000eR\u001a\u0010\u001d\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u000e\"\u0004\b\u001f\u0010\u0010R\u0011\u0010 \u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0018R\u001e\u0010$\u001a\u00020#2\u0006\u0010\"\u001a\u00020#@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0018R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0018R$\u0010/\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b0\u0010\u000e\"\u0004\b1\u0010\u0010R\u001a\u00102\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u000e\"\u0004\b4\u0010\u0010R\u001a\u00105\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u000e\"\u0004\b7\u0010\u0010\u00a8\u0006T"}, d2={"Ledu/duke/cs/osprey/molscope/render/Camera;", "Ljava/lang/AutoCloseable;", "device", "Lcuchaz/kludge/vulkan/Device;", "(Lcuchaz/kludge/vulkan/Device;)V", "buf", "Lcuchaz/kludge/vulkan/Buffer$Allocated;", "Lcuchaz/kludge/vulkan/Buffer;", "getBuf", "()Lcuchaz/kludge/vulkan/Buffer$Allocated;", "value", "", "closeness", "getCloseness", "()F", "setCloseness", "(F)V", "closer", "Lcuchaz/kludge/tools/AutoCloser;", "getDevice$osprey3", "()Lcuchaz/kludge/vulkan/Device;", "look", "Lorg/joml/Vector3f;", "getLook", "()Lorg/joml/Vector3f;", "lookAt", "getLookAt", "lookDist", "getLookDist", "magnification", "getMagnification", "setMagnification", "pos", "getPos", "<set-?>", "", "sequence", "getSequence", "()I", "side", "getSide", "size", "Lorg/joml/Vector2f;", "getSize", "()Lorg/joml/Vector2f;", "up", "getUp", "viewDistance", "getViewDistance", "setViewDistance", "zFar", "getZFar", "setZFar", "zNear", "getZNear", "setZNear", "changed", "", "close", "target", "Lorg/joml/Vector3fc;", "views", "", "Ledu/duke/cs/osprey/molscope/view/RenderView;", "lookAtBox", "width", "height", "focalLength", "box", "Lorg/joml/AABBf;", "resize", "rotate", "q", "Lorg/joml/Quaternionf;", "set", "other", "updateLook", "kotlin.jvm.PlatformType", "updateSide", "upload", "autoClose", "R", "(Ljava/lang/AutoCloseable;)Ljava/lang/AutoCloseable;", "Rotator", "osprey3"})
@SourceDebugExtension(value={"SMAP\nCamera.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Camera.kt\nedu/duke/cs/osprey/molscope/render/Camera\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 MemoryStager.kt\ncuchaz/kludge/vulkan/MemoryStagerKt\n+ 4 memory.kt\ncuchaz/kludge/vulkan/MemoryAllocation\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,264:1\n1#2:265\n111#3,9:266\n124#3,7:280\n168#4,5:275\n1549#5:287\n1620#5,3:288\n800#5,11:291\n1360#5:302\n1446#5,5:303\n1549#5:308\n1620#5,3:309\n*S KotlinDebug\n*F\n+ 1 Camera.kt\nedu/duke/cs/osprey/molscope/render/Camera\n*L\n101#1:266,9\n101#1:280,7\n101#1:275,5\n142#1:287\n142#1:288,3\n204#1:291,11\n205#1:302\n205#1:303,5\n206#1:308\n206#1:309,3\n*E\n"})
public final class Camera
implements AutoCloseable {
    @NotNull
    private final Device device;
    @NotNull
    private final AutoCloser closer;
    @NotNull
    private final Vector3f pos;
    @NotNull
    private final Vector3f lookAt;
    @NotNull
    private final Vector3f up;
    @NotNull
    private final Vector2f size;
    private float zNear;
    private float zFar;
    private float magnification;
    @NotNull
    private final Vector3f side;
    @NotNull
    private final Vector3f look;
    private int sequence;
    @NotNull
    private final Buffer.Allocated buf;

    public Camera(@NotNull Device device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        this.device = device;
        this.closer = new AutoCloser();
        this.pos = new Vector3f(0.0f, 0.0f, -2.0f);
        this.lookAt = new Vector3f(0.0f, 0.0f, 0.0f);
        this.up = new Vector3f(0.0f, 1.0f, 0.0f);
        this.size = new Vector2f(320.0f, 160.0f);
        this.zNear = 1.0f;
        this.zFar = 3.0f;
        this.magnification = 40.0f;
        this.side = new Vector3f();
        this.look = new Vector3f();
        this.updateSide();
        this.updateLook();
        Buffer.Usage[] usageArray = new Buffer.Usage[]{Buffer.Usage.UniformBuffer, Buffer.Usage.TransferDst};
        this.buf = (Buffer.Allocated)this.autoClose((AutoCloseable)MemoryStagerKt.allocateDevice((Buffer)((Buffer)this.autoClose((AutoCloseable)MemoryKt.buffer-O_cmygw$default((Device)this.device, (long)84L, (int)IntFlags.Companion.of-V5G__BY((IntFlags.Bit[])usageArray), null, (int)0, (int)12, null)))));
    }

    @NotNull
    public final Device getDevice$osprey3() {
        return this.device;
    }

    private final <R extends AutoCloseable> R autoClose(R $this$autoClose) {
        R r;
        R it = r = $this$autoClose;
        boolean bl = false;
        AutoCloser.add$default((AutoCloser)this.closer, $this$autoClose, null, (int)2, null);
        return r;
    }

    @Override
    public void close() {
        this.closer.close();
    }

    @NotNull
    public final Vector3f getPos() {
        return this.pos;
    }

    @NotNull
    public final Vector3f getLookAt() {
        return this.lookAt;
    }

    @NotNull
    public final Vector3f getUp() {
        return this.up;
    }

    @NotNull
    public final Vector2f getSize() {
        return this.size;
    }

    public final float getZNear() {
        return this.zNear;
    }

    public final void setZNear(float f) {
        this.zNear = f;
    }

    public final float getZFar() {
        return this.zFar;
    }

    public final void setZFar(float f) {
        this.zFar = f;
    }

    public final float getMagnification() {
        return this.magnification;
    }

    public final void setMagnification(float f) {
        this.magnification = f;
    }

    @NotNull
    public final Vector3f getSide() {
        return this.side;
    }

    @NotNull
    public final Vector3f getLook() {
        return this.look;
    }

    public final int getSequence() {
        return this.sequence;
    }

    public final void changed() {
        int n = this.sequence;
        this.sequence = n + 1;
    }

    private final float getLookDist() {
        return this.lookAt.distance((Vector3fc)this.pos);
    }

    public final float getCloseness() {
        return this.zNear / this.getLookDist();
    }

    public final void setCloseness(float value2) {
        float oldZNear = this.zNear;
        this.zNear = value2 * this.getLookDist();
        this.magnification *= oldZNear / this.zNear;
    }

    public final float getViewDistance() {
        return this.zFar - this.zNear;
    }

    public final void setViewDistance(float value2) {
        this.zFar = this.zNear + value2;
        int n = this.sequence;
        this.sequence = n + 1;
    }

    public final Vector3f updateSide() {
        return this.side.set((Vector3fc)this.up).cross((Vector3fc)this.look);
    }

    public final Vector3f updateLook() {
        return this.look.set((Vector3fc)this.lookAt).sub((Vector3fc)this.pos).normalize();
    }

    @NotNull
    public final Buffer.Allocated getBuf() {
        return this.buf;
    }

    public final void set(@NotNull Camera other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.pos.set((Vector3fc)other.pos);
        this.lookAt.set((Vector3fc)other.lookAt);
        this.up.set((Vector3fc)other.up);
        this.size.set((Vector2fc)other.size);
        this.zNear = other.zNear;
        this.zFar = other.zFar;
        this.magnification = other.magnification;
        this.side.set((Vector3fc)other.side);
        this.look.set((Vector3fc)other.look);
    }

    public final void resize(int width, int height) {
        this.size.set((float)width, (float)height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void upload() {
        ByteBuffer byteBuffer;
        void this_$iv$iv;
        Buffer.Allocated $this$transferHtoD_u24default$iv = this.buf;
        long offset$iv = 0L;
        int size$iv = $this$transferHtoD_u24default$iv.getMemory().getSizeAsInt();
        boolean $i$f$transferHtoD = false;
        if (IntFlags.has-impl((int)$this$transferHtoD_u24default$iv.getMemory().getType().getFlags-Oo1xsMU(), (IntFlags.Bit)((IntFlags.Bit)MemoryType.Flags.HostVisible))) {
            MemoryAllocation this_$iv$iv2 = $this$transferHtoD_u24default$iv.getMemory();
            boolean $i$f$map = false;
            try {
                ByteBuffer buf = this_$iv$iv2.map(offset$iv, size$iv);
                boolean bl = false;
                Camera.upload$lambda$2$put(buf, this.pos);
                Camera.upload$lambda$2$put(buf, this.side);
                Camera.upload$lambda$2$put(buf, this.up);
                Camera.upload$lambda$2$put(buf, this.look);
                Camera.upload$lambda$2$put$1(buf, this.size);
                buf.putFloat(this.zNear);
                buf.putFloat(this.zFar);
                buf.putFloat(this.magnification);
                ByteBuffer byteBuffer2 = buf.flip();
            }
            finally {
                this_$iv$iv2.unmap();
            }
        }
        Buffer.Allocated hostBuf$iv = $this$transferHtoD_u24default$iv.getMemory().getDevice().getMemoryStager().getBuffer((long)size$iv);
        Buffer.Allocated deviceBuf$iv = $this$transferHtoD_u24default$iv;
        MemoryAllocation memoryAllocation = hostBuf$iv.getMemory();
        long offset$iv$iv = 0L;
        boolean $i$f$map = false;
        try {
            ByteBuffer buf = this_$iv$iv.map(offset$iv$iv, size$iv);
            boolean bl = false;
            Camera.upload$lambda$2$put(buf, this.pos);
            Camera.upload$lambda$2$put(buf, this.side);
            Camera.upload$lambda$2$put(buf, this.up);
            Camera.upload$lambda$2$put(buf, this.look);
            Camera.upload$lambda$2$put$1(buf, this.size);
            buf.putFloat(this.zNear);
            buf.putFloat(this.zFar);
            buf.putFloat(this.magnification);
            byteBuffer = buf.flip();
        }
        finally {
            this_$iv$iv.unmap();
        }
        ByteBuffer result$iv = byteBuffer;
        $this$transferHtoD_u24default$iv.getMemory().getDevice().getMemoryStager().command((Function1)new Function1<CommandBuffer, Unit>(hostBuf$iv, deviceBuf$iv, offset$iv, size$iv){
            final /* synthetic */ Buffer.Allocated $hostBuf;
            final /* synthetic */ Buffer.Allocated $deviceBuf;
            final /* synthetic */ long $offset;
            final /* synthetic */ int $size;
            {
                this.$hostBuf = $hostBuf;
                this.$deviceBuf = $deviceBuf;
                this.$offset = $offset;
                this.$size = $size;
                super(1);
            }

            public final void invoke(@NotNull CommandBuffer $this$command) {
                Intrinsics.checkNotNullParameter((Object)$this$command, (String)"$this$command");
                $this$command.copyBuffer(this.$hostBuf.getBuffer(), this.$deviceBuf.getBuffer(), 0L, this.$offset, (long)this.$size);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public final void lookAtBox(int width, int height, float focalLength, @NotNull Vector3f look, @NotNull Vector3f up, @NotNull AABBf box) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)look, (String)"look");
        Intrinsics.checkNotNullParameter((Object)up, (String)"up");
        Intrinsics.checkNotNullParameter((Object)box, (String)"box");
        this.look.set((Vector3fc)look).normalize();
        this.up.set((Vector3fc)up).normalize();
        this.updateSide();
        this.size.set((float)width, (float)height);
        MathKt.boxCenter((Vector3f)this.lookAt, (AABBf)box);
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)MathKt.getNumCorners((AABBf)box));
        boolean $i$f$map = false;
        void var10_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void i;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Vector3f vector3f = MathKt.boxCorner((Vector3f)new Vector3f(), (AABBf)box, (int)i).sub((Vector3fc)this.lookAt);
            Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"Vector3f().boxCorner(box, i)\n\t\t\t\t\t.sub(lookAt)");
            Vector3f parallel = MathKt.parallelTo((Vector3f)vector3f, (Vector3fc)((Vector3fc)this.look));
            boolean bl2 = false;
            collection.add(Float.valueOf(Math.signum(parallel.dot((Vector3fc)look)) * parallel.length()));
        }
        List cornerDistances = (List)destination$iv$iv;
        Float f = CollectionsKt.minOrNull((Iterable)cornerDistances);
        Intrinsics.checkNotNull((Object)f);
        float near = f.floatValue();
        Float f2 = CollectionsKt.maxOrNull((Iterable)cornerDistances);
        Intrinsics.checkNotNull((Object)f2);
        float far = f2.floatValue();
        this.pos.set((Vector3fc)this.look).mul(near - focalLength).add((Vector3fc)this.lookAt);
        this.zNear = focalLength;
        this.zFar = focalLength + far - near;
        Vector3f center = MathKt.boxCenter((Vector3f)new Vector3f(), (AABBf)box);
        this.magnification = Float.min(Float.min((float)width / (box.maxX - center.x) / (float)2, (float)width / (center.x - box.minX) / (float)2), Float.min((float)height / (box.maxY - center.y) / (float)2, (float)height / (center.y - box.minY) / (float)2));
    }

    public final void rotate(@NotNull Quaternionf q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        this.pos.sub((Vector3fc)this.lookAt).rotate((Quaternionfc)q).add((Vector3fc)this.lookAt);
        this.side.rotate((Quaternionfc)q);
        this.up.rotate((Quaternionfc)q);
        this.look.rotate((Quaternionfc)q);
    }

    /*
     * WARNING - void declaration
     */
    public final void lookAt(@NotNull Vector3fc target, @Nullable Iterable<? extends RenderView> views) {
        block4: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object list$iv$iv;
            MoleculeRenderView it;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.pos.add(target).sub((Vector3fc)this.lookAt);
            this.lookAt.set(target);
            if (views == null) break block4;
            Iterable<? extends RenderView> iterable = views;
            boolean $i$f$filterIsInstance = false;
            void var6_5 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof MoleculeRenderView)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (MoleculeRenderView)element$iv$iv;
                boolean bl = false;
                list$iv$iv = it.getCurrentMol().getAtoms();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (Atom)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Float.valueOf(MathKt.toFloat((Vector3dc)((Vector3dc)((Atom)((Object)it)).getPos())).distanceSquared(target)));
            }
            Float f = CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
            if (f != null) {
                float r = LangKt.sqrt((float)f.floatValue());
                boolean bl = false;
                this.zNear = LangKt.atLeast((float)(this.getLookDist() - r), (float)0.001f);
                this.zFar = this.getLookDist() + r;
            }
        }
    }

    public static /* synthetic */ void lookAt$default(Camera camera, Vector3fc vector3fc, Iterable iterable, int n, Object object) {
        if ((n & 2) != 0) {
            iterable = null;
        }
        camera.lookAt(vector3fc, iterable);
    }

    private static final void upload$lambda$2$put(ByteBuffer $this$upload_u24lambda_u242_u24put, Vector3f v) {
        $this$upload_u24lambda_u242_u24put.putFloat(v.x);
        $this$upload_u24lambda_u242_u24put.putFloat(v.y);
        $this$upload_u24lambda_u242_u24put.putFloat(v.z);
        $this$upload_u24lambda_u242_u24put.putFloat(Float.NaN);
    }

    private static final void upload$lambda$2$put$1(ByteBuffer $this$upload_u24lambda_u242_u24put_u241, Vector2f v) {
        $this$upload_u24lambda_u242_u24put_u241.putFloat(v.x);
        $this$upload_u24lambda_u242_u24put_u241.putFloat(v.y);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0011\u0010\u0013\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\n\u00a8\u0006\u0018"}, d2={"Ledu/duke/cs/osprey/molscope/render/Camera$Rotator;", "", "(Ledu/duke/cs/osprey/molscope/render/Camera;)V", "camera", "Ledu/duke/cs/osprey/molscope/render/Camera;", "getCamera", "()Ledu/duke/cs/osprey/molscope/render/Camera;", "look", "Lorg/joml/Vector3f;", "getLook", "()Lorg/joml/Vector3f;", "pos", "getPos", "q", "Lorg/joml/Quaternionf;", "getQ", "()Lorg/joml/Quaternionf;", "side", "getSide", "up", "getUp", "capture", "", "update", "osprey3"})
    public final class Rotator {
        @NotNull
        private final Camera camera;
        @NotNull
        private final Vector3f pos;
        @NotNull
        private final Vector3f side;
        @NotNull
        private final Vector3f up;
        @NotNull
        private final Vector3f look;
        @NotNull
        private final Quaternionf q;

        public Rotator() {
            this.camera = Camera.this;
            this.pos = new Vector3f();
            this.side = new Vector3f();
            this.up = new Vector3f();
            this.look = new Vector3f();
            this.q = new Quaternionf();
            this.capture();
        }

        @NotNull
        public final Camera getCamera() {
            return this.camera;
        }

        @NotNull
        public final Vector3f getPos() {
            return this.pos;
        }

        @NotNull
        public final Vector3f getSide() {
            return this.side;
        }

        @NotNull
        public final Vector3f getUp() {
            return this.up;
        }

        @NotNull
        public final Vector3f getLook() {
            return this.look;
        }

        @NotNull
        public final Quaternionf getQ() {
            return this.q;
        }

        public final void capture() {
            this.pos.set((Vector3fc)this.camera.getPos());
            this.side.set((Vector3fc)this.camera.getSide());
            this.up.set((Vector3fc)this.camera.getUp());
            this.look.set((Vector3fc)this.camera.getLook());
        }

        public final void update() {
            this.camera.getPos().set((Vector3fc)this.pos);
            this.camera.getSide().set((Vector3fc)this.side);
            this.camera.getUp().set((Vector3fc)this.up);
            this.camera.getLook().set((Vector3fc)this.look);
            this.camera.rotate(this.q);
        }
    }
}

