/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.molscope.render;

import edu.duke.cs.osprey.molscope.molecule.Atom;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import edu.duke.cs.osprey.molscope.render.RenderEffect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0002J\n\u0010\u0015\u001a\u00060\u0010R\u00020\u0000R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0010R\u00020\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ledu/duke/cs/osprey/molscope/render/MoleculeRenderEffects;", "", "mol", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "(Ledu/duke/cs/osprey/molscope/molecule/Molecule;)V", "value", "getMol", "()Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "setMol", "<set-?>", "", "sequence", "getSequence", "()I", "writers", "Ljava/util/ArrayList;", "Ledu/duke/cs/osprey/molscope/render/MoleculeRenderEffects$Writer;", "get", "Ledu/duke/cs/osprey/molscope/render/RenderEffect;", "atom", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "writer", "Writer", "osprey3"})
public final class MoleculeRenderEffects {
    @NotNull
    private Molecule mol;
    @NotNull
    private final ArrayList<Writer> writers;
    private int sequence;

    public MoleculeRenderEffects(@NotNull Molecule mol) {
        Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
        this.mol = mol;
        this.writers = new ArrayList();
    }

    @NotNull
    public final Molecule getMol() {
        return this.mol;
    }

    public final void setMol(@NotNull Molecule value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.mol = value2;
        ++this.sequence;
        for (Writer writer : this.writers) {
            writer.clear();
        }
    }

    @NotNull
    public final Writer writer() {
        return new Writer();
    }

    public final int getSequence() {
        return this.sequence;
    }

    @Nullable
    public final RenderEffect get(@NotNull Atom atom) {
        Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
        IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)RangesKt.until((int)0, (int)this.writers.size())));
        int i = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                RenderEffect effect;
                if ((effect = this.writers.get(i).get(atom)) != null) {
                    return effect;
                }
                if (i == n) break;
                i += n2;
            }
        }
        return null;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\fH\u0016J\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u0005H\u0086\u0002J\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0005J$\u0010\u0010\u001a\u00020\f2\u001c\u0010\u0011\u001a\u0018\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00130\u0012j\u0002`\u0014J\u0014\u0010\u0010\u001a\u00020\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016J\u0019\u0010\u0017\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0006H\u0086\u0002J/\u0010\u0017\u001a\u00020\f2\u001c\u0010\u0011\u001a\u0018\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00130\u0012j\u0002`\u00142\u0006\u0010\u0018\u001a\u00020\u0006H\u0086\u0002J\u001f\u0010\u0017\u001a\u00020\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00162\u0006\u0010\u0018\u001a\u00020\u0006H\u0086\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Ledu/duke/cs/osprey/molscope/render/MoleculeRenderEffects$Writer;", "Ljava/lang/AutoCloseable;", "(Ledu/duke/cs/osprey/molscope/render/MoleculeRenderEffects;)V", "effectsByAtom", "Ljava/util/IdentityHashMap;", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "Ledu/duke/cs/osprey/molscope/render/RenderEffect;", "mol", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "getMol", "()Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "clear", "", "close", "get", "atom", "remove", "selector", "Lkotlin/Function1;", "", "Ledu/duke/cs/osprey/molscope/molecule/MoleculeSelector;", "atoms", "", "set", "effect", "osprey3"})
    public final class Writer
    implements AutoCloseable {
        @NotNull
        private final IdentityHashMap<Atom, RenderEffect> effectsByAtom;

        public Writer() {
            MoleculeRenderEffects.this.writers.add(this);
            this.effectsByAtom = new IdentityHashMap();
        }

        @NotNull
        public final Molecule getMol() {
            return MoleculeRenderEffects.this.getMol();
        }

        @Override
        public void close() {
            MoleculeRenderEffects.this.writers.remove(this);
            MoleculeRenderEffects moleculeRenderEffects = MoleculeRenderEffects.this;
            moleculeRenderEffects.sequence = moleculeRenderEffects.getSequence() + 1;
        }

        public final void clear() {
            if (!((Map)this.effectsByAtom).isEmpty()) {
                this.effectsByAtom.clear();
                MoleculeRenderEffects moleculeRenderEffects = MoleculeRenderEffects.this;
                moleculeRenderEffects.sequence = moleculeRenderEffects.getSequence() + 1;
            }
        }

        public final void set(@NotNull Atom atom, @NotNull RenderEffect effect) {
            Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            if (!Intrinsics.areEqual((Object)this.effectsByAtom.get(atom), (Object)effect)) {
                ((Map)this.effectsByAtom).put(atom, effect);
                MoleculeRenderEffects moleculeRenderEffects = MoleculeRenderEffects.this;
                moleculeRenderEffects.sequence = moleculeRenderEffects.getSequence() + 1;
            }
        }

        public final void set(@NotNull Collection<Atom> atoms, @NotNull RenderEffect effect) {
            Intrinsics.checkNotNullParameter(atoms, (String)"atoms");
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            boolean isChanged = false;
            for (Atom atom : atoms) {
                if (Intrinsics.areEqual((Object)this.effectsByAtom.get(atom), (Object)effect)) continue;
                ((Map)this.effectsByAtom).put(atom, effect);
                isChanged = true;
            }
            if (isChanged) {
                MoleculeRenderEffects moleculeRenderEffects = MoleculeRenderEffects.this;
                moleculeRenderEffects.sequence = moleculeRenderEffects.getSequence() + 1;
            }
        }

        public final void remove(@NotNull Atom atom) {
            Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
            RenderEffect oldVal = this.effectsByAtom.remove(atom);
            if (oldVal != null) {
                MoleculeRenderEffects moleculeRenderEffects = MoleculeRenderEffects.this;
                moleculeRenderEffects.sequence = moleculeRenderEffects.getSequence() + 1;
            }
        }

        public final void remove(@NotNull Collection<Atom> atoms) {
            Intrinsics.checkNotNullParameter(atoms, (String)"atoms");
            boolean isChanged = false;
            for (Atom atom : atoms) {
                RenderEffect oldVal = this.effectsByAtom.remove(atom);
                if (oldVal == null) continue;
                isChanged = true;
            }
            if (isChanged) {
                MoleculeRenderEffects moleculeRenderEffects = MoleculeRenderEffects.this;
                moleculeRenderEffects.sequence = moleculeRenderEffects.getSequence() + 1;
            }
        }

        public final void set(@NotNull Function1<? super Molecule, ? extends List<Atom>> selector, @NotNull RenderEffect effect) {
            Intrinsics.checkNotNullParameter(selector, (String)"selector");
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            this.set((Collection)selector.invoke((Object)this.getMol()), effect);
        }

        public final void remove(@NotNull Function1<? super Molecule, ? extends List<Atom>> selector) {
            Intrinsics.checkNotNullParameter(selector, (String)"selector");
            this.remove((Collection)selector.invoke((Object)this.getMol()));
        }

        @Nullable
        public final RenderEffect get(@NotNull Atom atom) {
            Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
            return this.effectsByAtom.get(atom);
        }
    }
}

