/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.multistatekstar;

import edu.duke.cs.osprey.confspace.Strand;
import edu.duke.cs.osprey.control.ParamSet;
import edu.duke.cs.osprey.multistatekstar.LMB;
import edu.duke.cs.osprey.multistatekstar.MSConfigFileParser;
import edu.duke.cs.osprey.restypes.DAminoAcidHandler;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.PDBIO;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.StringParsing;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;

public class InputValidation {
    ArrayList<ArrayList<ArrayList<ArrayList<String>>>> AATypeOptions;
    ArrayList<ArrayList<ArrayList<Integer>>> state2MutableResNums;

    public InputValidation(ArrayList<ArrayList<ArrayList<ArrayList<String>>>> AATypeOptions, ArrayList<ArrayList<ArrayList<Integer>>> state2MutableResNums) {
        this.AATypeOptions = AATypeOptions;
        this.state2MutableResNums = state2MutableResNums;
    }

    public void handleObjFcn(ParamSet msParams, LMB objFcn) {
        if (objFcn.getCoeffs().length != msParams.getInt("NUMSTATES")) {
            throw new RuntimeException("ERROR: the number of OBJFCN coefficients must equal NUMSTATES");
        }
        for (BigDecimal coeff : objFcn.getCoeffs()) {
            if (coeff.compareTo(BigDecimal.ZERO) != 0) continue;
            throw new RuntimeException("ERROR: objective function coefficient cannot be 0");
        }
    }

    public void handleConstraints(ParamSet msParams, LMB[] constraints) {
        for (LMB constr : constraints) {
            if (constr.getCoeffs().length == msParams.getInt("NUMSTATES")) continue;
            throw new RuntimeException("ERROR: the number of constraint coefficients must equal NUMSTATES");
        }
    }

    public void handleAATypeOptions(int state, int subState, MSConfigFileParser stateCfp) {
        Molecule wtMolec = new Strand.Builder((Molecule)PDBIO.readFile((String)stateCfp.params.getValue((String)"PDBName"))).build().mol;
        ArrayList<Integer> mutRes = this.state2MutableResNums.get(state).get(subState);
        ArrayList<ArrayList<String>> subStateAAOptions = stateCfp.getAllowedAAs(mutRes);
        if (this.AATypeOptions == null) {
            this.AATypeOptions = new ArrayList();
        }
        for (int mutPos = 0; mutPos < mutRes.size(); ++mutPos) {
            ArrayList<String> defaultSubStateResOptions;
            ArrayList<String> subStateResOptions = subStateAAOptions.get(mutPos);
            if (stateCfp.params.getBool("AddWT")) {
                Residue res = wtMolec.getResByPDBResNumber(String.valueOf(mutRes.get(mutPos)));
                if (StringParsing.containsIgnoreCase(subStateResOptions, res.template.name)) {
                    subStateResOptions.remove(res.template.name);
                }
                subStateResOptions.add(0, res.template.name);
            }
            if (this.AATypeOptions.size() <= state) {
                this.AATypeOptions.add(new ArrayList());
            }
            if (this.AATypeOptions.get(state).size() <= subState) {
                this.AATypeOptions.get(state).add(new ArrayList());
            }
            if (this.AATypeOptions.get(state).get(subState).size() <= mutPos) {
                this.AATypeOptions.get(state).get(subState).add(subStateResOptions);
            }
            if ((defaultSubStateResOptions = this.AATypeOptions.get(0).get(subState).get(mutPos)).size() != subStateResOptions.size()) {
                throw new RuntimeException("ERROR: Current state has " + subStateResOptions.size() + " AA types allowed for position " + mutPos + " compared to " + defaultSubStateResOptions.size() + " for previous states");
            }
            for (int a = 0; a < defaultSubStateResOptions.size(); ++a) {
                String aa1 = defaultSubStateResOptions.get(a);
                String aa2 = subStateResOptions.get(a);
                if (!DAminoAcidHandler.isStandardLAminoAcid(aa1) || !DAminoAcidHandler.isStandardLAminoAcid(aa2) || aa1.equalsIgnoreCase(aa2)) continue;
                throw new RuntimeException("ERROR: Current state has AA type " + aa2 + " where previous states have AA type " + aa1 + ", at position " + mutPos);
            }
        }
    }

    public void handleStateParams(int state, ParamSet sParams, ParamSet msParams) {
        boolean doMinimize;
        boolean imindee = sParams.getBool("IMINDEE");
        if (imindee != (doMinimize = sParams.getBool("DOMINIMIZE"))) {
            throw new RuntimeException("ERROR: IMINDEE must have the same value as DOMINIMIZE");
        }
        double epsilon = sParams.getDouble("EPSILON");
        if (epsilon >= 1.0 || epsilon < 0.0) {
            throw new RuntimeException("ERROR: EPSILON must be >= 0 and < 1");
        }
        int numUbConstr = sParams.getInt("NUMUBCONSTR");
        ArrayList<String> ubConstr = sParams.searchParams("UBCONSTR");
        ubConstr.remove("NUMUBCONSTR");
        if (numUbConstr != ubConstr.size()) {
            throw new RuntimeException("ERROR: NUMUBCONSTR != number of listed constraints");
        }
        int numUbStates = sParams.getInt("NUMUBSTATES");
        if (numUbStates < 2) {
            throw new RuntimeException("ERROR: NUMUBSTATES must be >=2");
        }
        String ubStateMutNums = sParams.getValue("UBSTATEMUTNUMS");
        StringTokenizer st = new StringTokenizer(ubStateMutNums);
        if (st.countTokens() != numUbStates) {
            throw new RuntimeException("ERROR: the number of tokens in UBSTATEMUTNUMS should be the same as NUMUBSTATES");
        }
        if (numUbStates != sParams.searchParams("UBSTATELIMITS").size()) {
            throw new RuntimeException("ERROR: need an UBSTATELIMITS line for each NUMUBSTATES");
        }
        int numMutsRes = 0;
        while (st.hasMoreTokens()) {
            numMutsRes += Integer.valueOf(st.nextToken()).intValue();
        }
        if (numMutsRes != msParams.getInt("NUMMUTRES")) {
            throw new RuntimeException("ERROR: UBSTATEMUTNUMS does not sum up to NUMMUTRES");
        }
        ArrayList globalMutList = new ArrayList();
        for (int ubState = 0; ubState < numUbStates; ++ubState) {
            int res;
            int numUbMutRes = Integer.valueOf(StringParsing.getToken(ubStateMutNums, ubState + 1));
            String ubMutRes = sParams.getValue("UBSTATEMUT" + ubState);
            st = new StringTokenizer(ubMutRes);
            ArrayList<Integer> ubStateMutList = new ArrayList<Integer>();
            while (st.hasMoreTokens()) {
                ubStateMutList.add(Integer.valueOf(st.nextToken()));
            }
            if ((ubStateMutList = new ArrayList(new HashSet(ubStateMutList))).size() != numUbMutRes) {
                throw new RuntimeException("ERROR: the number of distinct mutable residues in UBSTATEMUT" + ubState + " is not equal to the value specified in UBSTATEMUTNUMS");
            }
            globalMutList.addAll(ubStateMutList);
            ArrayList<Integer> ubStateLims = new ArrayList<Integer>();
            st = new StringTokenizer(sParams.getValue("UBSTATELIMITS" + state));
            if (st.countTokens() != 2) {
                throw new RuntimeException("ERROR: UBSTATELIMITS" + state + " must have 2 tokens");
            }
            while (st.hasMoreTokens()) {
                ubStateLims.add(Integer.valueOf(st.nextToken()));
            }
            Collections.sort(ubStateLims);
            Iterator iterator2 = ubStateMutList.iterator();
            while (iterator2.hasNext()) {
                res = (Integer)iterator2.next();
                if (res >= (Integer)ubStateLims.get(0) || res <= (Integer)ubStateLims.get(1)) continue;
                throw new RuntimeException("ERROR: mutable residue " + res + " exceeds the boundaries of UBSTATELIMITS" + state);
            }
            iterator2 = ubStateMutList.iterator();
            while (iterator2.hasNext()) {
                res = (Integer)iterator2.next();
                if (sParams.getValue("RESALLOWED" + res, "").length() != 0) continue;
                throw new RuntimeException("ERROR: RESALLOWED" + res + " must be delcared");
            }
        }
        ArrayList<String> raKeys = sParams.searchParams("RESALLOWED");
        if (raKeys.size() > numMutsRes) {
            for (String raVal : raKeys) {
                if (globalMutList.contains(Integer.valueOf(raVal = raVal.replaceAll("RESALLOWED", "").trim()))) continue;
                throw new RuntimeException("ERROR: RESALLOWED" + raVal + " is not in the list of UBSTATEMUT");
            }
        }
        ArrayList ubStateLimits = new ArrayList();
        for (int ubState = 0; ubState < numUbStates; ++ubState) {
            st = new StringTokenizer(sParams.getValue("UBSTATELIMITS" + ubState));
            ArrayList<Integer> tmp = new ArrayList<Integer>();
            while (st.hasMoreTokens()) {
                tmp.add(Integer.valueOf(st.nextToken()));
            }
            Collections.sort(tmp);
            ubStateLimits.add(tmp);
        }
        if ((Integer)((ArrayList)ubStateLimits.get(0)).get(0) <= (Integer)((ArrayList)ubStateLimits.get(1)).get(1) && (Integer)((ArrayList)ubStateLimits.get(1)).get(0) <= (Integer)((ArrayList)ubStateLimits.get(0)).get(1)) {
            throw new RuntimeException("ERROR: UBSTATELIMITS are not disjoint");
        }
    }
}

