/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.multistatekstar;

import edu.duke.cs.osprey.confspace.SearchProblem;
import edu.duke.cs.osprey.confspace.Strand;
import edu.duke.cs.osprey.control.ConfigFileParser;
import edu.duke.cs.osprey.control.EnvironmentVars;
import edu.duke.cs.osprey.dof.deeper.DEEPerSettings;
import edu.duke.cs.osprey.ematrix.epic.EPICSettings;
import edu.duke.cs.osprey.multistatekstar.ResidueTermini;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.PDBIO;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.ObjectIO;
import edu.duke.cs.osprey.tools.StringParsing;
import edu.duke.cs.osprey.tupexp.LUTESettings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;

public class MSConfigFileParser
extends ConfigFileParser {
    public MSConfigFileParser() {
    }

    public MSConfigFileParser(String[] confPaths) {
        for (String path2 : confPaths) {
            this.params.addParamsFromFile(path2);
        }
    }

    public MSConfigFileParser(String[] confPaths, boolean isVerbose) {
        for (String path2 : confPaths) {
            this.params.addParamsFromFile(path2);
        }
        this.params.setVerbosity(isVerbose);
    }

    public SearchProblem getSearchProblem(int state, int subState, ArrayList<Integer> mutRes, boolean cont) {
        String flexibility = cont ? "cont" : "disc";
        ArrayList<String> mutResS = new ArrayList<String>();
        for (int res : mutRes) {
            mutResS.add(String.valueOf(res));
        }
        DEEPerSettings deeperSettings = this.setupDEEPer(state, subState, mutRes, cont);
        ArrayList<Object> moveableUbStates = this.moveableUbStateTermini(subState);
        ArrayList<Object> freeBBZones = this.freeBBZoneTermini(subState);
        EPICSettings epicSettings = new EPICSettings(this.params);
        LUTESettings luteSettings = new LUTESettings(this.params);
        if (!cont) {
            deeperSettings = deeperSettings.makeDiscreteVersion();
            freeBBZones = new ArrayList();
            moveableUbStates = new ArrayList();
            epicSettings = new EPICSettings();
            luteSettings = new LUTESettings();
        }
        String dir = this.params.getValue("RunName") + File.separator + this.params.getValue("EmatDir");
        ObjectIO.makeDir(dir, false);
        SearchProblem ans = new SearchProblem(dir + File.separator + "State." + state + "." + subState + "." + flexibility, this.params.getValue("PDBNAME"), mutResS, this.getAllowedAAs(mutRes), this.params.getBool("AddWT"), cont, this.params.getBool("UseEPIC"), epicSettings, this.params.getBool("UseTupExp"), luteSettings, deeperSettings, moveableUbStates, freeBBZones, this.params.getBool("useEllipses"), this.params.getBool("useERef"), this.params.getBool("AddResEntropy"), this.params.getBool("addWTRots"), this.subState2Termini(subState), this.params.getBool("useVoxelG"), this.getWtRotOnlyRes());
        ans.numEmatThreads = this.params.getInt("EmatThreads");
        return ans;
    }

    public String[] getWtSeq(ArrayList<Integer> mutRes) {
        Molecule m = new Strand.Builder((Molecule)PDBIO.readFile((String)this.params.getValue((String)"PDBNAME"))).build().mol;
        int numPos = mutRes.size();
        String[] wt = new String[numPos];
        for (int pos = 0; pos < numPos; ++pos) {
            String wtName;
            Residue res = m.getResByPDBResNumber(String.valueOf(mutRes.get(pos)));
            wt[pos] = wtName = res.template.name;
        }
        return wt;
    }

    public ArrayList<ArrayList<String>> getAllowedAAs(ArrayList<Integer> mutRes) {
        ArrayList<ArrayList<String>> ans = new ArrayList<ArrayList<String>>();
        for (int pos = 0; pos < mutRes.size(); ++pos) {
            ans.add(new ArrayList());
            int res = mutRes.get(pos);
            StringTokenizer st = new StringTokenizer(this.params.getValue("RESALLOWED" + res).trim());
            while (st.hasMoreTokens()) {
                ans.get(pos).add(st.nextToken());
            }
        }
        return ans;
    }

    ResidueTermini subState2Termini(int subState) {
        String key = this.params.searchParams("UbStateLimits").size() > 0 ? "UbStateLimits" : "Strand";
        ArrayList<String> alTmni = new ArrayList<String>();
        if (this.params.getValue(key + subState, "").length() == 0) {
            for (int unbound = 0; unbound < subState; ++unbound) {
                StringTokenizer st = new StringTokenizer(this.params.getValue(key + unbound));
                while (st.hasMoreTokens()) {
                    alTmni.add(st.nextToken());
                }
            }
        } else {
            StringTokenizer st = new StringTokenizer(this.params.getValue(key + subState));
            while (st.hasMoreTokens()) {
                alTmni.add(st.nextToken());
            }
        }
        Collections.sort(alTmni);
        return new ResidueTermini(subState, (String)alTmni.get(0), (String)alTmni.get(alTmni.size() - 1));
    }

    protected DEEPerSettings setupDEEPer(int state, int subState, ArrayList<Integer> mutRes, boolean cont) {
        ArrayList<String> sMutRes = new ArrayList<String>();
        for (int res : mutRes) {
            sMutRes.add(String.valueOf(res));
        }
        String flexibility = cont ? "cont" : "disc";
        DEEPerSettings dset = new DEEPerSettings(this.params.getBool("doPerturbations"), "State." + state + "." + subState + "." + flexibility + "." + this.params.getRunSpecificFileName("perturbationFile", ".pert"), this.params.getBool("selectPerturbations"), this.params.getValue("startingPerturbationFile"), this.params.getBool("onlyStartingPerturbations"), this.params.getDouble("maxShearParam"), this.params.getDouble("maxBackrubParam"), this.params.getBool("selectLCAs"), sMutRes, this.params.getValue("PDBNAME"), this.params.getBool("DORAMACHECK"), EnvironmentVars.resTemplates);
        dset.loadPertFile(this.subState2Termini(subState));
        return dset;
    }

    protected ArrayList<String[]> freeBBZoneTermini(int subState) {
        ArrayList<String[]> ans = new ArrayList<String[]>();
        for (String rt : this.params.searchParams("BBFREEBLOCK")) {
            String val = this.params.getValue(rt);
            String[] bbfTmni = new String[]{StringParsing.getToken(val, 1), StringParsing.getToken(val, 2)};
            ResidueTermini tmni = this.subState2Termini(subState);
            if (!tmni.contains(bbfTmni[0]) || !tmni.contains(bbfTmni[1])) continue;
            ans.add(bbfTmni);
        }
        return ans;
    }

    protected ArrayList<String[]> moveableUbStateTermini(int subState) {
        String key = this.params.searchParams("UBSTATEROTTRANS").size() > 0 ? "UBSTATEROTTRANS" : "STRANDROTTRANS";
        ArrayList<String[]> ans = new ArrayList<String[]>();
        for (String rt : this.params.searchParams(key)) {
            if (!this.params.getBool(rt)) continue;
            String ubState = rt.replaceAll(key, "").trim();
            if (!String.valueOf(subState).equals(ubState)) continue;
            ResidueTermini tmni = this.subState2Termini(subState);
            ans.add(tmni.toStringArray());
        }
        return ans;
    }
}

