/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.multistatekstar;

import edu.duke.cs.osprey.astar.ConfTree;
import edu.duke.cs.osprey.astar.FullAStarNode;
import edu.duke.cs.osprey.confspace.HigherTupleFinder;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.multistatekstar.MSSearchProblem;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import java.math.BigInteger;
import java.util.ArrayList;

public class MultiSequenceConfTree
extends ConfTree<FullAStarNode> {
    public boolean energyLBs;
    MSSearchProblem search;
    PruningMatrix pmat;
    Integer[] allowedPos;

    public MultiSequenceConfTree(MSSearchProblem search2, EnergyMatrix emat, PruningMatrix pmat) {
        super(new FullAStarNode.Factory(search2.getNumAssignedPos()), search2, pmat);
        this.energyLBs = search2.settings.energyLBs;
        this.search = search2;
        this.emat = emat;
        this.pmat = pmat;
        this.allowedPos = this.getPosNums(true);
        this.init();
    }

    protected Integer[] getPosNums(boolean defined) {
        ArrayList<Integer> ans = this.search.getPosNums(defined);
        return ans.toArray(new Integer[ans.size()]);
    }

    protected void init() {
        this.numPos = this.allowedPos.length;
        this.definedPos = new int[this.numPos];
        this.definedRCs = new int[this.numPos];
        this.undefinedPos = new int[this.numPos];
        this.childConf = new int[this.numPos];
        this.unprunedRCsAtPos = new int[this.search.confSpace.numPos][];
        for (int pos = 0; pos < this.unprunedRCsAtPos.length; ++pos) {
            ArrayList<Integer> srcRCs = this.pmat.unprunedRCsAtPos(pos);
            int[] destRCs = new int[srcRCs.size()];
            for (int i = 0; i < srcRCs.size(); ++i) {
                destRCs[i] = srcRCs.get(i);
            }
            this.unprunedRCsAtPos[pos] = destRCs;
        }
        if (this.search.useTupExpForSearch) {
            this.emat = this.search.tupExpEMat;
        } else {
            this.emat = this.search.emat;
            if (this.search.useEPIC) {
                this.useRefinement = true;
                this.epicMat = this.search.epicMat;
                this.minPartialConfs = this.search.epicSettings.minPartialConfs;
            }
        }
    }

    @Override
    public BigInteger getNumConformations() {
        BigInteger num = BigInteger.valueOf(1L);
        Integer[] integerArray = this.allowedPos;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int pos = integerArray[i];
            num = num.multiply(BigInteger.valueOf(this.unprunedRCsAtPos[pos].length));
        }
        return num;
    }

    @Override
    protected void splitPositions(FullAStarNode node) {
        assert (this.numDefined == 0 && this.numUndefined == 0);
        int[] conf = node.getNodeAssignments();
        this.numDefined = 0;
        this.numUndefined = 0;
        Integer[] integerArray = this.allowedPos;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int pos = integerArray[i];
            int rc = conf[pos];
            if (rc >= 0) {
                this.definedPos[this.numDefined] = pos;
                this.definedRCs[this.numDefined] = rc;
                ++this.numDefined;
                continue;
            }
            this.undefinedPos[this.numUndefined] = pos;
            ++this.numUndefined;
        }
        assert (this.numDefined + this.numUndefined == this.numPos);
    }

    @Override
    protected double scoreNode(int[] partialConf) {
        if (this.traditionalScore) {
            this.rcTuple.set(partialConf);
            double score = this.emat.getConstTerm() + this.emat.getInternalEnergy(this.rcTuple);
            for (int pos = 0; pos < this.search.confSpace.numPos; ++pos) {
                if (this.rcTuple.pos.contains(pos)) continue;
                double bestE = this.energyLBs ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
                for (int rc : this.unprunedRCsAtPos[pos]) {
                    double rcContrib = this.RCContribution(pos, rc, this.rcTuple);
                    bestE = this.energyLBs ? Math.min(bestE, rcContrib) : Math.max(bestE, rcContrib);
                }
                score += bestE;
            }
            return score;
        }
        throw new UnsupportedOperationException("Advanced A* scoring methods not implemented yet!");
    }

    protected double RCContribution(int pos1, int rc1, RCTuple definedTuple) {
        double rcContrib = this.emat.getOneBody(pos1, rc1);
        for (int pos2 = 0; pos2 < this.search.confSpace.numPos; ++pos2) {
            if (!definedTuple.pos.contains(pos2) && pos2 >= pos1) continue;
            double posBestE = this.energyLBs ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            for (int rc2 : this.unprunedRCsAtPos[pos2]) {
                double interactionE = this.emat.getPairwise(pos1, rc1, pos2, rc2);
                double higherOrderE = this.higherOrderContrib(pos1, rc1, pos2, rc2, definedTuple);
                posBestE = this.energyLBs ? Math.min(posBestE, interactionE) : Math.max(posBestE, interactionE += higherOrderE);
            }
            rcContrib += posBestE;
        }
        return rcContrib;
    }

    protected double higherOrderContrib(int pos1, int rc1, int pos2, int rc2, RCTuple definedTuple) {
        HigherTupleFinder<Double> htf = this.emat.getHigherOrderTerms(pos1, rc1, pos2, rc2);
        if (htf == null) {
            return 0.0;
        }
        RCTuple curPair = new RCTuple(pos1, rc1, pos2, rc2);
        return this.higherOrderContrib(htf, curPair, definedTuple);
    }

    double higherOrderContrib(HigherTupleFinder<Double> htf, RCTuple startingTuple, RCTuple definedTuple) {
        double contrib = 0.0;
        int startingLevel = startingTuple.pos.get(startingTuple.pos.size() - 1);
        for (int iPos : htf.getInteractingPos()) {
            if (!this.posComesBefore(iPos, startingLevel, definedTuple)) continue;
            double posBestE = this.energyLBs ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            for (int rc : this.unprunedRCsAtPos[iPos]) {
                RCTuple augTuple = startingTuple.addRC(iPos, rc);
                double interactionE = htf.getInteraction(iPos, rc);
                HigherTupleFinder<Double> htf2 = htf.getHigherInteractions(iPos, rc);
                if (htf2 != null) {
                    interactionE += this.higherOrderContrib(htf2, augTuple, definedTuple);
                }
                posBestE = this.energyLBs ? Math.min(posBestE, interactionE) : Math.max(posBestE, interactionE);
            }
            contrib += posBestE;
        }
        return contrib;
    }

    protected boolean posComesBefore(int pos1, int pos2, RCTuple definedTuple) {
        if (definedTuple.pos.contains(pos2)) {
            return pos1 < pos2 && definedTuple.pos.contains(pos1);
        }
        return pos1 < pos2 || definedTuple.pos.contains(pos1);
    }

    @Override
    protected double scoreConfDifferential(FullAStarNode parentNode, int childPos, int childRc) {
        this.assertSplitPositions();
        int[] conf = parentNode.getNodeAssignments();
        if (childPos >= 0) {
            assert (conf[childPos] < 0);
            System.arraycopy(conf, 0, this.childConf, 0, this.numPos);
            this.childConf[childPos] = childRc;
            conf = this.childConf;
        }
        double ans = this.scoreNode(conf);
        return ans;
    }
}

