/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.multistatekstar;

import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.gmec.ConfSearchFactory;
import edu.duke.cs.osprey.gmec.GMECConfEnergyCalculator;
import edu.duke.cs.osprey.kstar.pfunc.PartitionFunction;
import edu.duke.cs.osprey.multistatekstar.PartitionFunctionMinimized;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import java.math.BigDecimal;
import java.math.BigInteger;

public class PartitionFunctionDiscrete
extends PartitionFunctionMinimized {
    public PartitionFunctionDiscrete(EnergyMatrix emat, PruningMatrix pmat, PruningMatrix invmat, ConfSearchFactory confSearchFactory, GMECConfEnergyCalculator.Async ecalc) {
        super(emat, pmat, invmat, confSearchFactory, ecalc);
    }

    @Override
    public void init(double targetEpsilon) {
        super.init(targetEpsilon);
        this.energyConfs = null;
    }

    @Override
    public void compute(int maxNumConfs) {
        if (!this.status.canContinue()) {
            throw new IllegalStateException("can't continue from status " + String.valueOf((Object)this.status));
        }
        int stopAtConf = this.numConfsEvaluated + maxNumConfs;
        while (this.status.canContinue() && this.numConfsEvaluated < stopAtConf) {
            ConfSearch.ScoredConf conf = this.scoreConfs.nextConf();
            if (conf == null) {
                if (this.status == PartitionFunction.Status.Estimated) break;
                this.status = PartitionFunction.Status.OutOfConformations;
                break;
            }
            ++this.numConfsEvaluated;
            BigDecimal scoreWeight = this.boltzmann.calc(conf.getScore());
            if (scoreWeight.compareTo(BigDecimal.ZERO) == 0) {
                if (this.status == PartitionFunction.Status.Estimated) break;
                this.status = PartitionFunction.Status.OutOfLowEnergies;
                break;
            }
            if (this.status != PartitionFunction.Status.Estimating) continue;
            this.numConfsToScore = this.numConfsToScore.subtract(BigInteger.ONE);
            this.values.qstar = this.values.qstar.add(scoreWeight);
            this.values.qprime = this.updateQprime(scoreWeight);
            if (this.isReportingProgress && this.numConfsEvaluated % 1024 == 0) {
                this.phase1Output(conf);
            }
            if (this.confListener != null) {
                this.confListener.onConf(conf);
            }
            if (!(this.getEffectiveEpsilon() <= this.targetEpsilon)) continue;
            this.status = PartitionFunction.Status.Estimated;
            this.phase1Output(conf);
        }
    }

    @Override
    public void compute(BigDecimal targetScoreWeights) {
        if (!this.status.canContinue()) {
            throw new IllegalStateException("can't continue from status " + String.valueOf((Object)this.status));
        }
        while (this.status.canContinue() && this.qstarScoreWeights.compareTo(targetScoreWeights) < 0) {
            ConfSearch.ScoredConf conf = this.scoreConfs.nextConf();
            if (conf == null) {
                if (this.status == PartitionFunction.Status.Estimated) break;
                this.status = PartitionFunction.Status.OutOfConformations;
                break;
            }
            ++this.numConfsEvaluated;
            BigDecimal scoreWeight = this.boltzmann.calc(conf.getScore());
            if (scoreWeight.compareTo(BigDecimal.ZERO) == 0) {
                if (this.status == PartitionFunction.Status.Estimated) break;
                this.status = PartitionFunction.Status.OutOfLowEnergies;
                break;
            }
            if (this.status != PartitionFunction.Status.Estimating) continue;
            this.qstarScoreWeights = this.qstarScoreWeights.add(scoreWeight);
            this.values.qstar = this.values.qstar.add(scoreWeight);
            this.values.qprime = this.updateQprime(scoreWeight);
            BigDecimal pdiff = targetScoreWeights.subtract(this.qstarScoreWeights);
            if (this.isReportingProgress && this.numConfsEvaluated % 1024 == 0) {
                this.phase2Output(conf, pdiff);
            }
            if (this.confListener != null) {
                this.confListener.onConf(conf);
            }
            if (!(this.getEffectiveEpsilon() <= this.targetEpsilon)) continue;
            this.status = PartitionFunction.Status.Estimated;
            this.phase2Output(conf, pdiff);
        }
    }

    protected BigDecimal updateQprime(BigDecimal val) {
        return val.multiply(new BigDecimal(this.numConfsToScore.toString()));
    }

    protected double getEffectiveEpsilon() {
        return this.values.getEffectiveEpsilon();
    }
}

