/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.multistatekstar;

import edu.duke.cs.osprey.astar.conf.ConfAStarTree;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.gmec.ConfSearchFactory;
import edu.duke.cs.osprey.gmec.GMECConfEnergyCalculator;
import edu.duke.cs.osprey.kstar.pfunc.ParallelConfPartitionFunction;
import edu.duke.cs.osprey.kstar.pfunc.PartitionFunction;
import edu.duke.cs.osprey.multistatekstar.MSSearchProblem;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import edu.duke.cs.osprey.tools.ObjectIO;
import edu.duke.cs.osprey.tools.Stopwatch;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.PriorityQueue;

public class PartitionFunctionMinimized
extends ParallelConfPartitionFunction {
    public static final BigDecimal MAX_VALUE = new BigDecimal("2e65536");
    public static final BigDecimal MIN_VALUE = BigDecimal.ZERO;
    protected PriorityQueue<ConfSearch.ScoredConf> topConfs;
    protected int maxNumTopConfs;
    protected BigDecimal qstarScoreWeights;
    protected int numActiveThreads;
    protected PruningMatrix invmat;

    public PartitionFunctionMinimized(EnergyMatrix emat, PruningMatrix pmat, PruningMatrix invmat, ConfSearchFactory confSearchFactory, GMECConfEnergyCalculator.Async ecalc) {
        super(emat, pmat, confSearchFactory, ecalc);
        this.invmat = invmat;
        this.qstarScoreWeights = null;
        this.topConfs = null;
    }

    protected void writeTopConfs(int state, MSSearchProblem search2) {
        if (this.topConfs == null || this.topConfs.size() == 0) {
            return;
        }
        String seq = search2.settings.getFormattedSequence();
        if (this.isReportingProgress) {
            System.out.println("Writing top " + this.topConfs.size() + " confs:");
        }
        seq = seq.replace(" ", ".");
        String dir = "topConfs" + File.separator + "State." + state + File.separator + seq;
        ObjectIO.makeDir(dir, false);
        for (int i = this.topConfs.size() - 1; i > -1; --i) {
            if (this.isReportingProgress) {
                ConfSearch.ScoredConf head = this.topConfs.peek();
                double energy = head instanceof ConfSearch.EnergiedConf ? ((ConfSearch.EnergiedConf)head).getEnergy() : head.getScore();
                System.out.println(String.format("conf: %4d.pdf, energy: %.6f", i, energy));
            }
            String PDBFileName = dir + File.separator + i + ".pdb";
            search2.outputMinimizedStruct(this.topConfs.poll().getAssignments(), PDBFileName);
        }
    }

    protected void saveConf(ConfSearch.ScoredConf conf) {
        if (this.topConfs.size() >= this.maxNumTopConfs) {
            double e2;
            ConfSearch.ScoredConf head = this.topConfs.peek();
            double e1 = head instanceof ConfSearch.EnergiedConf ? ((ConfSearch.EnergiedConf)head).getEnergy() : head.getScore();
            double d = e2 = conf instanceof ConfSearch.EnergiedConf ? ((ConfSearch.EnergiedConf)conf).getEnergy() : conf.getScore();
            if (e1 > e2) {
                this.topConfs.poll();
            } else {
                return;
            }
        }
        this.topConfs.add(conf);
    }

    protected void saveEConfs(PriorityQueue<ConfSearch.ScoredConf> other) {
        if (this.topConfs == null || other == null) {
            return;
        }
        while (other.size() > 0) {
            this.saveConf(other.poll());
        }
    }

    @Override
    public void init(double targetEpsilon) {
        this.targetEpsilon = targetEpsilon;
        this.status = PartitionFunction.Status.Estimating;
        this.values = new PartitionFunction.Values();
        ConfSearch ptree = this.confSearchFactory.make(this.emat, this.invmat);
        ((ConfAStarTree)ptree).stopProgress();
        this.values.pstar = this.calcWeightSumUpperBound(ptree);
        ConfSearch tree = this.confSearchFactory.make(this.emat, this.pmat);
        ((ConfAStarTree)tree).stopProgress();
        ConfSearch.MultiSplitter confsSplitter = new ConfSearch.MultiSplitter(tree);
        this.scoreConfs = confsSplitter.makeStream();
        this.energyConfs = confsSplitter.makeStream();
        this.numConfsEvaluated = 0;
        this.numConfsToScore = tree.getNumConformations();
        this.qprimeUnevaluated = BigDecimal.ZERO;
        this.qprimeUnscored = BigDecimal.ZERO;
        this.qstarScoreWeights = BigDecimal.ZERO;
        this.numActiveThreads = 0;
        this.maxNumTopConfs = 0;
        this.stopwatch = new Stopwatch().start();
    }

    @Override
    protected BigDecimal updateQprime(ConfSearch.EnergiedConf econf) {
        double effectiveEpsilon;
        do {
            ConfSearch.ScoredConf conf;
            if ((conf = this.scoreConfs.nextConf()) == null) {
                this.qprimeUnscored = BigDecimal.ZERO;
                break;
            }
            BigDecimal scoreWeight = this.boltzmann.calc(conf.getScore());
            if (scoreWeight.compareTo(BigDecimal.ZERO) == 0) {
                this.qprimeUnscored = BigDecimal.ZERO;
                break;
            }
            this.numConfsToScore = this.numConfsToScore.subtract(BigInteger.ONE);
            this.qprimeUnevaluated = this.qprimeUnevaluated.add(scoreWeight);
            this.qprimeUnscored = scoreWeight.multiply(new BigDecimal(this.numConfsToScore));
        } while (!((effectiveEpsilon = this.qprimeUnscored.divide(this.qprimeUnevaluated.add(this.qprimeUnscored), RoundingMode.HALF_UP).doubleValue()) <= 0.01));
        this.qprimeUnevaluated = this.qprimeUnevaluated.subtract(this.boltzmann.calc(econf.getScore()));
        return this.qprimeUnevaluated.add(this.qprimeUnscored);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compute(int maxNumConfs) {
        this.numActiveThreads = 0;
        if (!this.status.canContinue()) {
            throw new IllegalStateException("can't continue from status " + String.valueOf((Object)this.status));
        }
        int stopAtConf = this.numConfsEvaluated + maxNumConfs;
        while (true) {
            ConfSearch.ScoredConf conf;
            PartitionFunctionMinimized partitionFunctionMinimized = this;
            synchronized (partitionFunctionMinimized) {
                if (!this.status.canContinue() || this.numConfsEvaluated >= stopAtConf) {
                    break;
                }
                conf = this.energyConfs.nextConf();
                if (conf == null) {
                    while (this.numActiveThreads > 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    if (this.status != PartitionFunction.Status.Estimated) {
                        this.status = PartitionFunction.Status.OutOfConformations;
                    }
                    break;
                }
                if (this.boltzmann.calc(conf.getScore()).compareTo(BigDecimal.ZERO) == 0) {
                    while (this.numActiveThreads > 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    if (this.status != PartitionFunction.Status.Estimated) {
                        this.status = PartitionFunction.Status.OutOfLowEnergies;
                    }
                    break;
                }
                ++this.numActiveThreads;
            }
            this.ecalc.calcEnergyAsync(conf, econf -> {
                PartitionFunctionMinimized partitionFunctionMinimized = this;
                synchronized (partitionFunctionMinimized) {
                    if (this.status == PartitionFunction.Status.Estimating) {
                        BigDecimal energyWeight = this.boltzmann.calc(econf.getEnergy());
                        ++this.numConfsEvaluated;
                        this.values.qstar = this.values.qstar.add(energyWeight);
                        this.values.qprime = this.updateQprime((ConfSearch.EnergiedConf)econf);
                        if (this.isReportingProgress && this.numConfsEvaluated % this.ecalc.getTasks().getParallelism() == 0) {
                            this.phase1Output((ConfSearch.ScoredConf)econf);
                        }
                        if (this.confListener != null) {
                            this.confListener.onConf((ConfSearch.ScoredConf)econf);
                        }
                        if (this.values.getEffectiveEpsilon() <= this.targetEpsilon) {
                            this.status = PartitionFunction.Status.Estimated;
                            this.phase1Output((ConfSearch.ScoredConf)econf);
                        }
                    }
                    --this.numActiveThreads;
                    this.notify();
                }
            });
        }
        this.ecalc.getTasks().waitForFinish();
    }

    void phase1Output(ConfSearch.ScoredConf conf) {
        MemoryUsage heapMem = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        double confVal = conf instanceof ConfSearch.EnergiedConf ? ((ConfSearch.EnergiedConf)conf).getEnergy() : conf.getScore();
        System.out.println(String.format("conf: %4d, energy: %.6f, q*: %12e, q': %12e, p*: %12e, epsilon: %.6f, time: %10s, heapMem: %.0f%%", this.numConfsEvaluated, confVal, this.values.qstar, this.values.qprime, this.values.pstar, this.values.getEffectiveEpsilon(), this.stopwatch.getTime(2), Float.valueOf(100.0f * (float)heapMem.getUsed() / (float)heapMem.getMax())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compute(BigDecimal targetScoreWeights) {
        this.numActiveThreads = 0;
        if (!this.status.canContinue()) {
            throw new IllegalStateException("can't continue from status " + String.valueOf((Object)this.status));
        }
        while (true) {
            ConfSearch.ScoredConf conf;
            PartitionFunctionMinimized partitionFunctionMinimized = this;
            synchronized (partitionFunctionMinimized) {
                if (!this.status.canContinue() || this.qstarScoreWeights.compareTo(targetScoreWeights) >= 0) {
                    break;
                }
                conf = this.energyConfs.nextConf();
                if (conf == null) {
                    while (this.numActiveThreads > 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    if (this.status != PartitionFunction.Status.Estimated) {
                        this.status = PartitionFunction.Status.OutOfConformations;
                    }
                    break;
                }
                if (this.boltzmann.calc(conf.getScore()).compareTo(BigDecimal.ZERO) == 0) {
                    while (this.numActiveThreads > 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    if (this.status != PartitionFunction.Status.Estimated) {
                        this.status = PartitionFunction.Status.OutOfLowEnergies;
                    }
                    break;
                }
                ++this.numActiveThreads;
            }
            this.ecalc.calcEnergyAsync(conf, econf -> {
                PartitionFunctionMinimized partitionFunctionMinimized = this;
                synchronized (partitionFunctionMinimized) {
                    if (this.status == PartitionFunction.Status.Estimating) {
                        BigDecimal scoreWeight = this.boltzmann.calc(econf.getScore());
                        this.qstarScoreWeights = this.qstarScoreWeights.add(scoreWeight);
                        BigDecimal energyWeight = this.boltzmann.calc(econf.getEnergy());
                        ++this.numConfsEvaluated;
                        this.values.qstar = this.values.qstar.add(energyWeight);
                        this.values.qprime = this.updateQprime((ConfSearch.EnergiedConf)econf);
                        BigDecimal pdiff = targetScoreWeights.subtract(this.qstarScoreWeights);
                        if (this.isReportingProgress && this.numConfsEvaluated % this.ecalc.getTasks().getParallelism() == 0) {
                            this.phase2Output((ConfSearch.ScoredConf)econf, pdiff);
                        }
                        if (this.confListener != null) {
                            this.confListener.onConf((ConfSearch.ScoredConf)econf);
                        }
                        if (this.values.getEffectiveEpsilon() <= this.targetEpsilon) {
                            this.status = PartitionFunction.Status.Estimated;
                            this.phase2Output((ConfSearch.ScoredConf)econf, pdiff);
                        }
                    }
                    --this.numActiveThreads;
                    this.notify();
                }
            });
        }
        this.ecalc.getTasks().waitForFinish();
    }

    void phase2Output(ConfSearch.ScoredConf conf, BigDecimal pdiff) {
        MemoryUsage heapMem = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        double confVal = conf instanceof ConfSearch.EnergiedConf ? ((ConfSearch.EnergiedConf)conf).getEnergy() : conf.getScore();
        System.out.println(String.format("conf: %4d, energy: %.6f, q*: %12e, q': %12e, score diff: %12e, epsilon: %.6f, time: %10s, heapMem: %.0f%%", this.numConfsEvaluated, confVal, this.values.qstar, this.values.qprime, pdiff, this.values.getEffectiveEpsilon(), this.stopwatch.getTime(2), Float.valueOf(100.0f * (float)heapMem.getUsed() / (float)heapMem.getMax())));
    }

    public void setStatus(PartitionFunction.Status val) {
        this.status = val;
    }

    public void cleanup() {
        this.scoreConfs = null;
        this.energyConfs = null;
    }
}

