/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.multistatekstar;

import edu.duke.cs.osprey.confspace.HigherTupleFinder;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.multistatekstar.MSSearchProblem;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import java.util.ArrayList;
import java.util.Iterator;

public class PruningMatrixInverted
extends PruningMatrix {
    private PruningMatrix other;
    private MSSearchProblem search;

    public PruningMatrixInverted(MSSearchProblem search2, PruningMatrix other) {
        this.other = other;
        this.search = search2;
    }

    private boolean somethingPrunedForAAType(int res, String rcAAType) {
        for (int index : this.other.prunedRCsAtPos(res)) {
            String rcAAType2 = this.search.confSpace.posFlex.get((int)res).RCs.get((int)index).AAType;
            if (!rcAAType2.equalsIgnoreCase(rcAAType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean getOneBody(int res, int index) {
        String rcAAType = this.search.confSpace.posFlex.get((int)res).RCs.get((int)index).AAType;
        if (!this.search.settings.AATypeOptions.get(res).contains(rcAAType)) {
            return true;
        }
        if (this.somethingPrunedForAAType(res, rcAAType)) {
            return this.other.getOneBody(res, index) == false;
        }
        return false;
    }

    private boolean contains(int res1, int index1, int res2, int index2) {
        String rcAAType1 = this.search.confSpace.posFlex.get((int)res1).RCs.get((int)index1).AAType;
        String rcAAType2 = this.search.confSpace.posFlex.get((int)res2).RCs.get((int)index2).AAType;
        boolean c1 = this.search.settings.AATypeOptions.get(res1).contains(rcAAType1);
        boolean c2 = this.search.settings.AATypeOptions.get(res2).contains(rcAAType2);
        return c1 && c2;
    }

    @Override
    public Boolean getPairwise(int res1, int index1, int res2, int index2) {
        if (this.contains(res1, index1, res2, index2) && !this.getOneBody(res1, index1).booleanValue() && !this.getOneBody(res2, index2).booleanValue()) {
            return false;
        }
        return true;
    }

    @Override
    public void setOneBody(int res, int conf, Boolean val) {
        this.dontwrite();
    }

    @Override
    public void setOneBody(int res, ArrayList<Boolean> val) {
        this.dontwrite();
    }

    @Override
    public void setPairwise(int res1, int conf1, int res2, int conf2, Boolean val) {
        this.dontwrite();
    }

    @Override
    public void setPairwise(int res1, int res2, ArrayList<ArrayList<Boolean>> val) {
        this.dontwrite();
    }

    @Override
    public void markAsPruned(RCTuple tup) {
        this.dontwrite();
    }

    @Override
    public void fill(Boolean val) {
        this.dontwrite();
    }

    @Override
    public void fill(Iterator<Boolean> val) {
        this.dontwrite();
    }

    @Override
    public void setTupleValue(RCTuple tup, Boolean val) {
        this.dontwrite();
    }

    @Override
    public void setHigherOrder(RCTuple tup, Boolean val) {
        this.dontwrite();
    }

    @Override
    public HigherTupleFinder<Boolean> getHigherOrderTerms(int res1, int conf1, int res2, int conf2) {
        throw new UnsupportedOperationException("higher order terms not yet supported with value inversion");
    }

    @Override
    public void setHigherOrderTerms(int res1, int conf1, int res2, int conf2, HigherTupleFinder<Boolean> val) {
        this.dontwrite();
    }

    @Override
    public int getNumPos() {
        return this.other.getNumPos();
    }

    @Override
    public int getNumConfAtPos(int pos) {
        return this.other.getNumConfAtPos(pos);
    }

    private void dontwrite() {
        throw new UnsupportedOperationException("this inverted pruning matrix is read-only");
    }
}

