/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.parallelism;

import edu.duke.cs.osprey.control.ConfigFileParser;
import edu.duke.cs.osprey.gpu.cuda.Gpus;
import edu.duke.cs.osprey.parallelism.TaskExecutor;
import edu.duke.cs.osprey.parallelism.ThreadPoolTaskExecutor;

public class Parallelism {
    public final int numThreads;
    public final int numGpus;
    public final int numStreamsPerGpu;
    public final Type type;
    public static final Parallelism SingleThreaded = new Parallelism(1, 0, 0);

    public static Parallelism makeCpu(int numThreads) {
        return new Parallelism(numThreads, 0, 0);
    }

    public static int getMaxNumCPUs() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static Parallelism make(int numCpus, int numGpus, int numStreamsPerGpu) {
        return new Parallelism(numCpus, numGpus, numStreamsPerGpu);
    }

    public static Parallelism make(int numCpus, int numGpus) {
        return new Parallelism(numCpus, numGpus, 1);
    }

    public static Parallelism makeFromConfig(ConfigFileParser cfp) {
        return new Parallelism(cfp.params.getInt("MinimizationThreads", 1), cfp.params.getInt("MinimizationGpus", 0), cfp.params.getInt("MinimizationStreamsPerGpu", 1));
    }

    public static boolean hasGPUs() {
        return !Gpus.get().getGpus().isEmpty();
    }

    public Parallelism(int numThreads, int numGpus, int numStreamsPerGpu) {
        this.numThreads = numThreads;
        this.numGpus = numGpus;
        this.numStreamsPerGpu = numStreamsPerGpu;
        this.type = numGpus > 0 ? Type.Gpu : Type.Cpu;
        if (this.getParallelism() <= 0) {
            throw new IllegalArgumentException(String.format("parallelism should be at least 1: threads=%d, gpus=%d, streams/gpu=%d", numThreads, numGpus, numStreamsPerGpu));
        }
    }

    public int getParallelism() {
        return this.type.getParallelism(this);
    }

    public TaskExecutor makeTaskExecutor() {
        return this.makeTaskExecutor(null);
    }

    public TaskExecutor makeTaskExecutor(Integer queueSize) {
        if (this.getParallelism() > 1) {
            ThreadPoolTaskExecutor tasks = new ThreadPoolTaskExecutor();
            if (queueSize != null) {
                tasks.queueSize = queueSize;
            }
            tasks.start(this.getParallelism());
            return tasks;
        }
        return new TaskExecutor();
    }

    public String toString() {
        return String.format("Parallelism(threads=%d, gpus=%d, streams/gpu=%d)", this.numThreads, this.numGpus, this.numStreamsPerGpu);
    }

    public static enum Type {
        Cpu{

            @Override
            public int getParallelism(Parallelism parallelism) {
                return parallelism.numThreads;
            }
        }
        ,
        Gpu{

            @Override
            public int getParallelism(Parallelism parallelism) {
                return parallelism.numGpus * parallelism.numStreamsPerGpu;
            }
        };


        public abstract int getParallelism(Parallelism var1);
    }

    public static class Builder {
        private int numCpus = 1;
        private int numGpus = 0;
        private int numStreamsPerGpu = 1;

        public Builder setNumCpus(int val) {
            this.numCpus = val;
            return this;
        }

        public Builder setNumGpus(int val) {
            this.numGpus = val;
            return this;
        }

        public Builder setNumStreamsPerGpu(int val) {
            this.numStreamsPerGpu = val;
            return this;
        }

        public Parallelism build() {
            return new Parallelism(this.numCpus, this.numGpus, this.numStreamsPerGpu);
        }
    }
}

