/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.parallelism;

import edu.duke.cs.osprey.tools.AutoCleanable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class Threads
implements AutoCleanable {
    private static int nextId = 0;
    private final int poolId = nextId++;
    private final ThreadPoolExecutor pool;
    private final ThreadPoolExecutor listener;
    public final BlockingQueue<Runnable> queue;

    public Threads(int numThreads, int queueSize) {
        this.queue = queueSize <= 0 ? new SynchronousQueue<Runnable>() : new ArrayBlockingQueue<Runnable>(queueSize);
        AtomicInteger threadId = new AtomicInteger(0);
        this.pool = new ThreadPoolExecutor(numThreads, numThreads, 0L, TimeUnit.DAYS, this.queue, runnable -> {
            Thread thread2 = Executors.defaultThreadFactory().newThread(runnable);
            thread2.setDaemon(true);
            thread2.setName(String.format("pool-%d-%d", this.poolId, threadId.getAndIncrement()));
            return thread2;
        });
        this.pool.prestartAllCoreThreads();
        this.listener = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.DAYS, new LinkedBlockingQueue<Runnable>(), runnable -> {
            Thread thread2 = Executors.defaultThreadFactory().newThread(runnable);
            thread2.setDaemon(true);
            thread2.setName(String.format("pool-%d-listener", this.poolId));
            return thread2;
        });
        this.listener.prestartAllCoreThreads();
    }

    @Override
    public void clean() {
        this.pool.shutdown();
        this.listener.shutdown();
    }

    public void cleanAndWait(int timeoutMs) {
        this.clean();
        try {
            this.pool.awaitTermination(timeoutMs, TimeUnit.MILLISECONDS);
            this.listener.awaitTermination(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new Error(ex);
        }
    }

    public int size() {
        return this.pool.getCorePoolSize();
    }

    public boolean submit(long timeout, TimeUnit timeUnit, Runnable runnable) {
        try {
            return this.queue.offer(runnable, timeout, timeUnit);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("can't submit runnable to threads", ex);
        }
    }

    public void submitLoop(long interval, TimeUnit timeUnit, Runnable runnable) {
        boolean wasAdded = false;
        while (!wasAdded) {
            wasAdded = this.submit(interval, timeUnit, runnable);
        }
    }

    public void submitToListener(Runnable runnable) {
        this.listener.submit(runnable);
    }
}

