/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.parallelism;

import edu.duke.cs.osprey.parallelism.Worker;
import java.util.ArrayList;
import java.util.Iterator;

public class WorkCrew<T extends Worker>
implements Iterable<T> {
    protected ArrayList<T> workers;
    private String name;
    private Object workSync;
    private Object resultsSync;
    private volatile int counter;

    @CalledByBoss
    public WorkCrew(String name) {
        this.name = name;
        this.workers = new ArrayList();
        this.workSync = new Object();
        this.resultsSync = new Object();
        this.counter = 0;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<T> getWorkers() {
        return this.workers;
    }

    @Override
    public Iterator<T> iterator() {
        return this.workers.iterator();
    }

    public void start() {
        for (Worker worker : this.workers) {
            worker.start();
        }
    }

    public void askToStop() {
        for (Worker worker : this.workers) {
            worker.askToStop();
        }
    }

    public void killThreads() {
        for (Worker worker : this.workers) {
            worker.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByWorker
    public void waitForWork(Worker processor, int timeoutMs) throws InterruptedException {
        if (processor.hasWork) {
            return;
        }
        Object object = this.workSync;
        synchronized (object) {
            if (processor.hasWork) {
                return;
            }
            this.workSync.wait(timeoutMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByBoss
    public void sendWork() {
        this.counter = 0;
        for (Worker worker : this.workers) {
            worker.hasWork = true;
        }
        Object object = this.workSync;
        synchronized (object) {
            this.workSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByBoss
    public boolean waitForResults(int timeoutMs) throws InterruptedException {
        if (this.counter == this.workers.size()) {
            return true;
        }
        Object object = this.resultsSync;
        synchronized (object) {
            if (this.counter == this.workers.size()) {
                return true;
            }
            this.resultsSync.wait(timeoutMs);
        }
        return this.counter == this.workers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByWorker
    public void finishedWork() {
        int c;
        Object object = this;
        synchronized (object) {
            ++this.counter;
            c = this.counter;
        }
        if (c == this.workers.size()) {
            object = this.resultsSync;
            synchronized (object) {
                this.resultsSync.notify();
            }
        }
    }

    public static @interface CalledByBoss {
    }

    public static @interface CalledByWorker {
    }
}

