/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.parallelism;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class WorkLatch {
    private final AtomicLong incoming;
    private final CountDownLatch latch;

    public WorkLatch(long size) {
        this.incoming = new AtomicLong(size);
        this.latch = new CountDownLatch(1);
    }

    public void await(long timeout, TimeUnit unit) {
        if (this.incoming.get() > 0L) {
            try {
                boolean finished = this.latch.await(timeout, unit);
                if (!finished) {
                    throw new RuntimeException("Timeed out waiting work to finish, remaining: " + this.incoming.get());
                }
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void finished(long size) {
        long remaining = this.incoming.updateAndGet(i -> i -= size);
        if (remaining <= 0L) {
            this.latch.countDown();
            if (remaining < 0L) {
                System.err.println("WARNING: too much work done, overwork: " + -remaining);
                Thread.dumpStack();
            }
        }
    }
}

