/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.partcr.splitters;

import edu.duke.cs.osprey.confspace.RC;
import edu.duke.cs.osprey.partcr.splitters.RCSplitter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NAryRCSplitter
extends RCSplitter {
    @Override
    public List<RC> split(int pos, RC rc) {
        ArrayList<RC> rcs = new ArrayList<RC>();
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < rc.DOFs.size(); ++i) {
            if (rc.DOFmin.get(i) == rc.DOFmax.get(i)) continue;
            indices.add(i);
        }
        int numDofs = indices.size();
        int numRcs = 1 << numDofs;
        for (int rcIndex = 0; rcIndex < numRcs; ++rcIndex) {
            ArrayList<Double> mins = new ArrayList<Double>(rc.DOFmin);
            ArrayList<Double> maxs = new ArrayList<Double>(rc.DOFmax);
            RC subRc = new RC(rc.AAType, rc.template, rc.rotNum, rc.DOFs, mins, maxs, rc.RCIndex);
            Iterator iterator2 = indices.iterator();
            while (iterator2.hasNext()) {
                int dofIndex = (Integer)iterator2.next();
                double min = rc.DOFmin.get(dofIndex);
                double max = rc.DOFmax.get(dofIndex);
                double mid = (max + min) / 2.0;
                switch (Side.get(rcIndex, dofIndex)) {
                    case Low: {
                        mins.set(dofIndex, min);
                        maxs.set(dofIndex, mid);
                        break;
                    }
                    case High: {
                        mins.set(dofIndex, mid);
                        maxs.set(dofIndex, max);
                    }
                }
            }
            rcs.add(subRc);
        }
        double volume = this.calcVolume(rc, indices);
        for (RC subRc : rcs) {
            volume -= this.calcVolume(subRc, indices);
        }
        assert (Math.abs(volume) < 1.0E-10);
        return rcs;
    }

    private double calcVolume(RC rc, List<Integer> indices) {
        double volume = 1.0;
        for (int dofIndex : indices) {
            double min = rc.DOFmin.get(dofIndex);
            double max = rc.DOFmax.get(dofIndex);
            volume *= max - min;
        }
        return volume;
    }

    private static enum Side {
        Low,
        High;


        public static Side get(int rcIndex, int dofIndex) {
            int ord = rcIndex >> dofIndex & 1;
            return Side.values()[ord];
        }
    }
}

