/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.plug;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.SingularValueDecomposition;
import edu.duke.cs.osprey.bbfree.BBFreeDOF;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.plug.LPChecks;
import edu.duke.cs.osprey.plug.VoxelVDWDistExplorer;
import edu.duke.cs.osprey.restypes.HardCodedResidueInfo;
import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.VectorAlgebra;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.optim.linear.LinearConstraint;
import org.apache.commons.math3.optim.linear.Relationship;

public class VoxelVDWListChecker {
    ArrayList<DOFInterval> dofIntervals = new ArrayList();
    ArrayList<Atom[]> interactingAtoms = new ArrayList();
    ArrayList<Residue> knownConfRes = null;
    HashSet<Residue> shellResidues = null;
    ArrayList<LinearConstraint> voxLinConstr = new ArrayList();
    static boolean onlyLC = true;

    public VoxelVDWListChecker(ArrayList<DOFInterval> dofIntervals, ArrayList<Atom[]> interactingAtoms, ArrayList<Residue> knownConfRes, ArrayList<Residue> shellRes, ArrayList<LinearConstraint> voxLinConstr) {
        this.dofIntervals = dofIntervals;
        this.interactingAtoms = interactingAtoms;
        this.knownConfRes = knownConfRes;
        this.voxLinConstr = voxLinConstr;
        if (shellRes == null) {
            int n = 5;
        }
        this.shellResidues = new HashSet<Residue>(shellRes);
    }

    public VoxelVDWListChecker() {
    }

    public final void addDOFInterval(DegreeOfFreedom dof, double lb, double range) {
        this.dofIntervals.add(new DOFInterval(dof, lb, range));
    }

    public final void addAtomPair(Atom atom1, Atom atom2) {
        this.interactingAtoms.add(new Atom[]{atom1, atom2});
    }

    public final void addVoxLinConstr(ArrayList<LinearConstraint> linConstr) {
        this.voxLinConstr.addAll(linConstr);
    }

    int numDOFs() {
        return this.dofIntervals.size();
    }

    boolean checkFeasibility() {
        return this.calcFeasiblePolytope(null) != null;
    }

    double atomPairOverlap(Atom at1, Atom at2) {
        double dist = VectorAlgebra.distance(at1.getCoords(), at2.getCoords());
        return VoxelVDWDistExplorer.getVDWRadius(at1) + VoxelVDWDistExplorer.getVDWRadius(at2) - dist;
    }

    ArrayList<LinearConstraint> calcFeasiblePolytope(ArrayList<String> atomPairNames) {
        ArrayList<LinearConstraint> curPolygon = this.voxelPolygon();
        if (atomPairNames != null) {
            for (int n = 0; n < curPolygon.size(); ++n) {
                atomPairNames.add("VOXEL CONSTRAINT");
            }
        }
        int numVDWPairs = this.interactingAtoms.size();
        for (int p = 0; p < numVDWPairs; ++p) {
            boolean validLC;
            LinearConstraint lc = this.tooCloseConstr(this.interactingAtoms.get(p));
            boolean bl = validLC = !(lc.getCoefficients().getNorm() < 1.0E-10);
            if (validLC) {
                if (!LPChecks.canAddConstr(lc, curPolygon)) {
                    return null;
                }
                curPolygon.add(lc);
                if (atomPairNames == null) continue;
                atomPairNames.add(this.makeAtomPairNames(this.interactingAtoms.get(p)));
                continue;
            }
            if (lc.getRelationship() == Relationship.GEQ != lc.getValue() > 0.0 || this.atomsFixed(this.interactingAtoms.get(p))) continue;
            return null;
        }
        if (onlyLC) {
            return curPolygon;
        }
        for (DOFInterval di : this.dofIntervals) {
            di.dof.apply(di.lb + di.range / 2.0);
        }
        HashMap<Atom, Atom> closestContactingAtom = new HashMap<Atom, Atom>();
        HashMap<Atom, Double> biggestOverlap = new HashMap<Atom, Double>();
        HashMap partners = new HashMap();
        for (Atom[] atomPair : this.interactingAtoms) {
            if (!partners.containsKey(atomPair[0])) {
                partners.put(atomPair[0], new ArrayList());
            }
            ((ArrayList)partners.get(atomPair[0])).add(atomPair[1]);
            double overlap = this.atomPairOverlap(atomPair[0], atomPair[1]);
            if (biggestOverlap.containsKey(atomPair[0]) && overlap <= (Double)biggestOverlap.get(atomPair[0])) continue;
            biggestOverlap.put(atomPair[0], overlap);
            closestContactingAtom.put(atomPair[0], atomPair[1]);
        }
        for (Atom at1 : partners.keySet()) {
            LinearConstraint uc;
            boolean validUC;
            if (at1.bonds.size() > 3) continue;
            double closestOverlap = (Double)biggestOverlap.get(at1);
            boolean keepUC = true;
            if (closestOverlap < 0.0) {
                boolean hasCloseAtoms = false;
                double dist1 = VoxelVDWDistExplorer.getVDWRadius(at1) + 1.0 - closestOverlap;
                for (Atom at2 : (ArrayList)partners.get(at1)) {
                    double dist2;
                    ArrayList<double[]> borderSamps = VoxelVDWListChecker.sampleSphereIntersection(at1, dist1, at2, dist2 = VoxelVDWDistExplorer.getVDWRadius(at2) + 1.0);
                    if (!borderSamps.isEmpty()) {
                        hasCloseAtoms = true;
                    }
                    for (double[] samp : borderSamps) {
                        if (this.coordWithinSomeAtomVDWRad(samp, 1.0)) continue;
                        keepUC = false;
                        break;
                    }
                    if (keepUC) continue;
                    break;
                }
                if (!hasCloseAtoms) {
                    keepUC = false;
                }
            }
            if (!keepUC || !(validUC = !((uc = this.tooFarConstr(new Atom[]{at1, (Atom)closestContactingAtom.get(at1)})).getCoefficients().getNorm() < 1.0E-10))) continue;
            if (!LPChecks.canAddConstr(uc, curPolygon)) {
                return null;
            }
            curPolygon.add(uc);
        }
        return curPolygon;
    }

    String makeAtomPairNames(Atom[] atoms) {
        return this.makeAtomName(atoms[0]) + " ; " + this.makeAtomName(atoms[1]);
    }

    String makeAtomName(Atom atom) {
        return atom.res.fullName + " , " + atom.name;
    }

    boolean atomsFixed(Atom[] pair) {
        for (DOFInterval di : this.dofIntervals) {
            if (!(di.dof instanceof BBFreeDOF)) continue;
            return false;
        }
        for (Atom at : pair) {
            if (HardCodedResidueInfo.possibleBBAtomsLookup.contains(at.name) || at.name.equalsIgnoreCase("CB") || this.shellResidues.contains(at.res)) continue;
            return false;
        }
        return true;
    }

    boolean coordWithinSomeAtomVDWRad(double[] coord, double buffer) {
        for (Residue res : this.knownConfRes) {
            for (Atom at : res.atoms) {
                double dist = VectorAlgebra.distance(at.getCoords(), coord);
                if (!(dist < VoxelVDWDistExplorer.getVDWRadius(at) + buffer)) continue;
                return true;
            }
        }
        return false;
    }

    static ArrayList<double[]> sampleSphereIntersection(Atom at1, double rad1, Atom at2, double rad2) {
        ArrayList<double[]> ans = new ArrayList<double[]>();
        double[] aaVec = VectorAlgebra.subtract(at2.getCoords(), at1.getCoords());
        double dist = VectorAlgebra.norm(aaVec);
        double cosAng1 = (rad1 * rad1 + dist * dist - rad2 * rad2) / (2.0 * rad1 * dist);
        if (cosAng1 > 1.0 || cosAng1 < -1.0) {
            return ans;
        }
        double z = cosAng1 * rad1;
        double r = rad1 * Math.sqrt(1.0 - cosAng1 * cosAng1);
        double[] cen = VectorAlgebra.add(at1.getCoords(), VectorAlgebra.scale(aaVec, z / dist));
        double[] x = VectorAlgebra.getPerpendicular(aaVec);
        VectorAlgebra.normalizeInPlace(x);
        double[] y = VectorAlgebra.cross(aaVec, x);
        VectorAlgebra.normalizeInPlace(y);
        double numSamps = 8.0;
        int s = 0;
        while ((double)s < numSamps) {
            double ang = (double)(s * 2) * Math.PI / numSamps;
            double[] samp = VectorAlgebra.scale(x, r * Math.cos(ang));
            VectorAlgebra.addInPlace(samp, VectorAlgebra.scale(y, r * Math.sin(ang)));
            VectorAlgebra.addInPlace(samp, cen);
            ans.add(samp);
            ++s;
        }
        return ans;
    }

    ArrayList<LinearConstraint> calcFeasiblePolytope3() {
        ArrayList<LinearConstraint> lcPolygon = this.voxelPolygon();
        int numVDWPairs = this.interactingAtoms.size();
        for (int p = 0; p < numVDWPairs; ++p) {
            boolean validLC;
            LinearConstraint lc = this.tooCloseConstr(this.interactingAtoms.get(p));
            boolean bl = validLC = !(lc.getCoefficients().getNorm() < 1.0E-10);
            if (!validLC) continue;
            if (!LPChecks.canAddConstr(lc, lcPolygon)) {
                return null;
            }
            lcPolygon.add(lc);
        }
        ArrayList curPolygon = (ArrayList)lcPolygon.clone();
        for (int p = 0; p < numVDWPairs; ++p) {
            boolean validUC;
            LinearConstraint uc = this.tooFarConstr(this.interactingAtoms.get(p));
            boolean bl = validUC = !(uc.getCoefficients().getNorm() < 1.0E-10);
            if (!validUC) continue;
            if (LPChecks.canAddConstr(uc, lcPolygon) && !LPChecks.canAddConstr(uc, curPolygon)) {
                return null;
            }
            curPolygon.add(uc);
        }
        return curPolygon;
    }

    ArrayList<LinearConstraint> calcFeasiblePolytope2() {
        ArrayList<LinearConstraint> curPolygon = this.voxelPolygon();
        int numVDWPairs = this.interactingAtoms.size();
        for (int p = 0; p < numVDWPairs; ++p) {
            boolean validLC;
            LinearConstraint lc = this.tooCloseConstr(this.interactingAtoms.get(p));
            boolean bl = validLC = !(lc.getCoefficients().getNorm() < 1.0E-10);
            if (!validLC) continue;
            if (!LPChecks.canAddConstr(lc, curPolygon)) {
                return null;
            }
            curPolygon.add(lc);
        }
        return curPolygon;
    }

    double[] DOFsAtAtomPairDist(Atom[] atomPair, double targetDist, double[] initGuess) {
        double initDist;
        double[] x = (double[])initGuess.clone();
        double curDist = initDist = this.calcAtomPairDist(x, atomPair);
        double[] w = new double[this.numDOFs()];
        for (int dof = 0; dof < this.numDOFs(); ++dof) {
            w[dof] = this.dofIntervals.get((int)dof).range;
        }
        while (Math.abs(targetDist - curDist) > 0.01) {
            int dof;
            double[] grad = this.calcAtomPairDistGrad(x, atomPair);
            double derivsq = 0.0;
            for (dof = 0; dof < this.numDOFs(); ++dof) {
                derivsq += w[dof] * w[dof] * grad[dof] * grad[dof];
            }
            if (derivsq == 0.0) {
                return null;
            }
            for (dof = 0; dof < this.numDOFs(); ++dof) {
                int n = dof;
                x[n] = x[n] - (curDist - targetDist) * grad[dof] * w[dof] * w[dof] / derivsq;
                DOFInterval di = this.dofIntervals.get(dof);
                if (!(x[dof] < di.lb) && !(x[dof] > di.lb + di.range)) continue;
                return null;
            }
            curDist = this.calcAtomPairDist(x, atomPair);
        }
        return x;
    }

    double[] DOFsAtAtomPairDist(Atom[] atomPair, double targetDist) {
        return this.DOFsAtAtomPairDist(atomPair, targetDist, this.voxelCenter());
    }

    LinearConstraint linearizedAtomDistConstr(Atom[] atomPair, double targetDist, boolean lbConstr) {
        double[] cen = this.voxelCenter();
        double[] x = this.DOFsAtAtomPairDist(atomPair, targetDist, cen);
        if (x == null) {
            double initDist = this.calcAtomPairDist(cen, atomPair);
            if (lbConstr == initDist > targetDist) {
                return new LinearConstraint(new double[this.numDOFs()], Relationship.GEQ, -1.0);
            }
            return new LinearConstraint(new double[this.numDOFs()], Relationship.GEQ, 1.0);
        }
        double curDist = this.calcAtomPairDist(x, atomPair);
        double[] grad = this.calcAtomPairDistGrad(x, atomPair);
        double targ = targetDist - curDist;
        for (int dof = 0; dof < this.numDOFs(); ++dof) {
            targ += grad[dof] * x[dof];
        }
        if (lbConstr) {
            return new LinearConstraint(grad, Relationship.GEQ, targ);
        }
        return new LinearConstraint(grad, Relationship.LEQ, targ);
    }

    double calcAtomPairDist(double[] DOFVals, Atom[] atomPair) {
        for (int dofNum = 0; dofNum < this.numDOFs(); ++dofNum) {
            this.dofIntervals.get((int)dofNum).dof.apply(DOFVals[dofNum]);
        }
        return VectorAlgebra.distance(atomPair[0].getCoords(), atomPair[1].getCoords());
    }

    double[] calcAtomPairDistGrad(double[] DOFVals, Atom[] atomPair) {
        double step = 1.0E-6;
        int numDOFs = this.numDOFs();
        double[] ans = new double[numDOFs];
        for (int dof = 0; dof < numDOFs; ++dof) {
            int n = dof;
            DOFVals[n] = DOFVals[n] + step;
            double upVal = this.calcAtomPairDist(DOFVals, atomPair);
            int n2 = dof;
            DOFVals[n2] = DOFVals[n2] - 2.0 * step;
            double downVal = this.calcAtomPairDist(DOFVals, atomPair);
            int n3 = dof;
            DOFVals[n3] = DOFVals[n3] + step;
            ans[dof] = (upVal - downVal) / (2.0 * step);
        }
        return ans;
    }

    LinearConstraint tooCloseConstr(Atom[] atomPair) {
        double idealDist = VoxelVDWDistExplorer.getVDWRadius(atomPair[0]) + VoxelVDWDistExplorer.getVDWRadius(atomPair[1]);
        double buffer = VoxelVDWListChecker.getClashBuffer(atomPair[0], atomPair[1]);
        return this.linearizedAtomDistConstr(atomPair, idealDist - buffer, true);
    }

    public static double getTargetDist(Atom atom1, Atom atom2) {
        return VoxelVDWDistExplorer.getVDWRadius(atom1) + VoxelVDWDistExplorer.getVDWRadius(atom2) - VoxelVDWListChecker.getClashBuffer(atom1, atom2);
    }

    static double getClashBuffer(Atom atom1, Atom atom2) {
        int HBondedElem;
        if (atom1.elementNumber == 1) {
            Atom tmp = atom1;
            atom1 = atom2;
            atom2 = tmp;
        }
        if (!(atom2.elementNumber != 1 || (HBondedElem = atom2.bonds.get((int)0).elementNumber) != 7 && HBondedElem != 8 || atom1.elementNumber != 8 && atom1.elementNumber != 16)) {
            if (VoxelVDWListChecker.isCarboxylateO(atom1) && (VoxelVDWListChecker.isAmmoniumH(atom2) || VoxelVDWListChecker.isArgChargedH(atom2))) {
                return 0.8;
            }
            return 0.6;
        }
        return 0.4;
    }

    private static boolean isCarboxylateO(Atom atom) {
        if (atom.elementNumber != 8) {
            return false;
        }
        if (atom.bonds.size() != 1) {
            return false;
        }
        Atom C = atom.bonds.get(0);
        if (C.elementNumber != 6) {
            return false;
        }
        if (C.bonds.size() != 3) {
            return false;
        }
        int countO = 0;
        for (Atom atom2 : C.bonds) {
            if (atom2.bonds.size() != 1 || atom2.elementNumber != 8) continue;
            ++countO;
        }
        return countO == 2;
    }

    private static boolean isAmmoniumH(Atom atom) {
        if (atom.elementNumber != 1) {
            return false;
        }
        Atom N = atom.bonds.get(0);
        if (N.elementNumber != 7) {
            return false;
        }
        return N.bonds.size() == 4;
    }

    private static boolean isArgChargedH(Atom atom) {
        if (!atom.res.template.name.equalsIgnoreCase("ARG")) {
            return false;
        }
        if (atom.elementNumber != 1) {
            return false;
        }
        return atom.name.equalsIgnoreCase("HE") || atom.name.startsWith("HH");
    }

    LinearConstraint tooFarConstr(Atom[] atomPair) {
        double idealDist = VoxelVDWDistExplorer.getVDWRadius(atomPair[0]) + VoxelVDWDistExplorer.getVDWRadius(atomPair[1]);
        return this.linearizedAtomDistConstr(atomPair, idealDist + 0.25, false);
    }

    ArrayList<LinearConstraint> voxelPolygon() {
        ArrayList<LinearConstraint> ans = new ArrayList<LinearConstraint>();
        for (int dof = 0; dof < this.numDOFs(); ++dof) {
            double[] unitVec = new double[this.numDOFs()];
            unitVec[dof] = 1.0;
            DOFInterval di = this.dofIntervals.get(dof);
            ans.add(new LinearConstraint(unitVec, Relationship.GEQ, di.lb));
            ans.add(new LinearConstraint(unitVec, Relationship.LEQ, di.lb + di.range));
        }
        ans.addAll(this.voxLinConstr);
        return ans;
    }

    double[] voxelCenter() {
        double[] ans = new double[this.numDOFs()];
        HashMap<DegreeOfFreedom, Double> specialCenter = this.calcSpecialCenter();
        for (int dof = 0; dof < this.numDOFs(); ++dof) {
            DOFInterval di = this.dofIntervals.get(dof);
            ans[dof] = specialCenter.containsKey(di.dof) ? specialCenter.get(di.dof) : di.lb + di.range / 2.0;
        }
        return ans;
    }

    public HashMap<DegreeOfFreedom, Double> calcSpecialCenter() {
        HashMap<DegreeOfFreedom, Double> ans = new HashMap<DegreeOfFreedom, Double>();
        int numSpecialDOFConstr = this.voxLinConstr.size() / 2;
        if (numSpecialDOFConstr == 0) {
            return ans;
        }
        HashSet<Integer> specialDOFSet = new HashSet<Integer>();
        for (int spesh = 0; spesh < numSpecialDOFConstr; ++spesh) {
            RealVector coeff = this.voxLinConstr.get(2 * spesh).getCoefficients();
            if (coeff.getDistance(this.voxLinConstr.get(2 * spesh + 1).getCoefficients()) > 0.0) {
                throw new RuntimeException("ERROR: voxLinConstr not paired like expected");
            }
            for (int d = 0; d < this.dofIntervals.size(); ++d) {
                if (coeff.getEntry(d) == 0.0) continue;
                specialDOFSet.add(d);
            }
        }
        int numSpecialDOFs = specialDOFSet.size();
        ArrayList<Integer> specialDOFList = new ArrayList<Integer>();
        specialDOFList.addAll(specialDOFSet);
        DoubleMatrix2D specialConstr = DoubleFactory2D.dense.make(numSpecialDOFConstr, numSpecialDOFs);
        DoubleMatrix2D target = DoubleFactory2D.dense.make(numSpecialDOFs, 1);
        for (int spesh = 0; spesh < numSpecialDOFConstr; ++spesh) {
            RealVector coeffs = this.voxLinConstr.get(2 * spesh).getCoefficients();
            for (int d = 0; d < numSpecialDOFs; ++d) {
                specialConstr.set(spesh, d, coeffs.getEntry(((Integer)specialDOFList.get(d)).intValue()));
            }
            target.set(spesh, 0, 0.5 * (this.voxLinConstr.get(2 * spesh).getValue() + this.voxLinConstr.get(2 * spesh + 1).getValue()));
        }
        DoubleMatrix2D orthComponents = VoxelVDWListChecker.getOrthogVectors(specialConstr);
        DoubleMatrix2D M = DoubleFactory2D.dense.compose((DoubleMatrix2D[][])new DoubleMatrix2D[][]{{specialConstr}, {Algebra.DEFAULT.transpose(orthComponents)}});
        DoubleMatrix1D specialDOFVals = Algebra.DEFAULT.solve(M, target).viewColumn(0);
        for (int d = 0; d < numSpecialDOFs; ++d) {
            ans.put(this.dofIntervals.get((int)((Integer)specialDOFList.get((int)d)).intValue()).dof, specialDOFVals.get(d));
        }
        return ans;
    }

    public static DoubleMatrix2D getOrthogVectors(DoubleMatrix2D M) {
        DoubleMatrix2D Maug = DoubleFactory2D.dense.make(M.columns(), M.columns());
        Maug.viewPart(0, 0, M.rows(), M.columns()).assign(M);
        SingularValueDecomposition svd = new SingularValueDecomposition(Maug);
        int numOrthVecs = M.columns() - M.rows();
        if (svd.rank() != M.rows()) {
            throw new RuntimeException("ERROR: Singularity in constr jac.  Rank: " + svd.rank());
        }
        DoubleMatrix2D orthVecs = svd.getV().viewPart(0, M.rows(), M.columns(), numOrthVecs);
        return orthVecs;
    }

    protected static class DOFInterval {
        DegreeOfFreedom dof;
        double lb;
        double range;

        protected DOFInterval(DegreeOfFreedom dof, double lb, double range) {
            this.dof = dof;
            this.lb = lb;
            this.range = range;
        }
    }
}

