/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.pruning;

import edu.duke.cs.osprey.confspace.SearchProblem;
import edu.duke.cs.osprey.pruning.Pruner;
import edu.duke.cs.osprey.tools.TimeFormatter;

public class PruningControl {
    SearchProblem searchSpace;
    double pruningInterval;
    boolean typeDep;
    double boundsThresh;
    int algOption;
    boolean useFlags;
    boolean useTriples;
    boolean preDACS;
    boolean useEPIC;
    boolean useTupExp;
    double stericThresh;
    boolean onlyGoldstein = false;
    private ReportMode reportMode;

    public PruningControl(SearchProblem searchSpace, double pruningInterval, boolean typeDep, double boundsThresh, int algOption, boolean useFlags, boolean useTriples, boolean preDACS, boolean useEPIC, boolean useTupExp, double stericThresh) {
        this.searchSpace = searchSpace;
        this.pruningInterval = pruningInterval;
        this.typeDep = typeDep;
        this.boundsThresh = boundsThresh;
        this.algOption = algOption;
        this.useFlags = useFlags;
        this.useTriples = useTriples;
        this.preDACS = preDACS;
        this.useEPIC = useEPIC;
        this.useTupExp = useTupExp;
        this.stericThresh = stericThresh;
        this.reportMode = ReportMode.Long;
    }

    public void setPruningInterval(double val) {
        this.pruningInterval = val;
    }

    public void setUseEPIC(boolean val) {
        this.useEPIC = val;
    }

    public void setUseTupExp(boolean val) {
        this.useTupExp = val;
    }

    public void setReportMode(ReportMode val) {
        this.reportMode = val;
        if (this.reportMode == null) {
            this.reportMode = ReportMode.None;
        }
    }

    public void prune() {
        this.reportMode.preamble(this.pruningInterval);
        long startTime = System.currentTimeMillis();
        Pruner dee = new Pruner(this.searchSpace, this.typeDep, this.boundsThresh, this.pruningInterval, this.useEPIC, this.useTupExp);
        dee.setVerbose(this.reportMode.isVerbose());
        if (Double.isFinite(this.stericThresh) && !this.onlyGoldstein) {
            dee.pruneSteric(this.stericThresh);
        }
        boolean done = false;
        int numPrunedRot = this.searchSpace.pruneMat.countPrunedRCs();
        int numPrunedPairs = 0;
        if (this.useFlags || this.algOption >= 3) {
            numPrunedPairs = this.searchSpace.pruneMat.countPrunedPairs();
        }
        int numRuns = 0;
        while (!done) {
            this.reportMode.preRun(numRuns);
            dee.prune("GOLDSTEIN");
            int newNumPrunedRot = this.searchSpace.pruneMat.countPrunedRCs();
            int newNumPrunedPairs = 0;
            if (this.useFlags || this.algOption >= 3) {
                newNumPrunedPairs = this.searchSpace.pruneMat.countPrunedPairs();
            }
            if (newNumPrunedRot == numPrunedRot && newNumPrunedPairs == numPrunedPairs && !this.preDACS) {
                if (this.algOption >= 3) {
                    dee.prune("GOLDSTEIN PAIRS FULL");
                    if (this.useTriples) {
                        dee.prune("GOLDSTEIN TRIPLES");
                    }
                }
                newNumPrunedRot = this.searchSpace.pruneMat.countPrunedRCs();
                newNumPrunedPairs = 0;
                if (this.useFlags || this.algOption >= 3) {
                    newNumPrunedPairs = this.searchSpace.pruneMat.countPrunedPairs();
                }
            }
            int numPrunedRotThisRun = newNumPrunedRot - numPrunedRot;
            int numPrunedPairsThisRun = newNumPrunedPairs - numPrunedPairs;
            this.reportMode.postRun(numRuns, numPrunedRotThisRun, numPrunedPairsThisRun);
            if (numPrunedRotThisRun == 0 && numPrunedPairsThisRun == 0) {
                done = true;
            }
            numPrunedRot = newNumPrunedRot;
            numPrunedPairs = newNumPrunedPairs;
            ++numRuns;
        }
        long pruneTime = System.currentTimeMillis() - startTime;
        this.reportMode.conclusion(numRuns, numPrunedRot, numPrunedPairs, pruneTime);
    }

    public void setOnlyGoldstein(boolean onlyGoldstein) {
        this.onlyGoldstein = onlyGoldstein;
    }

    public static enum ReportMode {
        Long(true){

            @Override
            public void preamble(double pruningInterval) {
                System.out.println();
                System.out.println("BEGINNING PRUNING.  PRUNING INTERVAL: " + pruningInterval);
                System.out.println();
            }

            @Override
            public void preRun(int run2) {
                System.out.println("Starting DEE cycle run: " + run2);
            }

            @Override
            public void postRun(int run2, int numSinglesPruned, int numPairsPruned) {
                System.out.println("Num pruned rot this run: " + numSinglesPruned);
                System.out.println("Num pruned pairs this run: " + numPairsPruned);
                System.out.println();
            }

            @Override
            public void conclusion(int numRuns, int numSinglesPruned, int numPairsPruned, long pruneTimeMs) {
                System.out.println("Pruning time: " + pruneTimeMs + " ms");
                System.out.println();
            }
        }
        ,
        Short(false){

            @Override
            public void conclusion(int numRuns, int numSinglesPruned, int numPairsPruned, long pruneTimeMs) {
                System.out.println(String.format("DEE took %s to prune %d singles and %d pairs in %d runs", TimeFormatter.format(pruneTimeMs * 1000000L, 1), numSinglesPruned, numPairsPruned, numRuns));
            }
        }
        ,
        None(false){};

        private boolean isVerbose;

        private ReportMode(boolean isVerbose) {
            this.isVerbose = isVerbose;
        }

        public boolean isVerbose() {
            return this.isVerbose;
        }

        public void preamble(double pruningInterval) {
        }

        public void preRun(int run2) {
        }

        public void postRun(int run2, int numSinglesPruned, int numPairsPruned) {
        }

        public void conclusion(int numRuns, int numSinglesPruned, int numPairsPruned, long pruneTimeMs) {
        }
    }
}

