/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.restypes;

import edu.duke.cs.osprey.confspace.Strand;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.restypes.DAminoAcidHandler;
import edu.duke.cs.osprey.restypes.ResidueEntropies;
import edu.duke.cs.osprey.restypes.ResidueEntropyParser;
import edu.duke.cs.osprey.restypes.ResidueTemplate;
import edu.duke.cs.osprey.restypes.RotamerLibraryReader;
import edu.duke.cs.osprey.restypes.TemplateCoordsParser;
import edu.duke.cs.osprey.restypes.TemplateParser;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.FileTools;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class ResidueTemplateLibrary
implements Serializable {
    public final ForcefieldParams ffparams;
    public final ArrayList<ResidueTemplate> templates = new ArrayList();
    public final Map<String, ResidueTemplate> wildTypeTemplates = new HashMap<String, ResidueTemplate>();
    public final ResidueEntropies residueEntropies = new ResidueEntropies();
    public int totalNumRotamers;

    /*
     * WARNING - void declaration
     */
    private ResidueTemplateLibrary(ForcefieldParams ffparams, List<String> templatesTexts, List<String> templateCoordTexts, List<String> rotamersTexts, List<String> backboneDependentRotamerTexts, List<String> resEntropyTexts, boolean makeDAminoAcids, List<Molecule> molsForRotamers) {
        void var11_14;
        this.ffparams = ffparams;
        TemplateParser templateParser = new TemplateParser(ffparams);
        for (String string : templatesTexts) {
            this.templates.addAll(templateParser.parse(string));
        }
        TemplateCoordsParser templateCoordsParser = new TemplateCoordsParser(this.templates);
        for (String string : templateCoordTexts) {
            templateCoordsParser.parse(string);
        }
        boolean bl = false;
        for (String text : rotamersTexts) {
            var11_14 += RotamerLibraryReader.readRotLibrary(text, this.templates);
        }
        this.totalNumRotamers = var11_14;
        for (String text : backboneDependentRotamerTexts) {
            RotamerLibraryReader.readDunbrackRotamerLibraryForResiduePosition(text, this.templates);
        }
        if (makeDAminoAcids) {
            this.templates.addAll(DAminoAcidHandler.makeDTemplates(this.templates));
        }
        ResidueEntropyParser residueEntropyParser = new ResidueEntropyParser(this.residueEntropies);
        for (String text : resEntropyTexts) {
            residueEntropyParser.parse(text);
        }
        for (Molecule mol : molsForRotamers) {
            Strand strand = new Strand.Builder(mol).setTemplateLibrary(this).build();
            for (Residue res : strand.mol.residues) {
                this.getOrMakeWildTypeTemplate(res);
            }
        }
    }

    public ResidueTemplate getTemplate(String resType) {
        return this.getTemplate(resType, false);
    }

    public ResidueTemplate getTemplate(String resType, boolean requireCoords) {
        for (ResidueTemplate templ : this.templates) {
            if (!templ.name.equalsIgnoreCase(resType) || requireCoords && templ.templateRes.coords == null) continue;
            return templ;
        }
        return null;
    }

    public ResidueTemplate getTemplateOrThrow(String resType) {
        return this.getTemplateOrThrow(resType, false);
    }

    public ResidueTemplate getTemplateOrThrow(String resType, boolean requireCoords) {
        ResidueTemplate templ = this.getTemplate(resType, requireCoords);
        if (templ != null) {
            return templ;
        }
        throw new NoSuchElementException("no residue template with name: " + resType);
    }

    public ResidueTemplate getTemplateForMutation(String resType, Residue res) {
        try {
            return this.getTemplateOrThrow(resType, true);
        }
        catch (NoSuchElementException ex) {
            throw new NoSuchElementException("ERROR: Couldn't find a template for mutating " + res.fullName + " to " + resType);
        }
    }

    public double getResEntropy(String resType) {
        return this.residueEntropies.get(resType);
    }

    public int numDihedralsForResType(String resType) {
        return this.getTemplateOrThrow((String)resType).numDihedrals;
    }

    public int numRotForResType(int pos, String resType, double phi, double psi) {
        return this.getTemplateOrThrow(resType).getNumRotamers(phi, psi);
    }

    public double getDihedralForRotamer(int pos, String resType, double phi, double psi, int rotNum, int dihedralNum) {
        return this.getTemplateOrThrow(resType).getRotamericDihedrals(phi, psi, rotNum, dihedralNum);
    }

    public double getDihedralForRotamer(int pos, String resType, int rotNum, int dihedralNum) {
        return this.getTemplateOrThrow(resType).getRotamericDihedrals(0.0, 0.0, rotNum, dihedralNum);
    }

    public double getDihedralForRotamer(String resType, int rotNum, int dihedralNum) {
        return this.getTemplateOrThrow(resType).getRotamericDihedrals(0.0, 0.0, rotNum, dihedralNum);
    }

    public ResidueTemplate getOrMakeWildTypeTemplate(Residue res) {
        String resNum = res.getPDBResNumber();
        ResidueTemplate template = this.wildTypeTemplates.get(resNum);
        if (template != null) {
            return template;
        }
        ArrayList<Residue> residues = new ArrayList<Residue>();
        residues.add(res);
        residues.addAll(res.molec.getAlternates(res.indexInMolecule));
        template = ResidueTemplate.makeFromResidueConfs(residues);
        this.wildTypeTemplates.put(resNum, template);
        return template;
    }

    public boolean containsName(String name) {
        for (ResidueTemplate templ : this.templates) {
            if (!templ.name.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public HashSet<String> templateNameSet() {
        HashSet<String> ans = new HashSet<String>();
        for (ResidueTemplate templ : this.templates) {
            ans.add(templ.name);
        }
        return ans;
    }

    public static class Builder {
        private static final String LovellRotamersPath = "/config/LovellRotamer.dat";
        private ForcefieldParams ffparams;
        private final List<String> templatesTexts = Builder.listOf(new String[0]);
        private final List<String> templateCoordsTexts = Builder.listOf(new String[0]);
        private final List<String> rotamersTexts = Builder.listOf(new String[0]);
        private final List<String> backboneDependentRotamersTexts = Builder.listOf(new String[0]);
        private final List<String> entropyTexts = Builder.listOf(new String[0]);
        private boolean makeDAminoAcidTemplates = true;
        private List<Molecule> molsForRotamers = Builder.listOf(new Molecule[0]);

        @SafeVarargs
        private static <T> List<T> listOf(T ... vals) {
            ArrayList<T> list = new ArrayList<T>();
            list.addAll(Arrays.asList(vals));
            return list;
        }

        public Builder() {
            this(new ForcefieldParams());
        }

        public Builder(ForcefieldParams.Forcefield forcefield) {
            this(new ForcefieldParams(forcefield));
        }

        public Builder(ForcefieldParams ffparams) {
            this.ffparams = ffparams;
            this.templatesTexts.add(FileTools.readResource(ffparams.forcefld.aaPath));
            this.templatesTexts.add(FileTools.readResource(ffparams.forcefld.aaNTPath));
            this.templatesTexts.add(FileTools.readResource(ffparams.forcefld.aaCTPath));
            this.templatesTexts.add(FileTools.readResource(ffparams.forcefld.grPath));
            this.templateCoordsTexts.add(FileTools.readResource("/config/all_amino_coords.in"));
            this.rotamersTexts.add(FileTools.readResource(LovellRotamersPath));
            this.entropyTexts.add(FileTools.readResource("/config/ResEntropy.dat"));
        }

        public Builder clearTemplates() {
            this.templatesTexts.clear();
            return this;
        }

        public Builder addTemplates(String text) {
            this.templatesTexts.add(text);
            return this;
        }

        public Builder clearTemplateCoords() {
            this.templateCoordsTexts.clear();
            return this;
        }

        public Builder addTemplateCoords(String text) {
            this.templateCoordsTexts.add(text);
            return this;
        }

        public Builder clearRotamers() {
            this.rotamersTexts.clear();
            return this;
        }

        public Builder addRotamers(String text) {
            this.rotamersTexts.add(text);
            return this;
        }

        public Builder addLovellRotamers() {
            return this.addRotamers(FileTools.readResource(LovellRotamersPath));
        }

        public Builder addBackboneDependentRotamers(String text) {
            this.backboneDependentRotamersTexts.add(text);
            return this;
        }

        public Builder clearResidueEntropies() {
            this.entropyTexts.clear();
            return this;
        }

        public Builder addResidueEntropies(String text) {
            this.entropyTexts.add(text);
            return this;
        }

        public Builder setMakeDAminoAcidTemplates(boolean val) {
            this.makeDAminoAcidTemplates = val;
            return this;
        }

        @Deprecated
        public Builder addMoleculeForWildTypeRotamers(Molecule val) {
            System.err.println("Warning: addMoleculeForWildTypeRotamers() is no longer needed. Conf spaces will add wild-type rotamers the library automatically");
            return this;
        }

        public ResidueTemplateLibrary build() {
            return new ResidueTemplateLibrary(this.ffparams, this.templatesTexts, this.templateCoordsTexts, this.rotamersTexts, this.backboneDependentRotamersTexts, this.entropyTexts, this.makeDAminoAcidTemplates, this.molsForRotamers);
        }
    }
}

