/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.restypes;

import edu.duke.cs.osprey.control.EnvironmentVars;
import edu.duke.cs.osprey.restypes.ResidueTemplate;
import edu.duke.cs.osprey.tools.FileTools;
import edu.duke.cs.osprey.tools.Streams;
import edu.duke.cs.osprey.tools.StringParsing;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class RotamerLibraryReader
implements Serializable {
    public static final boolean debug = false;

    public static int readRotLibrary(String text, List<ResidueTemplate> templates) {
        int numRotamersRead = 0;
        Iterator<String> lines = FileTools.parseLines(text).iterator();
        int numLines = 0;
        while (lines.hasNext()) {
            int q;
            String line = lines.next();
            if (line.startsWith("!") || line.isEmpty() || numLines++ == 0) continue;
            String aaName = StringParsing.getToken(line, 1);
            int numDihedrals = Integer.parseInt(StringParsing.getToken(line, 2));
            int numRotamers = Integer.parseInt(StringParsing.getToken(line, 3));
            if (numRotamers < 0) {
                numRotamers = 0;
            }
            String[][] dihedralAtomNames = new String[numDihedrals][4];
            double[][] rotamerValues = new double[numRotamers][numDihedrals];
            for (q = 0; q < numDihedrals; ++q) {
                line = lines.next();
                dihedralAtomNames[q][0] = StringParsing.getToken(line, 1);
                dihedralAtomNames[q][1] = StringParsing.getToken(line, 2);
                dihedralAtomNames[q][2] = StringParsing.getToken(line, 3);
                dihedralAtomNames[q][3] = StringParsing.getToken(line, 4);
            }
            for (q = 0; q < numRotamers; ++q) {
                line = lines.next();
                for (int w = 0; w < numDihedrals; ++w) {
                    rotamerValues[q][w] = Double.parseDouble(StringParsing.getToken(line, w + 1));
                }
            }
            boolean foundTemplate = false;
            for (ResidueTemplate template : templates) {
                if (!template.name.equalsIgnoreCase(aaName)) continue;
                template.numDihedrals = numDihedrals;
                template.setNumberOfPhiPsiBins(1);
                template.setRLphiPsiResolution(360.0);
                template.initializeRotamerArrays();
                template.setNumRotamers(numRotamers, 0, 0);
                template.setRotamericDihedrals(rotamerValues, 0, 0);
                template.dihedral4Atoms = new int[dihedralAtomNames.length][4];
                for (int dihedNum = 0; dihedNum < numDihedrals; ++dihedNum) {
                    for (int a = 0; a < 4; ++a) {
                        String atomName = dihedralAtomNames[dihedNum][a];
                        int atomIndex = template.templateRes.getAtomIndexByName(atomName);
                        if (atomIndex < 0) {
                            throw new NoSuchElementException(String.format("can't match dihedral %s to template %s: didn't find atom named %s among [%s]", Arrays.toString(dihedralAtomNames[dihedNum]), template.name, atomName, Streams.joinToString(template.templateRes.atoms, ",", atom -> atom.name)));
                        }
                        template.dihedral4Atoms[dihedNum][a] = atomIndex;
                    }
                }
                template.computeDihedralMovingAtoms();
                foundTemplate = true;
            }
            if (!foundTemplate) {
                throw new RuntimeException("ERROR: Have rotamer information for residue type " + aaName + " but can't find a template for it");
            }
            numRotamersRead = Math.max(1, numRotamers);
        }
        return numRotamersRead;
    }

    public static void readDunbrackRotamerLibraryForResiduePosition(String text, List<ResidueTemplate> templates) {
        double dunbrackResolution = 10.0;
        int binsDunbrack = 37;
        HashMap<String, BBDepRotamersForType> allDunbrackRotamersMap = new HashMap<String, BBDepRotamersForType>();
        for (ResidueTemplate template : templates) {
            BBDepRotamersForType bbDepRotamerForTypeOfTemplate = new BBDepRotamersForType(template.name, binsDunbrack, dunbrackResolution);
            allDunbrackRotamersMap.put(template.name, bbDepRotamerForTypeOfTemplate);
        }
        for (String line : FileTools.parseLines(text)) {
            BBDepRotamersForType bbRotForType;
            if (line.startsWith("#")) continue;
            char[] dbLine = line.toCharArray();
            String aaNameNewRot = "" + dbLine[0] + dbLine[1] + dbLine[2];
            int r1 = Integer.parseInt(("" + dbLine[24] + dbLine[25]).trim());
            int r2 = Integer.parseInt(("" + dbLine[27] + dbLine[28]).trim());
            int r3 = Integer.parseInt(("" + dbLine[30] + dbLine[31]).trim());
            int r4 = Integer.parseInt(("" + dbLine[33] + dbLine[34]).trim());
            int numDih = 1;
            if (r2 > 0) {
                ++numDih;
            }
            if (r3 > 0) {
                ++numDih;
            }
            if (r4 > 0) {
                ++numDih;
            }
            String phiForThisEntryAsStr = "" + dbLine[5] + dbLine[6] + dbLine[7] + dbLine[8];
            double phiForThisEntry = Double.valueOf(phiForThisEntryAsStr.trim());
            String psiForThisEntryAsStr = "" + dbLine[10] + dbLine[11] + dbLine[12] + dbLine[13];
            double psiForThisEntry = Double.valueOf(psiForThisEntryAsStr.trim());
            String probabilityStr = "" + dbLine[37] + dbLine[38] + dbLine[39] + dbLine[40] + dbLine[41] + dbLine[42] + dbLine[43] + dbLine[44];
            double myProbability = Double.parseDouble(probabilityStr.trim());
            int[] dihedralIndices = new int[]{47, 55, 63, 71};
            double[] chiAngles = new double[numDih];
            for (int chiIx = 0; chiIx < numDih; ++chiIx) {
                String dihedralStr = "" + dbLine[dihedralIndices[chiIx]] + dbLine[dihedralIndices[chiIx] + 1] + dbLine[dihedralIndices[chiIx] + 2] + dbLine[dihedralIndices[chiIx] + 3] + dbLine[dihedralIndices[chiIx] + 4] + dbLine[dihedralIndices[chiIx] + 5];
                chiAngles[chiIx] = Double.parseDouble(dihedralStr.trim());
            }
            if (!(myProbability >= EnvironmentVars.DUNBRACK_PROBABILTY_CUTOFF) || (bbRotForType = (BBDepRotamersForType)allDunbrackRotamersMap.get(aaNameNewRot)) == null) continue;
            bbRotForType.addNewRotamer(phiForThisEntry, psiForThisEntry, chiAngles);
        }
        for (ResidueTemplate myTemplate : templates) {
            myTemplate.setRLphiPsiResolution(dunbrackResolution);
            myTemplate.setNumberOfPhiPsiBins(binsDunbrack);
            myTemplate.initializeRotamerArrays();
            for (int phiBin = 0; phiBin < binsDunbrack; ++phiBin) {
                for (int psiBin = 0; psiBin < binsDunbrack; ++psiBin) {
                    double[][] rotamers = ((BBDepRotamersForType)allDunbrackRotamersMap.get((Object)myTemplate.name)).rotamersForType[phiBin][psiBin].convertRotamersToArray();
                    myTemplate.setRotamericDihedrals(rotamers, phiBin, psiBin);
                    myTemplate.setNumRotamers(rotamers.length, phiBin, psiBin);
                    if (rotamers.length <= 0) continue;
                    myTemplate.setNumDihedrals(rotamers[0].length);
                }
            }
        }
    }

    private static class BBDepRotamersForType {
        public String aaType;
        public double resolution;
        public int numBins;
        public BBDepRotamersForTypePhiAndPsi[][] rotamersForType;

        public BBDepRotamersForType(String aaType, int numBins, double resolution) {
            this.aaType = aaType;
            this.numBins = numBins;
            this.resolution = resolution;
            this.rotamersForType = new BBDepRotamersForTypePhiAndPsi[numBins][];
            for (int phiBin = 0; phiBin < numBins; ++phiBin) {
                this.rotamersForType[phiBin] = new BBDepRotamersForTypePhiAndPsi[numBins];
                double phi = (double)(phiBin - numBins / 2) * resolution;
                for (int psiBin = 0; psiBin < numBins; ++psiBin) {
                    double psi = (double)(psiBin - numBins / 2) * resolution;
                    this.rotamersForType[phiBin][psiBin] = new BBDepRotamersForTypePhiAndPsi(phi, psi);
                }
            }
        }

        public void addNewRotamer(double phi, double psi, double[] dihedralValues) {
            int phiBin = (int)Math.round(phi / this.resolution) + this.numBins / 2;
            int psiBin = (int)Math.round(psi / this.resolution) + this.numBins / 2;
            this.rotamersForType[phiBin][psiBin].addRotamerForTypePhiAndPsi(dihedralValues);
        }
    }

    private static class BBDepRotamersForTypePhiAndPsi {
        ArrayList<double[]> rotamersForPhiAndPsi = new ArrayList();
        public double phi;
        public double psi;

        public BBDepRotamersForTypePhiAndPsi(double phi, double psi) {
            this.phi = phi;
            this.psi = psi;
        }

        public void addRotamerForTypePhiAndPsi(double[] dihedralValues) {
            this.rotamersForPhiAndPsi.add(dihedralValues);
        }

        public double[][] convertRotamersToArray() {
            double[][] arrayOfRotamers = new double[this.rotamersForPhiAndPsi.size()][];
            for (int rot = 0; rot < this.rotamersForPhiAndPsi.size(); ++rot) {
                arrayOfRotamers[rot] = this.rotamersForPhiAndPsi.get(rot);
            }
            return arrayOfRotamers;
        }
    }
}

