/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.restypes;

import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.restypes.HardCodedResidueInfo;
import edu.duke.cs.osprey.restypes.InterResBondingTemplate;
import edu.duke.cs.osprey.restypes.ResidueTemplate;
import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.FileTools;
import edu.duke.cs.osprey.tools.StringParsing;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class TemplateParser {
    public final ForcefieldParams ffparams;

    public TemplateParser(ForcefieldParams ffparams) {
        this.ffparams = ffparams;
    }

    public List<ResidueTemplate> parse(String text) {
        ResidueTemplate newTemplate;
        ArrayList<ResidueTemplate> templates = new ArrayList<ResidueTemplate>();
        Iterator<String> lines = FileTools.parseLines(text).iterator();
        lines.next();
        lines.next();
        while ((newTemplate = this.readTemplate(lines)) != null) {
            templates.add(newTemplate);
        }
        return templates;
    }

    private ResidueTemplate readTemplate(Iterator<String> lines) {
        String curLine = lines.next();
        if (curLine == null) {
            return null;
        }
        if (curLine.length() >= 4 && curLine.substring(0, 4).equalsIgnoreCase("stop")) {
            curLine = lines.next();
            return null;
        }
        InterResBondingTemplate interResBonding = null;
        if (curLine.startsWith("INTER-RES BONDING:")) {
            interResBonding = TemplateParser.parseInterResBonding(curLine);
        }
        curLine = lines.next();
        String CAEquivalent = null;
        if (curLine.startsWith("CAEQUIVALENT: ")) {
            CAEquivalent = StringParsing.getToken(curLine, 2);
        }
        curLine = lines.next();
        String templateName = StringParsing.getToken(curLine, 1);
        curLine = lines.next();
        curLine = lines.next();
        curLine = lines.next();
        int dumPresent = 0;
        while (StringParsing.getToken(curLine, 2).equalsIgnoreCase("DUMM")) {
            ++dumPresent;
            curLine = lines.next();
        }
        ++dumPresent;
        ArrayList<Atom> atomList = new ArrayList<Atom>();
        while (!StringParsing.getToken(curLine, 2).equals("")) {
            String atomName = StringParsing.getToken(curLine, 2);
            Atom at = new Atom(atomName);
            at.forceFieldType = StringParsing.getToken(curLine, 3);
            at.type = this.ffparams.atomTypeToInt(at.forceFieldType);
            at.charge = Double.parseDouble(StringParsing.getToken(curLine, 11));
            int atomBondedTo = Integer.parseInt(StringParsing.getToken(curLine, 5)) - dumPresent;
            if (atomBondedTo >= 0) {
                at.addBond(atomList.get(atomBondedTo));
            }
            atomList.add(at);
            curLine = lines.next();
        }
        Residue templateRes = new Residue(atomList, (double[])null, templateName, null);
        while ((curLine = lines.next()).trim().isEmpty()) {
        }
        if (curLine.length() >= 4 && StringParsing.getToken(curLine, 1).equalsIgnoreCase("LOOP")) {
            curLine = lines.next();
            while (!StringParsing.getToken(curLine, 2).equals("")) {
                for (Atom a : atomList) {
                    if (!a.name.equalsIgnoreCase(StringParsing.getToken(curLine, 1))) continue;
                    for (Atom b : atomList) {
                        if (!b.name.equalsIgnoreCase(StringParsing.getToken(curLine, 2))) continue;
                        a.addBond(b);
                    }
                }
                curLine = lines.next();
            }
        }
        templateRes.intraResBondsMarked = true;
        boolean atDone = false;
        atDone = curLine.length() >= 4 ? curLine.substring(0, 4).equalsIgnoreCase("done") : false;
        while (!atDone) {
            curLine = lines.next();
            if (curLine.length() < 4) continue;
            atDone = curLine.substring(0, 4).equalsIgnoreCase("done");
        }
        if (interResBonding == null) {
            interResBonding = HardCodedResidueInfo.inferInterResBonding(templateRes);
        } else {
            TemplateParser.checkInterResBonding(templateRes, interResBonding);
        }
        if (CAEquivalent == null && HardCodedResidueInfo.hasAminoAcidBB(templateRes)) {
            CAEquivalent = "CA";
        }
        return new ResidueTemplate(templateRes, templateName, interResBonding, CAEquivalent);
    }

    private static InterResBondingTemplate parseInterResBonding(String line) {
        StringTokenizer st = new StringTokenizer(line, " ");
        st.nextToken();
        st.nextToken();
        ArrayList<String> bondingAtoms = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equalsIgnoreCase("NONE")) {
                return new InterResBondingTemplate.NoBondingTemplate();
            }
            if (tok.equalsIgnoreCase("PEPTIDE")) {
                return new InterResBondingTemplate.PeptideBondingTemplate();
            }
            if (tok.equalsIgnoreCase("NUCLEOTIDE")) {
                return new InterResBondingTemplate.NucleotideBondingTemplate();
            }
            if (tok.equalsIgnoreCase("CYS")) {
                return new InterResBondingTemplate.CysteineBondingTemplate();
            }
            bondingAtoms.add(tok);
        }
        return new InterResBondingTemplate.SpecifiedBondingAtomsTemplate(bondingAtoms);
    }

    private static void checkInterResBonding(Residue res, InterResBondingTemplate interResBonding) {
        if (interResBonding instanceof InterResBondingTemplate.PeptideBondingTemplate && !HardCodedResidueInfo.hasAminoAcidBB(res)) {
            throw new RuntimeException("ERROR: Residue template " + res.fullName + " has no amino-acid backbone  but trying to assign a PeptideBondingTemplate to it");
        }
        if (interResBonding instanceof InterResBondingTemplate.SpecifiedBondingAtomsTemplate) {
            for (String atName : ((InterResBondingTemplate.SpecifiedBondingAtomsTemplate)interResBonding).getBondingAtomNames()) {
                if (res.getAtomByName(atName) != null) continue;
                throw new RuntimeException("ERROR: Residue template " + res.fullName + " has no atom named " + atName + " but its inter-residue bonding template thinks it does");
            }
        }
    }
}

