/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.sofea;

import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.kstar.pfunc.BoltzmannCalculator;
import edu.duke.cs.osprey.lute.LUTEConfEnergyCalculator;
import java.math.BigDecimal;
import java.math.MathContext;

public class BoltzmannLute {
    public final LUTEConfEnergyCalculator luteEcalc;
    public final BigDecimal factor;
    private final BigDecimal[] values;

    public BoltzmannLute(LUTEConfEnergyCalculator luteEcalc, MathContext mathContext) {
        this.luteEcalc = luteEcalc;
        this.values = new BigDecimal[luteEcalc.tuples.size()];
        BoltzmannCalculator bcalc = new BoltzmannCalculator(mathContext);
        this.factor = bcalc.calcPrecise(luteEcalc.state.tupleEnergyOffset);
        for (int t = 0; t < luteEcalc.tuples.size(); ++t) {
            this.values[t] = bcalc.calcPrecise(luteEcalc.state.tupleEnergies[t]);
        }
    }

    public boolean has(int pos, int rc) {
        return this.luteEcalc.hasTuple(pos, rc);
    }

    public boolean has(int pos1, int rc1, int pos2, int rc2) {
        return this.luteEcalc.hasTuple(pos1, rc1, pos2, rc2);
    }

    public BigDecimal get(int pos, int rc) {
        return this.get(this.luteEcalc.tuples.getIndex(pos, rc));
    }

    public BigDecimal get(int pos1, int rc1, int pos2, int rc2) {
        return this.get(this.luteEcalc.tuples.getIndex(pos1, rc1, pos2, rc2));
    }

    public BigDecimal get(int pos1, int rc1, int pos2, int rc2, int pos3, int rc3) {
        return this.get(this.luteEcalc.tuples.getIndex(pos1, rc1, pos2, rc2, pos3, rc3));
    }

    public BigDecimal get(RCTuple tuple) {
        return this.get(this.luteEcalc.tuples.getIndex(tuple));
    }

    private BigDecimal get(Integer t) {
        if (t == null) {
            return null;
        }
        return this.values[t];
    }
}

