/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.sofea;

import edu.duke.cs.osprey.astar.conf.ConfIndex;
import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.confspace.Conf;
import edu.duke.cs.osprey.confspace.ConfDB;
import edu.duke.cs.osprey.confspace.MultiStateConfSpace;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SeqSpace;
import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.kstar.pfunc.BoltzmannCalculator;
import edu.duke.cs.osprey.parallelism.TaskExecutor;
import edu.duke.cs.osprey.sofea.FringeDB;
import edu.duke.cs.osprey.sofea.RCDB;
import edu.duke.cs.osprey.sofea.SeqDB;
import edu.duke.cs.osprey.sofea.ZMatrix;
import edu.duke.cs.osprey.tools.BigExp;
import edu.duke.cs.osprey.tools.BigMath;
import edu.duke.cs.osprey.tools.JvmMem;
import edu.duke.cs.osprey.tools.MathTools;
import edu.duke.cs.osprey.tools.Stopwatch;
import edu.duke.cs.osprey.tools.Streams;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Sofea {
    public final MultiStateConfSpace confSpace;
    public final List<StateConfig> stateConfigs;
    public final File seqdbFile;
    public final MathContext seqdbMathContext;
    public final File fringedbLowerFile;
    public final long fringedbLowerBytes;
    public final File fringedbUpperFile;
    public final long fringedbUpperBytes;
    public final File rcdbFile;
    public final boolean showProgress;
    public final File performanceLogFile;
    public final double sweepIncrement;
    public final int maxCriterionCheckSeconds;
    public final long maxNumMinimizations;
    public final double negligableFreeEnergy;
    public final MathContext mathContext = BigExp.mathContext;
    public final BoltzmannCalculator bcalc;
    public final double gThresholdUpper;
    public final BigExp zPruneThreshold;
    private final List<StateInfo> stateInfos;
    private final double[] gThresholdsLower;

    private Sofea(MultiStateConfSpace confSpace, List<StateConfig> stateConfigs, File seqdbFile, MathContext seqdbMathContext, File fringedbLowerFile, long fringedbLowerBytes, File fringedbUpperFile, long fringedbUpperBytes, File rcdbFile, boolean showProgress, File performanceLogFile, double sweepIncrement, int maxCriterionCheckSeconds, long maxNumMinimizations, double negligableFreeEnergy) {
        this.confSpace = confSpace;
        this.stateConfigs = stateConfigs;
        this.seqdbFile = seqdbFile;
        this.seqdbMathContext = seqdbMathContext;
        this.fringedbLowerFile = fringedbLowerFile;
        this.fringedbLowerBytes = fringedbLowerBytes;
        this.fringedbUpperFile = fringedbUpperFile;
        this.fringedbUpperBytes = fringedbUpperBytes;
        this.rcdbFile = rcdbFile;
        this.showProgress = showProgress;
        this.performanceLogFile = performanceLogFile;
        this.sweepIncrement = sweepIncrement;
        this.maxCriterionCheckSeconds = maxCriterionCheckSeconds;
        this.maxNumMinimizations = maxNumMinimizations;
        this.negligableFreeEnergy = negligableFreeEnergy;
        this.bcalc = new BoltzmannCalculator(this.mathContext);
        this.gThresholdUpper = this.bcalc.freeEnergyPrecise(this.bigMath().set(this.bcalc.calcPrecise(negligableFreeEnergy)).div(maxNumMinimizations).get());
        this.zPruneThreshold = new BigExp(this.bcalc.calcPrecise(this.gThresholdUpper));
        this.stateInfos = confSpace.states.stream().map(state -> new StateInfo((MultiStateConfSpace.State)state)).collect(Collectors.toList());
        this.gThresholdsLower = confSpace.states.stream().mapToDouble(state -> {
            StateInfo stateInfo = this.getStateInfo((MultiStateConfSpace.State)state);
            BigExp zSumUpper = stateInfo.calcZSumUpper(stateInfo.makeConfIndex(), stateInfo.rcs);
            return this.bcalc.freeEnergyPrecise(zSumUpper.toBigDecimal(BigExp.mathContext));
        }).toArray();
    }

    public StateConfig getConfig(MultiStateConfSpace.State state) {
        return this.stateConfigs.get(state.index);
    }

    protected StateInfo getStateInfo(MultiStateConfSpace.State state) {
        return this.stateInfos.get(state.index);
    }

    protected BigMath bigMath() {
        return new BigMath(this.mathContext);
    }

    public SeqDB openSeqDB() {
        return new SeqDB(this.confSpace, this.seqdbMathContext, this.seqdbFile);
    }

    public FringeDB openFringeDBLower() {
        if (this.fringedbLowerFile.exists()) {
            return FringeDB.open(this.confSpace, this.fringedbLowerFile);
        }
        this.log("Allocating %d bytes for %s", this.fringedbLowerBytes, this.fringedbLowerFile);
        return FringeDB.create(this.confSpace, this.fringedbLowerFile, this.fringedbLowerBytes);
    }

    public FringeDB openFringeDBUpper() {
        if (this.fringedbUpperFile.exists()) {
            return FringeDB.open(this.confSpace, this.fringedbUpperFile);
        }
        this.log("Allocating %d bytes for %s", this.fringedbUpperBytes, this.fringedbUpperFile);
        return FringeDB.create(this.confSpace, this.fringedbUpperFile, this.fringedbUpperBytes);
    }

    public RCDB openRCDB() {
        if (this.rcdbFile != null) {
            return new RCDB(this.confSpace, this.seqdbMathContext, this.rcdbFile);
        }
        return null;
    }

    public void logf(String format, Object ... args) {
        String msg = String.format(format, args);
        System.out.print(msg);
        this.performanceLog(msg);
    }

    public void log(String format, Object ... args) {
        String msg = String.format(format, args);
        System.out.println(msg);
        this.performanceLog(msg);
    }

    private void performanceLog(String pattern, Object ... args) {
        if (this.performanceLogFile == null) {
            return;
        }
        this.performanceLog(String.format(pattern, args));
    }

    private void performanceLog(String msg) {
        if (this.performanceLogFile == null) {
            return;
        }
        try (FileWriter out = new FileWriter(this.performanceLogFile, true);){
            out.write(msg);
            out.write("\n");
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public void init() {
        this.init(false);
    }

    public void init(boolean overwrite) {
        if (!overwrite) {
            ArrayList<File> filesToCheck = new ArrayList<File>();
            filesToCheck.add(this.seqdbFile);
            filesToCheck.add(this.fringedbLowerFile);
            filesToCheck.add(this.fringedbUpperFile);
            if (this.rcdbFile != null) {
                filesToCheck.add(this.rcdbFile);
            }
            if (filesToCheck.stream().anyMatch(file -> file.exists())) {
                throw new Error("Database files already exist, will not destroy existing results at:\n\t" + Streams.joinToString(filesToCheck, "\n\t", file -> file.getAbsolutePath()));
            }
        }
        this.seqdbFile.delete();
        this.fringedbLowerFile.delete();
        this.fringedbUpperFile.delete();
        if (this.rcdbFile != null) {
            this.rcdbFile.delete();
        }
        try (SeqDB seqdb = this.openSeqDB();
             FringeDB fringedbLower = this.openFringeDBLower();
             FringeDB fringedbUpper = this.openFringeDBUpper();){
            FringeDB.Transaction fringetxLower = fringedbLower.transaction();
            FringeDB.Transaction fringetxUpper = fringedbUpper.transaction();
            SeqDB.Transaction seqtx = seqdb.transaction();
            for (MultiStateConfSpace.State state : this.confSpace.states) {
                StateInfo stateInfo = this.stateInfos.get(state.index);
                ConfIndex index = stateInfo.makeConfIndex();
                BigExp zSumUpper = stateInfo.calcZSumUpper(index, stateInfo.rcs);
                zSumUpper.normalize(true);
                fringetxLower.writeRootNode(state, zSumUpper);
                fringetxUpper.writeRootNode(state, zSumUpper);
                seqtx.addZSumUpper(state, state.confSpace.seqSpace().makeUnassignedSequence(), zSumUpper);
            }
            fringetxLower.commit();
            fringedbLower.finishStep();
            fringetxUpper.commit();
            fringedbUpper.finishStep();
            seqtx.commit();
        }
    }

    private Double[] initGThresholds(FringeDB fringedb) {
        return (Double[])this.confSpace.states.stream().map(state -> {
            BigExp zSumMax = fringedb.getZSumMax((MultiStateConfSpace.State)state);
            if (zSumMax.isNaN()) {
                return null;
            }
            return this.bcalc.freeEnergyPrecise(zSumMax);
        }).toArray(Double[]::new);
    }

    private double calcSeqdbScore(SeqDB seqdb) {
        BigMath m = seqdb.bigMath().set(0L);
        for (Map.Entry<Sequence, SeqDB.SeqInfo> entry : seqdb.getSequencedSums()) {
            for (MultiStateConfSpace.State state : this.confSpace.sequencedStates) {
                MathTools.BigDecimalBounds z = entry.getValue().get(state);
                assert (MathTools.isFinite(z.upper));
                m.add(z.upper);
                m.sub(z.lower);
            }
        }
        for (MultiStateConfSpace.State state : this.confSpace.unsequencedStates) {
            MathTools.BigDecimalBounds z = seqdb.getUnsequencedSum(state);
            assert (MathTools.isFinite(z.upper));
            m.add(z.upper);
            m.sub(z.lower);
        }
        assert (MathTools.isGreaterThanOrEqual(m.get(), BigDecimal.ZERO));
        return this.bcalc.ln1p(m.get());
    }

    private boolean needsMinimization(SeqDB seqdb) {
        for (Map.Entry<Sequence, SeqDB.SeqInfo> entry : seqdb.getSequencedSums()) {
            for (MultiStateConfSpace.State state : this.confSpace.sequencedStates) {
                if (!MathTools.isPositive(entry.getValue().get((MultiStateConfSpace.State)state).lower)) continue;
                return false;
            }
        }
        for (MultiStateConfSpace.State state : this.confSpace.unsequencedStates) {
            if (!MathTools.isPositive(seqdb.getUnsequencedSum((MultiStateConfSpace.State)state).lower)) continue;
            return false;
        }
        return true;
    }

    public void refine(Criterion criterion) {
        this.refine(criterion, true);
    }

    public void refine(Criterion criterion, boolean resumeSweep) {
        block68: {
            try (SeqDB seqdb = this.openSeqDB();
                 FringeDB fringedbLower = this.openFringeDBLower();
                 FringeDB fringedbUpper = this.openFringeDBUpper();
                 RCDB rcdb = this.openRCDB();
                 ConfTables confTables = new ConfTables(this);){
                double pass2TargetSeconds;
                double pass1TargetSeconds;
                Stopwatch stopwatch = new Stopwatch().start();
                Double[] gPass1Thresholds = this.initGThresholds(fringedbLower);
                Double[] gPass2Thresholds = this.initGThresholds(fringedbUpper);
                if (!resumeSweep) {
                    for (MultiStateConfSpace.State state : this.confSpace.states) {
                        gPass1Thresholds[state.index] = this.gThresholdsLower[state.index];
                        gPass2Thresholds[state.index] = this.gThresholdsLower[state.index];
                    }
                }
                BiFunction<Long, Long, Boolean> checkCriterion = (pass1step, pass2step) -> {
                    if (criterion != null && criterion.isSatisfied(seqdb, fringedbLower, fringedbUpper, (long)pass1step, (long)pass2step, this.bcalc) == Criterion.Satisfied.Terminate) {
                        this.log("SOFEA finished in %s, criterion satisfied", stopwatch.getTime(2));
                        return true;
                    }
                    return false;
                };
                Runnable showFringes = () -> this.log("fringe sizes:  lower = %d/%d nodes (%.1f%% used)  upper = %d/%d nodes (%.1f%% used)  heap = %s  running for %s", fringedbLower.getNumNodes(), fringedbLower.getCapacity(), Float.valueOf(100.0f * (float)fringedbLower.getNumNodes() / (float)fringedbLower.getCapacity()), fringedbUpper.getNumNodes(), fringedbUpper.getCapacity(), Float.valueOf(100.0f * (float)fringedbUpper.getNumNodes() / (float)fringedbUpper.getCapacity()), JvmMem.getOldPool(), stopwatch.getTime(2));
                long pass1step2 = 0L;
                long pass2step2 = 0L;
                boolean needPass1Step = true;
                boolean needPass2Step = true;
                if (checkCriterion.apply(pass1step2, pass2step2).booleanValue()) {
                    return;
                }
                double seqdbScore = this.calcSeqdbScore(seqdb);
                boolean needsMinimization = this.needsMinimization(seqdb);
                if (this.performanceLogFile != null) {
                    this.performanceLog("initial SeqDB score: %s  needmin: %b", seqdbScore, needsMinimization);
                }
                double pass1Slope = Double.POSITIVE_INFINITY;
                double pass2Slope = Double.POSITIVE_INFINITY;
                double slopeGrowthRate = 2.0;
                do {
                    double delta;
                    double newSeqdbScore2;
                    if (fringedbLower.isEmpty() && fringedbUpper.isEmpty()) {
                        this.log("SOFEA finished in %s, explored every node", stopwatch.getTime(2));
                        break block68;
                    }
                    if (this.showProgress) {
                        showFringes.run();
                    }
                    pass1TargetSeconds = !fringedbLower.hasNodesToRead() ? 0.0 : (pass1step2 <= pass2step2 ? (double)this.maxCriterionCheckSeconds : (fringedbUpper.hasNodesToRead() && pass2Slope >= pass1Slope ? 0.0 : (double)this.maxCriterionCheckSeconds));
                    if (this.performanceLogFile != null) {
                        this.performanceLog("PASS 1  %.4f s   needmin=%b  s1=[%d,%b,%s]  s2=[%d,%b,%s]", pass1TargetSeconds, needsMinimization, pass1step2, fringedbLower.hasNodesToRead(), pass1Slope, pass2step2, fringedbUpper.hasNodesToRead(), pass2Slope);
                    }
                    if (pass1TargetSeconds > 0.0) {
                        if (needPass1Step) {
                            ++pass1step2;
                            needPass1Step = false;
                            for (MultiStateConfSpace.State state : this.confSpace.states) {
                                if (gPass1Thresholds[state.index] == null) continue;
                                if (gPass1Thresholds[state.index] > this.gThresholdUpper) {
                                    gPass1Thresholds[state.index] = null;
                                    continue;
                                }
                                Double[] doubleArray = gPass1Thresholds;
                                int n = state.index;
                                Double.valueOf(doubleArray[n] + this.sweepIncrement);
                            }
                            if (this.showProgress) {
                                this.log("pass 1 step %d", pass1step2);
                                for (MultiStateConfSpace.State state : this.confSpace.states) {
                                    this.log("\t%20s  gThreshold = %9.3f  in  [%9.3f,%9.3f]", state.name, gPass1Thresholds[state.index], this.gThresholdsLower[state.index], this.gThresholdUpper);
                                }
                            }
                        }
                        Stopwatch pass1Stopwatch = new Stopwatch().start();
                        long pass1Nodes = this.pass1(fringedbLower, seqdb, rcdb, pass1step2, criterion, gPass1Thresholds, pass1Stopwatch, pass1TargetSeconds);
                        double pass1ElapsedSeconds = pass1Stopwatch.stop().getTimeS();
                        if (!fringedbLower.hasNodesToRead()) {
                            fringedbLower.finishStep();
                            needPass1Step = true;
                        }
                        if (this.showProgress) {
                            showFringes.run();
                        }
                        if (checkCriterion.apply(pass1step2, pass2step2).booleanValue()) {
                            break block68;
                        }
                        newSeqdbScore2 = this.calcSeqdbScore(seqdb);
                        needsMinimization = this.needsMinimization(seqdb);
                        delta = seqdbScore - newSeqdbScore2;
                        if (delta < -1.0E-9) {
                            throw new Error("Negative improvement (" + delta + "). This is a bug.");
                        }
                        if (delta < 0.0) {
                            delta = 0.0;
                        }
                        if (pass1Nodes > 0L) {
                            pass1Slope = delta / pass1ElapsedSeconds;
                        }
                        if (this.performanceLogFile != null) {
                            this.performanceLog("pass1 score=%.3f -> %.3f  delta=%s  seconds=%.3f slope=%s", seqdbScore, newSeqdbScore2, delta, pass1ElapsedSeconds, pass1Slope);
                        }
                        seqdbScore = newSeqdbScore2;
                        if (pass2Slope == 0.0) {
                            pass2Slope = pass1Slope / 10000.0;
                        }
                        pass2Slope *= 2.0;
                    }
                    pass2TargetSeconds = !fringedbUpper.hasNodesToRead() ? 0.0 : (needsMinimization ? (double)this.maxCriterionCheckSeconds : (fringedbLower.hasNodesToRead() && pass2step2 >= pass1step2 ? 0.0 : (fringedbLower.hasNodesToRead() && pass1Slope > pass2Slope ? 0.0 : (double)this.maxCriterionCheckSeconds)));
                    if (this.performanceLogFile != null) {
                        this.performanceLog("PASS 2  %.4f s   needmin=%b  s1=[%d,%b,%s]  s2=[%d,%b,%s]", pass2TargetSeconds, needsMinimization, pass1step2, fringedbLower.hasNodesToRead(), pass1Slope, pass2step2, fringedbUpper.hasNodesToRead(), pass2Slope);
                    }
                    if (!(pass2TargetSeconds > 0.0)) continue;
                    if (needPass2Step) {
                        ++pass2step2;
                        needPass2Step = false;
                        for (MultiStateConfSpace.State state : this.confSpace.states) {
                            if (gPass2Thresholds[state.index] == null) continue;
                            if (gPass2Thresholds[state.index] > this.gThresholdUpper) {
                                gPass2Thresholds[state.index] = null;
                                continue;
                            }
                            Double[] doubleArray = gPass2Thresholds;
                            int newSeqdbScore2 = state.index;
                            Double.valueOf(doubleArray[newSeqdbScore2] + this.sweepIncrement);
                        }
                        if (this.showProgress) {
                            this.log("pass 2 step %d", pass2step2);
                            for (MultiStateConfSpace.State state : this.confSpace.states) {
                                this.log("\t%20s  gThreshold = %9.3f  in  [%9.3f,%9.3f]", state.name, gPass2Thresholds[state.index], this.gThresholdsLower[state.index], this.gThresholdUpper);
                            }
                        }
                    }
                    Stopwatch pass2Stopwatch = new Stopwatch().start();
                    this.pass2(fringedbUpper, seqdb, rcdb, pass2step2, criterion, gPass2Thresholds, confTables, pass2Stopwatch, pass2TargetSeconds);
                    double pass2ElapsedSeconds = pass2Stopwatch.stop().getTimeS();
                    if (!fringedbUpper.hasNodesToRead()) {
                        fringedbUpper.finishStep();
                        needPass2Step = true;
                    }
                    if (checkCriterion.apply(pass1step2, pass2step2).booleanValue()) {
                        break block68;
                    }
                    newSeqdbScore2 = this.calcSeqdbScore(seqdb);
                    needsMinimization = this.needsMinimization(seqdb);
                    delta = seqdbScore - newSeqdbScore2;
                    if (delta < -1.0E-9) {
                        throw new Error("Negative improvement (" + delta + "). This is a bug.");
                    }
                    if (delta < 0.0) {
                        delta = 0.0;
                    }
                    pass2Slope = delta / pass2ElapsedSeconds;
                    if (this.performanceLogFile != null) {
                        this.performanceLog("\n### P2  score=%.3f -> %.3f  delta=%s  seconds=%.3f slope=%s", seqdbScore, newSeqdbScore2, delta, pass2ElapsedSeconds, pass2Slope);
                    }
                    seqdbScore = newSeqdbScore2;
                    if (pass1Slope == 0.0) {
                        pass1Slope = pass2Slope / 10000.0;
                    }
                    pass1Slope *= 2.0;
                } while (!(pass1TargetSeconds <= 0.0) || !(pass2TargetSeconds <= 0.0));
                throw new Error("Neither pass chosen. This is a bug.");
            }
        }
    }

    private BigExp[] gtozThresholds(Double[] gs) {
        return (BigExp[])Arrays.stream(gs).map(g -> {
            if (g == null) {
                return null;
            }
            return new BigExp(this.bcalc.calcPrecise((double)g));
        }).toArray(BigExp[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long pass1(FringeDB fringedb, SeqDB seqdb, RCDB rcdb, long step, Criterion criterion, Double[] gThresholds, Stopwatch stopwatch, double targetSeconds) {
        if (this.showProgress) {
            this.logf("pass 1 running ...", new Object[0]);
        }
        BigExp[] zThresholds = this.gtozThresholds(gThresholds);
        TaskExecutor tasks = this.stateConfigs.get((int)0).confEcalc.tasks;
        class StateStats {
            long read = 0L;
            long expanded = 0L;
            long requeuedByThreshold = 0L;
            long requeuedByFilter = 0L;
            long requeuedForSpace = 0L;
            long added = 0L;

            StateStats(Sofea this$0) {
            }
        }
        StateStats[] stats = new StateStats[this.confSpace.states.size()];
        for (MultiStateConfSpace.State state2 : this.confSpace.states) {
            stats[state2.index] = new StateStats(this);
        }
        FringeDB.Transaction fringetx = fringedb.transaction();
        SeqDB.Transaction seqtx = seqdb.transaction();
        long numNodesToRead = fringetx.numNodesToRead();
        int[] nodesInFlight = new int[]{0};
        while (!(stopwatch.getTimeS() > targetSeconds)) {
            NodeTransaction nodetx;
            Sofea sofea = this;
            synchronized (sofea) {
                if (!fringetx.hasNodesToRead()) {
                    break;
                }
                fringetx.readNode();
                ++stats[fringetx.state().index].read;
                nodesInFlight[0] = nodesInFlight[0] + 1;
                nodetx = new NodeTransaction(fringetx.state(), fringetx.conf(), fringetx.zSumUpper());
            }
            if (criterion != null && criterion.filterNode(nodetx.state, nodetx.conf, this.bcalc) == Criterion.Filter.Requeue) {
                sofea = this;
                synchronized (sofea) {
                    ++stats[nodetx.state.index].requeuedByFilter;
                    nodesInFlight[0] = nodesInFlight[0] - 1;
                    nodetx.requeuePass1(fringetx, seqtx, rcdb);
                    continue;
                }
            }
            tasks.submit(() -> this.refineZSumUpper(nodetx, zThresholds[nodetx.state.index], nodetx.index, nodetx.zSumUpper), result -> {
                Sofea sofea = this;
                synchronized (sofea) {
                    nodesInFlight[0] = nodesInFlight[0] - 1;
                    if (result == NodeResult.Saved) {
                        ++stats[nodetx.state.index].requeuedByThreshold;
                        nodetx.requeuePass1(fringetx, seqtx, rcdb);
                    } else if (nodetx.hasRoomToReplace(fringetx, nodesInFlight[0])) {
                        ++stats[nodetx.state.index].expanded;
                        stats[nodetx.state.index].added += (long)nodetx.numReplacementNodes();
                        nodetx.replacePass1(fringetx, seqtx, rcdb);
                    } else {
                        ++stats[nodetx.state.index].requeuedForSpace;
                        nodetx.requeuePass1(fringetx, seqtx, rcdb);
                    }
                }
            });
        }
        tasks.waitForFinish();
        fringetx.commit();
        seqtx.commit();
        if (this.showProgress) {
            long nodesRead = this.confSpace.states.stream().mapToLong(state -> stats[state.index].read).sum();
            this.log(" %s   read=%6d/%6d (%5.1f%%)", stopwatch.getTime(2), nodesRead, numNodesToRead, Float.valueOf(100.0f * (float)nodesRead / (float)numNodesToRead));
        }
        if (this.performanceLogFile != null) {
            for (MultiStateConfSpace.State state3 : this.confSpace.states) {
                this.performanceLog("\t%20s  read=%6d [ expanded=%6d  requeuedByThreshold=%6d  requeuedByFilter=%6d  requeuedForSpace=%6d ] added=%6d", state3.name, stats[state3.index].read, stats[state3.index].expanded, stats[state3.index].requeuedByThreshold, stats[state3.index].requeuedByFilter, stats[state3.index].requeuedForSpace, stats[state3.index].added);
            }
        }
        return this.confSpace.states.stream().mapToLong(state -> stats[state.index].read - stats[state.index].requeuedByFilter - stats[state.index].requeuedByThreshold).sum();
    }

    private NodeResult refineZSumUpper(NodeTransaction nodetx, BigExp zSumThreshold, ConfIndex index, BigExp zSumUpper) {
        if (zSumUpper.lessThan(this.zPruneThreshold)) {
            return NodeResult.Removed;
        }
        StateInfo stateInfo = this.stateInfos.get(nodetx.state.index);
        Integer lastAssignedPos = null;
        if (this.rcdbFile != null && index.numDefined > 0) {
            lastAssignedPos = stateInfo.posPermutation[index.numDefined - 1];
        }
        if (index.isFullyDefined()) {
            nodetx.addZPath(index, zSumUpper);
            if (lastAssignedPos != null) {
                nodetx.addRCInfo(index, lastAssignedPos, zSumUpper.toBigDecimal());
            }
            return NodeResult.Removed;
        }
        if (zSumThreshold != null && zSumUpper.lessThan(zSumThreshold)) {
            nodetx.addReplacementNode(index, zSumUpper);
            if (lastAssignedPos != null) {
                nodetx.addRCInfo(index, lastAssignedPos, zSumUpper.toBigDecimal());
            }
            return NodeResult.Saved;
        }
        NodeResult result = NodeResult.ExpandedThenRemoved;
        BigMath m = null;
        if (lastAssignedPos != null) {
            m = new BigMath(this.seqdbMathContext).set(0L);
        }
        int pos = stateInfo.posPermutation[index.numDefined];
        for (int rc : stateInfo.rcs.get(pos)) {
            index.assignInPlace(pos, rc);
            BigExp rcZSumUpper = stateInfo.calcZSumUpper(index, stateInfo.rcs);
            NodeResult rcResult = this.refineZSumUpper(nodetx, zSumThreshold, index, rcZSumUpper);
            index.unassignInPlace(pos);
            if (!rcResult.removed) {
                result = NodeResult.ExpandedThenSaved;
            }
            if (m == null) continue;
            m.add(rcZSumUpper);
        }
        if (lastAssignedPos != null) {
            if (index.numDefined > 1) {
                int lastLastAssignedPos = stateInfo.posPermutation[index.numDefined - 2];
                nodetx.addRCInfo(index, lastAssignedPos, m.get(), lastLastAssignedPos, zSumUpper.toBigDecimal());
            } else {
                nodetx.addRCInfo(index, lastAssignedPos, m.get());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pass2(FringeDB fringedb, SeqDB seqdb, RCDB rcdb, long step, Criterion criterion, Double[] gThresholds, ConfTables confTables, Stopwatch stopwatch, double targetSeconds) {
        if (this.showProgress) {
            this.logf("pass 2 running ...", new Object[0]);
        }
        TaskExecutor tasks = this.stateConfigs.get((int)0).confEcalc.tasks;
        BigExp[] zThresholds = this.gtozThresholds(gThresholds);
        FringeDB.Transaction fringetx = fringedb.transaction();
        long numNodesToRead = fringetx.numNodesToRead();
        SeqDB.Transaction seqtx = seqdb.transaction();
        int[] nodesInFlight = new int[]{0};
        class StateStats {
            long read = 0L;
            long expanded = 0L;
            long requeuedByThreshold = 0L;
            long requeuedByFilter = 0L;
            long requeuedForSpace = 0L;
            long added = 0L;
            long minimized = 0L;

            StateStats(Sofea this$0) {
            }
        }
        StateStats[] stats = new StateStats[this.confSpace.states.size()];
        for (MultiStateConfSpace.State state2 : this.confSpace.states) {
            stats[state2.index] = new StateStats(this);
        }
        ArrayDeque minimizationQueue = new ArrayDeque();
        Runnable processMinimizationQueue = () -> {
            while (true) {
                NodeTransaction nodetx;
                Deque deque = minimizationQueue;
                synchronized (deque) {
                    nodetx = (NodeTransaction)minimizationQueue.pollFirst();
                }
                if (nodetx == null) break;
                tasks.submit(() -> {
                    ConfDB.ConfTable confTable = confTables.get(nodetx.state);
                    StateInfo stateInfo = this.getStateInfo(nodetx.state);
                    for (ZPath zPath : nodetx.zPaths) {
                        zPath.zPath = new BigExp(stateInfo.calcZPath(zPath.conf, confTable));
                    }
                    return 42;
                }, theAnswer -> {
                    Sofea sofea = this;
                    synchronized (sofea) {
                        nodesInFlight[0] = nodesInFlight[0] - nodetx.replacementNodes.size();
                        ++stats[nodetx.state.index].expanded;
                        stats[nodetx.state.index].added += (long)nodetx.numReplacementNodes();
                        stats[nodetx.state.index].minimized += (long)nodetx.zPaths.size();
                        nodetx.replacePass2(fringetx, seqtx, rcdb);
                    }
                });
            }
        };
        while (!(stopwatch.getTimeS() > targetSeconds)) {
            NodeTransaction nodetx;
            processMinimizationQueue.run();
            Sofea sofea = this;
            synchronized (sofea) {
                if (!fringetx.hasNodesToRead()) {
                    break;
                }
                fringetx.readNode();
                ++stats[fringetx.state().index].read;
                nodesInFlight[0] = nodesInFlight[0] + 1;
                nodetx = new NodeTransaction(fringetx.state(), fringetx.conf(), fringetx.zSumUpper());
            }
            if (criterion != null && criterion.filterNode(nodetx.state, nodetx.conf, this.bcalc) == Criterion.Filter.Requeue) {
                sofea = this;
                synchronized (sofea) {
                    nodesInFlight[0] = nodesInFlight[0] - 1;
                    ++stats[nodetx.state.index].requeuedByFilter;
                    nodetx.requeuePass2(fringetx, seqtx, rcdb);
                    continue;
                }
            }
            tasks.submit(() -> this.refineZSumLower(nodetx, zThresholds[nodetx.state.index], nodetx.index, nodetx.zSumUpper), result -> {
                boolean needsMinimization = false;
                Object object = this;
                synchronized (object) {
                    nodesInFlight[0] = nodesInFlight[0] - 1;
                    if (result == NodeResult.Saved) {
                        ++stats[nodetx.state.index].requeuedByThreshold;
                        nodetx.requeuePass2(fringetx, seqtx, rcdb);
                    } else if (nodetx.hasRoomToReplace(fringetx, nodesInFlight[0])) {
                        if (nodetx.zPaths.isEmpty()) {
                            ++stats[nodetx.state.index].expanded;
                            stats[nodetx.state.index].added += (long)nodetx.numReplacementNodes();
                            nodetx.replacePass2(fringetx, seqtx, rcdb);
                        } else {
                            nodesInFlight[0] = nodesInFlight[0] + nodetx.replacementNodes.size();
                            needsMinimization = true;
                        }
                    } else {
                        ++stats[nodetx.state.index].requeuedForSpace;
                        nodetx.requeuePass2(fringetx, seqtx, rcdb);
                    }
                }
                if (needsMinimization) {
                    object = minimizationQueue;
                    synchronized (object) {
                        minimizationQueue.add(nodetx);
                    }
                }
            });
        }
        tasks.waitForFinish();
        processMinimizationQueue.run();
        tasks.waitForFinish();
        assert (minimizationQueue.isEmpty());
        assert (nodesInFlight[0] == 0);
        fringetx.commit();
        seqtx.commit();
        if (this.showProgress) {
            long nodesRead = this.confSpace.states.stream().mapToLong(state -> stats[state.index].read).sum();
            this.log(" %s   read=%6d/%6d (%5.1f%%)", stopwatch.getTime(2), nodesRead, numNodesToRead, Float.valueOf(100.0f * (float)nodesRead / (float)numNodesToRead));
        }
        if (this.performanceLogFile != null) {
            for (MultiStateConfSpace.State state3 : this.confSpace.states) {
                this.performanceLog("\t%20s  read=%6d [ expanded=%6d  requeuedByThreshold=%6d  requeuedByFilter=%6d  requeuedForSpace=%6d ] added=%6d  minimized=%6d", state3.name, stats[state3.index].read, stats[state3.index].expanded, stats[state3.index].requeuedByThreshold, stats[state3.index].requeuedByFilter, stats[state3.index].requeuedForSpace, stats[state3.index].added, stats[state3.index].minimized);
            }
        }
    }

    private NodeResult refineZSumLower(NodeTransaction nodetx, BigExp zSumThreshold, ConfIndex index, BigExp zSumUpper) {
        if (zSumUpper.lessThan(this.zPruneThreshold)) {
            return NodeResult.Removed;
        }
        if (zSumThreshold != null && zSumUpper.lessThan(zSumThreshold)) {
            nodetx.addReplacementNode(index, zSumUpper);
            return NodeResult.Saved;
        }
        StateInfo stateInfo = this.stateInfos.get(nodetx.state.index);
        if (index.isFullyDefined()) {
            nodetx.addZPath(index, zSumUpper);
            return NodeResult.Removed;
        }
        NodeResult result = NodeResult.ExpandedThenRemoved;
        int pos = stateInfo.posPermutation[index.numDefined];
        for (int rc : stateInfo.rcs.get(pos)) {
            index.assignInPlace(pos, rc);
            NodeResult rcResult = this.refineZSumLower(nodetx, zSumThreshold, index, stateInfo.calcZSumUpper(index, stateInfo.rcs));
            index.unassignInPlace(pos);
            if (rcResult.removed) continue;
            result = NodeResult.ExpandedThenSaved;
        }
        return result;
    }

    protected BigDecimal calcZSum(Sequence seq, MultiStateConfSpace.State state) {
        StateInfo stateInfo = this.stateInfos.get(state.index);
        try (StateInfo.Confs confs = new StateInfo.Confs(stateInfo);){
            RCs rcs = seq.makeRCs(state.confSpace);
            BigDecimal bigDecimal = stateInfo.calcZSum(stateInfo.makeConfIndex(), rcs, confs.table());
            return bigDecimal;
        }
    }

    public static class StateConfig {
        public final EnergyMatrix emat;
        public final ConfEnergyCalculator confEcalc;
        public final File confDBFile;

        public StateConfig(EnergyMatrix emat, ConfEnergyCalculator confEcalc, File confDBFile) {
            this.emat = emat;
            this.confEcalc = confEcalc;
            this.confDBFile = confDBFile;
        }
    }

    protected class StateInfo {
        final MultiStateConfSpace.State state;
        final ConfEnergyCalculator confEcalc;
        final ZMatrix zmat;
        final RCs rcs;
        final int[] posPermutation;
        private final int[][] rtsByRcByPos;
        private final int[] numRtsByPos;
        private final BigExp[][][] maxzrc2;

        StateInfo(MultiStateConfSpace.State state) {
            this.state = state;
            StateConfig config = Sofea.this.stateConfigs.get(state.index);
            this.confEcalc = config.confEcalc;
            this.zmat = new ZMatrix(state.confSpace);
            this.zmat.set(config.emat);
            this.rcs = new RCs(state.confSpace);
            this.rtsByRcByPos = new int[state.confSpace.numPos()][];
            this.numRtsByPos = new int[state.confSpace.numPos()];
            for (int posi = 0; posi < state.confSpace.numPos(); ++posi) {
                this.rtsByRcByPos[posi] = new int[state.confSpace.numConf(posi)];
                SeqSpace.Position seqPos = Sofea.this.confSpace.seqSpace.getPosition(state.confSpace.name(posi));
                if (seqPos != null) {
                    this.numRtsByPos[posi] = seqPos.resTypes.size();
                    for (int confi = 0; confi < state.confSpace.numConf(posi); ++confi) {
                        SeqSpace.ResType rt = seqPos.getResTypeOrThrow(state.confSpace.confType(posi, confi));
                        this.rtsByRcByPos[posi][confi] = rt.index;
                    }
                    continue;
                }
                this.numRtsByPos[posi] = 0;
                Arrays.fill(this.rtsByRcByPos[posi], -1);
            }
            this.maxzrc2 = new BigExp[this.rcs.getNumPos()][][];
            for (int pos1 = 0; pos1 < this.rcs.getNumPos(); ++pos1) {
                this.maxzrc2[pos1] = new BigExp[this.rcs.getNum(pos1)][];
                for (int rc1 : this.rcs.get(pos1)) {
                    this.maxzrc2[pos1][rc1] = new BigExp[pos1];
                    for (int pos2 = 0; pos2 < pos1; ++pos2) {
                        BigExp optzrc2 = new BigExp(Double.NEGATIVE_INFINITY);
                        for (int rc2 : this.rcs.get(pos2)) {
                            optzrc2.max((BigExp)this.zmat.getPairwise(pos1, rc1, pos2, rc2));
                        }
                        this.maxzrc2[pos1][rc1][pos2] = optzrc2;
                    }
                }
            }
            this.posPermutation = IntStream.range(0, state.confSpace.numPos()).boxed().sorted((a, b) -> {
                boolean amut = state.confSpace.hasMutations((int)a);
                boolean bmut = state.confSpace.hasMutations((int)b);
                if (amut && !bmut) {
                    return -1;
                }
                if (!amut && bmut) {
                    return 1;
                }
                int order = Double.compare(this.calcOrderHeuristic((int)a), this.calcOrderHeuristic((int)b));
                if (order != 0) {
                    return -order;
                }
                return a - b;
            }).mapToInt(i -> i).toArray();
        }

        double calcOrderHeuristic(int posi) {
            return 0.0;
        }

        void checkOrderHeuristic(SimpleConfSpace.Position pos) {
            Sofea.this.log("pos %d", pos.index);
            ConfIndex index = this.makeConfIndex();
            for (int rc : this.rcs.get(pos.index)) {
                index.assignInPlace(pos.index, rc);
                BigExp zSumUpper = this.calcZSumUpper(index, this.rcs);
                index.unassignInPlace(pos.index);
                Sofea.this.log("\tRC %d -> %e", rc, zSumUpper);
            }
        }

        ConfIndex makeConfIndex() {
            ConfIndex index = new ConfIndex(this.state.confSpace.numPos());
            index.updateUndefined();
            return index;
        }

        Sequence makeSeq(int[] conf) {
            return Sofea.this.confSpace.seqSpace.makeSequence(this.state.confSpace, conf);
        }

        int getLastAssignedPos(int[] conf) {
            for (int i = this.posPermutation.length - 1; i >= 0; --i) {
                int pos = this.posPermutation[i];
                if (conf[pos] == -1) continue;
                return pos;
            }
            return -1;
        }

        Map<Sequence, BigInteger> calcNumLeavesBySequence(ConfIndex index) {
            HashMap<Sequence, BigInteger> out = new HashMap<Sequence, BigInteger>();
            Runnable[] f = new Runnable[]{null};
            f[0] = () -> {
                if (index.isFullyDefined()) {
                    out.compute(this.makeSeq(Conf.make(index)), (seq, old) -> {
                        if (old == null) {
                            return BigInteger.ONE;
                        }
                        return old.add(BigInteger.ONE);
                    });
                    return;
                }
                int pos = this.posPermutation[index.numDefined];
                for (int rc : this.rcs.get(pos)) {
                    index.assignInPlace(pos, rc);
                    f[0].run();
                    index.unassignInPlace(pos);
                }
            };
            f[0].run();
            return out;
        }

        BigExp calcNumLeavesUpperBySequence(ConfIndex index, RCs rcs) {
            BigExp count = new BigExp(1.0);
            for (int i = 0; i < index.numUndefined; ++i) {
                int pos = index.undefinedPos[i];
                int maxCount = 0;
                int numRts = this.numRtsByPos[pos];
                if (numRts > 0) {
                    int[] counts = new int[numRts];
                    for (int rc : rcs.get(pos)) {
                        int n = this.rtsByRcByPos[pos][rc];
                        int n2 = counts[n] + 1;
                        counts[n] = n2;
                        int rtCount = n2;
                        maxCount = Math.max(maxCount, rtCount);
                    }
                } else {
                    maxCount = rcs.getNum(pos);
                }
                count.mult(maxCount);
            }
            return count;
        }

        BigExp calcZSumUpper(ConfIndex index, RCs rcs) {
            BigExp out = this.calcZPathHeadUpper(index);
            out.mult(this.calcZPathTailUpper(index, rcs));
            out.mult(this.calcNumLeavesUpperBySequence(index, rcs));
            return out;
        }

        BigExp calcZPathUpper(ConfIndex index, RCs rcs) {
            BigExp out = this.calcZPathHeadUpper(index);
            out.mult(this.calcZPathTailUpper(index, rcs));
            return out;
        }

        BigExp calcZPathHeadUpper(ConfIndex index) {
            BigExp z = new BigExp(1.0);
            for (int i1 = 0; i1 < index.numDefined; ++i1) {
                int pos1 = index.definedPos[i1];
                int rc1 = index.definedRCs[i1];
                z.mult((BigExp)this.zmat.getOneBody(pos1, rc1));
                for (int i2 = 0; i2 < i1; ++i2) {
                    int pos2 = index.definedPos[i2];
                    int rc2 = index.definedRCs[i2];
                    z.mult((BigExp)this.zmat.getPairwise(pos1, rc1, pos2, rc2));
                }
            }
            int[] conf = Conf.make(index);
            this.zmat.forEachHigherOrderTupleIn(conf, (tuple, tupleZ) -> z.mult((BigExp)tupleZ));
            return z;
        }

        BigExp calcZPathTailUpper(ConfIndex index, RCs rcs) {
            BigExp z = new BigExp(1.0);
            for (int i1 = 0; i1 < index.numUndefined; ++i1) {
                int pos1 = index.undefinedPos[i1];
                BigExp zpos1 = new BigExp(Double.NEGATIVE_INFINITY);
                for (int rc1 : rcs.get(pos1)) {
                    int pos2;
                    int i2;
                    BigExp zrc1 = new BigExp((BigExp)this.zmat.getOneBody(pos1, rc1));
                    for (i2 = 0; i2 < index.numDefined; ++i2) {
                        pos2 = index.definedPos[i2];
                        int rc2 = index.definedRCs[i2];
                        zrc1.mult((BigExp)this.zmat.getPairwise(pos1, rc1, pos2, rc2));
                    }
                    for (i2 = 0; i2 < i1; ++i2) {
                        pos2 = index.undefinedPos[i2];
                        zrc1.mult(this.maxzrc2[pos1][rc1][pos2]);
                    }
                    zpos1.max(zrc1);
                }
                assert (zpos1.isFinite());
                z.mult(zpos1);
            }
            return z;
        }

        BigDecimal calcZPath(ConfIndex index, ConfDB.ConfTable confTable) {
            if (!index.isFullyDefined()) {
                throw new IllegalArgumentException("not a full conf");
            }
            double e = this.confEcalc.calcEnergy(new RCTuple(index), confTable);
            return Sofea.this.bcalc.calcPrecise(e);
        }

        BigDecimal calcZPath(int[] conf, ConfDB.ConfTable confTable) {
            if (!Conf.isCompletelyAssigned(conf)) {
                throw new IllegalArgumentException("not a full conf");
            }
            double e = this.confEcalc.calcEnergy(new RCTuple(conf), confTable);
            return Sofea.this.bcalc.calcPrecise(e);
        }

        @Deprecated
        BigDecimal calcZPathHead(ConfIndex index, ConfDB.ConfTable confTable) {
            throw new Error("stop trying to do this! There's no such thing!");
        }

        BigDecimal calcZSum(ConfIndex index, RCs rcs, ConfDB.ConfTable confTable) {
            if (index.isFullyDefined()) {
                double e = this.confEcalc.calcEnergy(new RCTuple(index), confTable);
                return Sofea.this.bcalc.calcPrecise(e);
            }
            BigMath m = Sofea.this.bigMath().set(0.0);
            int pos = this.posPermutation[index.numDefined];
            for (int rc : rcs.get(pos)) {
                index.assignInPlace(pos, rc);
                m.add(this.calcZSum(index, rcs, confTable));
                index.unassignInPlace(pos);
            }
            return m.get();
        }

        MathTools.BigDecimalBounds calcZPathBoundsExact(ConfIndex index, RCs rcs, ConfDB.ConfTable confTable) {
            if (index.isFullyDefined()) {
                return new MathTools.BigDecimalBounds(this.calcZPath(index, confTable));
            }
            BigMath mlo = Sofea.this.bigMath();
            BigMath mhi = Sofea.this.bigMath();
            int pos = this.posPermutation[index.numDefined];
            for (int rc : rcs.get(pos)) {
                index.assignInPlace(pos, rc);
                MathTools.BigDecimalBounds sub = this.calcZPathBoundsExact(index, rcs, confTable);
                mlo.minOrSet(sub.lower);
                mhi.maxOrSet(sub.upper);
                index.unassignInPlace(pos);
            }
            return new MathTools.BigDecimalBounds(mlo.get(), mhi.get());
        }

        class Confs
        implements AutoCloseable {
            final ConfDB db;
            final ConfDB.Key key;

            Confs(StateInfo this$1) {
                StateConfig config = this$1.Sofea.this.stateConfigs.get(this$1.state.index);
                if (config.confDBFile != null) {
                    this.db = new ConfDB(this$1.state.confSpace, config.confDBFile);
                    this.key = new ConfDB.Key("sofea");
                } else {
                    this.db = null;
                    this.key = null;
                }
            }

            @Override
            public void close() {
                if (this.db != null) {
                    this.db.close();
                }
            }

            public ConfDB.ConfTable table() {
                if (this.db != null) {
                    return this.db.get(this.key);
                }
                return null;
            }
        }
    }

    public static interface Criterion {
        default public Filter filterNode(MultiStateConfSpace.State state, int[] conf, BoltzmannCalculator bcalc) {
            return Filter.Process;
        }

        public Satisfied isSatisfied(SeqDB var1, FringeDB var2, FringeDB var3, long var4, long var6, BoltzmannCalculator var8);

        public static enum Filter {
            Process,
            Requeue;

        }

        public static enum Satisfied {
            KeepSweeping,
            Terminate;

        }
    }

    private class ConfTables
    implements AutoCloseable {
        StateInfo.Confs[] confsByState;

        ConfTables(Sofea sofea) {
            this.confsByState = new StateInfo.Confs[sofea.confSpace.states.size()];
            for (MultiStateConfSpace.State state : sofea.confSpace.states) {
                this.confsByState[state.index] = new StateInfo.Confs(sofea.stateInfos.get(state.index));
            }
        }

        @Override
        public void close() {
            for (StateInfo.Confs confs : this.confsByState) {
                confs.close();
            }
        }

        public ConfDB.ConfTable get(MultiStateConfSpace.State state) {
            return this.confsByState[state.index].table();
        }
    }

    private class NodeTransaction {
        final MultiStateConfSpace.State state;
        final int[] conf;
        final BigExp zSumUpper;
        final ConfIndex index;
        final List<Node> replacementNodes = new ArrayList<Node>();
        final List<ZPath> zPaths = new ArrayList<ZPath>();
        final List<RCInfo> rcInfos = new ArrayList<RCInfo>();

        NodeTransaction(MultiStateConfSpace.State state, int[] conf, BigExp zSumUpper) {
            this.state = state;
            this.conf = conf;
            this.zSumUpper = zSumUpper;
            this.index = new ConfIndex(state.confSpace.numPos());
            Conf.index(conf, this.index);
        }

        void addReplacementNode(ConfIndex index, BigExp zSumUpper) {
            this.replacementNodes.add(new Node(Conf.make(index), zSumUpper));
        }

        int numReplacementNodes() {
            return this.replacementNodes.size();
        }

        void addZPath(ConfIndex index, BigExp zSumUpper) {
            this.zPaths.add(new ZPath(Conf.make(index), null, zSumUpper));
        }

        void addRCInfo(ConfIndex index, int pos, BigDecimal zSumUpper) {
            this.addRCInfo(index, pos, zSumUpper, -1, null);
        }

        void addRCInfo(ConfIndex index, int pos, BigDecimal zSumUpper, int parentPos, BigDecimal zSumUpperInParent) {
            this.rcInfos.add(new RCInfo(Conf.make(index), pos, zSumUpper, parentPos, zSumUpperInParent));
        }

        boolean hasRoomToReplace(FringeDB.Transaction fringetx, int otherNodesInFlight) {
            return fringetx.dbHasRoomFor(this.replacementNodes.size() + otherNodesInFlight);
        }

        void normalize() {
            for (ZPath zPath : this.zPaths) {
                zPath.zSumUpper.normalize(true);
            }
            for (Node replacementNode : this.replacementNodes) {
                replacementNode.zSumUpper.normalize(true);
            }
        }

        boolean replacePass1(FringeDB.Transaction fringetx, SeqDB.Transaction seqtx, RCDB rcdb) {
            boolean flush;
            boolean bl = flush = !fringetx.txHasRoomFor(this.replacementNodes.size());
            if (flush) {
                this.flushTransactions(fringetx, seqtx);
            }
            StateInfo stateInfo = Sofea.this.stateInfos.get(this.state.index);
            this.normalize();
            for (ZPath zPath : this.zPaths) {
                seqtx.addZSumUpper(this.state, stateInfo.makeSeq(zPath.conf), zPath.zSumUpper);
            }
            for (Node replacementNode : this.replacementNodes) {
                fringetx.writeReplacementNode(this.state, replacementNode.conf, replacementNode.zSumUpper);
                Sequence seq = stateInfo.makeSeq(replacementNode.conf);
                seqtx.addZSumUpper(this.state, seq, replacementNode.zSumUpper);
            }
            seqtx.subZSumUpper(this.state, stateInfo.makeSeq(this.conf), this.zSumUpper);
            if (rcdb != null) {
                this.updateRCDBPass1(rcdb);
            }
            return flush;
        }

        boolean requeuePass1(FringeDB.Transaction fringetx, SeqDB.Transaction seqtx, RCDB rcdb) {
            boolean flush;
            boolean bl = flush = !fringetx.txHasRoomFor(1);
            if (flush) {
                this.flushTransactions(fringetx, seqtx);
            }
            if (this.replacementNodes.isEmpty() && this.zPaths.isEmpty()) {
                fringetx.writeReplacementNode(this.state, this.conf, this.zSumUpper);
            } else {
                this.normalize();
                BigMath m = new BigMath(Sofea.this.seqdbMathContext).set(0L);
                for (Node replacementNode : this.replacementNodes) {
                    m.add(replacementNode.zSumUpper);
                }
                for (ZPath zPath : this.zPaths) {
                    m.add(zPath.zSumUpper);
                }
                BigExp newZSumUpper = new BigExp(m.get());
                fringetx.writeReplacementNode(this.state, this.conf, newZSumUpper);
                Sequence seq = Sofea.this.stateInfos.get(this.state.index).makeSeq(this.conf);
                for (Node replacementNode : this.replacementNodes) {
                    seqtx.addZSumUpper(this.state, seq, replacementNode.zSumUpper);
                }
                for (ZPath zPath : this.zPaths) {
                    seqtx.addZSumUpper(this.state, seq, zPath.zSumUpper);
                }
                seqtx.subZSumUpper(this.state, seq, this.zSumUpper);
                if (rcdb != null) {
                    this.updateRCDBPass1(rcdb);
                }
            }
            return flush;
        }

        void updateRCDBPass1(RCDB rcdb) {
            StateInfo stateInfo = Sofea.this.stateInfos.get(this.state.index);
            for (RCInfo rcInfo : this.rcInfos) {
                rcdb.addZSumUpper(this.state, stateInfo.makeSeq(rcInfo.conf), rcInfo.conf, rcInfo.pos, rcInfo.zSumUpper);
                if (rcInfo.parentPos == -1) continue;
                Conf.unassignFor(rcInfo.conf, rcInfo.pos, () -> rcdb.subZSumUpper(this.state, stateInfo.makeSeq(rcInfo.conf), rcInfo.conf, rcInfo.parentPos, rcInfo.zSumUpperInParent));
            }
            int pos = stateInfo.getLastAssignedPos(this.conf);
            if (pos >= 0) {
                rcdb.subZSumUpper(this.state, stateInfo.makeSeq(this.conf), this.conf, pos, this.zSumUpper.toBigDecimal());
            }
        }

        boolean replacePass2(FringeDB.Transaction fringetx, SeqDB.Transaction seqtx, RCDB rcdb) {
            boolean flush;
            boolean bl = flush = !fringetx.txHasRoomFor(this.replacementNodes.size());
            if (flush) {
                this.flushTransactions(fringetx, seqtx);
            }
            StateInfo stateInfo = Sofea.this.stateInfos.get(this.state.index);
            this.normalize();
            for (Node replacementNode : this.replacementNodes) {
                fringetx.writeReplacementNode(this.state, replacementNode.conf, replacementNode.zSumUpper);
            }
            for (ZPath zPath : this.zPaths) {
                seqtx.addZPath(this.state, stateInfo.makeSeq(zPath.conf), zPath.zPath, zPath.zSumUpper);
            }
            if (rcdb != null) {
                for (ZPath zPath : this.zPaths) {
                    int pos = stateInfo.getLastAssignedPos(zPath.conf);
                    rcdb.addZPath(this.state, stateInfo.makeSeq(zPath.conf), zPath.conf, pos, zPath.zPath.toBigDecimal(), zPath.zSumUpper.toBigDecimal());
                    Conf.unassignFor(zPath.conf, pos, () -> {
                        int parentPos = stateInfo.getLastAssignedPos(zPath.conf);
                        if (parentPos >= 0) {
                            rcdb.subZSumUpper(this.state, stateInfo.makeSeq(zPath.conf), zPath.conf, parentPos, zPath.zSumUpper.toBigDecimal());
                        }
                    });
                }
            }
            return flush;
        }

        boolean requeuePass2(FringeDB.Transaction fringetx, SeqDB.Transaction seqtx, RCDB rcdb) {
            boolean flush;
            boolean bl = flush = !fringetx.txHasRoomFor(1);
            if (flush) {
                this.flushTransactions(fringetx, seqtx);
            }
            this.normalize();
            BigExp zSumUpper = this.zSumUpper;
            if (!this.replacementNodes.isEmpty() && !this.zPaths.isEmpty()) {
                BigMath m = new BigMath(Sofea.this.seqdbMathContext).set(0L);
                for (Node replacementNode : this.replacementNodes) {
                    m.add(replacementNode.zSumUpper);
                }
                for (ZPath zPath : this.zPaths) {
                    m.add(zPath.zSumUpper);
                }
                zSumUpper = new BigExp(m.get());
            }
            fringetx.writeReplacementNode(this.state, this.conf, zSumUpper);
            return flush;
        }

        boolean flushTransactions(FringeDB.Transaction fringetx, SeqDB.Transaction seqtx) {
            if (this.replacementNodes.size() > fringetx.maxWriteBufferNodes()) {
                throw new IllegalStateException(String.format("FringeDB write buffer is too small. Holds %d nodes, but need %d nodes", fringetx.maxWriteBufferNodes(), this.replacementNodes.size()));
            }
            fringetx.commit();
            seqtx.commit();
            return true;
        }
    }

    private static enum NodeResult {
        Saved(false, false),
        Removed(false, true),
        ExpandedThenSaved(true, false),
        ExpandedThenRemoved(true, true);

        public final boolean expanded;
        public final boolean removed;

        private NodeResult(boolean expanded, boolean removed) {
            this.expanded = expanded;
            this.removed = removed;
        }
    }

    private static class ZPath {
        final int[] conf;
        BigExp zPath;
        BigExp zSumUpper;

        ZPath(int[] conf, BigExp zPath, BigExp zSumUpper) {
            this.conf = conf;
            this.zPath = zPath;
            this.zSumUpper = zSumUpper;
        }
    }

    private static class RCInfo {
        final int[] conf;
        final int pos;
        final BigDecimal zSumUpper;
        final int parentPos;
        final BigDecimal zSumUpperInParent;

        RCInfo(int[] conf, int pos, BigDecimal zSumUpper, int parentPos, BigDecimal zSumUpperInParent) {
            this.conf = conf;
            this.pos = pos;
            this.zSumUpper = zSumUpper;
            this.parentPos = parentPos;
            this.zSumUpperInParent = zSumUpperInParent;
        }
    }

    private static class Node {
        final int[] conf;
        final BigExp zSumUpper;

        Node(int[] conf, BigExp zSumUpper) {
            this.conf = conf;
            this.zSumUpper = zSumUpper;
        }
    }

    public static class SeqResult {
        public final Sequence sequence;
        public final MathTools.DoubleBounds lmfeFreeEnergy;
        public final MathTools.DoubleBounds[] stateFreeEnergies;

        public SeqResult(Sequence sequence, MathTools.DoubleBounds lmfeFreeEnergy, MathTools.DoubleBounds[] stateFreeEnergies) {
            this.sequence = sequence;
            this.lmfeFreeEnergy = lmfeFreeEnergy;
            this.stateFreeEnergies = stateFreeEnergies;
        }
    }

    public static class Builder {
        public final MultiStateConfSpace confSpace;
        private final StateConfig[] stateConfigs;
        private File seqdbFile = new File("seq.db");
        private MathContext seqdbMathContext = new MathContext(128, RoundingMode.HALF_UP);
        private File fringedbLowerFile = new File("fringe.lower.db");
        private long fringedbLowerBytes = 0xA00000L;
        private File fringedbUpperFile = new File("fringe.upper.db");
        private long fringedbUpperBytes = 0x100000L;
        private File rcdbFile = null;
        private boolean showProgress = true;
        private File performanceLogFile = null;
        private double sweepIncrement = 1.0;
        private int maxCriterionCheckSeconds = 60;
        private long maxNumMinimizations = 1000000000L;
        private double negligableFreeEnergy = -1.0;

        public Builder(MultiStateConfSpace confSpace) {
            this.confSpace = confSpace;
            this.stateConfigs = new StateConfig[confSpace.states.size()];
        }

        public Builder configState(MultiStateConfSpace.State state, StateConfig config) {
            this.stateConfigs[state.index] = config;
            return this;
        }

        public Builder configEachState(Function<MultiStateConfSpace.State, StateConfig> configurator) {
            for (MultiStateConfSpace.State state : this.confSpace.states) {
                this.configState(state, configurator.apply(state));
            }
            return this;
        }

        public Builder setSeqDBFile(File val) {
            this.seqdbFile = val;
            return this;
        }

        public Builder setSeqDBMathContext(MathContext val) {
            this.seqdbMathContext = val;
            return this;
        }

        public Builder setFringeDBLowerFile(File val) {
            this.fringedbLowerFile = val;
            return this;
        }

        public Builder setFringeDBLowerBytes(long val) {
            this.fringedbLowerBytes = val;
            return this;
        }

        public Builder setFringeDBLowerMiB(int val) {
            this.fringedbLowerBytes = (long)val * 1024L * 1024L;
            return this;
        }

        public Builder setFringeDBUpperFile(File val) {
            this.fringedbUpperFile = val;
            return this;
        }

        public Builder setFringeDBUpperBytes(long val) {
            this.fringedbUpperBytes = val;
            return this;
        }

        public Builder setFringeDBUpperMiB(int val) {
            this.fringedbUpperBytes = (long)val * 1024L * 1024L;
            return this;
        }

        public Builder setRCDBFile(File val) {
            this.rcdbFile = val;
            return this;
        }

        public Builder setShowProgress(boolean val) {
            this.showProgress = val;
            return this;
        }

        public Builder setPerformanceLogFile(File val) {
            this.performanceLogFile = val;
            return this;
        }

        public Builder setSweepIncrement(double val) {
            this.sweepIncrement = val;
            return this;
        }

        public Builder setMaxCriterionCheckSeconds(int val) {
            this.maxCriterionCheckSeconds = val;
            return this;
        }

        public Builder setMaxNumMinimizations(long val) {
            this.maxNumMinimizations = val;
            return this;
        }

        public Builder setNegligableFreeEnergy(double val) {
            this.negligableFreeEnergy = val;
            return this;
        }

        public Sofea build() {
            List unconfiguredStateNames = this.confSpace.states.stream().filter(state -> this.stateConfigs[state.index] == null).map(state -> state.name).collect(Collectors.toList());
            if (!unconfiguredStateNames.isEmpty()) {
                throw new IllegalStateException("not all states have been configured. Please configure states: " + String.valueOf(unconfiguredStateNames));
            }
            return new Sofea(this.confSpace, Arrays.asList(this.stateConfigs), this.seqdbFile, this.seqdbMathContext, this.fringedbLowerFile, this.fringedbLowerBytes, this.fringedbUpperFile, this.fringedbUpperBytes, this.rcdbFile, this.showProgress, this.performanceLogFile, this.sweepIncrement, this.maxCriterionCheckSeconds, this.maxNumMinimizations, this.negligableFreeEnergy);
        }
    }
}

