/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.structure;

import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.PeriodicTable;
import java.io.Serializable;
import java.util.ArrayList;

public class Atom
implements Serializable {
    public Residue res;
    public int indexInRes;
    public String name;
    public String elementType;
    public double BFactor = 0.0;
    public int modelAtomNumber = -1;
    public String forceFieldType;
    public int type;
    public double charge;
    public ArrayList<Atom> bonds = new ArrayList();
    public int elementNumber;
    public double radius;
    public double mass;

    public Atom(String name, String elementType) {
        this.name = name;
        PeriodicTable.setElementProperties(this, elementType);
    }

    public Atom(String name) {
        this.name = name;
        PeriodicTable.inferElementProperties(this);
    }

    public Atom copy() {
        Atom ans = new Atom(this.name, this.elementType);
        ans.BFactor = this.BFactor;
        ans.modelAtomNumber = this.modelAtomNumber;
        ans.indexInRes = this.indexInRes;
        ans.res = null;
        ans.charge = this.charge;
        ans.type = this.type;
        ans.forceFieldType = this.forceFieldType;
        return ans;
    }

    public Atom copyToRes(Residue res) {
        Atom copy2 = new Atom();
        copy2.name = this.name;
        copy2.elementType = this.elementType;
        copy2.BFactor = this.BFactor;
        copy2.modelAtomNumber = this.modelAtomNumber;
        copy2.forceFieldType = this.forceFieldType;
        copy2.type = this.type;
        copy2.charge = this.charge;
        copy2.elementNumber = this.elementNumber;
        copy2.radius = this.radius;
        copy2.mass = this.mass;
        copy2.bonds = new ArrayList();
        copy2.res = res;
        copy2.indexInRes = res.atoms.size();
        res.atoms.add(copy2);
        return copy2;
    }

    private Atom() {
    }

    public void addBond(Atom atom2) {
        this.bonds.add(atom2);
        atom2.bonds.add(this);
    }

    public double[] getCoords() {
        int i = 3 * this.indexInRes;
        double x = this.res.coords[i++];
        double y = this.res.coords[i++];
        double z = this.res.coords[i];
        return new double[]{x, y, z};
    }

    public void setCoords(double x, double y, double z) {
        int i = 3 * this.indexInRes;
        this.res.coords[i++] = x;
        this.res.coords[i++] = y;
        this.res.coords[i] = z;
    }

    public boolean isHydrogen() {
        return this.elementType.equalsIgnoreCase("H");
    }

    public boolean isCarbon() {
        return this.elementType.equalsIgnoreCase("C");
    }

    public boolean isOxygen() {
        return this.elementType.equalsIgnoreCase("O");
    }

    public boolean isSulfur() {
        return this.elementType.equalsIgnoreCase("S");
    }

    public String toString() {
        if (this.res != null) {
            int i = 3 * this.indexInRes;
            return String.format("%s %s (%.3f, %.3f, %.3f)", this.res.fullName, this.name, this.res.coords[i], this.res.coords[i + 1], this.res.coords[i + 2]);
        }
        return this.name;
    }
}

