/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.structure;

import edu.duke.cs.osprey.restypes.ResidueTemplate;
import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.structure.AtomNeighbors;
import edu.duke.cs.osprey.structure.ProbeAtomNeighbors;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.HashCalculator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AtomConnectivity {
    public final boolean treat15HasNonBonded;
    private final Map<Key1, AtomPairs> atomPairs1 = new HashMap<Key1, AtomPairs>();
    private final Map<Key2, AtomPairs> atomPairs2 = new HashMap<Key2, AtomPairs>();
    private final Map<KeySeparate, AtomPairs> atomPairsSeparate = new HashMap<KeySeparate, AtomPairs>();

    private AtomConnectivity(boolean treat15HasNonBonded) {
        this.treat15HasNonBonded = treat15HasNonBonded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtomPairs getAtomPairs(Residue res1, Residue res2) {
        if (res1 == res2) {
            Map<Key1, AtomPairs> map = this.atomPairs1;
            synchronized (map) {
                return this.atomPairs1.computeIfAbsent(new Key1(res1.template), key -> this.makeAtomPairs(res1, res1));
            }
        }
        if (this.isInterResBondedForward(res1, res2)) {
            Map<Key2, AtomPairs> map = this.atomPairs2;
            synchronized (map) {
                return this.atomPairs2.computeIfAbsent(new Key2(res1.template, res2.template, true), key -> this.makeAtomPairs(res1, res2));
            }
        }
        if (this.isInterResBondedForward(res2, res1)) {
            Map<Key2, AtomPairs> map = this.atomPairs2;
            synchronized (map) {
                return this.atomPairs2.computeIfAbsent(new Key2(res2.template, res1.template, false), key -> this.makeAtomPairs(res1, res2));
            }
        }
        Map<KeySeparate, AtomPairs> map = this.atomPairsSeparate;
        synchronized (map) {
            return this.atomPairsSeparate.computeIfAbsent(new KeySeparate(res1.template, res2.template), key -> this.makeAtomPairs(res1, res2));
        }
    }

    private boolean isInterResBondedForward(Residue res1, Residue res2) {
        Class<?> class2;
        Class<?> class1 = res1.template.interResBonding.getClass();
        return (class1.isAssignableFrom(class2 = res2.template.interResBonding.getClass()) || class2.isAssignableFrom(class1)) && res1.template.interResBonding.isInterResBondedForward(res1, res2);
    }

    private AtomPairs makeAtomPairs(Residue res1, Residue res2) {
        EnumMap pairsByType = new EnumMap(AtomNeighbors.Type.class);
        for (AtomNeighbors.Type type : AtomNeighbors.Type.values()) {
            pairsByType.put(type, new ArrayList());
        }
        for (int i = 0; i < res1.atoms.size(); ++i) {
            Atom atom1 = res1.atoms.get(i);
            AtomNeighbors neighbors = this.treat15HasNonBonded ? new AtomNeighbors(atom1) : new ProbeAtomNeighbors(atom1);
            int n = i;
            if (res1 != res2) {
                n = res2.atoms.size();
            }
            int j = 0;
            while (j < n) {
                Atom atom2 = res2.atoms.get(j);
                AtomNeighbors.Type type = neighbors.classifyAtom(atom2);
                ((List)pairsByType.get((Object)type)).add(new int[]{i, j++});
            }
        }
        AtomPairs pairs = new AtomPairs(res1.template, res2.template);
        for (Map.Entry entry : pairsByType.entrySet()) {
            AtomNeighbors.Type type = (AtomNeighbors.Type)((Object)entry.getKey());
            List atomPairs = (List)entry.getValue();
            pairs.pairsByType[type.ordinal()] = new int[atomPairs.size()][2];
            atomPairs.toArray((T[])pairs.pairsByType[type.ordinal()]);
        }
        return pairs;
    }

    private static class Key1 {
        private ResidueTemplate templ1;

        public Key1(ResidueTemplate templ1) {
            this.templ1 = templ1;
        }

        public int hashCode() {
            return System.identityHashCode(this.templ1);
        }

        public boolean equals(Object obj) {
            Key1 other = (Key1)obj;
            return this.templ1 == other.templ1;
        }
    }

    public static class AtomPairs {
        public final ResidueTemplate templ1;
        public final ResidueTemplate templ2;
        private int[][][] pairsByType = new int[AtomNeighbors.Type.values().length][][];

        public AtomPairs(ResidueTemplate templ1, ResidueTemplate templ2) {
            this.templ1 = templ1;
            this.templ2 = templ2;
        }

        public int[][] getPairs(AtomNeighbors.Type type) {
            return this.pairsByType[type.ordinal()];
        }

        public int getNumPairs(AtomNeighbors.Type type) {
            return this.getPairs(type).length;
        }

        public String dumpPairs(AtomNeighbors.Type type) {
            StringBuilder buf = new StringBuilder();
            buf.append("[");
            for (int i = 0; i < this.getNumPairs(type); ++i) {
                if (buf.length() > 1) {
                    buf.append(", ");
                }
                buf.append(Arrays.toString(this.getPairs(type)[i]));
            }
            buf.append("]");
            return buf.toString();
        }
    }

    private static class Key2 {
        private ResidueTemplate templ1;
        private ResidueTemplate templ2;
        private boolean isForward;

        public Key2(ResidueTemplate templ1, ResidueTemplate templ2, boolean isForward) {
            this.templ1 = templ1;
            this.templ2 = templ2;
            this.isForward = isForward;
        }

        public int hashCode() {
            return HashCalculator.combineHashes(System.identityHashCode(this.templ1), System.identityHashCode(this.templ2), Boolean.hashCode(this.isForward));
        }

        public boolean equals(Object obj) {
            Key2 other = (Key2)obj;
            return this.templ1 == other.templ1 && this.templ2 == other.templ2 && this.isForward == other.isForward;
        }
    }

    private static class KeySeparate {
        private ResidueTemplate templ1;
        private ResidueTemplate templ2;

        public KeySeparate(ResidueTemplate templ1, ResidueTemplate templ2) {
            this.templ1 = templ1;
            this.templ2 = templ2;
        }

        public int hashCode() {
            return HashCalculator.combineHashes(System.identityHashCode(this.templ1), System.identityHashCode(this.templ2));
        }

        public boolean equals(Object obj) {
            KeySeparate other = (KeySeparate)obj;
            return this.templ1 == other.templ1 && this.templ2 == other.templ2;
        }
    }

    public static class Builder {
        private boolean treat15HasNonBonded = true;

        public Builder set15HasNonBonded(boolean val) {
            this.treat15HasNonBonded = val;
            return this;
        }

        public AtomConnectivity build() {
            return new AtomConnectivity(this.treat15HasNonBonded);
        }
    }
}

