/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.structure;

import edu.duke.cs.osprey.dof.ProlinePucker;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.restypes.HardCodedResidueInfo;
import edu.duke.cs.osprey.restypes.ResTemplateMatching;
import edu.duke.cs.osprey.restypes.ResidueTemplate;
import edu.duke.cs.osprey.restypes.ResidueTemplateLibrary;
import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.structure.ConfProblem;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.tools.Log;
import edu.duke.cs.osprey.tools.Protractor;
import edu.duke.cs.osprey.tools.StringParsing;
import edu.duke.cs.osprey.tools.VectorAlgebra;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

public class Residue
implements Serializable {
    private static final long serialVersionUID = -6188262155881479376L;
    public String fullName;
    public int indexInMolecule = -1;
    public Molecule molec;
    public ResidueTemplate template = null;
    public ArrayList<Atom> atoms;
    public double[] coords;
    public boolean intraResBondsMarked = false;
    public boolean interResBondsMarked = false;
    public ArrayList<ConfProblem> confProblems = new ArrayList();
    public ProlinePucker pucker = null;
    public SecondaryStructure secondaryStruct = SecondaryStructure.LOOP;
    private String resNum = null;

    public Residue(Residue other) {
        this(Residue.copyAtoms(other.atoms), Arrays.copyOf(other.coords, other.coords.length), other.fullName, other.molec);
        this.indexInMolecule = other.indexInMolecule;
        this.template = other.template;
        this.confProblems = new ArrayList<ConfProblem>(other.confProblems);
        this.pucker = other.pucker;
        this.secondaryStruct = other.secondaryStruct;
        if (this.template != null) {
            this.markIntraResBondsByTemplate();
        }
    }

    public static ArrayList<Atom> copyAtoms(ArrayList<Atom> atoms) {
        ArrayList<Atom> out = new ArrayList<Atom>();
        for (Atom atom : atoms) {
            out.add(atom.copy());
        }
        return out;
    }

    public Residue(ArrayList<Atom> atoms, ArrayList<double[]> coords, String fullName, Molecule molec) {
        this(atoms, Residue.convertCoords(coords), fullName, molec);
    }

    private static double[] convertCoords(ArrayList<double[]> coords) {
        if (coords == null) {
            return null;
        }
        int numAtoms = coords.size();
        double[] out = new double[3 * numAtoms];
        for (int i = 0; i < numAtoms; ++i) {
            System.arraycopy(coords.get(i), 0, out, 3 * i, 3);
        }
        return out;
    }

    public Residue(ArrayList<Atom> atoms, double[] coords, String fullName, Molecule molec) {
        this.atoms = atoms;
        this.fullName = fullName;
        this.molec = molec;
        int numAtoms = atoms.size();
        this.coords = coords;
        if (coords != null && numAtoms * 3 != coords.length) {
            throw new RuntimeException("ERROR: Trying to instantiate residue with " + numAtoms + " atoms but " + coords.length + "/3 atom coordinates");
        }
        for (int a = 0; a < numAtoms; ++a) {
            atoms.get((int)a).res = this;
            atoms.get((int)a).indexInRes = a;
        }
    }

    public Residue copyToMol(Molecule mol, boolean copyIntraBonds) {
        Residue copy2 = new Residue();
        copy2.fullName = this.fullName;
        copy2.resNum = this.resNum;
        copy2.template = this.template;
        copy2.confProblems = new ArrayList<ConfProblem>(this.confProblems);
        copy2.pucker = this.pucker;
        copy2.secondaryStruct = this.secondaryStruct;
        copy2.atoms = new ArrayList();
        for (Atom atom : this.atoms) {
            atom.copyToRes(copy2);
        }
        if (copyIntraBonds) {
            for (int i = 0; i < this.atoms.size(); ++i) {
                Atom thisAtom = this.atoms.get(i);
                Atom copyAtom = copy2.atoms.get(i);
                for (Atom thisBondedAtom : thisAtom.bonds) {
                    copyAtom.bonds.add(copy2.atoms.get(thisBondedAtom.indexInRes));
                }
            }
            copy2.intraResBondsMarked = this.intraResBondsMarked;
        } else {
            copy2.intraResBondsMarked = false;
        }
        copy2.coords = Arrays.copyOf(this.coords, this.coords.length);
        copy2.molec = mol;
        copy2.indexInMolecule = mol.residues.size();
        mol.residues.add(copy2);
        return copy2;
    }

    private Residue() {
    }

    public String getPDBResNumber() {
        if (this.resNum == null) {
            this.resNum = this.fullName.length() > 5 ? StringParsing.getToken(this.fullName.substring(3, 5), 1) + StringParsing.getToken(this.fullName.substring(5), 1) : Integer.toString(this.indexInMolecule + 1);
        }
        return this.resNum;
    }

    public char getChainId() {
        return this.fullName.charAt(4);
    }

    public String getType() {
        return this.fullName.substring(0, 3).trim();
    }

    public boolean assignTemplate(ResidueTemplateLibrary templateLib, TemplateMatchingMethod method) {
        switch (method) {
            case AtomNames: {
                return this.assignTemplateSimple(templateLib, HardCodedResidueInfo.getTemplateName(this));
            }
            case BondDistances: {
                return this.assignTemplate(templateLib);
            }
        }
        throw new Error("unknown method: " + String.valueOf((Object)method));
    }

    public boolean assignTemplate(ResidueTemplateLibrary templateLib) {
        ArrayList<ResidueTemplate> templCandidates = new ArrayList<ResidueTemplate>();
        String templateName = HardCodedResidueInfo.getTemplateName(this);
        for (ResidueTemplate templ : templateLib.templates) {
            if (!templ.name.equalsIgnoreCase(templateName)) continue;
            templCandidates.add(templ);
        }
        if (templCandidates.isEmpty()) {
            return false;
        }
        return this.assignTemplate(templCandidates, templateLib.ffparams);
    }

    public boolean assignTemplate(List<ResidueTemplate> templCandidates, ForcefieldParams ffParams) {
        ResTemplateMatching bestMatching = null;
        double bestScore = Double.POSITIVE_INFINITY;
        for (ResidueTemplate templ : templCandidates) {
            ResTemplateMatching templMatching = new ResTemplateMatching(this, templ, ffParams);
            if (!(templMatching.score < bestScore)) continue;
            bestScore = templMatching.score;
            bestMatching = templMatching;
        }
        if (bestMatching == null) {
            return false;
        }
        bestMatching.assign();
        return true;
    }

    public void assignTemplateSimple(ResidueTemplateLibrary templateLib) {
        this.assignTemplateSimple(templateLib, this.getType());
    }

    public boolean assignTemplateSimple(ResidueTemplateLibrary templateLib, String type) {
        List templateCandidates = templateLib.templates.stream().filter(templ -> templ.name.equals(type) && templ.templateRes.atoms.size() == this.atoms.size()).collect(Collectors.toList());
        if (templateCandidates.isEmpty()) {
            return false;
        }
        if (templateCandidates.size() != 1) {
            Log.log("warning: too many templates (%d) for %s", templateCandidates.size(), this.fullName);
            return false;
        }
        ResidueTemplate template = (ResidueTemplate)templateCandidates.get(0);
        List atomNames2 = this.atoms.stream().map(atom -> {
            Object name = atom.name;
            if (Character.isDigit(((String)name).charAt(0))) {
                name = ((String)name).substring(1) + ((String)name).substring(0, 1);
            }
            return name;
        }).collect(Collectors.toList());
        for (String atomName : atomNames2) {
            if (template.templateRes.getAtomByName(atomName) != null) continue;
            Log.log("warning: no atoms match for %s\n\tres:   %s\n\ttempl: %s", this.fullName, this.atoms.stream().map(a -> a.name).sorted(Comparator.naturalOrder()).collect(Collectors.toList()), template.templateRes.atoms.stream().map(a -> a.name).sorted(Comparator.naturalOrder()).collect(Collectors.toList()));
            return false;
        }
        HashMap<String, double[]> coords = new HashMap<String, double[]>();
        for (int i = 0; i < this.atoms.size(); ++i) {
            coords.put((String)atomNames2.get(i), this.atoms.get(i).getCoords());
        }
        this.template = template;
        ArrayList<Atom> newAtoms = new ArrayList<Atom>();
        for (Atom atom2 : template.templateRes.atoms) {
            Atom newAtom = atom2.copy();
            newAtom.res = this;
            newAtoms.add(newAtom);
        }
        this.atoms = newAtoms;
        this.markIntraResBondsByTemplate();
        for (Atom atom2 : this.atoms) {
            double[] atomCoords = (double[])coords.get(atom2.name);
            if (atomCoords == null) {
                throw new NoSuchElementException(String.format("Could not find the coordinates for %s. Perhaps check whether the same atom name is used in all places.", atom2));
            }
            atom2.setCoords(atomCoords[0], atomCoords[1], atomCoords[2]);
        }
        return true;
    }

    public void markIntraResBondsByTemplate() {
        int numAtoms = this.atoms.size();
        ArrayList<Atom> templateAtoms = this.template.templateRes.atoms;
        if (templateAtoms.size() != numAtoms) {
            throw new RuntimeException("ERROR: Template for " + this.fullName + " has the wrong number of atoms");
        }
        this.copyIntraBondsFrom(this.template.templateRes);
        this.intraResBondsMarked = true;
    }

    public void reconnectInterResBonds() {
        this.template.interResBonding.connectInterResBonds(this, false);
        this.interResBondsMarked = true;
    }

    public boolean[][] getIntraResBondMatrix() {
        int numAtoms = this.atoms.size();
        boolean[][] intraResBondMatrix = new boolean[numAtoms][numAtoms];
        for (int atNum1 = 0; atNum1 < numAtoms; ++atNum1) {
            block1: for (int atNum2 = 0; atNum2 < numAtoms; ++atNum2) {
                Atom atom1 = this.atoms.get(atNum1);
                Atom atom2 = this.atoms.get(atNum2);
                for (Atom bondedAtom : atom1.bonds) {
                    if (bondedAtom != atom2) continue;
                    intraResBondMatrix[atNum1][atNum2] = true;
                    continue block1;
                }
            }
        }
        return intraResBondMatrix;
    }

    public void copyIntraBondsFrom(Residue other) {
        int i;
        boolean[][] isBonded = other.getIntraResBondMatrix();
        int numAtoms = this.atoms.size();
        for (i = 0; i < numAtoms; ++i) {
            if (this.atoms.get((int)i).name.equalsIgnoreCase(other.atoms.get((int)i).name)) continue;
            throw new Error("ERROR: Atom names don't match aross residues, can't copy bonds");
        }
        for (i = 0; i < numAtoms; ++i) {
            Atom atomi = this.atoms.get(i);
            for (int j = 0; j < numAtoms; ++j) {
                if (!isBonded[i][j]) continue;
                Atom atomj = this.atoms.get(j);
                atomi.bonds.add(atomj);
            }
        }
        this.checkBonds();
    }

    public void checkTemplateAtomNames() {
        int numAtoms = this.atoms.size();
        ArrayList<Atom> templateAtoms = this.template.templateRes.atoms;
        if (templateAtoms.size() != numAtoms) {
            throw new RuntimeException("ERROR: Template has wrong number of atoms for " + this.fullName);
        }
        for (int atNum = 0; atNum < numAtoms; ++atNum) {
            String resAtomName = this.atoms.get((int)atNum).name;
            String templateAtomName = templateAtoms.get((int)atNum).name;
            if (resAtomName.equalsIgnoreCase(templateAtomName)) continue;
            throw new RuntimeException("ERROR: Atom name mismatch between template and atom list in " + this.fullName + ": " + resAtomName + " in atom list, " + templateAtomName + " in template");
        }
    }

    public void checkBonds() {
        for (Atom atom1 : this.atoms) {
            for (Atom atom2 : atom1.bonds) {
                if (atom2 == null) {
                    throw new RuntimeException("ERROR: checkBonds found a null bond");
                }
                boolean bothSides = false;
                for (Atom bondedAtom : atom2.bonds) {
                    if (bondedAtom != atom1) continue;
                    bothSides = true;
                    break;
                }
                if (bothSides) continue;
                throw new RuntimeException("ERROR: checkBonds found atom1 bonded to atom2 but atom2 not bonded to atom1");
            }
        }
    }

    public Atom getAtomByName(String name) {
        int index = this.getAtomIndexByName(name);
        if (index >= 0) {
            return this.atoms.get(index);
        }
        return null;
    }

    public Atom getAtomByNameOrThrow(String name) {
        Atom atom = this.getAtomByName(name);
        if (atom == null) {
            throw new NoSuchElementException("no atom named " + name + " in residue " + this.getPDBResNumber());
        }
        return atom;
    }

    public int getAtomIndexByName(String n) {
        for (int atNum = 0; atNum < this.atoms.size(); ++atNum) {
            if (!this.atoms.get((int)atNum).name.equalsIgnoreCase(n)) continue;
            return atNum;
        }
        return -1;
    }

    public double[] getCoordsByAtomName(String n) {
        int index = this.getAtomIndexByName(n);
        if (index == -1) {
            return null;
        }
        return this.atoms.get(index).getCoords();
    }

    public void setCoordsByAtomName(String name, double[] atomCoords) {
        int index = this.getAtomIndexByName(name);
        System.arraycopy(atomCoords, 0, this.coords, 3 * index, 3);
    }

    public double distanceTo(Residue res2) {
        double minDist = Double.POSITIVE_INFINITY;
        for (int atNum1 = 0; atNum1 < this.atoms.size(); ++atNum1) {
            for (int atNum2 = 0; atNum2 < res2.atoms.size(); ++atNum2) {
                double dist = VectorAlgebra.distance(this.coords, atNum1, res2.coords, atNum2);
                minDist = Math.min(minDist, dist);
            }
        }
        return minDist;
    }

    public boolean isBondedTo(Residue res2) {
        for (Atom at : this.atoms) {
            for (Atom at2 : res2.atoms) {
                if (!at.bonds.contains(at2)) continue;
                return true;
            }
        }
        return false;
    }

    public double[][] atomDistanceMatrix() {
        int numAtoms = this.atoms.size();
        double[][] ans = new double[numAtoms][numAtoms];
        for (int atNum1 = 0; atNum1 < numAtoms; ++atNum1) {
            for (int atNum2 = 0; atNum2 < numAtoms; ++atNum2) {
                double dist;
                ans[atNum1][atNum2] = dist = VectorAlgebra.distance(this.coords, atNum1, this.coords, atNum2);
            }
        }
        return ans;
    }

    public double[][] estBondDistanceMatrix(ForcefieldParams ffParams) {
        int numAtoms = this.atoms.size();
        double[][] ans = new double[numAtoms][numAtoms];
        for (int atNum1 = 0; atNum1 < numAtoms; ++atNum1) {
            Atom atom1 = this.atoms.get(atNum1);
            int atomType1 = atom1.type;
            if (atomType1 < 0) {
                throw new NoSuchElementException("unknown atom type for atom: " + atom1.name + ":" + atom1.forceFieldType);
            }
            for (Atom atom2 : atom1.bonds) {
                int atNum2 = this.getAtomIndexByName(atom2.name);
                int atomType2 = atom2.type;
                if (atomType2 < 0) {
                    throw new NoSuchElementException("unknown atom type for atom: " + atom2.name + ":" + atom2.forceFieldType);
                }
                ans[atNum1][atNum2] = ffParams.getBondEquilibriumLength(atom1, atom2);
                if (!Double.isNaN(ans[atNum1][atNum2])) continue;
                ans[atNum1][atNum2] = ffParams.estBondEBL(atom1, atom2);
            }
        }
        return ans;
    }

    public void removeInterResBonds() {
        this.interResBondsMarked = false;
        for (Atom atom : this.atoms) {
            for (int bondNum = atom.bonds.size() - 1; bondNum >= 0; --bondNum) {
                Atom bondedAtom = atom.bonds.get(bondNum);
                if (bondedAtom.res == this) continue;
                atom.bonds.remove(bondedAtom);
                bondedAtom.bonds.remove(atom);
            }
        }
    }

    public int getNumDihedrals() {
        return this.template.numDihedrals;
    }

    public double getDihedralAngle(int i) {
        return Protractor.measureDihedral(this.coords, this.template.getDihedralDefiningAtoms(i));
    }

    public double[] getDihedralAngles() {
        double[] dihedrals = new double[this.getNumDihedrals()];
        for (int i = 0; i < dihedrals.length; ++i) {
            dihedrals[i] = this.getDihedralAngle(i);
        }
        return dihedrals;
    }

    public Residue equivalentInMolec(Molecule mol) {
        return mol.getResByPDBResNumber(this.getPDBResNumber());
    }

    public static ArrayList<Residue> equivalentInMolec(ArrayList<Residue> resList, Molecule mol) {
        ArrayList<Residue> ans = new ArrayList<Residue>();
        for (Residue res : resList) {
            ans.add(res.equivalentInMolec(mol));
        }
        return ans;
    }

    public void deleteHydrogens() {
        BitSet isHeavy = new BitSet();
        ArrayList<Atom> newAtoms = new ArrayList<Atom>();
        for (int at = 0; at < this.atoms.size(); ++at) {
            if (this.atoms.get(at).isHydrogen()) continue;
            isHeavy.set(at);
            newAtoms.add(this.atoms.get(at));
        }
        double[] newCoords = new double[3 * isHeavy.cardinality()];
        int newAtCounter = 0;
        for (int at = 0; at < this.atoms.size(); ++at) {
            if (!isHeavy.get(at)) continue;
            System.arraycopy(this.coords, 3 * at, newCoords, 3 * newAtCounter, 3);
            ++newAtCounter;
        }
        this.atoms = newAtoms;
        this.coords = newCoords;
    }

    public void addAtom(Atom atom, double[] newAtomCoords) {
        this.atoms.add(atom);
        double[] newCoords = new double[this.coords.length + 3];
        System.arraycopy(this.coords, 0, newCoords, 0, this.coords.length);
        System.arraycopy(newAtomCoords, 0, newCoords, this.coords.length, 3);
        this.coords = newCoords;
        atom.res = this;
        atom.indexInRes = this.atoms.size() - 1;
    }

    public static enum SecondaryStructure {
        HELIX,
        SHEET,
        LOOP;

    }

    public static enum TemplateMatchingMethod {
        AtomNames,
        BondDistances;

    }
}

