/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.structure;

import edu.duke.cs.osprey.structure.Residue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class Residues
extends ArrayList<Residue> {
    private static final long serialVersionUID = 4950265664624559802L;
    private Map<String, Integer> indicesByNum = new HashMap<String, Integer>();

    public Residues() {
    }

    public Residues(Residue ... residues) {
        this();
        this.addAll((Collection<? extends Residue>)Arrays.asList(residues));
    }

    @Override
    public boolean add(Residue res) {
        int index = this.size();
        super.add(null);
        this.set(index, res);
        return true;
    }

    @Override
    public void add(int index, Residue res) {
        super.add(index, null);
        this.set(index, res);
    }

    @Override
    public Residue set(int index, Residue res) {
        String num = Residues.normalizeResNum(res.getPDBResNumber());
        if (this.indicesByNum.containsKey(num)) {
            throw new IllegalArgumentException("residue number " + num + " is already present in this collection");
        }
        this.indicesByNum.put(num, index);
        return super.set(index, res);
    }

    @Override
    public boolean remove(Object obj) {
        return this.remove((Residue)obj);
    }

    public boolean remove(Residue res) {
        return this.remove(res.getPDBResNumber()) != null;
    }

    public Residue remove(String num) {
        Integer index = this.findIndex(num);
        if (index != null) {
            return this.remove(index);
        }
        return null;
    }

    @Override
    public Residue remove(int index) {
        Residue res = (Residue)super.remove(index);
        if (res != null) {
            this.reindex();
        }
        return res;
    }

    @Override
    public void clear() {
        super.clear();
        this.reindex();
    }

    private void reindex() {
        this.indicesByNum.clear();
        for (int i = 0; i < this.size(); ++i) {
            this.indicesByNum.put(Residues.normalizeResNum(((Residue)this.get(i)).getPDBResNumber()), i);
        }
    }

    @Override
    public boolean contains(Object obj) {
        return super.contains((Residue)obj);
    }

    public boolean contains(String resNum) {
        return this.getOrNull(resNum) != null;
    }

    @Override
    public int indexOf(Object obj) {
        return this.indexOf((Residue)obj);
    }

    public int indexOf(Residue res) {
        Integer index = this.findIndex(res);
        if (index != null) {
            return index;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object obj) {
        return this.lastIndexOf((Residue)obj);
    }

    public int lastIndexOf(Residue res) {
        return this.indexOf(res);
    }

    public Integer findIndex(Residue res) {
        return this.findIndex(res.getPDBResNumber());
    }

    public Integer findIndex(String num) {
        Integer index = this.indicesByNum.get(num = Residues.normalizeResNum(num));
        if (index == null) {
            for (String num2 : this.indicesByNum.keySet()) {
                if (!num2.substring(1).equalsIgnoreCase(num)) continue;
                if (index != null) {
                    throw new RuntimeException("ERROR: Residue number " + num + " appears multiple times in molecule.  Please specify chain ID. ");
                }
                index = this.indicesByNum.get(num2);
            }
        }
        return index;
    }

    public int findIndexOrThrow(Residue res) {
        return this.findIndexOrThrow(res.getPDBResNumber());
    }

    public int findIndexOrThrow(String num) {
        Integer index = this.findIndex(num);
        if (index != null) {
            return index;
        }
        throw new NoSuchElementException("no residue with number " + num + " was found");
    }

    public Residue getOrThrow(String num) {
        return (Residue)this.get(this.findIndexOrThrow(num));
    }

    public Residue getOrNull(String num) {
        Integer index = this.findIndex(num);
        if (index != null) {
            return (Residue)this.get(index);
        }
        return null;
    }

    @Override
    public Object clone() {
        Residues residues = (Residues)super.clone();
        residues.indicesByNum = new HashMap<String, Integer>(this.indicesByNum);
        return residues;
    }

    @Override
    public boolean addAll(Collection<? extends Residue> c) {
        return this.reindexIfChanged(super.addAll(c));
    }

    @Override
    public boolean addAll(int index, Collection<? extends Residue> c) {
        return this.reindexIfChanged(super.addAll(index, c));
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        super.removeRange(fromIndex, toIndex);
        this.reindex();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.reindexIfChanged(super.removeAll(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.reindexIfChanged(super.retainAll(c));
    }

    @Override
    public boolean removeIf(Predicate<? super Residue> filter) {
        return this.reindexIfChanged(super.removeIf(filter));
    }

    @Override
    public void replaceAll(UnaryOperator<Residue> operator) {
        super.replaceAll(operator);
        this.reindex();
    }

    @Override
    public void sort(Comparator<? super Residue> c) {
        super.sort(c);
        this.reindex();
    }

    private boolean reindexIfChanged(boolean changed) {
        if (changed) {
            this.reindex();
        }
        return changed;
    }

    public static String normalizeResNum(String resNum) {
        return resNum.toUpperCase();
    }
}

