/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.structure.analysis;

import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.PDBIO;
import edu.duke.cs.osprey.tools.Log;
import edu.duke.cs.osprey.tools.Progress;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;

public class PDBScanner {
    public final File dir;
    public final Set<String> blacklist;
    public final List<File> files;

    public PDBScanner(File dir, String ... blacklist) {
        this(dir, new HashSet<String>(Arrays.asList(blacklist)));
    }

    public PDBScanner(File dir, Set<String> blacklist) {
        this.dir = dir;
        this.blacklist = blacklist;
        this.files = Arrays.asList(dir.listFiles((file, filename) -> filename.endsWith(".pdb") && !blacklist.contains(filename)));
    }

    public void scan(int numFiles, BiConsumer<File, Molecule> callback) {
        this.scan(this.files.subList(0, numFiles), true, callback);
    }

    public void scan(BiConsumer<File, Molecule> callback) {
        this.scan(this.files, true, callback);
    }

    public void scan(String filename, BiConsumer<File, Molecule> callback) {
        this.scan(Arrays.asList(new File(this.dir, filename)), false, callback);
    }

    private void scan(List<File> files, boolean showProgress, BiConsumer<File, Molecule> callback) {
        Progress progress2 = null;
        if (showProgress) {
            progress2 = new Progress(files.size());
            Log.log("Reading %d PDB files...", files.size());
        }
        for (File file : files) {
            List<Molecule> mols;
            try {
                mols = PDBIO.readMols(file);
            }
            catch (Exception ex) {
                System.err.println("error reading PDB file " + file.getName() + ", skipping it:\n\t" + ex.getMessage());
                continue;
            }
            for (Molecule mol : mols) {
                callback.accept(file, mol);
            }
            if (!showProgress) continue;
            progress2.incrementProgress();
        }
        if (showProgress) {
            Log.log("Done reading PDB files!", new Object[0]);
        }
    }
}

