/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tests;

import edu.duke.cs.osprey.astar.conf.ConfAStarTree;
import edu.duke.cs.osprey.confspace.DEEPerStrandFlex;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.confspace.Strand;
import edu.duke.cs.osprey.confspace.StrandFlex;
import edu.duke.cs.osprey.dof.deeper.DEEPerSettings;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.ematrix.SimpleReferenceEnergies;
import edu.duke.cs.osprey.ematrix.SimplerEnergyMatrixCalculator;
import edu.duke.cs.osprey.ematrix.epic.EPICSettings;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.energy.EnergyCalculator;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.gmec.DEEGMECFinder;
import edu.duke.cs.osprey.gmec.SimpleGMECFinder;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.PDBIO;
import edu.duke.cs.osprey.tupexp.LUTESettings;
import java.util.ArrayList;
import java.util.Arrays;

public class ComplicatedGMECFinding {
    static boolean useDEEGMECFinder = true;
    static boolean useERef = false;
    static boolean useLittleDEEPer = false;
    static boolean useLUTE = true;
    static boolean useEPIC = false;

    public static void main(String[] args) {
        SimpleConfSpace confSpace = useLittleDEEPer ? ComplicatedGMECFinding.littleDEEPerConfSpace() : ComplicatedGMECFinding.prepareConfSpace();
        ForcefieldParams ffparams = new ForcefieldParams();
        ffparams.solvScale = 0.0;
        EnergyCalculator ecalc = new EnergyCalculator.Builder(confSpace, ffparams).build();
        ConfEnergyCalculator.Builder confEcalcBuilder = new ConfEnergyCalculator.Builder(confSpace, ecalc);
        if (useERef) {
            SimpleReferenceEnergies eref = new SimpleReferenceEnergies.Builder(confSpace, ecalc).build();
            confEcalcBuilder.setReferenceEnergies(eref);
        }
        ConfEnergyCalculator confEcalc = confEcalcBuilder.build();
        EnergyMatrix emat = new SimplerEnergyMatrixCalculator.Builder(confEcalc).build().calcEnergyMatrix();
        if (useDEEGMECFinder) {
            DEEGMECFinder gf = new DEEGMECFinder.Builder(emat, confSpace, ecalc, confEcalc, "1CC8.dee").build();
            if (useEPIC) {
                gf.epicSettings = EPICSettings.defaultEPIC();
                gf.pruningSettings.algOption = 3;
            }
            if (useLUTE) {
                gf.luteSettings = LUTESettings.defaultLUTE();
                gf.pruningSettings.algOption = 3;
                gf.pruningSettings.useTriples = true;
            }
            gf.calcGMEC();
        } else {
            ConfAStarTree search2 = new ConfAStarTree.Builder(emat, confSpace).build();
            SimpleGMECFinder gf = new SimpleGMECFinder.Builder(search2, confEcalc).build();
            gf.find();
        }
    }

    private static SimpleConfSpace prepareConfSpace() {
        Molecule mol = PDBIO.readFile("examples/python.GMEC/1CC8.ss.pdb");
        String[][] allowedAAs = new String[][]{{"Ile", "Ala", "Gly"}, {"Ser", "Ala", "Gly"}, {"Met", "Ser", "Ala", "Gly"}, {"Glu", "Ala", "Gly"}, {"Ala", "Gly"}, {"Gln", "Ala", "Gly"}, {"Leu", "Ala", "Gly"}};
        String[] flexResNums = new String[]{"38", "39", "40", "41", "42", "43", "44"};
        Strand strand = new Strand.Builder(mol).build();
        for (int pos = 0; pos < 7; ++pos) {
            strand.flexibility.get(flexResNums[pos]).setLibraryRotamers(allowedAAs[pos]).setContinuous();
        }
        SimpleConfSpace confSpace = new SimpleConfSpace.Builder().addStrand(strand, new StrandFlex[0]).build();
        return confSpace;
    }

    private static SimpleConfSpace littleDEEPerConfSpace() {
        Molecule mol = PDBIO.readFile("examples/python.GMEC/1CC8.ss.pdb");
        String[][] allowedAAs = new String[][]{{"Ile", "Ala", "Gly"}, {"Ser", "Ala", "Gly"}, {"Met", "Ser", "Ala", "Gly", "Leu"}, {"Glu", "Ala", "Gly"}};
        String[] flexResNums = new String[]{"38", "39", "40", "41"};
        Strand strand = new Strand.Builder(mol).build();
        for (int pos = 0; pos < 4; ++pos) {
            strand.flexibility.get(flexResNums[pos]).setLibraryRotamers(allowedAAs[pos]).setContinuous();
        }
        DEEPerStrandFlex bbFlex = new DEEPerStrandFlex(strand, new DEEPerSettings(true, "1CC8.d.pert", true, "none", false, 2.5, 2.5, false, new ArrayList<String>(Arrays.asList(flexResNums)), "examples/python.GMEC/1CC8.ss.pdb", false, strand.templateLib));
        SimpleConfSpace confSpace = new SimpleConfSpace.Builder().addStrand(strand, bbFlex).build();
        return confSpace;
    }
}

